/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.jboss.arquillian.utils;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.JavaRuntimeConfigurationProducerBase;
import com.intellij.execution.junit2.info.LocationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ArquillianUtils {
    public static boolean isJunitArquillianEnabled(ConfigurationContext context) {
        Location contextLocation = context.getLocation();
        assert (contextLocation != null);
        Location location = JavaExecutionUtil.stepIntoSingleClass((Location)contextLocation);
        if (location == null) {
            return false;
        }
        PsiClass testClass = JUnitUtil.getTestClass((Location)location);
        return testClass != null && ArquillianUtils.isJunitArquillianEnabled(testClass);
    }

    public static boolean isJunitArquillianEnabled(@NotNull PsiClass aClass) {
        if (aClass == null) {
            ArquillianUtils.$$$reportNull$$$0(0);
        }
        PsiModifierList modifierList = aClass.getModifierList();
        if (aClass.isInterface() || modifierList != null && modifierList.hasExplicitModifier("abstract")) {
            return false;
        }
        PsiAnnotation runWithAnnotation = (PsiAnnotation)ArquillianUtils.lookupRunWithAnnotation((PsiClass)aClass).first;
        return runWithAnnotation != null && ArquillianUtils.isArquillianRunner(runWithAnnotation, aClass.getProject());
    }

    private static boolean isArquillianRunner(@NotNull PsiAnnotation runWithAnnotation, Project project) {
        if (runWithAnnotation == null) {
            ArquillianUtils.$$$reportNull$$$0(1);
        }
        for (PsiNameValuePair nameValuePair : runWithAnnotation.getParameterList().getAttributes()) {
            String name = nameValuePair.getName();
            if (name != null && !name.equals("value")) continue;
            PsiAnnotationMemberValue value = nameValuePair.getDetachedValue();
            if (!(value instanceof PsiClassObjectAccessExpression)) {
                return false;
            }
            PsiTypeElement typeElement = ((PsiClassObjectAccessExpression)value).getOperand();
            PsiClassType arquillianJunitType = PsiType.getTypeByName((String)"org.jboss.arquillian.junit.Arquillian", (Project)project, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
            return arquillianJunitType.isAssignableFrom(typeElement.getType());
        }
        return false;
    }

    private static Pair<PsiAnnotation, Boolean> lookupRunWithAnnotation(PsiClass aClass) {
        boolean isInherited = false;
        PsiAnnotation result = null;
        HashSet<PsiClass> visitedClasses = new HashSet<PsiClass>();
        while (aClass != null && !visitedClasses.contains(aClass)) {
            visitedClasses.add(aClass);
            result = ArquillianUtils.getArquillianAnnotation(aClass);
            if (result != null) break;
            isInherited = true;
            aClass = aClass.getSuperClass();
        }
        return Pair.create(result, (Object)isInherited);
    }

    private static PsiAnnotation getArquillianAnnotation(@NotNull PsiClass aClass) {
        PsiModifierList classModifierList;
        if (aClass == null) {
            ArquillianUtils.$$$reportNull$$$0(2);
        }
        if ((classModifierList = aClass.getModifierList()) == null) {
            return null;
        }
        return classModifierList.findAnnotation("org.junit.runner.RunWith");
    }

    public static PsiElement getJunitArquillianEnabledElement(@NotNull PsiClass aClass) {
        if (aClass == null) {
            ArquillianUtils.$$$reportNull$$$0(3);
        }
        if (!ArquillianUtils.isJunitArquillianEnabled(aClass)) {
            return null;
        }
        PsiAnnotation annotation = ArquillianUtils.getArquillianAnnotation(aClass);
        return annotation != null ? annotation : aClass.getNameIdentifier();
    }

    public static PsiElement getTestngArquillianEnabledElement(@NotNull PsiClass aClass) {
        PsiClass psiClass;
        if (aClass == null) {
            ArquillianUtils.$$$reportNull$$$0(4);
        }
        return (psiClass = ArquillianUtils.getTestngArquillianType(aClass.getProject()).resolve()) != null && aClass.isInheritor(psiClass, true) ? aClass.getExtendsList() : null;
    }

    public static boolean isTestngArquillianEnabled(@NotNull PsiClass aClass) {
        PsiModifierList modifierList;
        if (aClass == null) {
            ArquillianUtils.$$$reportNull$$$0(5);
        }
        if ((modifierList = aClass.getModifierList()) != null && modifierList.hasExplicitModifier("abstract")) {
            return false;
        }
        PsiClass psiClass = ArquillianUtils.getTestngArquillianType(aClass.getProject()).resolve();
        return psiClass != null && aClass.isInheritor(psiClass, true);
    }

    public static PsiClassType getTestngArquillianType(@NotNull Project project) {
        if (project == null) {
            ArquillianUtils.$$$reportNull$$$0(6);
        }
        return PsiType.getTypeByName((String)"org.jboss.arquillian.testng.Arquillian", (Project)project, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
    }

    public static List<PsiMethod> getAnnotatedMethods(@NotNull PsiClass aClass, @NonNls @NotNull String annotationFQN) {
        if (aClass == null) {
            ArquillianUtils.$$$reportNull$$$0(7);
        }
        if (annotationFQN == null) {
            ArquillianUtils.$$$reportNull$$$0(8);
        }
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
        for (PsiMethod method : aClass.getAllMethods()) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)annotationFQN, (boolean)false)) continue;
            result.add(method);
        }
        return result;
    }

    public static boolean isClassAvailableInContext(ConfigurationContext context, String fqn) {
        PsiPackage psiPackage = JavaRuntimeConfigurationProducerBase.checkPackage((PsiElement)context.getPsiLocation());
        if (context.getLocation() == null || psiPackage == null) {
            return false;
        }
        return LocationUtil.isJarAttached((Location)context.getLocation(), (PsiPackage)psiPackage, (String[])new String[]{fqn});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runWithAnnotation";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQN";
                break;
            }
        }
        objectArray2[1] = "com/intellij/plugins/jboss/arquillian/utils/ArquillianUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isJunitArquillianEnabled";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isArquillianRunner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getArquillianAnnotation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getJunitArquillianEnabledElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getTestngArquillianEnabledElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isTestngArquillianEnabled";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getTestngArquillianType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getAnnotatedMethods";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

