/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.util;

import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import javax.swing.ComboBoxEditor;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class NodePackageEditor
implements ComboBoxEditor {
    private final SortedComboBoxModel<Object> myComboBoxModel;
    private final JPanel myMainPanel;
    private final JBTextField myTextField;
    private final SimpleColoredComponent myVersionComp;
    private final Color myNormalForegroundColor;
    private final NodePackageDescriptor myDescriptor;
    private final TextComponentAccessor<ComboBox<Object>> myTextComponentAccessor;

    NodePackageEditor(@NotNull SortedComboBoxModel<Object> comboBoxModel, @NotNull NodePackageDescriptor descriptor2) {
        if (comboBoxModel == null) {
            NodePackageEditor.$$$reportNull$$$0(0);
        }
        if (descriptor2 == null) {
            NodePackageEditor.$$$reportNull$$$0(1);
        }
        this.myMainPanel = new JPanel(new GridBagLayout()){
            {
                this.setBorder((Border)JBUI.Borders.empty());
            }

            @Override
            public synchronized void addFocusListener(FocusListener l) {
                NodePackageEditor.this.myTextField.addFocusListener(l);
            }

            @Override
            public synchronized void removeFocusListener(FocusListener l) {
                NodePackageEditor.this.myTextField.removeFocusListener(l);
            }

            @Override
            public void setFocusable(boolean focusable) {
                super.setFocusable(false);
            }

            @Override
            public void setBorder(Border border) {
                super.setBorder((Border)JBUI.Borders.empty());
            }
        };
        this.myTextField = new JBTextField();
        this.myVersionComp = new SimpleColoredComponent();
        this.myNormalForegroundColor = this.myTextField.getForeground();
        this.myTextComponentAccessor = new NodePackageComboBoxTextComponentAccessor();
        this.myComboBoxModel = comboBoxModel;
        this.myMainPanel.setCursor(Cursor.getPredefinedCursor(2));
        this.myMainPanel.setBackground(this.myTextField.getBackground());
        this.myVersionComp.setFont(UIUtil.getFont((UIUtil.FontSize)UIUtil.FontSize.SMALL, (Font)this.myTextField.getFont()));
        this.myVersionComp.setOpaque(false);
        this.myVersionComp.setForeground(this.myTextField.getForeground());
        this.myVersionComp.setIpad((Insets)JBUI.emptyInsets());
        this.myTextField.setOpaque(false);
        this.myTextField.setMinimumSize(new Dimension(0, 0));
        this.myTextField.setBorder((Border)JBUI.Borders.emptyRight((int)8));
        this.myDescriptor = descriptor2;
        String hintText = this.myDescriptor.getHintText();
        if (hintText != null) {
            this.myTextField.getEmptyText().setText(hintText);
        }
        this.myVersionComp.setMyBorder((Border)JBUI.Borders.emptyRight((int)1));
        this.myMainPanel.add((Component)this.myTextField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 256, 1, (Insets)JBUI.emptyInsets(), 0, 0));
        this.myMainPanel.add((Component)this.myVersionComp, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 256, 0, (Insets)JBUI.emptyInsets(), 0, 0));
        this.myTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                NodePackageEditor.this.textUpdated();
            }
        });
        this.myMainPanel.setFocusable(false);
        this.myVersionComp.setFocusable(false);
    }

    private void textUpdated() {
        NodePackage item = this.getItem();
        boolean valid = item.isValid();
        this.myTextField.setForeground(valid ? this.myNormalForegroundColor : JBColor.red);
        this.myVersionComp.clear();
        SemVer version = item.getVersion();
        if (version != null) {
            this.myVersionComp.append(version.getRawVersion(), SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    @NotNull
    public JTextField getTextField() {
        JBTextField jBTextField = this.myTextField;
        if (jBTextField == null) {
            NodePackageEditor.$$$reportNull$$$0(2);
        }
        return jBTextField;
    }

    @Override
    @NotNull
    public Component getEditorComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            NodePackageEditor.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    @NotNull
    TextComponentAccessor<ComboBox<Object>> getTextComponentAccessor() {
        TextComponentAccessor<ComboBox<Object>> textComponentAccessor = this.myTextComponentAccessor;
        if (textComponentAccessor == null) {
            NodePackageEditor.$$$reportNull$$$0(4);
        }
        return textComponentAccessor;
    }

    @Override
    public void setItem(Object anObject) {
        String text;
        NodePackage pkg = (NodePackage)ObjectUtils.tryCast((Object)anObject, NodePackage.class);
        String string = text = pkg != null ? pkg.getPresentablePath() : "";
        if (!this.myTextField.getText().equals(text)) {
            this.myTextField.setText(text);
        }
    }

    @Override
    @NotNull
    public NodePackage getItem() {
        String text = FileUtil.expandUserHome((String)this.myTextField.getText().trim());
        NodePackage pkg = this.myDescriptor.createPackage(text);
        int ind = this.myComboBoxModel.indexOf((Object)pkg);
        NodePackage nodePackage = ind >= 0 ? (NodePackage)this.myComboBoxModel.get(ind) : pkg;
        if (nodePackage == null) {
            NodePackageEditor.$$$reportNull$$$0(5);
        }
        return nodePackage;
    }

    @Override
    public void selectAll() {
        this.myTextField.selectAll();
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myTextField, true));
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.myTextField.addActionListener(l);
    }

    @Override
    public void removeActionListener(ActionListener l) {
        this.myTextField.removeActionListener(l);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBoxModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/util/NodePackageEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/util/NodePackageEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextField";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextComponentAccessor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class NodePackageComboBoxTextComponentAccessor
    implements TextComponentAccessor<ComboBox<Object>> {
        private NodePackageComboBoxTextComponentAccessor() {
        }

        public String getText(ComboBox<Object> component) {
            Object obj = component.getEditor().getItem();
            if (obj instanceof NodePackage) {
                return ((NodePackage)obj).getSystemDependentPath();
            }
            return "";
        }

        public void setText(ComboBox<Object> component, @NotNull String text) {
            if (text == null) {
                NodePackageComboBoxTextComponentAccessor.$$$reportNull$$$0(0);
            }
            component.getEditor().setItem(NodePackageEditor.this.myDescriptor.createPackage(text));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/javascript/nodejs/util/NodePackageEditor$NodePackageComboBoxTextComponentAccessor", "setText"));
        }
    }
}

