/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nullable;

public abstract class JSContextTypeFilter {
    public static final LanguageExtension<JSContextTypeFilter> INSTANCE = new LanguageExtension("JavaScript.contextTypeFilter");
    public static final JSContextTypeFilter DEFAULT_INSTANCE = new DefaultJSRefactoringFilterProvider();

    public abstract boolean isInContext(@Nullable PsiElement var1);

    private static class DefaultJSRefactoringFilterProvider
    extends JSContextTypeFilter {
        private DefaultJSRefactoringFilterProvider() {
        }

        private static Language getLanguage(PsiElement element) {
            PsiLanguageInjectionHost host;
            Language language;
            Language language2 = language = element != null ? element.getParent().getLanguage() : null;
            if (language != null && (host = (PsiLanguageInjectionHost)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLanguageInjectionHost.class, (boolean)false)) != null) {
                final Ref injectedLanguageRef = new Ref();
                InjectedLanguageUtil.enumerate((PsiElement)host, (PsiFile)element.getContainingFile(), (boolean)false, (PsiLanguageInjectionHost.InjectedPsiVisitor)new JSResolveUtil.JSInjectedFilesVisitor(){

                    @Override
                    protected void process(JSFile file) {
                        injectedLanguageRef.set((Object)file.getLanguage());
                    }
                });
                if (!injectedLanguageRef.isNull()) {
                    language = (Language)injectedLanguageRef.get();
                }
            }
            return language;
        }

        @Override
        public boolean isInContext(@Nullable PsiElement element) {
            Language language = DefaultJSRefactoringFilterProvider.getLanguage(element);
            return language != null && language.isKindOf((Language)JavascriptLanguage.INSTANCE) && !language.isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4);
        }
    }
}

