/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.MultiHostRegistrarImpl;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringInterpolationErrorFilter
extends HighlightErrorFilter
implements HighlightInfoFilter {
    private static final Key<List<TextRange>> STRING_FRAGMENTS_KEY = new Key("STRING_FRAGMENTS_KEY");
    private static final Comparator<TextRange> RANGE_START_COMPARATOR = (o1, o2) -> Comparing.compare((int)o1.getStartOffset(), (int)o2.getStartOffset());

    public static void register(@NotNull MultiHostRegistrar registrar) {
        MultiHostRegistrarImpl registrarImpl;
        if (registrar == null) {
            StringInterpolationErrorFilter.$$$reportNull$$$0(0);
        }
        MultiHostRegistrarImpl multiHostRegistrarImpl = registrarImpl = registrar instanceof MultiHostRegistrarImpl ? (MultiHostRegistrarImpl)registrar : null;
        if (registrarImpl == null) {
            return;
        }
        List result = registrarImpl.getResult();
        if (result == null || result.size() != 1) {
            return;
        }
        Place shreds = (Place)((Pair)result.get((int)0)).first;
        PsiFile file = (PsiFile)((Pair)result.get((int)0)).second;
        if (shreds.size() <= 1) {
            return;
        }
        file.putUserData(STRING_FRAGMENTS_KEY, (Object)ContainerUtil.map((Collection)shreds, place -> place.getRange().grown(-place.getSuffix().length())));
    }

    public boolean shouldHighlightErrorElement(@NotNull PsiErrorElement element) {
        List acceptedRanges;
        if (element == null) {
            StringInterpolationErrorFilter.$$$reportNull$$$0(1);
        }
        if ((acceptedRanges = (List)element.getContainingFile().getUserData(STRING_FRAGMENTS_KEY)) == null) {
            return true;
        }
        TextRange stringRange = StringInterpolationErrorFilter.findRange(element.getTextRange(), acceptedRanges);
        return stringRange == null || stringRange.contains(element.getTextRange());
    }

    public boolean accept(@NotNull HighlightInfo highlightInfo, @Nullable PsiFile file) {
        List acceptedRanges;
        if (highlightInfo == null) {
            StringInterpolationErrorFilter.$$$reportNull$$$0(2);
        }
        List list = acceptedRanges = file != null ? (List)file.getUserData(STRING_FRAGMENTS_KEY) : null;
        if (acceptedRanges == null) {
            return true;
        }
        if (highlightInfo.getSeverity() == HighlightSeverity.WARNING || highlightInfo.getSeverity() == HighlightSeverity.WEAK_WARNING || highlightInfo.getSeverity() == HighlightSeverity.ERROR) {
            TextRange highlightRange = new TextRange(highlightInfo.getStartOffset(), highlightInfo.getEndOffset());
            TextRange stringRange = StringInterpolationErrorFilter.findRange(highlightRange, acceptedRanges);
            return stringRange == null || highlightInfo.startOffset > stringRange.getStartOffset() && highlightInfo.endOffset < stringRange.getEndOffset();
        }
        return true;
    }

    @Nullable
    private static TextRange findRange(@NotNull TextRange range, @NotNull List<TextRange> list) {
        int i;
        if (range == null) {
            StringInterpolationErrorFilter.$$$reportNull$$$0(3);
        }
        if (list == null) {
            StringInterpolationErrorFilter.$$$reportNull$$$0(4);
        }
        if ((i = Collections.binarySearch(list, range, RANGE_START_COMPARATOR)) == -1) {
            return null;
        }
        return list.get(i < 0 ? -i - 2 : i);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/StringInterpolationErrorFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "register";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldHighlightErrorElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

