/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.bower.cache;

import com.intellij.openapi.util.Pair;
import com.intellij.util.MergingBackgroundExecutor;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrevRequestSkippingCache<K, V> {
    private final Fetcher<K, V> myFetcher;
    private final Map<K, Future<V>> myRecentFutureMap;
    private final MergingBackgroundExecutor<Pair<FetchCallback<K, V>, Future<V>>> myCheckExecutor;
    private final MergingBackgroundExecutor<Runnable> myFetchExecutor;
    private final BlockingQueue<FetchCallback<K, V>> myFetchQueue;
    private volatile FetchCallback<K, V> myLatestCallback;

    public PrevRequestSkippingCache(@NotNull Fetcher<K, V> fetcher) {
        if (fetcher == null) {
            PrevRequestSkippingCache.$$$reportNull$$$0(0);
        }
        this.myRecentFutureMap = Collections.synchronizedMap(new LinkedHashMap<K, Future<V>>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, Future<V>> eldest) {
                return this.size() > 10;
            }
        });
        this.myFetchQueue = new LinkedBlockingQueue<FetchCallback<K, V>>();
        this.myFetcher = fetcher;
        this.myCheckExecutor = new MergingBackgroundExecutor("com.intellij.lang.javascript.bower.cache.PrevRequestSkippingCache.PrevRequestSkippingCache check pool", 2, pair -> {
            if (!this.canBeSkipped((FetchCallback)pair.first)) {
                this.processFuture((FetchCallback)pair.first, (Future)pair.second);
            }
        });
        this.myFetchExecutor = MergingBackgroundExecutor.newRunnableExecutor((String)"com.intellij.lang.javascript.bower.cache.PrevRequestSkippingCache.PrevRequestSkippingCache pool", (int)2);
    }

    public void fetch(@NotNull FetchCallback<K, V> callback) {
        if (callback == null) {
            PrevRequestSkippingCache.$$$reportNull$$$0(1);
        }
        this.myLatestCallback = callback;
        if (!this.checkRecentCache(callback)) {
            this.fetchAsync(callback);
        }
    }

    private boolean canBeSkipped(@NotNull FetchCallback callback) {
        if (callback == null) {
            PrevRequestSkippingCache.$$$reportNull$$$0(2);
        }
        if (!callback.canBeSkipped()) {
            return false;
        }
        FetchCallback<K, V> latestFetch = this.myLatestCallback;
        if (callback == latestFetch || latestFetch == null) {
            return false;
        }
        return !callback.getKey().equals(latestFetch.getKey());
    }

    private boolean checkRecentCache(@NotNull FetchCallback<K, V> callback) {
        Future<V> future;
        if (callback == null) {
            PrevRequestSkippingCache.$$$reportNull$$$0(3);
        }
        if ((future = this.myRecentFutureMap.get(callback.getKey())) == null) {
            return false;
        }
        if (future.isDone()) {
            this.processFuture(callback, future);
        } else {
            this.myCheckExecutor.queue((Object)Pair.create(callback, future));
        }
        return true;
    }

    private void fetchAsync(@NotNull FetchCallback<K, V> callback) {
        if (callback == null) {
            PrevRequestSkippingCache.$$$reportNull$$$0(4);
        }
        this.myFetchQueue.offer(callback);
        this.myFetchExecutor.queue(() -> {
            FetchCallback next;
            while ((next = (FetchCallback)this.myFetchQueue.poll()) != null) {
                if (this.canBeSkipped(next) || this.checkRecentCache(next)) continue;
                this.fetchSync(next);
            }
        });
    }

    private void fetchSync(@NotNull FetchCallback<K, V> callback) {
        if (callback == null) {
            PrevRequestSkippingCache.$$$reportNull$$$0(5);
        }
        FutureTask<Object> future = new FutureTask<Object>(() -> {
            if (callback == null) {
                PrevRequestSkippingCache.$$$reportNull$$$0(8);
            }
            try {
                V result = this.myFetcher.fetch(callback.getKey());
                callback.onSuccess(result);
                return result;
            }
            catch (Exception e) {
                callback.onException(e);
                throw e;
            }
        });
        this.myRecentFutureMap.put(callback.getKey(), future);
        future.run();
    }

    private void processFuture(@NotNull FetchCallback<K, V> consumer, @NotNull Future<V> future) {
        if (consumer == null) {
            PrevRequestSkippingCache.$$$reportNull$$$0(6);
        }
        if (future == null) {
            PrevRequestSkippingCache.$$$reportNull$$$0(7);
        }
        try {
            V result = future.get();
            consumer.onSuccess(result);
        }
        catch (InterruptedException e) {
            consumer.onSuccess(null);
        }
        catch (ExecutionException e) {
            Exception cause = (Exception)ObjectUtils.tryCast((Object)e.getCause(), Exception.class);
            if (cause != null) {
                consumer.onException(cause);
            }
            consumer.onException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fetcher";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/bower/cache/PrevRequestSkippingCache";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "fetch";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "canBeSkipped";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkRecentCache";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchAsync";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchSync";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "processFuture";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$fetchSync$2";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static abstract class FetchCallback<K, V> {
        private final K myKey;
        private final boolean myCanBeSkipped;

        public FetchCallback(@NotNull K key, boolean canBeSkipped) {
            if (key == null) {
                FetchCallback.$$$reportNull$$$0(0);
            }
            this.myKey = key;
            this.myCanBeSkipped = canBeSkipped;
        }

        @NotNull
        public K getKey() {
            K k = this.myKey;
            if (k == null) {
                FetchCallback.$$$reportNull$$$0(1);
            }
            return k;
        }

        public boolean canBeSkipped() {
            return this.myCanBeSkipped;
        }

        public abstract void onSuccess(@Nullable V var1);

        public abstract void onException(@NotNull Exception var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/bower/cache/PrevRequestSkippingCache$FetchCallback";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/bower/cache/PrevRequestSkippingCache$FetchCallback";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface Fetcher<K, V> {
        @Nullable
        public V fetch(@NotNull K var1) throws Exception;
    }
}

