/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.lang.javascript.buildTools.base.JsbtFileManager;
import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskSet;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskTreeView;
import com.intellij.lang.javascript.buildTools.base.JsbtToolWindowManager;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.gulp.GulpTaskListFetchUtil;
import com.intellij.lang.javascript.buildTools.gulp.GulpTaskTreeView;
import com.intellij.lang.javascript.buildTools.gulp.GulpTasksFetchSettingsDialog;
import com.intellij.lang.javascript.buildTools.gulp.GulpfileManager;
import com.intellij.lang.javascript.buildTools.gulp.GulpfileStructure;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpConfigurationType;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunConfiguration;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunConfigurationProducer;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import icons.JavaScriptLanguageIcons;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GulpService
extends JsbtService {
    private static final String GULPFILE_NAME_WITHOUT_EXT = "Gulpfile";
    private static final String[] FILENAMES_WITHOUT_EXT = new String[]{"gulpfile", "gulpfile.babel"};
    private static final String[] KNOWN_EXTENSIONS = new String[]{"coffee", "es6", "js", "ts"};
    private static final NotNullLazyValue<GulpService> LAZY_INSTANCE = JsbtService.newLazyInstance(GulpService.class);

    @NotNull
    public static GulpService getInstance() {
        GulpService gulpService = (GulpService)LAZY_INSTANCE.getValue();
        if (gulpService == null) {
            GulpService.$$$reportNull$$$0(0);
        }
        return gulpService;
    }

    @Override
    @NotNull
    public String getName() {
        if ("Gulp" == null) {
            GulpService.$$$reportNull$$$0(1);
        }
        return "Gulp";
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return JavaScriptLanguageIcons.BuildTools.Gulp16;
    }

    @Override
    @NotNull
    public JsbtFileManager getFileManager(@NotNull Project project) {
        if (project == null) {
            GulpService.$$$reportNull$$$0(2);
        }
        GulpfileManager gulpfileManager = GulpfileManager.getInstance(project);
        if (gulpfileManager == null) {
            GulpService.$$$reportNull$$$0(3);
        }
        return gulpfileManager;
    }

    @Override
    @NotNull
    protected JsbtToolWindowManager createToolWindowManager(@NotNull Project project) {
        if (project == null) {
            GulpService.$$$reportNull$$$0(4);
        }
        JsbtToolWindowManager jsbtToolWindowManager = new JsbtToolWindowManager(project, "Gulp", JavaScriptLanguageIcons.BuildTools.Gulp_toolwindow, "reference.tool.window.js.build_tools.gulp", this);
        if (jsbtToolWindowManager == null) {
            GulpService.$$$reportNull$$$0(5);
        }
        return jsbtToolWindowManager;
    }

    @Override
    @NotNull
    public JsbtTaskTreeView createTaskTreeView(@NotNull Project project, @Nullable String layoutPlace) {
        if (project == null) {
            GulpService.$$$reportNull$$$0(6);
        }
        GulpTaskTreeView gulpTaskTreeView = new GulpTaskTreeView(this, project, layoutPlace);
        if (gulpTaskTreeView == null) {
            GulpService.$$$reportNull$$$0(7);
        }
        return gulpTaskTreeView;
    }

    @Override
    @NotNull
    public List<VirtualFile> detectAllBuildfiles(@NotNull Project project) {
        if (project == null) {
            GulpService.$$$reportNull$$$0(8);
        }
        ArrayList result = ContainerUtil.newArrayList();
        result.addAll(JsbtUtil.detectAllBuildfiles(project, GULPFILE_NAME_WITHOUT_EXT, FILENAMES_WITHOUT_EXT, KNOWN_EXTENSIONS));
        List<VirtualFile> indexFiles = JsbtUtil.detectAllBuildfiles(project, "index.", new String[]{"index"}, KNOWN_EXTENSIONS);
        for (VirtualFile indexFile : indexFiles) {
            if (!GulpService.isIndexFile(indexFile)) continue;
            result.add(indexFile);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            GulpService.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<VirtualFile> detectAllBuildfilesInContentRoots(@NotNull Project project, boolean webModulesOnly, boolean filterOutEmptyBuildfiles) {
        if (project == null) {
            GulpService.$$$reportNull$$$0(10);
        }
        ArrayList result = ContainerUtil.newArrayList();
        List<VirtualFile> files = JsbtUtil.detectAllBuildfilesInContentRoots(project, webModulesOnly, GULPFILE_NAME_WITHOUT_EXT, KNOWN_EXTENSIONS, true);
        for (VirtualFile file : files) {
            if (file.isDirectory()) {
                VirtualFile indexFile = GulpService.findIndexFile(file);
                if (indexFile == null) continue;
                result.add(indexFile);
                continue;
            }
            result.add(file);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            GulpService.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @Nullable
    private static VirtualFile findIndexFile(@NotNull VirtualFile gulpfileJsDir) {
        if (gulpfileJsDir == null) {
            GulpService.$$$reportNull$$$0(12);
        }
        if (GulpService.isNameMatchedStrictly(gulpfileJsDir, "gulpfile")) {
            VirtualFile[] children;
            for (VirtualFile file : children = (VirtualFile[])ObjectUtils.notNull((Object)gulpfileJsDir.getChildren(), (Object)VirtualFile.EMPTY_ARRAY)) {
                if (file.isDirectory() || !GulpService.isNameMatchedStrictly(file, "index")) continue;
                return file;
            }
        }
        return null;
    }

    @Override
    public String getBuildfileCommonName() {
        return GULPFILE_NAME_WITHOUT_EXT;
    }

    @Override
    public boolean isBuildfile(@NotNull VirtualFile file) {
        if (file == null) {
            GulpService.$$$reportNull$$$0(13);
        }
        if (JsbtUtil.isFilenameMatched(file.getNameSequence(), GULPFILE_NAME_WITHOUT_EXT, KNOWN_EXTENSIONS)) {
            return true;
        }
        return GulpService.isIndexFile(file);
    }

    private static boolean isIndexFile(@NotNull VirtualFile indexFile) {
        VirtualFile parent;
        if (indexFile == null) {
            GulpService.$$$reportNull$$$0(14);
        }
        return (parent = indexFile.getParent()) != null && GulpService.isNameMatchedStrictly(parent, "gulpfile") && GulpService.isNameMatchedStrictly(indexFile, "index");
    }

    private static boolean isNameMatchedStrictly(@NotNull VirtualFile file, @NotNull String nameWithoutExtension) {
        String ext;
        if (file == null) {
            GulpService.$$$reportNull$$$0(15);
        }
        if (nameWithoutExtension == null) {
            GulpService.$$$reportNull$$$0(16);
        }
        return (ext = file.getExtension()) != null && ArrayUtil.contains((String)ext, (String[])KNOWN_EXTENSIONS) && nameWithoutExtension.equals(file.getNameWithoutExtension());
    }

    @Override
    @NotNull
    public JsbtFileStructure createEmptyFileStructure(@NotNull VirtualFile buildfile) {
        if (buildfile == null) {
            GulpService.$$$reportNull$$$0(17);
        }
        GulpfileStructure gulpfileStructure = new GulpfileStructure(buildfile);
        if (gulpfileStructure == null) {
            GulpService.$$$reportNull$$$0(18);
        }
        return gulpfileStructure;
    }

    @Override
    @NotNull
    public JsbtFileStructure fetchBuildfileStructure(@NotNull Project project, @NotNull VirtualFile buildfile) throws JsbtTaskFetchException {
        if (project == null) {
            GulpService.$$$reportNull$$$0(19);
        }
        if (buildfile == null) {
            GulpService.$$$reportNull$$$0(20);
        }
        GulpfileStructure gulpfileStructure = GulpTaskListFetchUtil.listTasks(project, buildfile);
        if (gulpfileStructure == null) {
            GulpService.$$$reportNull$$$0(21);
        }
        return gulpfileStructure;
    }

    @Override
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = GulpConfigurationType.getFactory();
        if (configurationFactory == null) {
            GulpService.$$$reportNull$$$0(22);
        }
        return configurationFactory;
    }

    @Override
    public boolean isConfigurationMatched(@NotNull RunConfiguration runConfiguration, @NotNull Object patternObject) {
        if (runConfiguration == null) {
            GulpService.$$$reportNull$$$0(23);
        }
        if (patternObject == null) {
            GulpService.$$$reportNull$$$0(24);
        }
        if (runConfiguration instanceof GulpRunConfiguration) {
            GulpRunSettings runSettings = ((GulpRunConfiguration)runConfiguration).getRunSettings();
            if (patternObject instanceof GulpRunSettings) {
                GulpRunSettings patternRunSettings = (GulpRunSettings)patternObject;
                return JsbtUtil.equalsOrderless(patternRunSettings.getTasks(), runSettings.getTasks()) && patternRunSettings.getGulpfileSystemIndependentPath().equals(runSettings.getGulpfileSystemIndependentPath());
            }
            if (patternObject instanceof JsbtTaskSet) {
                JsbtTaskSet patternTaskSet = (JsbtTaskSet)patternObject;
                return JsbtUtil.equalsOrderless(patternTaskSet.getTaskNames(), runSettings.getTasks()) && patternTaskSet.getStructure().getBuildfile().getPath().equals(runSettings.getGulpfileSystemIndependentPath());
            }
        }
        return false;
    }

    @Override
    public void setupRunConfiguration(@NotNull RunConfiguration runConfiguration, @NotNull JsbtTaskSet taskSet) {
        if (runConfiguration == null) {
            GulpService.$$$reportNull$$$0(25);
        }
        if (taskSet == null) {
            GulpService.$$$reportNull$$$0(26);
        }
        GulpfileStructure structure = (GulpfileStructure)taskSet.getStructure();
        GulpRunConfiguration gulpRunConfiguration = (GulpRunConfiguration)runConfiguration;
        GulpRunSettings merged = new GulpRunSettings.Builder(gulpRunConfiguration.getRunSettings()).setGulpfilePath(structure.getBuildfile().getPath()).setTasks(taskSet.getTaskNames()).build();
        GulpRunConfigurationProducer.setupConfigurationFromSettings(gulpRunConfiguration, merged);
    }

    @Override
    public boolean showTaskListingSettingsDialog(@NotNull Project project, @Nullable VirtualFile contextGruntfile) {
        if (project == null) {
            GulpService.$$$reportNull$$$0(27);
        }
        return new GulpTasksFetchSettingsDialog(project, contextGruntfile).showAndGet();
    }

    @Nullable
    public VirtualFile detectFirstBuildfileInContentRoots(@NotNull Project project, boolean webModulesOnly) {
        if (project == null) {
            GulpService.$$$reportNull$$$0(28);
        }
        List<VirtualFile> buildfiles = this.detectAllBuildfilesInContentRoots(project, webModulesOnly);
        return (VirtualFile)ContainerUtil.getFirstItem(buildfiles);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/gulp/GulpService";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 19: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gulpfileJsDir";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexFile";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameWithoutExtension";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildfile";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternObject";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/gulp/GulpService";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolWindowManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createTaskTreeView";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "detectAllBuildfiles";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "detectAllBuildfilesInContentRoots";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyFileStructure";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchBuildfileStructure";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFileManager";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createToolWindowManager";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createTaskTreeView";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "detectAllBuildfiles";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "detectAllBuildfilesInContentRoots";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findIndexFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isBuildfile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isIndexFile";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isNameMatchedStrictly";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyFileStructure";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "fetchBuildfileStructure";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationMatched";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setupRunConfiguration";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "showTaskListingSettingsDialog";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "detectFirstBuildfileInContentRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

