/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.javascript.JSFileReference;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSConditionalCompilationDefinitionsProvider;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSReferenceCompletionContributor;
import com.intellij.lang.javascript.completion.JSReferenceCompletionProvider;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.CompletionResultSink;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.VariantsProcessor;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class JSReferenceCompletionUtil {
    JSReferenceCompletionUtil() {
    }

    @NotNull
    public static Iterable calcDefaultVariants(@NotNull JSExpression expression, PsiFile containingFile, boolean ecma, @NotNull Set<String> pushedSmartVariants, @NotNull CompletionResultSet resultSet) {
        if (expression == null) {
            JSReferenceCompletionUtil.$$$reportNull$$$0(0);
        }
        if (pushedSmartVariants == null) {
            JSReferenceCompletionUtil.$$$reportNull$$$0(1);
        }
        if (resultSet == null) {
            JSReferenceCompletionUtil.$$$reportNull$$$0(2);
        }
        assert (expression instanceof JSReferenceExpression || expression instanceof JSIndexedPropertyAccessExpression);
        JSExpression qualifier = expression instanceof JSIndexedPropertyAccessExpression ? ((JSIndexedPropertyAccessExpression)expression).getQualifier() : (expression instanceof JSReferenceExpressionImpl ? ((JSReferenceExpressionImpl)expression).getResolveQualifier() : ((JSReferenceExpression)expression).getQualifier());
        CompletionResultSink sink = new CompletionResultSink((PsiElement)expression);
        PsiElement parent = expression.getParent();
        if (JSReferenceExpressionImpl.isLocalResolveQualifier(qualifier)) {
            if (expression instanceof JSReferenceExpression && JSResolveUtil.isSelfReference(parent, (PsiElement)expression)) {
                if (parent instanceof JSQualifiedNamedElement && !(parent instanceof JSPackageStatement)) {
                    SmartList results = new SmartList();
                    if (!(parent instanceof JSVariable) || !(JSResolveUtil.findParent(parent) instanceof JSClass)) {
                        VirtualFile file = containingFile.getOriginalFile().getVirtualFile();
                        String fileName = JSFileReference.getFileNameWithoutExtension(file.getName(), JSFileReference.IMPLICIT_EXTENSIONS);
                        String newName = DialectDetector.isTypeScript((PsiElement)containingFile) ? JSReferenceCompletionUtil.capitalizeWords(fileName) : fileName;
                        results.add(newName);
                    }
                    Iterable iterable = JSReferenceCompletionUtil.pushVariants((Iterable)results, pushedSmartVariants, resultSet);
                    if (iterable == null) {
                        JSReferenceCompletionUtil.$$$reportNull$$$0(3);
                    }
                    return iterable;
                }
                List list = Collections.emptyList();
                if (list == null) {
                    JSReferenceCompletionUtil.$$$reportNull$$$0(4);
                }
                return list;
            }
            SinkResolveProcessor<CompletionResultSink> localProcessor = new SinkResolveProcessor<CompletionResultSink>(sink);
            JSReferenceExpressionImpl.doProcessLocalDeclarations((PsiElement)expression, qualifier, localProcessor, ecma, true, null);
            if (ecma && !localProcessor.processingEncounteredAnyTypeAccess() && !localProcessor.isEncounteredDynamicClasses()) {
                List<LookupElement> results = sink.getResultsAsObjects();
                List<LookupElement> concat = expression instanceof JSReferenceExpression ? ContainerUtil.concat((Iterable[])new Iterable[]{results, JSReferenceCompletionUtil.conditionalCompilationVars((JSReferenceExpression)expression)}) : results;
                Iterable iterable = JSReferenceCompletionUtil.pushVariants(concat, pushedSmartVariants, resultSet);
                if (iterable == null) {
                    JSReferenceCompletionUtil.$$$reportNull$$$0(5);
                }
                return iterable;
            }
            if (DialectDetector.isTypeScript((PsiElement)containingFile) && (!(qualifier instanceof JSThisExpression) || JSContextResolver.findContextElement((JSThisExpression)qualifier) instanceof JSClass)) {
                Iterable iterable = JSReferenceCompletionUtil.pushVariants(sink.getResultsAsObjects(), pushedSmartVariants, resultSet);
                if (iterable == null) {
                    JSReferenceCompletionUtil.$$$reportNull$$$0(6);
                }
                return iterable;
            }
        } else {
            boolean useProcessorResults;
            QualifiedItemProcessor<? extends ResultSink> processor = JSDialectSpecificHandlersFactory.forElement((PsiElement)expression).createCompletionItemProcessor(sink, containingFile);
            JSTypeEvaluator.evaluateTypes(BaseJSSymbolProcessor.getOriginalQualifier(qualifier), containingFile.getOriginalFile(), processor);
            boolean bl = useProcessorResults = processor.resolved == QualifiedItemProcessor.TypeResolveState.Resolved || processor.resolved == QualifiedItemProcessor.TypeResolveState.Undefined && (DialectDetector.isTypeScript((PsiElement)containingFile) || ecma) || processor.resolved == QualifiedItemProcessor.TypeResolveState.PrefixUnknown && ecma;
            if (useProcessorResults) {
                Iterable iterable = JSReferenceCompletionUtil.pushVariants(sink.getResultsAsObjects(), pushedSmartVariants, resultSet);
                if (iterable == null) {
                    JSReferenceCompletionUtil.$$$reportNull$$$0(7);
                }
                return iterable;
            }
        }
        Iterable resultIterable = ContainerUtil.emptyIterable();
        VariantsProcessor processor = new VariantsProcessor(containingFile, (PsiElement)expression, JSRootConfiguration.getInstance(containingFile.getProject()).isOnlyTypeBasedCompletion(), resultSet);
        List<PsiElement> processorResults = sink.getResults();
        if (processorResults != null) {
            List<LookupElement> sinkLookupElements = sink.resultsToLookupElements(processorResults);
            processor.populateCompletionList(sinkLookupElements, DialectDetector.isTypeScript((PsiElement)containingFile), resultSet);
            resultIterable = ContainerUtil.concat((Iterable[])new Iterable[]{resultIterable, sinkLookupElements});
        }
        if (!ecma) {
            processor.collectReferencesUsedInCurrentScope((PsiElement)expression, qualifier != null);
        }
        boolean tooMuch = !JSReferenceCompletionContributor.processCompeteMatchedElements(processor);
        Collection<? extends LookupElement> completeMatchResults = processor.getCurrentResults();
        processor.populateCompletionList(completeMatchResults, false, resultSet);
        resultIterable = ContainerUtil.concat((Iterable[])new Iterable[]{resultIterable, completeMatchResults});
        if (tooMuch) {
            JSReferenceCompletionUtil.handleOverflow(resultSet);
            Iterable iterable = resultIterable = ContainerUtil.concat((Iterable[])new Iterable[]{resultIterable, JSReferenceCompletionUtil.finishCompletion(resultSet, processor)});
            if (iterable == null) {
                JSReferenceCompletionUtil.$$$reportNull$$$0(8);
            }
            return iterable;
        }
        boolean bl = tooMuch = !JSReferenceCompletionContributor.processIndexedSymbols((PsiElement)expression, processor, processor.addOnlyCompleteMatches());
        if (tooMuch) {
            JSReferenceCompletionUtil.handleOverflow(resultSet);
        }
        if (qualifier == null && ecma && expression instanceof JSReferenceExpression) {
            Collection conditionalCompilationVars = JSReferenceCompletionUtil.conditionalCompilationVars((JSReferenceExpression)expression);
            JSReferenceCompletionUtil.pushVariants(conditionalCompilationVars, pushedSmartVariants, resultSet);
            resultIterable = ContainerUtil.concat((Iterable[])new Iterable[]{resultIterable, conditionalCompilationVars});
        }
        Iterable iterable = resultIterable = ContainerUtil.concat((Iterable[])new Iterable[]{resultIterable, JSReferenceCompletionUtil.finishCompletion(resultSet, processor)});
        if (iterable == null) {
            JSReferenceCompletionUtil.$$$reportNull$$$0(9);
        }
        return iterable;
    }

    public static String capitalizeWords(String fileName) {
        return StringUtil.capitalizeWords((String)fileName, (String)"-.", (boolean)true, (boolean)false).replace(" ", "");
    }

    protected static void handleOverflow(@NotNull CompletionResultSet resultSet) {
        if (resultSet == null) {
            JSReferenceCompletionUtil.$$$reportNull$$$0(10);
        }
        resultSet.restartCompletionOnAnyPrefixChange();
        resultSet.addLookupAdvertisement("Not all variants are shown, please type more letters to see the rest");
    }

    protected static Iterable finishCompletion(@NotNull CompletionResultSet resultSet, VariantsProcessor processor) {
        if (resultSet == null) {
            JSReferenceCompletionUtil.$$$reportNull$$$0(11);
        }
        Collection<? extends LookupElement> results = processor.getFinalResults();
        processor.populateCompletionList(results, false, resultSet);
        return results;
    }

    @NotNull
    private static Collection conditionalCompilationVars(JSReferenceExpression expression) {
        JSReferenceExpression namespaceReference = JSReferenceExpressionImpl.getNamespaceReference(expression);
        List<String> list = namespaceReference != null && namespaceReference.resolve() == namespaceReference ? JSReferenceCompletionUtil.getConditionalCompilationConstantNamesForNamespace((PsiElement)expression, namespaceReference.getReferenceName()) : JSReferenceCompletionUtil.getAllConditionalCompilationConstants((PsiElement)expression);
        if (list == null) {
            JSReferenceCompletionUtil.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    private static List getAllConditionalCompilationConstants(PsiElement context) {
        ArrayList<Object> names = new ArrayList<Object>();
        for (JSConditionalCompilationDefinitionsProvider provider : (JSConditionalCompilationDefinitionsProvider[])JSConditionalCompilationDefinitionsProvider.EP_NAME.getExtensions()) {
            for (String conditional : provider.getAllConstants(ModuleUtilCore.findModuleForPsiElement((PsiElement)context))) {
                LookupItem lookupElement = new LookupItem((Object)conditional, conditional);
                JSCompletionUtil.setJSLookupPriority(lookupElement, JSLookupPriority.CONDITIONAL_COMPILATION_CONSTANTS_PRIORITY);
                names.add(lookupElement);
            }
            names.addAll(provider.getAllConstants(ModuleUtilCore.findModuleForPsiElement((PsiElement)context)));
        }
        ArrayList<Object> arrayList = names;
        if (arrayList == null) {
            JSReferenceCompletionUtil.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    private static List<String> getConditionalCompilationConstantNamesForNamespace(PsiElement context, String namespace) {
        ArrayList<String> names = new ArrayList<String>();
        for (JSConditionalCompilationDefinitionsProvider provider : (JSConditionalCompilationDefinitionsProvider[])JSConditionalCompilationDefinitionsProvider.EP_NAME.getExtensions()) {
            names.addAll(provider.getConstantNamesForNamespace(ModuleUtilCore.findModuleForPsiElement((PsiElement)context), namespace));
        }
        ArrayList<String> arrayList = names;
        if (arrayList == null) {
            JSReferenceCompletionUtil.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @NotNull
    private static Iterable pushVariants(@NotNull Iterable variants, Set<String> populatedVariants, @NotNull CompletionResultSet result) {
        if (variants == null) {
            JSReferenceCompletionUtil.$$$reportNull$$$0(15);
        }
        if (result == null) {
            JSReferenceCompletionUtil.$$$reportNull$$$0(16);
        }
        for (Object variant : variants) {
            LookupElement element = CompletionData.objectToLookupItem(variant);
            if (populatedVariants.contains(element.getLookupString())) continue;
            JSReferenceCompletionProvider.addVariant(JSInsertHandler.DEFAULT, element, result);
        }
        Iterable iterable = variants;
        if (iterable == null) {
            JSReferenceCompletionUtil.$$$reportNull$$$0(17);
        }
        return iterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pushedSmartVariants";
                break;
            }
            case 2: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/completion/JSReferenceCompletionUtil";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variants";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/completion/JSReferenceCompletionUtil";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "calcDefaultVariants";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "conditionalCompilationVars";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllConditionalCompilationConstants";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getConditionalCompilationConstantNamesForNamespace";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "pushVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calcDefaultVariants";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 17: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "handleOverflow";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "finishCompletion";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "pushVariants";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

