/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.psi.resolve.JSResolveScopeProvider;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.scratch.JSScratchFileInfoProvider;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptResolveScopeProvider
extends JSResolveScopeProvider {
    @Nullable
    public GlobalSearchScope getResolveScope(@NotNull VirtualFile file, Project project) {
        if (file == null) {
            TypeScriptResolveScopeProvider.$$$reportNull$$$0(0);
        }
        FileType type = file.getFileType();
        if (!this.isApplicable(file) && !TypeScriptResolveScopeProvider.isTypeScriptScratchFile(file, project, type)) {
            return null;
        }
        TypeScriptLibraryProvider libraryService = TypeScriptLibraryProvider.getService(project);
        Set<VirtualFile> allLibraries = libraryService.getAllPredefinedLibraries();
        if (allLibraries.contains(file)) {
            return GlobalSearchScope.filesScope((Project)project, libraryService.getPredefinedLibraries(file));
        }
        GlobalSearchScope moduleAndLibraryScope = this.getModuleAndDefaultLibraryScope(file, project);
        return this.restrictByFileType(file, libraryService, moduleAndLibraryScope);
    }

    protected GlobalSearchScope restrictByFileType(@NotNull VirtualFile file, @NotNull TypeScriptLibraryProvider libraryService, @NotNull GlobalSearchScope moduleAndLibraryScope) {
        if (file == null) {
            TypeScriptResolveScopeProvider.$$$reportNull$$$0(1);
        }
        if (libraryService == null) {
            TypeScriptResolveScopeProvider.$$$reportNull$$$0(2);
        }
        if (moduleAndLibraryScope == null) {
            TypeScriptResolveScopeProvider.$$$reportNull$$$0(3);
        }
        return libraryService.getFileTypeRestrictedScope(moduleAndLibraryScope, file);
    }

    @NotNull
    private GlobalSearchScope getModuleAndDefaultLibraryScope(@NotNull VirtualFile file, @NotNull Project project) {
        Module module;
        if (file == null) {
            TypeScriptResolveScopeProvider.$$$reportNull$$$0(4);
        }
        if (project == null) {
            TypeScriptResolveScopeProvider.$$$reportNull$$$0(5);
        }
        if ((module = ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(file)) == null) {
            GlobalSearchScope globalSearchScope = this.getProjectScopeIncludingPredefines(project);
            if (globalSearchScope == null) {
                TypeScriptResolveScopeProvider.$$$reportNull$$$0(6);
            }
            return globalSearchScope;
        }
        GlobalSearchScope scopeExcludingJsLibs = (GlobalSearchScope)((CachedValue)JSResolveUtil.ourScopeCache.get((UserDataHolder)module, null)).getValue();
        GlobalSearchScope libScope = JSLibraryMappings.getInstance(project).getLibraryScopeForFile(file, Collections.emptySet(), JSCorePredefinedLibrariesProvider.getJavaScriptPredefinedLibraryFiles());
        GlobalSearchScope globalSearchScope = scopeExcludingJsLibs.uniteWith(libScope);
        if (globalSearchScope == null) {
            TypeScriptResolveScopeProvider.$$$reportNull$$$0(7);
        }
        return globalSearchScope;
    }

    private static boolean isTypeScriptScratchFile(@NotNull VirtualFile file, @NotNull Project project, @NotNull FileType type) {
        if (file == null) {
            TypeScriptResolveScopeProvider.$$$reportNull$$$0(8);
        }
        if (project == null) {
            TypeScriptResolveScopeProvider.$$$reportNull$$$0(9);
        }
        if (type == null) {
            TypeScriptResolveScopeProvider.$$$reportNull$$$0(10);
        }
        return type instanceof LanguageFileType && JSScratchFileInfoProvider.Provider.isScratchForLanguage(project, file, type, JavaScriptSupportLoader.TYPESCRIPT);
    }

    @Override
    public List<VirtualFile> getPredefinedLibraryFiles(@NotNull Project project) {
        if (project == null) {
            TypeScriptResolveScopeProvider.$$$reportNull$$$0(11);
        }
        return JSResolveUtil.JS_INDEXED_ROOT_PROVIDER.getLibraryFiles(project).stream().filter(this::isApplicable).collect(Collectors.toList());
    }

    protected boolean isApplicable(@NotNull VirtualFile file) {
        if (file == null) {
            TypeScriptResolveScopeProvider.$$$reportNull$$$0(12);
        }
        return TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(file.getFileType());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryService";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleAndLibraryScope";
                break;
            }
            case 5: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptResolveScopeProvider";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptResolveScopeProvider";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleAndDefaultLibraryScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getResolveScope";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "restrictByFileType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getModuleAndDefaultLibraryScope";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isTypeScriptScratchFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedLibraryFiles";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

