/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.editing;

import com.intellij.codeInsight.hints.HintInfo;
import com.intellij.codeInsight.hints.InlayInfo;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.Option;
import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptInlayParameterHintsProvider
implements InlayParameterHintsProvider {
    public static final Option NAMES_FOR_ALL_ARGS = new Option("js.show.names.for.all.args", "Show name for all arguments", false);
    private static final Set<String> DEFAULT_BLACKLIST = ContainerUtil.immutableSet((Object[])new String[]{"(begin*, end*)", "(start*, end*)", "(first*, last*)", "(first*, second*)", "(from*, to*)", "(min*, max*)", "(key, value)", "(format, arg*)", "(message)", "(message, error)", "*.set*(*)", "*.add(*)", "*.push(*)", "*.concat(*)", "*.join(*)", "*.forEach(*)", "*.map(*)", "*.reduce(*, *)", "*.set(*,*)", "*.filter(*)", "*.get(*)", "*.create(*)", "*.log(*)", "*.log(*, *)", "*.error(*)", "*.error(*, *)", "*.debug(*)", "*.debug(*, *)", "*.append(*)", "*.charAt(*)", "*.charCodeAt(*)", "*.indexOf(*, *)", "*.lastIndexOf(*, *)", "*.contains(*)", "*.startsWith(*)", "*.startsWith(*, *)", "*.endsWith(*)", "*.endsWith(*, *)"});

    @Nullable
    public HintInfo getHintInfo(@NotNull PsiElement element) {
        List<? extends JSFunctionItem> psiElements;
        if (element == null) {
            TypeScriptInlayParameterHintsProvider.$$$reportNull$$$0(0);
        }
        if ((psiElements = this.resolveFunction(element)).size() != 1) {
            return null;
        }
        JSFunctionItem psiElement = psiElements.get(0);
        if (psiElement == null) {
            return null;
        }
        JSParameterItem[] parameters = psiElement.getParameters();
        if (parameters.length == 0) {
            return null;
        }
        List parameterNames = Arrays.stream(parameters).map(el -> el.getName()).collect(Collectors.toList());
        String qName = psiElement.getQualifiedName();
        if (qName != null) {
            return new HintInfo.MethodInfo(qName, parameterNames);
        }
        return null;
    }

    @NotNull
    public List<? extends JSFunctionItem> resolveFunction(@Nullable PsiElement element) {
        if (!(element instanceof JSCallExpression)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptInlayParameterHintsProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        if (element.getParent() instanceof ES6Decorator) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptInlayParameterHintsProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        JSExpression expression = ((JSCallExpression)element).getMethodExpression();
        if (!(expression instanceof JSReferenceExpression)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptInlayParameterHintsProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        if (element instanceof JSNewExpression) {
            List<JSFunctionWithSubstitutor> functionWithSubstitutors = TypeScriptSignatureChooser.getFunctionElementsWithCheckParameterTypes((PsiElement)expression);
            List list = functionWithSubstitutors.size() != 1 ? ContainerUtil.emptyList() : functionWithSubstitutors.stream().map(el -> el.myFunctionItem).collect(Collectors.toList());
            if (list == null) {
                TypeScriptInlayParameterHintsProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        ResolveResult[] results = ((JSReferenceExpression)expression).multiResolve(false);
        PsiElement resolve = JSResolveResult.resolve(results);
        if (resolve == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptInlayParameterHintsProvider.$$$reportNull$$$0(5);
            }
            return list;
        }
        PsiElement psiElement = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(resolve);
        List<JSFunction> list = JSUtils.getRelatedFunctions(psiElement);
        if (list == null) {
            TypeScriptInlayParameterHintsProvider.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public List<Option> getSupportedOptions() {
        List list = ContainerUtil.list((Object[])new Option[]{NAMES_FOR_ALL_ARGS});
        if (list == null) {
            TypeScriptInlayParameterHintsProvider.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public List<InlayInfo> getParameterHints(@NotNull PsiElement element) {
        JSParameterListElement[] parameters;
        if (element == null) {
            TypeScriptInlayParameterHintsProvider.$$$reportNull$$$0(8);
        }
        if (!(element instanceof JSCallExpression)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptInlayParameterHintsProvider.$$$reportNull$$$0(9);
            }
            return list;
        }
        boolean showAll = NAMES_FOR_ALL_ARGS.get();
        JSCallExpression callExpression = (JSCallExpression)element;
        List<? extends JSFunctionItem> functions = this.resolveFunction(element);
        JSExpression[] arguments = callExpression.getArguments();
        if (functions.size() == 0) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptInlayParameterHintsProvider.$$$reportNull$$$0(10);
            }
            return list;
        }
        Object[] objectArray = parameters = functions.size() == 1 ? functions.get(0).getParameters() : JSUtils.resolveOverloadParameterList(functions, arguments);
        if (parameters.length == 0) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptInlayParameterHintsProvider.$$$reportNull$$$0(11);
            }
            return list;
        }
        int toStop = Math.min(arguments.length, parameters.length);
        ArrayList list = ContainerUtil.newArrayListWithCapacity((int)toStop);
        for (int i = 0; i < toStop; ++i) {
            JSExpression argument = arguments[i];
            JSParameterListElement parameter = parameters[i];
            if (!TypeScriptInlayParameterHintsProvider.shouldInlineParameterName((PsiElement)argument, (JSParameterItem)parameter, showAll)) continue;
            list.add(this.createInlayInfo(argument, (JSParameterItem)parameter));
        }
        ArrayList arrayList = list;
        if (arrayList == null) {
            TypeScriptInlayParameterHintsProvider.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @NotNull
    public InlayInfo createInlayInfo(@NotNull JSExpression argument, @NotNull JSParameterItem parameter) {
        if (argument == null) {
            TypeScriptInlayParameterHintsProvider.$$$reportNull$$$0(13);
        }
        if (parameter == null) {
            TypeScriptInlayParameterHintsProvider.$$$reportNull$$$0(14);
        }
        InlayInfo inlayInfo = new InlayInfo(StringUtil.notNullize((String)parameter.getName()), argument.getTextOffset());
        if (inlayInfo == null) {
            TypeScriptInlayParameterHintsProvider.$$$reportNull$$$0(15);
        }
        return inlayInfo;
    }

    static boolean isLiteralOrUndefined(@Nullable PsiElement argument) {
        return argument instanceof JSLiteralExpression || argument instanceof JSPrefixExpression && ((JSPrefixExpression)argument).getExpression() instanceof JSLiteralExpression || argument instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)argument, "undefined");
    }

    private static boolean shouldInlineParameterName(@NotNull PsiElement argument, @NotNull JSParameterItem parameter, boolean showAll) {
        if (argument == null) {
            TypeScriptInlayParameterHintsProvider.$$$reportNull$$$0(16);
        }
        if (parameter == null) {
            TypeScriptInlayParameterHintsProvider.$$$reportNull$$$0(17);
        }
        if (parameter instanceof JSDestructuringParameter) {
            return false;
        }
        String name = parameter.getName();
        if (StringUtil.isEmpty((String)name)) {
            return false;
        }
        if (showAll) {
            return true;
        }
        if (argument instanceof JSBinaryExpression || argument instanceof JSConditionalExpression || argument instanceof JSObjectLiteralExpression || argument instanceof JSArrayLiteralExpression || argument instanceof JSFunctionExpression && ((JSFunctionExpression)argument).getName() == null) {
            return true;
        }
        return TypeScriptInlayParameterHintsProvider.isLiteralOrUndefined(argument);
    }

    public String getBlacklistExplanationHTML() {
        return JSBundle.message((String)"ts.inlay.hints.blacklist.pattern.explanation", (Object[])new Object[0]);
    }

    @NotNull
    public Set<String> getDefaultBlackList() {
        Set<String> set = DEFAULT_BLACKLIST;
        if (set == null) {
            TypeScriptInlayParameterHintsProvider.$$$reportNull$$$0(18);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/editing/TypeScriptInlayParameterHintsProvider";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/editing/TypeScriptInlayParameterHintsProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveFunction";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedOptions";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterHints";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createInlayInfo";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultBlackList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getHintInfo";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 18: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getParameterHints";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createInlayInfo";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "shouldInlineParameterName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

