/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.codeInspection.CustomSuppressableInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.ex.PairedUnfairLocalInspectionTool;
import com.intellij.lang.javascript.flow.FlowJSAnnotation;
import com.intellij.lang.javascript.flow.FlowJSServerManager;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSErrorInspection
extends JSInspection
implements CustomSuppressableInspectionTool,
PairedUnfairLocalInspectionTool {
    @NotNull
    public SuppressQuickFix[] getBatchSuppressActions(@Nullable PsiElement element) {
        if (SuppressQuickFix.EMPTY_ARRAY == null) {
            FlowJSErrorInspection.$$$reportNull$$$0(0);
        }
        return SuppressQuickFix.EMPTY_ARRAY;
    }

    @Nullable
    public SuppressIntentionAction[] getSuppressActions(@Nullable PsiElement element) {
        return SuppressIntentionAction.EMPTY_ARRAY;
    }

    public boolean isSuppressedFor(@NotNull PsiElement element) {
        if (element == null) {
            FlowJSErrorInspection.$$$reportNull$$$0(1);
        }
        return false;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        if (this.myOnTheFly) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                FlowJSErrorInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitFile(PsiFile file) {
                FlowJSServerService service = FlowJSServerManager.getService(file);
                if (service == null) {
                    return;
                }
                if (!FlowJSAnnotation.isFlowAnnotation(file)) {
                    return;
                }
                Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
                if (document == null) {
                    return;
                }
                Future<List<JSAnnotationError>> highlight = service.highlight(file, null);
                List<JSAnnotationError> errors = JSLanguageServiceUtil.awaitFuture(highlight);
                if (errors != null) {
                    FlowJSErrorInspection.reportErrors(errors, file, document, holder);
                }
                super.visitFile(file);
            }
        };
        if (psiElementVisitor == null) {
            FlowJSErrorInspection.$$$reportNull$$$0(3);
        }
        return psiElementVisitor;
    }

    @NotNull
    public String getInspectionForBatchShortName() {
        String string = this.getShortName();
        if (string == null) {
            FlowJSErrorInspection.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static void reportErrors(@NotNull List<JSAnnotationError> annotationResult, @NotNull PsiFile file, @NotNull Document document, @NotNull ProblemsHolder holder) {
        if (annotationResult == null) {
            FlowJSErrorInspection.$$$reportNull$$$0(5);
        }
        if (file == null) {
            FlowJSErrorInspection.$$$reportNull$$$0(6);
        }
        if (document == null) {
            FlowJSErrorInspection.$$$reportNull$$$0(7);
        }
        if (holder == null) {
            FlowJSErrorInspection.$$$reportNull$$$0(8);
        }
        VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
        for (JSAnnotationError result : annotationResult) {
            JSLanguageServiceUtil.PsiElementInfo info;
            if (StringUtil.isEmpty((String)result.getAbsoluteFilePath()) || !FileUtil.pathsEqual((String)result.getAbsoluteFilePath(), (String)virtualFile.getCanonicalPath()) || (info = JSLanguageServiceUtil.getElementInfo(file, document, result)) == null) continue;
            PsiElement element = info.getElement();
            holder.registerProblem((PsiElement)(element != null ? element : file), info.getRange(), result.getDescription(), new LocalQuickFix[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flow/FlowJSErrorInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationResult";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBatchSuppressActions";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flow/FlowJSErrorInspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionForBatchShortName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "reportErrors";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

