/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter.blocks;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Block;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.formatter.FormattableInjectedBlockInJS;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.formatter.blocks.CompositeJSBlock;
import com.intellij.lang.javascript.formatter.blocks.JSBlock;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.xml.XmlTagBlock;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.formatter.chainedMethods.ChainedBlocksSpacingStrategy;
import java.util.List;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSpacingStrategy
extends ChainedBlocksSpacingStrategy {
    private final JSCodeStyleSettings myJSCodeStyleSettings;
    private final BiFunction<ASTNode, ASTNode, Spacing> myProcessor;

    public JSSpacingStrategy(@NotNull JSCodeStyleSettings dialectSettings, @NotNull CommonCodeStyleSettings commonSettings, @NotNull BiFunction<ASTNode, ASTNode, Spacing> processor) {
        if (dialectSettings == null) {
            JSSpacingStrategy.$$$reportNull$$$0(0);
        }
        if (commonSettings == null) {
            JSSpacingStrategy.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            JSSpacingStrategy.$$$reportNull$$$0(2);
        }
        super(commonSettings);
        this.myJSCodeStyleSettings = dialectSettings;
        this.myProcessor = processor;
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            JSSpacingStrategy.$$$reportNull$$$0(3);
        }
        if (child1 instanceof CompositeJSBlock) {
            return this.getSpacing((Block)ContainerUtil.getLastItem((List)child1.getSubBlocks()), child2);
        }
        if (child2 instanceof CompositeJSBlock) {
            return this.getSpacing(child1, (Block)child2.getSubBlocks().get(0));
        }
        Spacing spacing = super.getSpacing(child1, child2);
        if (spacing != null) {
            return spacing;
        }
        if (!JSSpacingStrategy.canComputeSpacing(child1) || !JSSpacingStrategy.canComputeSpacing(child2)) {
            return null;
        }
        return this.myProcessor.apply(((ASTBlock)child1).getNode(), ((ASTBlock)child2).getNode());
    }

    private static boolean canComputeSpacing(Block block) {
        return block instanceof JSBlock || block instanceof XmlTagBlock || block instanceof FormattableInjectedBlockInJS;
    }

    protected boolean isDotOnNewLine() {
        return this.myJSCodeStyleSettings.CHAINED_CALL_DOT_ON_NEW_LINE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialectSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/formatter/blocks/JSSpacingStrategy";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getSpacing";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

