/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.flow.validation;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.validation.TypeScriptKeywordHighlighterVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FlowKeywordHighlighterVisitor
extends TypeScriptKeywordHighlighterVisitor {
    private static final Set<IElementType> MODIFIERS = Collections.singleton(JSTokenTypes.DECLARE_KEYWORD);
    private static final TokenSet SPECIFIER_MODIFIERS = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.TYPE_KEYWORD, JSTokenTypes.TYPEOF_KEYWORD});

    public FlowKeywordHighlighterVisitor(@NotNull AnnotationHolder holder) {
        if (holder == null) {
            FlowKeywordHighlighterVisitor.$$$reportNull$$$0(0);
        }
        super(holder, new JSHighlighter(DialectOptionHolder.FLOW));
    }

    public void visitES6ImportDeclaration(ES6ImportDeclaration element) {
        this.highlightChildKeywordOfType((PsiElement)element, JSTokenTypes.TYPE_KEYWORD);
        super.visitES6ImportDeclaration(element);
    }

    public void visitES6ImportExportSpecifier(ES6ImportExportSpecifier specifier) {
        ASTNode typeKeyword = specifier.getNode().findChildByType(SPECIFIER_MODIFIERS);
        if (typeKeyword != null && specifier.getReferenceNameElement() != typeKeyword.getPsi()) {
            FlowKeywordHighlighterVisitor.highlightKeyword(typeKeyword, this.myHolder, this.myHighlighter);
        }
        super.visitES6ImportExportSpecifier(specifier);
    }

    public void visitJSReferenceList(JSReferenceList element) {
        this.highlightChildKeywordOfType((PsiElement)element, JSTokenTypes.MIXINS_KEYWORD);
        super.visitJSReferenceList(element);
    }

    @Override
    public void visitTypeScriptTypeAlias(TypeScriptTypeAlias element) {
        this.highlightChildKeywordOfType((PsiElement)element, JSTokenTypes.OPAQUE_KEYWORD);
        super.visitTypeScriptTypeAlias(element);
    }

    @Override
    @NotNull
    protected Collection<IElementType> getModifiers() {
        Set<IElementType> set = MODIFIERS;
        if (set == null) {
            FlowKeywordHighlighterVisitor.$$$reportNull$$$0(1);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/flow/validation/FlowKeywordHighlighterVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/flow/validation/FlowKeywordHighlighterVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

