/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules;

import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.library.NodeJsCoreLibraryManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.frameworks.modules.JSModuleFileReferenceSet;
import com.intellij.lang.javascript.psi.resolve.JSModuleReferenceContributor;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDefaultModuleReferenceContributor
implements JSModuleReferenceContributor {
    @Override
    @NotNull
    public PsiReference[] getAllReferences(@NotNull String unquotedRefText, @NotNull PsiElement host, int offset, @Nullable PsiReferenceProvider provider) {
        if (unquotedRefText == null) {
            JSDefaultModuleReferenceContributor.$$$reportNull$$$0(0);
        }
        if (host == null) {
            JSDefaultModuleReferenceContributor.$$$reportNull$$$0(1);
        }
        PsiReference[] psiReferenceArray = this.getReferences(unquotedRefText, host, offset, provider, false);
        if (psiReferenceArray == null) {
            JSDefaultModuleReferenceContributor.$$$reportNull$$$0(2);
        }
        return psiReferenceArray;
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement host) {
        if (host == null) {
            JSDefaultModuleReferenceContributor.$$$reportNull$$$0(3);
        }
        return !DialectDetector.isTypeScript(host);
    }

    @Override
    @NotNull
    public PsiReference[] getCommonJSModuleReferences(@NotNull String unquotedRefText, @NotNull PsiElement host, int offset, @Nullable PsiReferenceProvider provider) {
        if (unquotedRefText == null) {
            JSDefaultModuleReferenceContributor.$$$reportNull$$$0(4);
        }
        if (host == null) {
            JSDefaultModuleReferenceContributor.$$$reportNull$$$0(5);
        }
        PsiReference[] psiReferenceArray = this.getReferences(unquotedRefText, host, offset, provider, true);
        if (psiReferenceArray == null) {
            JSDefaultModuleReferenceContributor.$$$reportNull$$$0(6);
        }
        return psiReferenceArray;
    }

    @Override
    @NotNull
    public PsiReference[] getReferences(@NotNull String unquotedRefText, @NotNull PsiElement host, int offset, @Nullable PsiReferenceProvider provider, boolean isCommonJS) {
        if (unquotedRefText == null) {
            JSDefaultModuleReferenceContributor.$$$reportNull$$$0(7);
        }
        if (host == null) {
            JSDefaultModuleReferenceContributor.$$$reportNull$$$0(8);
        }
        Pair<Integer, String> path = JSModuleReferenceContributor.getActualPath(unquotedRefText);
        String modulePath = (String)path.second;
        Integer resourcePathStartInd = (Integer)path.first;
        int index = resourcePathStartInd + offset;
        final boolean isSoft = JSDefaultModuleReferenceContributor.isSoft(host, modulePath, isCommonJS);
        FileReference[] fileReferenceArray = new JSModuleFileReferenceSet(modulePath, host, index, provider, JSDefaultModuleReferenceContributor.getFileTemplateName(host, isCommonJS)){

            protected boolean isSoft() {
                return isSoft;
            }
        }.getAllReferences();
        if (fileReferenceArray == null) {
            JSDefaultModuleReferenceContributor.$$$reportNull$$$0(9);
        }
        return fileReferenceArray;
    }

    private static boolean isSoft(@NotNull PsiElement host, @NotNull String modulePath, boolean isCommonJS) {
        if (host == null) {
            JSDefaultModuleReferenceContributor.$$$reportNull$$$0(10);
        }
        if (modulePath == null) {
            JSDefaultModuleReferenceContributor.$$$reportNull$$$0(11);
        }
        if (!isCommonJS) {
            return !JSModuleFileReferenceSet.isRelative(modulePath) && !modulePath.endsWith(".js");
        }
        if (!NodeModuleSearchUtil.isFileModuleRequired(modulePath)) {
            return true;
        }
        PsiFile file = host.getContainingFile();
        if (file != null) {
            file = file.getOriginalFile();
        }
        if (file != null && file.isValid()) {
            return !NodeJsCoreLibraryManager.isAssociatedWithNodeCoreLibrary(file);
        }
        return false;
    }

    @Nullable
    private static String getFileTemplateName(@NotNull PsiElement host, boolean isCommonJS) {
        boolean supportsNativeModules;
        if (host == null) {
            JSDefaultModuleReferenceContributor.$$$reportNull$$$0(12);
        }
        return (supportsNativeModules = DialectDetector.isES6(host)) || isCommonJS ? null : "AMD JavaScript File.js";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unquotedRefText";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 2: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/modules/JSDefaultModuleReferenceContributor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/modules/JSDefaultModuleReferenceContributor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllReferences";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonJSModuleReferences";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllReferences";
                break;
            }
            case 2: 
            case 6: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCommonJSModuleReferences";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isSoft";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFileTemplateName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

