/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.frameworks.amd.JSAmdUtil;
import com.intellij.lang.javascript.frameworks.amd.JSModuleReference;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.typescript.library.download.TypeScriptDefinitionFilesDirectory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSModuleFileReferenceSet
extends FileReferenceSet {
    private final String myExplicitNewFileTemplate;

    public JSModuleFileReferenceSet(String str, @NotNull PsiElement element, int startInElement, @Nullable PsiReferenceProvider provider, @Nullable String explicitNewFileTemplate) {
        if (element == null) {
            JSModuleFileReferenceSet.$$$reportNull$$$0(0);
        }
        super(str, element, startInElement, provider, false, false, FileType.EMPTY_ARRAY, false);
        this.myExplicitNewFileTemplate = explicitNewFileTemplate;
        this.reparse();
    }

    @NotNull
    public Collection<PsiFileSystemItem> computeDefaultContexts() {
        if (this.isAbsolutePathReference()) {
            LinkedHashSet result = ContainerUtil.newLinkedHashSet((Iterable)super.computeDefaultContexts());
            result.addAll(this.toFileSystemItems(ManagingFS.getInstance().getLocalRoots()));
            LinkedHashSet linkedHashSet = result;
            if (linkedHashSet == null) {
                JSModuleFileReferenceSet.$$$reportNull$$$0(1);
            }
            return linkedHashSet;
        }
        String path = this.getPathString();
        if (JSModuleFileReferenceSet.isRelative(path)) {
            Collection collection = super.computeDefaultContexts();
            if (collection == null) {
                JSModuleFileReferenceSet.$$$reportNull$$$0(2);
            }
            return collection;
        }
        PsiElement element = this.getElement();
        Project project = element.getProject();
        LinkedHashSet result = ContainerUtil.newLinkedHashSet();
        JSModuleFileReferenceSet.addNodeModulesDirContexts(project, element, result, this);
        this.addGlobalTypesContexts(result);
        result.addAll(JSAmdUtil.getBaseDirectories(element));
        result.addAll(this.getParentDirectoryContext());
        PsiFile file = this.getContainingFile();
        if (file != null) {
            JSModuleFileReferenceSet.addDefaultRoots(project, file, result);
        }
        result.addAll(super.computeDefaultContexts());
        LinkedHashSet linkedHashSet = result;
        if (linkedHashSet == null) {
            JSModuleFileReferenceSet.$$$reportNull$$$0(3);
        }
        return linkedHashSet;
    }

    private static void addDefaultRoots(@NotNull Project project, @NotNull PsiFile file, @NotNull Collection<PsiFileSystemItem> result) {
        VirtualFile[] roots;
        ModuleRootManager rootManager;
        if (project == null) {
            JSModuleFileReferenceSet.$$$reportNull$$$0(4);
        }
        if (file == null) {
            JSModuleFileReferenceSet.$$$reportNull$$$0(5);
        }
        if (result == null) {
            JSModuleFileReferenceSet.$$$reportNull$$$0(6);
        }
        PsiManager manager = file.getManager();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module != null && (rootManager = ModuleRootManager.getInstance((Module)module)) != null && (roots = rootManager.getSourceRoots()).length > 0) {
            for (VirtualFile root : roots) {
                ContainerUtil.addIfNotNull(result, (Object)manager.findDirectory(root));
            }
            return;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile contentRoot = index.getContentRootForFile(virtualFile);
        if (contentRoot != null) {
            ContainerUtil.addIfNotNull(result, (Object)manager.findDirectory(contentRoot));
        }
    }

    public FileReference createFileReference(TextRange textRange, int i, String text) {
        return new JSModuleReference(text, i, textRange, this, this.myExplicitNewFileTemplate, this.isSoft());
    }

    public static void addNodeModulesDirContexts(@NotNull Project project, @NotNull PsiElement element, @NotNull Collection<PsiFileSystemItem> result, @NotNull FileReferenceSet referenceSet) {
        FileReference firstRef;
        String firstRefText;
        if (project == null) {
            JSModuleFileReferenceSet.$$$reportNull$$$0(7);
        }
        if (element == null) {
            JSModuleFileReferenceSet.$$$reportNull$$$0(8);
        }
        if (result == null) {
            JSModuleFileReferenceSet.$$$reportNull$$$0(9);
        }
        if (referenceSet == null) {
            JSModuleFileReferenceSet.$$$reportNull$$$0(10);
        }
        String string = firstRefText = (firstRef = (FileReference)ArrayUtil.getFirstElement((Object[])referenceSet.getAllReferences())) != null ? firstRef.getText() : null;
        if (StringUtil.isEmpty((String)firstRefText)) {
            return;
        }
        VirtualFile localNodeModulesDir = JSModuleFileReferenceSet.findUpNodeModules(element);
        if (localNodeModulesDir == null) {
            JSModuleFileReferenceSet.addNodeModulesContextsFromIndexes(project, element, result, firstRefText);
        } else {
            VirtualFile current = localNodeModulesDir;
            while (current != null) {
                VirtualFile packageJson = NodeModuleUtil.findPackageJsonByNodeModules(current);
                JSModuleFileReferenceSet.doAddNodeModulesContext(current, packageJson, firstRefText, result, element.getManager());
                VirtualFile parent = current.getParent();
                current = parent == null ? null : NodeModuleUtil.findUpClosestNodeModulesResolveRoot(parent);
            }
            JSModuleFileReferenceSet.addTypesForNodeModulesDir(element, result, localNodeModulesDir);
        }
    }

    private static void addNodeModulesContextsFromIndexes(@NotNull Project project, @NotNull PsiElement element, @NotNull Collection<PsiFileSystemItem> result, String firstRefText) {
        if (project == null) {
            JSModuleFileReferenceSet.$$$reportNull$$$0(11);
        }
        if (element == null) {
            JSModuleFileReferenceSet.$$$reportNull$$$0(12);
        }
        if (result == null) {
            JSModuleFileReferenceSet.$$$reportNull$$$0(13);
        }
        Collection files = FilenameIndex.getVirtualFilesByName((Project)project, (String)"package.json", (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
        for (VirtualFile file : files) {
            VirtualFile nodeModulesDir = NodeModuleUtil.findNodeModulesByPackageJson(file);
            if (nodeModulesDir == null) continue;
            JSModuleFileReferenceSet.doAddNodeModulesContext(nodeModulesDir, file, firstRefText, result, element.getManager());
            JSModuleFileReferenceSet.addTypesForNodeModulesDir(element, result, nodeModulesDir);
        }
    }

    private void addGlobalTypesContexts(@NotNull Collection<PsiFileSystemItem> result) {
        PsiDirectory psiDirectory;
        FileReference firstRef;
        String firstRefText;
        if (result == null) {
            JSModuleFileReferenceSet.$$$reportNull$$$0(14);
        }
        String string = firstRefText = (firstRef = (FileReference)ArrayUtil.getFirstElement((Object[])this.myReferences)) != null ? firstRef.getText() : null;
        if (StringUtil.isEmpty((String)firstRefText)) {
            return;
        }
        VirtualFile directory = TypeScriptDefinitionFilesDirectory.getGlobalTypesDirectory();
        if (directory == null || !directory.isValid()) {
            return;
        }
        VirtualFile child = directory.findChild(firstRefText);
        if (child == null) {
            return;
        }
        PsiElement element = this.getElement();
        ProjectFileIndex index = ProjectFileIndex.getInstance((Project)element.getProject());
        if (index.isInLibrary(child) && (psiDirectory = element.getManager().findDirectory(directory)) != null) {
            result.add((PsiFileSystemItem)psiDirectory);
        }
    }

    @Nullable
    private static VirtualFile findUpNodeModules(@NotNull PsiElement element) {
        VirtualFile currentFile;
        if (element == null) {
            JSModuleFileReferenceSet.$$$reportNull$$$0(15);
        }
        if ((currentFile = element.getContainingFile().getOriginalFile().getVirtualFile()) != null) {
            return NodeModuleUtil.findUpClosestNodeModulesResolveRoot(currentFile);
        }
        return null;
    }

    private static void doAddNodeModulesContext(@NotNull VirtualFile nodeModulesDir, @Nullable VirtualFile packageJson, @NotNull String firstRefText, @NotNull Collection<PsiFileSystemItem> result, @NotNull PsiManager psiManager) {
        PackageJsonData data;
        if (nodeModulesDir == null) {
            JSModuleFileReferenceSet.$$$reportNull$$$0(16);
        }
        if (firstRefText == null) {
            JSModuleFileReferenceSet.$$$reportNull$$$0(17);
        }
        if (result == null) {
            JSModuleFileReferenceSet.$$$reportNull$$$0(18);
        }
        if (psiManager == null) {
            JSModuleFileReferenceSet.$$$reportNull$$$0(19);
        }
        if (packageJson != null && !(data = PackageJsonUtil.getOrCreateData(packageJson)).containsDependencyWithScope(firstRefText) && !data.isDependencyOfAnyType(firstRefText)) {
            return;
        }
        PsiDirectory directory = psiManager.findDirectory(nodeModulesDir);
        if (directory != null) {
            result.add((PsiFileSystemItem)directory);
        }
    }

    public static void addTypesForNodeModulesDir(@NotNull PsiElement context, @NotNull Collection<PsiFileSystemItem> altResolveModules, @Nullable VirtualFile nodeModulesDirectories) {
        PsiDirectory typesModules;
        VirtualFile typesFile;
        if (context == null) {
            JSModuleFileReferenceSet.$$$reportNull$$$0(20);
        }
        if (altResolveModules == null) {
            JSModuleFileReferenceSet.$$$reportNull$$$0(21);
        }
        if (nodeModulesDirectories != null && (typesFile = nodeModulesDirectories.findChild("@types")) != null && (typesModules = context.getManager().findDirectory(typesFile)) != null) {
            altResolveModules.add((PsiFileSystemItem)typesModules);
        }
    }

    protected boolean useIncludingFileAsContext() {
        return false;
    }

    public static boolean isRelative(String pathString) {
        return pathString.startsWith(".");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/modules/JSModuleFileReferenceSet";
                break;
            }
            case 4: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 9: 
            case 13: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceSet";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeModulesDir";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstRefText";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "altResolveModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/modules/JSModuleFileReferenceSet";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDefaultContexts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addDefaultRoots";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addNodeModulesDirContexts";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addNodeModulesContextsFromIndexes";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addGlobalTypesContexts";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findUpNodeModules";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "doAddNodeModulesContext";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addTypesForNodeModulesDir";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

