/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.webpack;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.packageJson.PackageJsonDependencies;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebpackUtil {
    public static final Key<Boolean> FORCE_WEBPACK2_IN_TEST_KEY = Key.create((String)"JavaScript.Webpack.2.For.Tests");
    private static final String WEBPACK = "webpack";

    public static boolean isWebpack2(Project project) {
        VirtualFile folder;
        if (ApplicationManager.getApplication().isUnitTestMode() && Boolean.TRUE.equals(project.getUserData(FORCE_WEBPACK2_IN_TEST_KEY))) {
            return true;
        }
        if (project.isDefault() || project.getBaseDir() == null || project.isDisposed()) {
            return false;
        }
        VirtualFile packageJson = project.getBaseDir().findChild("package.json");
        if (packageJson != null) {
            ThreeState threeState = WebpackUtil.checkInPackageJsonVersion(project, packageJson);
            if (ThreeState.YES.equals((Object)threeState)) {
                return true;
            }
            if (ThreeState.NO.equals((Object)threeState)) {
                return false;
            }
            folder = packageJson.getParent();
        } else {
            folder = project.getBaseDir();
        }
        return folder != null && Boolean.TRUE.equals(WebpackUtil.isWebpack2InNodeModules(folder));
    }

    @Nullable
    private static Boolean isWebpack2InNodeModules(@NotNull VirtualFile folder) {
        VirtualFile webpackPackageJson;
        if (folder == null) {
            WebpackUtil.$$$reportNull$$$0(0);
        }
        if ((webpackPackageJson = VfsUtil.findRelativeFile((VirtualFile)folder, (String[])new String[]{"node_modules", WEBPACK, "package.json"})) != null) {
            PackageJsonData data = PackageJsonUtil.getOrCreateData(webpackPackageJson);
            return data.getVersion() != null && data.getVersion().getMajor() >= 2;
        }
        return null;
    }

    private static ThreeState checkInPackageJsonVersion(Project project, VirtualFile packageJson) {
        PackageJsonDependencies dependencies = PackageJsonDependencies.getOrCreate(project, packageJson);
        if (dependencies == null) {
            return ThreeState.NO;
        }
        String versionText = dependencies.getDependencies().get(WEBPACK);
        if (versionText == null) {
            versionText = dependencies.getDevDependencies().get(WEBPACK);
        }
        if (versionText != null) {
            return PackageJsonUtil.isVersionGreaterOrEqualMajor(versionText, 2);
        }
        return ThreeState.NO;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folder", "com/intellij/lang/javascript/frameworks/webpack/WebpackUtil", "isWebpack2InNodeModules"));
    }
}

