/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.generation;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.util.MemberChooser;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.generation.JSNamedElementNode;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.refactoring.convertToClass.JSToClassConversionConstructorFunction;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMethodsFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseJSGenerateHandler
implements LanguageCodeInsightActionHandler {
    private final boolean mySkipMemberChooserDialog;

    public BaseJSGenerateHandler() {
        this.mySkipMemberChooserDialog = false;
    }

    public BaseJSGenerateHandler(boolean skipMemberChooserDialog) {
        this.mySkipMemberChooserDialog = skipMemberChooserDialog;
    }

    @Nullable
    protected String getProductivityFeatureId() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        List<Object> selectedElements;
        JSClass jsClass;
        block17: {
            if (project == null) {
                BaseJSGenerateHandler.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                BaseJSGenerateHandler.$$$reportNull$$$0(1);
            }
            if (file == null) {
                BaseJSGenerateHandler.$$$reportNull$$$0(2);
            }
            if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
                return;
            }
            jsClass = BaseJSGenerateHandler.findClass(file, editor, null);
            if (jsClass == null) {
                return;
            }
            if (this.collectCandidatesAndShowDialog()) {
                ArrayList<JSNamedElementNode> candidates = new ArrayList<JSNamedElementNode>();
                this.collectCandidates(jsClass, candidates);
                if (candidates.isEmpty()) {
                    if (this.canHaveEmptySelectedElements()) {
                        selectedElements = Collections.emptyList();
                        break block17;
                    } else {
                        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                            HintManager.getInstance().showErrorHint(editor, this.getNoCandidatesMessage());
                        }
                        return;
                    }
                }
                boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
                if (unitTestMode) {
                    Iterator i = candidates.iterator();
                    while (i.hasNext()) {
                        JSNamedElementNode next = (JSNamedElementNode)((Object)i.next());
                        PsiElement psiElement = ((JSNamedElementNode)next.getParentNodeDelegate()).getPsiElement();
                        if (!(psiElement instanceof JSClass) || !"Object".equals(((JSClass)psiElement).getQualifiedName())) continue;
                        i.remove();
                    }
                }
                if (this.mySkipMemberChooserDialog || unitTestMode) {
                    selectedElements = candidates;
                } else {
                    MemberChooser<JSNamedElementNode> chooser = this.createMemberChooserDialog(project, jsClass, candidates, this.canHaveEmptySelectedElements(), true, JSBundle.message((String)this.getTitleKey(), (Object[])new Object[0]));
                    chooser.show();
                    if (chooser.getExitCode() != 0) {
                        return;
                    }
                    List<Object> selected = chooser.getSelectedElements();
                    selectedElements = selected == null ? Collections.emptyList() : selected;
                }
            } else {
                selectedElements = Collections.emptyList();
            }
        }
        String featureId = this.getProductivityFeatureId();
        if (featureId != null) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed(featureId);
        }
        BaseCreateMethodsFix createMethodsFix = this.createFix(jsClass);
        this.doInvoke(project, editor, file, selectedElements, createMethodsFix);
    }

    protected void doInvoke(final Project project, final Editor editor, final PsiFile file, final Collection<JSNamedElementNode> selectedElements, final BaseCreateMethodsFix<JSNamedElement> createMethodsFix) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (JSNamedElementNode el : selectedElements) {
                    createMethodsFix.addElementToProcess((JSNamedElement)el.getPsiElement());
                }
                createMethodsFix.beforeInvoke(project, editor, file);
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            createMethodsFix.invoke(project, editor, file);
                        }
                        catch (IncorrectOperationException ex) {
                            Logger.getInstance((String)this.getClass().getName()).error((Throwable)ex);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        };
        if (CommandProcessor.getInstance().getCurrentCommand() == null) {
            CommandProcessor.getInstance().executeCommand(project, runnable, this.getClass().getName(), null);
        } else {
            runnable.run();
        }
    }

    protected MemberChooser<JSNamedElementNode> createMemberChooserDialog(Project project, final JSClass jsClass, final Collection<JSNamedElementNode> candidates, final boolean allowEmptySelection, boolean allowMultipleSelection, String title) {
        MemberChooser<JSNamedElementNode> chooser = new MemberChooser<JSNamedElementNode>(candidates.toArray(new JSNamedElementNode[candidates.size()]), allowEmptySelection, allowMultipleSelection, project, false){

            protected void init() {
                super.init();
                if (!allowEmptySelection) {
                    this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

                        @Override
                        public void valueChanged(TreeSelectionEvent e) {
                            this.setOKActionEnabled(myTree.getSelectionCount() > 0);
                        }
                    });
                } else {
                    this.setOKActionEnabled(true);
                }
            }

            protected JComponent createCenterPanel() {
                JComponent superComponent = super.createCenterPanel();
                JComponent optionsComponent = BaseJSGenerateHandler.this.getOptionsComponent(jsClass, candidates);
                if (optionsComponent == null) {
                    return superComponent;
                }
                JPanel panel = new JPanel(new BorderLayout());
                panel.add((Component)superComponent, "Center");
                panel.add((Component)optionsComponent, "South");
                return panel;
            }
        };
        chooser.setTitle(title);
        chooser.setCopyJavadocVisible(false);
        return chooser;
    }

    @Nullable
    protected JComponent getOptionsComponent(JSClass jsClass, Collection<JSNamedElementNode> candidates) {
        return null;
    }

    protected boolean canHaveEmptySelectedElements() {
        return false;
    }

    @Nullable
    public static JSClass findClass(@NotNull PsiFile file, @NotNull Editor editor, @Nullable Condition<PsiElement> dialectCheck) {
        if (file == null) {
            BaseJSGenerateHandler.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            BaseJSGenerateHandler.$$$reportNull$$$0(4);
        }
        if (file instanceof XmlFile && JavaScriptSupportLoader.isFlexMxmFile(file)) {
            return XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)file);
        }
        PsiElement at = JSChangeUtil.getMeaningfulElementAtCaret(file, editor);
        if (at == null || !at.getLanguage().isKindOf((Language)JavascriptLanguage.INSTANCE) || dialectCheck != null && !dialectCheck.value((Object)at)) {
            return null;
        }
        Object clazz = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)at, JSClass.class, (boolean)false);
        if (clazz == null) {
            PsiFile containingFile = at.getContainingFile();
            PsiElement element = JSResolveUtil.getClassReferenceForXmlFromContext((PsiElement)containingFile);
            if (element instanceof JSClass) {
                clazz = (JSClass)element;
            }
        } else if (JSResolveUtil.isArtificialClassUsedForReferenceList(clazz)) {
            PsiLanguageInjectionHost context = InjectedLanguageManager.getInstance((Project)file.getProject()).getInjectionHost((PsiElement)clazz);
            clazz = context != null && context.getContainingFile() instanceof XmlFile ? XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)context.getContainingFile()) : null;
        }
        return clazz;
    }

    @NonNls
    protected abstract String getTitleKey();

    protected String getNoCandidatesMessage() {
        return JSBundle.message((String)"no.candidates", (Object[])new Object[0]);
    }

    protected abstract BaseCreateMethodsFix createFix(JSClass var1);

    protected boolean collectCandidatesAndShowDialog() {
        return true;
    }

    protected void collectCandidates(JSClass clazz, Collection<JSNamedElementNode> candidates) {
    }

    protected static boolean indexedPropertyAccessCheck(@NotNull JSNamedElementBase element, @NotNull PairProcessor<String, String> secondPartConsumer) {
        if (element == null) {
            BaseJSGenerateHandler.$$$reportNull$$$0(5);
        }
        if (secondPartConsumer == null) {
            BaseJSGenerateHandler.$$$reportNull$$$0(6);
        }
        if (element instanceof JSDefinitionExpression && ((JSDefinitionExpression)element).getExpression() instanceof JSIndexedPropertyAccessExpression) {
            String first;
            JSExpression indexExpression = ((JSIndexedPropertyAccessExpression)((JSDefinitionExpression)element).getExpression()).getIndexExpression();
            if (indexExpression instanceof JSLiteralExpression && ((JSLiteralExpression)indexExpression).isQuotedLiteral()) {
                String innerText = StringUtil.unquoteString((String)indexExpression.getText());
                if (innerText.startsWith("_")) {
                    char quote = indexExpression.getText().charAt(0);
                    return secondPartConsumer.process((Object)("[" + indexExpression.getText() + "]"), (Object)("[" + quote + innerText.substring(1) + quote + "]"));
                }
                return true;
            }
            if (indexExpression instanceof JSBinaryExpression && JSTokenTypes.PLUS.equals(((JSBinaryExpression)indexExpression).getOperationSign()) && ((JSBinaryExpression)indexExpression).getLOperand() instanceof JSLiteralExpression && ((JSLiteralExpression)((JSBinaryExpression)indexExpression).getLOperand()).isQuotedLiteral() && "_".equals(first = StringUtil.unquoteString((String)((JSBinaryExpression)indexExpression).getLOperand().getText()))) {
                JSExpression rOperand = ((JSBinaryExpression)indexExpression).getROperand();
                rOperand = rOperand instanceof JSParenthesizedExpression ? ((JSParenthesizedExpression)rOperand).getInnerExpression() : rOperand;
                return secondPartConsumer.process((Object)("[" + indexExpression.getText() + "]"), (Object)("[" + rOperand.getText() + "]"));
            }
        }
        return true;
    }

    protected static void collectJSVariables(JSClass clazz, Collection<JSNamedElementNode> candidates, final boolean skipThatHaveGetters, final boolean skipThatHaveSetters, final boolean skipStatics, final boolean skipConstructorParameters, final boolean skipSymbolProperties) {
        final HashMap<String, JSPsiNamedElementBase> candidatesMap = new HashMap<String, JSPsiNamedElementBase>();
        final HashSet<String> accessors = new HashSet<String>();
        Processor duplicatesChecker = accessorName -> {
            if (accessors.contains(accessorName)) {
                return false;
            }
            JSPsiNamedElementBase element = (JSPsiNamedElementBase)candidatesMap.get(accessorName);
            return element == null || BaseJSGenerateHandler.indexedPropertyAccessCheck((JSNamedElementBase)element, (PairProcessor<String, String>)((PairProcessor)(existing, future) -> !accessors.contains(existing.replace('\'', '\"')) && !accessors.contains(future.replace('\'', '\"'))));
        };
        final ArrayList constructorParameters = new ArrayList();
        final JSCodeStyleSettings codeStyleSettings = (JSCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)clazz.getProject()).getCustomSettings(JSCodeStyleSettings.class);
        ResolveProcessor processor = new ResolveProcessor(null){
            {
                super(arg0);
                this.setToProcessMembers(true);
                this.setToProcessHierarchy(false);
                this.setLocalResolve(true);
            }

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                String name;
                JSAttributeList attributeList;
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    3.$$$reportNull$$$0(1);
                }
                JSPsiNamedElementBase namedElement = (JSPsiNamedElementBase)element;
                if (skipStatics && element instanceof JSAttributeListOwner && (attributeList = ((JSAttributeListOwner)element).getAttributeList()) != null && attributeList.hasModifier(JSAttributeList.ModifierType.STATIC)) {
                    return true;
                }
                if (!(element instanceof JSVariable)) {
                    if (element instanceof JSFunction) {
                        JSFunction function = (JSFunction)element;
                        if (skipThatHaveGetters && function.isGetProperty() || skipThatHaveSetters && function.isSetProperty()) {
                            accessors.add(StringUtil.notNullize((String)function.getName()).replace('\'', '\"'));
                        }
                        if (!skipConstructorParameters && function.isConstructor()) {
                            Collections.addAll(constructorParameters, function.getParameterVariables());
                        }
                    }
                    return true;
                }
                if (((JSVariable)element).isConst()) {
                    return true;
                }
                if (namedElement instanceof JSComputedPropertyNameOwner) {
                    JSExpression expr;
                    ES6ComputedName propName = ((JSComputedPropertyNameOwner)namedElement).getComputedPropertyName();
                    JSExpression jSExpression = expr = propName == null ? null : propName.getExpression();
                    if (!(expr == null || expr instanceof JSLiteralExpression || !skipSymbolProperties && JSPsiImplUtils.isSymbolRef(expr))) {
                        return true;
                    }
                }
                if ((name = namedElement.getName()) == null) {
                    return true;
                }
                String accessorName = JSRefactoringUtil.transformVarNameToAccessorName(name, codeStyleSettings);
                candidatesMap.put(accessorName, namedElement);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/generation/BaseJSGenerateHandler$3";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        clazz.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), (PsiElement)clazz, (PsiElement)clazz);
        BaseJSGenerateHandler.appendUnnamedComputedProperties(clazz, skipThatHaveGetters, skipThatHaveSetters, accessors);
        if (!skipConstructorParameters) {
            JSFunction constructor = clazz.getConstructor();
            if (constructor != null) {
                JSToClassConversionConstructorFunction function = new JSToClassConversionConstructorFunction(constructor, null);
                Collection<JSAssignmentExpression> definitions = function.getOnlyPropertyDefinitions();
                ContainerUtil.process(definitions, definition -> {
                    String accessorName;
                    PsiElement resolve;
                    if (definition.getDefinitionExpression() == null) {
                        return true;
                    }
                    JSExpression initializer = definition.getDefinitionExpression().getInitializer();
                    if (initializer instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)initializer).resolve()) instanceof JSParameter) {
                        return true;
                    }
                    JSExpression expression = definition.getDefinitionExpression().getExpression();
                    if (expression instanceof JSReferenceExpression) {
                        String name = ((JSReferenceExpression)expression).getReferenceName();
                        accessorName = JSRefactoringUtil.transformVarNameToAccessorName(name, codeStyleSettings);
                    } else if (expression instanceof JSIndexedPropertyAccessExpression) {
                        Object value;
                        JSExpression indexExpression = ((JSIndexedPropertyAccessExpression)expression).getIndexExpression();
                        accessorName = null;
                        if (indexExpression instanceof JSLiteralExpression && (value = ((JSLiteralExpression)indexExpression).getValue()) instanceof String) {
                            accessorName = JSRefactoringUtil.transformVarNameToAccessorName((String)value, codeStyleSettings);
                        }
                        if (indexExpression instanceof JSBinaryExpression) {
                            String first;
                            JSExpression lOperand = ((JSBinaryExpression)indexExpression).getLOperand();
                            String string = first = lOperand == null ? "" : StringUtil.unquoteString((String)lOperand.getText());
                            if ("_".equals(first)) {
                                JSExpression rOperand = ((JSBinaryExpression)indexExpression).getROperand();
                                JSExpression jSExpression = rOperand = rOperand instanceof JSParenthesizedExpression ? ((JSParenthesizedExpression)rOperand).getInnerExpression() : rOperand;
                                if (rOperand != null) {
                                    accessorName = "[" + rOperand.getText() + "]";
                                }
                            }
                        }
                        if (accessorName == null) {
                            accessorName = "[" + indexExpression.getText() + "]";
                        }
                    } else {
                        return true;
                    }
                    if (duplicatesChecker.process((Object)accessorName)) {
                        candidatesMap.put(accessorName, (JSPsiNamedElementBase)definition.getDefinitionExpression());
                    }
                    return true;
                });
            }
            for (JSPsiNamedElementBase parameter : constructorParameters) {
                String name = parameter.getName();
                String accessorName2 = JSRefactoringUtil.transformVarNameToAccessorName(name, codeStyleSettings);
                if (!duplicatesChecker.process((Object)accessorName2)) continue;
                candidatesMap.put(accessorName2, parameter);
            }
        }
        for (JSPsiNamedElementBase n : ContainerUtil.filter(candidatesMap, s -> duplicatesChecker.process(s)).values()) {
            if (!(n instanceof JSNamedElement)) continue;
            candidates.add(new JSNamedElementNode(n));
        }
    }

    private static void appendUnnamedComputedProperties(JSClass clazz, boolean skipThatHaveGetters, boolean skipThatHaveSetters, Set<String> accessors) {
        JSFunction[] children = (JSFunction[])PsiTreeUtil.getChildrenOfType((PsiElement)clazz, JSFunction.class);
        if (children != null) {
            for (JSFunction jSFunction : children) {
                ASTNode identifier;
                JSFunction function = jSFunction;
                if (function.getName() != null || (!skipThatHaveGetters || !function.isGetProperty()) && (!skipThatHaveSetters || !function.isSetProperty()) || (identifier = JSPsiImplUtils.getComputedNameOfFunction(function.getNode(), false)) == null) continue;
                accessors.add(identifier.getText());
            }
        }
        for (JSFunction jSFunction : clazz.getSuperClasses()) {
            BaseJSGenerateHandler.appendUnnamedComputedProperties((JSClass)jSFunction, skipThatHaveGetters, skipThatHaveSetters, accessors);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean isValidFor(Editor editor, PsiFile file) {
        JSClass jsClass = BaseJSGenerateHandler.findClass(file, editor, null);
        return jsClass != null && !jsClass.isInterface();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondPartConsumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/generation/BaseJSGenerateHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findClass";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "indexedPropertyAccessCheck";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

