/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.inspections.ES6ConvertModuleExportToExportInspection;
import com.intellij.lang.javascript.intentions.CommentsMover;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCommaExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ConvertModuleExportToExportQuickFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements HighPriorityAction {
    @Nullable
    private final String myExportedName;

    public ES6ConvertModuleExportToExportQuickFix(@NotNull JSAssignmentExpression assignment, @Nullable String exportedName) {
        if (assignment == null) {
            ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(0);
        }
        super((PsiElement)assignment);
        this.myExportedName = exportedName;
    }

    @Nls
    @NotNull
    public String getText() {
        String string = JSBundle.message((String)"js.convert.module.exports.into.es6.export.text", (Object[])new Object[0]);
        if (string == null) {
            ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.convert.module.exports.into.es6.export.family.name", (Object[])new Object[0]);
        if (string == null) {
            ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        JSExpression initializer;
        if (project == null) {
            ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(3);
        }
        if (file == null) {
            ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(4);
        }
        if (startElement == null) {
            ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(5);
        }
        if (endElement == null) {
            ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(6);
        }
        assert (this.getStartElement() instanceof JSAssignmentExpression);
        JSAssignmentExpression element = (JSAssignmentExpression)this.getStartElement();
        JSDefinitionExpression definition = element.getDefinitionExpression();
        if (definition == null || (initializer = JSPsiImplUtils.getInitializer(definition.getNode())) == null || initializer.getPrevSibling() == null) {
            return;
        }
        JSSourceElement sourceElement = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)element, JSSourceElement.class);
        if (sourceElement == null || !ES6ConvertModuleExportToExportInspection.checkContext(element)) {
            return;
        }
        SmartList toReformat = new SmartList();
        List<PsiComment> comments = this.collectInlineCommentsToBeRemoved(definition, initializer);
        JSElement createdElement = this.myExportedName == null ? ES6ConvertModuleExportToExportQuickFix.createDefaultExport(project, element, sourceElement, initializer, (List<FormatFixer>)toReformat) : (initializer instanceof JSFunction ? JSRefactoringUtil.functionDeclarationFromFunctionExpression(project, (JSFunction)initializer, this.myExportedName, true) : (initializer instanceof JSClass ? JSRefactoringUtil.classDeclarationFromClassExpression(project, (JSClass)initializer, this.myExportedName, true) : (initializer instanceof JSReferenceExpression && ((JSReferenceExpression)initializer).getQualifier() == null && !ES6ConvertModuleExportToExportQuickFix.isPredefinedConstant((JSReferenceExpression)initializer) ? ES6ConvertModuleExportToExportQuickFix.createReferenceExport(project, element, (JSReferenceExpression)initializer, this.myExportedName) : ES6ConvertModuleExportToExportQuickFix.createConstExport(project, element, initializer, this.myExportedName))));
        if (this.myExportedName != null) {
            ES6ConvertModuleExportToExportQuickFix.simplifyExportedObjectDetails(element, this.myExportedName);
        }
        PsiElement createdInFile = ES6ConvertModuleExportToExportQuickFix.createEquivalentExpression(element, sourceElement, createdElement, comments);
        toReformat.add(ES6ConvertModuleExportToExportQuickFix.createFixerForReformatWithoutBody(createdInFile));
        toReformat.forEach(FormatFixer::fixFormat);
        ES6ConvertModuleExportToExportQuickFix.caretAtStartOfCreatedExport(editor, createdInFile);
    }

    @NotNull
    private List<PsiComment> collectInlineCommentsToBeRemoved(JSDefinitionExpression definition, JSExpression initializer) {
        List<PsiComment> comments;
        if (this.myExportedName != null && initializer instanceof JSFunction && ((JSFunction)initializer).getParameterList() != null) {
            JSParameterList parameterList = ((JSFunction)initializer).getParameterList();
            assert (parameterList != null);
            comments = JSChangeUtil.getCommentsInBetween((PsiElement)definition, (PsiElement)parameterList);
            ASTNode leftBrace = JSRefactoringUtil.getLeftBrace((PsiElement)initializer);
            if (leftBrace != null) {
                comments.addAll(JSChangeUtil.getCommentsInBetween((PsiElement)parameterList, leftBrace.getPsi()));
            }
        } else {
            comments = JSChangeUtil.getCommentsInBetween((PsiElement)definition, (PsiElement)initializer);
        }
        List<PsiComment> list = comments;
        if (list == null) {
            ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static FormatFixer createFixerForReformatWithoutBody(@NotNull PsiElement createdInFile) {
        JSExpression expression;
        if (createdInFile == null) {
            ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(8);
        }
        PsiElement element = createdInFile;
        if (createdInFile instanceof ES6ExportDefaultAssignment && (expression = ((ES6ExportDefaultAssignment)createdInFile).getExpression()) != null) {
            element = expression;
        }
        return JSRefactoringUtil.createFixerForReformatWithoutBody(createdInFile, element);
    }

    @NotNull
    private static JSElement createDefaultExport(@NotNull Project project, @NotNull JSAssignmentExpression mainAssignment, @NotNull JSSourceElement sourceElement, @NotNull JSExpression initializer, @NotNull List<FormatFixer> toReformat) {
        List<Pair<JSAssignmentExpression, List<String>>> list;
        if (project == null) {
            ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(9);
        }
        if (mainAssignment == null) {
            ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(10);
        }
        if (sourceElement == null) {
            ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(11);
        }
        if (initializer == null) {
            ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(12);
        }
        if (toReformat == null) {
            ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(13);
        }
        if (!(list = PsiTreeUtil.findChildrenOfType((PsiElement)mainAssignment.getContainingFile(), JSAssignmentExpression.class).stream().map(assignment -> Pair.create((Object)assignment, ES6ConvertModuleExportToExportInspection.checkAssignmentToBeExport(assignment))).filter(pair -> pair.getSecond() != null && ((JSAssignmentExpression)pair.getFirst()).getDefinitionExpression() != null).filter(pair -> !((List)pair.getSecond()).isEmpty() && ("prototype".equals(((List)pair.getSecond()).get(0)) || "constructor".equals(((List)pair.getSecond()).get(0)))).sorted(Comparator.comparingInt(o -> ((List)o.getSecond()).size())).collect(Collectors.toList())).isEmpty()) {
            JSElement jSElement = ES6ConvertModuleExportToExportQuickFix.createClassLikeDefaultExport(project, mainAssignment, sourceElement, initializer, list, toReformat);
            if (jSElement == null) {
                ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(14);
            }
            return jSElement;
        }
        boolean omitSemicolon = initializer instanceof JSFunction || initializer instanceof JSClass;
        String text = omitSemicolon ? "export default {}" : "export default 1" + JSCodeStyleSettings.getSemicolon((PsiElement)mainAssignment.getContainingFile());
        ASTNode astNode = JSChangeUtil.createStatementFromText(project, text, DialectDetector.languageDialectOfElement((PsiElement)mainAssignment));
        assert (astNode != null);
        ES6ExportDefaultAssignment exportDefaultAssignment = (ES6ExportDefaultAssignment)astNode.getPsi(ES6ExportDefaultAssignment.class);
        assert (exportDefaultAssignment.getExpression() != null);
        exportDefaultAssignment.getExpression().replace(initializer.copy());
        ES6ExportDefaultAssignment eS6ExportDefaultAssignment = exportDefaultAssignment;
        if (eS6ExportDefaultAssignment == null) {
            ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(15);
        }
        return eS6ExportDefaultAssignment;
    }

    private static JSElement createClassLikeDefaultExport(@NotNull Project project, @NotNull JSAssignmentExpression mainAssignment, @NotNull JSSourceElement sourceElement, @NotNull JSExpression initializer, @NotNull List<Pair<JSAssignmentExpression, List<String>>> otherAssignments, @NotNull List<FormatFixer> toReformat) {
        if (project == null) {
            ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(16);
        }
        if (mainAssignment == null) {
            ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(17);
        }
        if (sourceElement == null) {
            ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(18);
        }
        if (initializer == null) {
            ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(19);
        }
        if (otherAssignments == null) {
            ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(20);
        }
        if (toReformat == null) {
            ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(21);
        }
        String varName = JSChangeUtil.generateNewVarName("_export", (PsiElement)mainAssignment.getContainingFile());
        JSLanguageDialect dialect = DialectDetector.languageDialectOfElement((PsiElement)mainAssignment);
        String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)mainAssignment.getContainingFile());
        assert (!otherAssignments.isEmpty());
        otherAssignments.forEach(pair -> {
            if (project == null) {
                ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(48);
            }
            ASTNode refNode = JSChangeUtil.createExpressionFromText(project, varName + "." + StringUtil.join((Collection)((Collection)pair.getSecond()), (String)"."), dialect);
            assert (refNode != null);
            JSReferenceExpression newRef = (JSReferenceExpression)refNode.getPsi(JSReferenceExpression.class);
            ((JSAssignmentExpression)pair.getFirst()).getDefinitionExpression().getExpression().replace((JSExpression)newRef);
        });
        ASTNode astNode = JSChangeUtil.createStatementFromText(project, "const " + varName + "=1" + semicolon + "\n", dialect);
        assert (astNode != null);
        JSVarStatement statement = (JSVarStatement)astNode.getPsi(JSVarStatement.class);
        assert (statement.getVariables().length == 1);
        JSVariable variable = statement.getVariables()[0];
        assert (variable.getInitializer() != null);
        variable.getInitializer().replace(initializer);
        PsiElement added = sourceElement.getParent().addBefore((PsiElement)statement, (PsiElement)sourceElement);
        toReformat.add(ES6ConvertModuleExportToExportQuickFix.createFixerForReformatWithoutBody(added));
        String text = "export default " + varName + semicolon;
        ASTNode exportNode = JSChangeUtil.createStatementFromText(project, text, DialectDetector.languageDialectOfElement((PsiElement)mainAssignment));
        assert (exportNode != null);
        return (JSElement)exportNode.getPsi(ES6ExportDefaultAssignment.class);
    }

    @NotNull
    private static JSElement createConstExport(@NotNull Project project, @NotNull JSAssignmentExpression element, @NotNull JSExpression initializer, @NotNull String name) {
        JSVarStatement createdElement;
        if (project == null) {
            ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(22);
        }
        if (element == null) {
            ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(23);
        }
        if (initializer == null) {
            ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(24);
        }
        if (name == null) {
            ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(25);
        }
        ASTNode astNode = JSChangeUtil.createStatementFromText(project, "export const " + name + " = 1" + JSCodeStyleSettings.getSemicolon((PsiElement)element.getContainingFile()), DialectDetector.languageDialectOfElement((PsiElement)element));
        assert (astNode != null);
        JSVarStatement statement = (JSVarStatement)astNode.getPsi(JSVarStatement.class);
        assert (statement.getVariables()[0].getInitializer() != null);
        statement.getVariables()[0].getInitializer().replace(initializer);
        JSVarStatement jSVarStatement = createdElement = statement;
        if (jSVarStatement == null) {
            ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(26);
        }
        return jSVarStatement;
    }

    @NotNull
    private static JSElement createReferenceExport(@NotNull Project project, @NotNull JSAssignmentExpression element, @NotNull JSReferenceExpression ref, @NotNull String name) {
        if (project == null) {
            ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(27);
        }
        if (element == null) {
            ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(28);
        }
        if (ref == null) {
            ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(29);
        }
        if (name == null) {
            ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(30);
        }
        String text = name.equals(ref.getReferenceName()) ? String.format("export {%s}", name) : String.format("export {%s as %s}", ref.getText(), name);
        ASTNode astNode = JSChangeUtil.createStatementFromText(project, text, DialectDetector.languageDialectOfElement((PsiElement)element));
        assert (astNode != null);
        JSElement jSElement = (JSElement)astNode.getPsi(ES6ExportDeclaration.class);
        if (jSElement == null) {
            ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(31);
        }
        return jSElement;
    }

    private static boolean isPredefinedConstant(@NotNull JSReferenceExpression ref) {
        if (ref == null) {
            ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(32);
        }
        return Stream.of("undefined", "NaN", "Infinity").anyMatch(name -> {
            if (ref == null) {
                ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(47);
            }
            return JSSymbolUtil.isAccurateReferenceExpressionName(ref, name);
        });
    }

    @NotNull
    private static PsiElement createEquivalentExpression(@NotNull JSAssignmentExpression element, @NotNull JSSourceElement sourceElement, @NotNull JSElement createdElement, @NotNull List<PsiComment> comments) {
        PsiElement createdInFile;
        if (element == null) {
            ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(33);
        }
        if (sourceElement == null) {
            ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(34);
        }
        if (createdElement == null) {
            ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(35);
        }
        if (comments == null) {
            ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(36);
        }
        Map<PsiComment, PsiComment> map = comments.stream().collect(Collectors.toMap(Function.identity(), e -> (PsiComment)e.copy()));
        CommentsMover mover = new CommentsMover(sourceElement);
        if (element.getParent() instanceof JSSourceElement) {
            createdInFile = element.getParent().replace((PsiElement)createdElement);
        } else {
            createdInFile = sourceElement.getNextSibling() != null ? JSChangeUtil.doDoAddBeforePure(sourceElement.getParent(), (PsiElement)createdElement, sourceElement.getNextSibling()) : JSChangeUtil.doDoAddAfter(sourceElement.getParent(), (PsiElement)createdElement, (PsiElement)sourceElement);
            if (element.getParent() instanceof JSCommaExpression) {
                JSChangeUtil.deletePartOfCommaExpression(element, (Consumer<PsiComment>)((Consumer)comment -> {
                    if (comments == null) {
                        ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(46);
                    }
                    comments.add((PsiComment)comment);
                    map.put((PsiComment)comment, (PsiComment)comment.copy());
                }));
            } else {
                JSChangeUtil.removeRangeWithRemovalOfCommas(element.getNode(), element.getParent().getNode());
            }
        }
        if (!sourceElement.isValid()) {
            Set set = ContainerUtil.set((Object[])new PsiElement[]{createdInFile});
            mover.move(set, set);
        }
        ES6ConvertModuleExportToExportQuickFix.moveInlineComments(comments, map, createdInFile);
        PsiElement psiElement = createdInFile;
        if (psiElement == null) {
            ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(37);
        }
        return psiElement;
    }

    private static void moveInlineComments(@NotNull List<PsiComment> comments, @NotNull Map<PsiComment, PsiComment> map, @NotNull PsiElement createdInFile) {
        PsiElement added;
        PsiElement sibling;
        if (comments == null) {
            ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(38);
        }
        if (map == null) {
            ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(39);
        }
        if (createdInFile == null) {
            ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(40);
        }
        Ref firstAddedComment = new Ref();
        comments.forEach(comment -> {
            if (map == null) {
                ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(44);
            }
            if (createdInFile == null) {
                ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(45);
            }
            PsiComment copy = (PsiComment)map.get(comment);
            PsiElement added = JSChangeUtil.doDoAddBeforePure(createdInFile.getParent(), (PsiElement)copy, createdInFile);
            if (firstAddedComment.isNull()) {
                firstAddedComment.set((Object)added);
            }
        });
        if (!(firstAddedComment.isNull() || (sibling = (added = (PsiElement)firstAddedComment.get()).getPrevSibling()) instanceof PsiWhiteSpace && sibling.getText().contains("\n"))) {
            JSChangeUtil.addWs(added.getParent().getNode(), added.getNode(), "\n");
        }
    }

    private static void caretAtStartOfCreatedExport(@Nullable Editor editor, @NotNull PsiElement createdInFile) {
        if (createdInFile == null) {
            ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(41);
        }
        if (editor == null) {
            editor = PsiUtilBase.findEditor((PsiElement)createdInFile);
        }
        if (editor != null) {
            PsiElement sibling;
            int offset = createdInFile.getTextRange().getStartOffset();
            JSDocComment comment = (JSDocComment)PsiTreeUtil.getChildOfType((PsiElement)createdInFile, JSDocComment.class);
            if (comment != null && (sibling = PsiTreeUtil.skipWhitespacesForward((PsiElement)comment)) != null) {
                offset = sibling.getTextRange().getStartOffset();
            }
            editor.getCaretModel().moveToOffset(offset);
        }
    }

    private static void simplifyExportedObjectDetails(@NotNull JSAssignmentExpression mainAssignment, @NotNull String name) {
        JSDefinitionExpression definition;
        if (mainAssignment == null) {
            ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(42);
        }
        if (name == null) {
            ES6ConvertModuleExportToExportQuickFix.$$$reportNull$$$0(43);
        }
        if ((definition = mainAssignment.getDefinitionExpression()) == null) {
            return;
        }
        JSLanguageDialect dialect = DialectDetector.languageDialectOfElement((PsiElement)mainAssignment);
        ASTNode astNode = JSChangeUtil.createExpressionFromText(mainAssignment.getProject(), name, dialect);
        assert (astNode != null);
        JSExpression newExpression = (JSExpression)astNode.getPsi(JSExpression.class);
        Collection references = ReferencesSearch.search((PsiElement)definition, (SearchScope)GlobalSearchScope.fileScope((PsiFile)mainAssignment.getContainingFile())).findAll();
        references.forEach(ref -> {
            if (!ref.equals(definition.getExpression()) && ref instanceof PsiElement) {
                ((PsiElement)ref).replace((PsiElement)newExpression);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 14: 
            case 15: 
            case 26: 
            case 31: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 14: 
            case 15: 
            case 26: 
            case 31: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 14: 
            case 15: 
            case 26: 
            case 31: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix";
                break;
            }
            case 3: 
            case 9: 
            case 16: 
            case 22: 
            case 27: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 8: 
            case 40: 
            case 41: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdInFile";
                break;
            }
            case 10: 
            case 17: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainAssignment";
                break;
            }
            case 11: 
            case 18: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 12: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toReformat";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherAssignments";
                break;
            }
            case 23: 
            case 28: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 25: 
            case 30: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 29: 
            case 32: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdElement";
                break;
            }
            case 36: 
            case 38: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comments";
                break;
            }
            case 39: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectInlineCommentsToBeRemoved";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultExport";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstExport";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferenceExport";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "createEquivalentExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 14: 
            case 15: 
            case 26: 
            case 31: 
            case 37: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createFixerForReformatWithoutBody";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultExport";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createClassLikeDefaultExport";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createConstExport";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createReferenceExport";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isPredefinedConstant";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createEquivalentExpression";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "moveInlineComments";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "caretAtStartOfCreatedExport";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "simplifyExportedObjectDetails";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "lambda$moveInlineComments$8";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createEquivalentExpression$7";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isPredefinedConstant$5";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createClassLikeDefaultExport$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 14: 
            case 15: 
            case 26: 
            case 31: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

