/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.parsing.JSDocParsing;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagValue;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocParamReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NotNull;

public class JSValidateJSDocInspection
extends JSInspection {
    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.validate.jsdoc.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            JSValidateJSDocInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    protected JSElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSDocTagValue(JSDocTagValue tagValue) {
                JSValidateJSDocInspection.checkReferences((PsiElement)tagValue, holder);
            }

            public void visitJSDocTag(JSDocTag tagValue) {
                JSValidateJSDocInspection.checkReferences((PsiElement)tagValue, holder);
            }

            public void visitJSDocComment(JSDocComment docComment) {
                JSValidateJSDocInspection.checkReferences((PsiElement)docComment, holder);
            }

            public void visitErrorElement(PsiErrorElement element) {
                if (JSDocParsing.isInsideJSDoc((PsiElement)element)) {
                    TextRange rangeInParent = new TextRange(element.getStartOffsetInParent(), element.getStartOffsetInParent() + 1);
                    holder.registerProblem(element.getParent(), rangeInParent, element.getErrorDescription(), new LocalQuickFix[0]);
                }
            }
        };
        if (jSElementVisitor == null) {
            JSValidateJSDocInspection.$$$reportNull$$$0(1);
        }
        return jSElementVisitor;
    }

    private static void checkReferences(PsiElement tagValue, ProblemsHolder holder) {
        for (PsiReference ref : tagValue.getReferences()) {
            if (ref instanceof JSDocParamReference || !XmlHighlightVisitor.hasBadResolve((PsiReference)ref, (boolean)false)) continue;
            holder.registerProblem(ref, ProblemsHolder.unresolvedReferenceMessage((PsiReference)ref), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/inspections/JSValidateJSDocInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

