/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library;

import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.library.JSPredefinedLibraryProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSPredefinedLibrariesData {
    private final Set<ScriptingLibraryModel> myLibraryModels;
    private final NotNullLazyValue<Set<VirtualFile>> myLibraryFiles;
    private final NotNullLazyValue<Map<String, VirtualFile>> myLibraryFileByNameMap;
    private final Set<VirtualFile> myRequiredLibraryFiles;
    private final Set<VirtualFile> myRequiredLibraryFilesForResolve;

    private JSPredefinedLibrariesData(final @NotNull Project project, final @NotNull Set<ScriptingLibraryModel> models, final @NotNull Set<VirtualFile> requiredLibraryFilesToIndex, final @NotNull Set<VirtualFile> requiredLibraryFilesForResolve) {
        if (project == null) {
            JSPredefinedLibrariesData.$$$reportNull$$$0(0);
        }
        if (models == null) {
            JSPredefinedLibrariesData.$$$reportNull$$$0(1);
        }
        if (requiredLibraryFilesToIndex == null) {
            JSPredefinedLibrariesData.$$$reportNull$$$0(2);
        }
        if (requiredLibraryFilesForResolve == null) {
            JSPredefinedLibrariesData.$$$reportNull$$$0(3);
        }
        this.myLibraryModels = models;
        this.myRequiredLibraryFiles = Collections.unmodifiableSet(ContainerUtil.union(requiredLibraryFilesToIndex, requiredLibraryFilesForResolve));
        this.myRequiredLibraryFilesForResolve = Collections.unmodifiableSet(requiredLibraryFilesForResolve);
        this.myLibraryFiles = new NotNullLazyValue<Set<VirtualFile>>(){

            @NotNull
            protected Set<VirtualFile> compute() {
                HashSet result = ContainerUtil.newHashSet((Iterable)requiredLibraryFilesToIndex);
                result.addAll(requiredLibraryFilesForResolve);
                JSLibraryMappings mappings = JSLibraryMappings.getInstance(project);
                for (ScriptingLibraryModel model : models) {
                    if (!model.shouldIndexSourcesWithoutMappings() && mappings.getMappingsByLibraryName(model.getName()).isEmpty()) continue;
                    result.addAll(model.getSourceFiles());
                }
                Set<VirtualFile> set = Collections.unmodifiableSet(result);
                if (set == null) {
                    1.$$$reportNull$$$0(0);
                }
                return set;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSPredefinedLibrariesData$1", "compute"));
            }
        };
        this.myLibraryFileByNameMap = new NotNullLazyValue<Map<String, VirtualFile>>(){

            @NotNull
            protected Map<String, VirtualFile> compute() {
                Set files = (Set)JSPredefinedLibrariesData.this.myLibraryFiles.getValue();
                Map map = ContainerUtilRt.newHashMap((int)files.size());
                for (VirtualFile file : files) {
                    map.put(file.getName(), file);
                }
                Map map2 = map;
                if (map2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return map2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSPredefinedLibrariesData$2", "compute"));
            }
        };
    }

    @NotNull
    public Set<VirtualFile> getLibraryFiles() {
        Set set = (Set)this.myLibraryFiles.getValue();
        if (set == null) {
            JSPredefinedLibrariesData.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public Set<ScriptingLibraryModel> getLibraryModels() {
        Set<ScriptingLibraryModel> set = this.myLibraryModels;
        if (set == null) {
            JSPredefinedLibrariesData.$$$reportNull$$$0(5);
        }
        return set;
    }

    @Nullable
    public VirtualFile findPredefinedFileByName(@NotNull String fileName) {
        if (fileName == null) {
            JSPredefinedLibrariesData.$$$reportNull$$$0(6);
        }
        return (VirtualFile)((Map)this.myLibraryFileByNameMap.getValue()).get(fileName);
    }

    public boolean isPredefinedFile(@NotNull VirtualFile file) {
        if (file == null) {
            JSPredefinedLibrariesData.$$$reportNull$$$0(7);
        }
        return ((Set)this.myLibraryFiles.getValue()).contains(file);
    }

    @NotNull
    public Set<VirtualFile> getRequiredLibraryFilesForResolve() {
        Set<VirtualFile> set = this.myRequiredLibraryFilesForResolve;
        if (set == null) {
            JSPredefinedLibrariesData.$$$reportNull$$$0(8);
        }
        return set;
    }

    @NotNull
    public Set<VirtualFile> getRequiredLibraryFiles() {
        Set<VirtualFile> set = this.myRequiredLibraryFiles;
        if (set == null) {
            JSPredefinedLibrariesData.$$$reportNull$$$0(9);
        }
        return set;
    }

    @NotNull
    public static JSPredefinedLibrariesData create(@NotNull Project project) {
        if (project == null) {
            JSPredefinedLibrariesData.$$$reportNull$$$0(10);
        }
        Set<ScriptingLibraryModel> models = JSPredefinedLibraryProvider.getAllPredefinedLibraries(project);
        Set<VirtualFile> requiredFilesToIndex = JSPredefinedLibraryProvider.getAllRequiredLibraryFilesToIndex();
        Set<VirtualFile> requiredFilesForResolve = JSPredefinedLibraryProvider.getAllRequiredLibraryFilesForResolve(project);
        JSPredefinedLibrariesData jSPredefinedLibrariesData = new JSPredefinedLibrariesData(project, models, requiredFilesToIndex, requiredFilesForResolve);
        if (jSPredefinedLibrariesData == null) {
            JSPredefinedLibrariesData.$$$reportNull$$$0(11);
        }
        return jSPredefinedLibrariesData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredLibraryFilesToIndex";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredLibraryFilesForResolve";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/library/JSPredefinedLibrariesData";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/library/JSPredefinedLibrariesData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryFiles";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryModels";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredLibraryFilesForResolve";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredLibraryFiles";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findPredefinedFileByName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isPredefinedFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

