/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.execution.ExecutionException;
import com.intellij.json.JsonFileType;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.linter.JSLinterGuesser;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.eslint.ESLintConfigTranslator;
import com.intellij.lang.javascript.linter.eslint.EslintUtil;
import com.intellij.lang.javascript.linter.eslint.importer.EslintRulesImporter;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorNotifications;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class EslintConfigTranslatorAndImporter
extends Task.Backgroundable {
    private static final Logger LOG = Logger.getInstance(EslintConfigTranslatorAndImporter.class);
    private final Project myProject;
    private final ESLintConfigTranslator myTranslator;
    private final VirtualFile myFile;
    private PsiFile myTranslatedFile;
    private String myErrorAnnotation;

    private EslintConfigTranslatorAndImporter(Project project, ESLintConfigTranslator translator, VirtualFile file) {
        super(project, JSBundle.message((String)"javascript.linter.import.translate.config.progress.title", (Object[])new Object[0]));
        this.myProject = project;
        this.myTranslator = translator;
        this.myFile = file;
    }

    public static void execute(@NotNull Project project, @NotNull VirtualFile file, boolean forceSilent) {
        Document document;
        PsiFile psiFile;
        if (project == null) {
            EslintConfigTranslatorAndImporter.$$$reportNull$$$0(0);
        }
        if (file == null) {
            EslintConfigTranslatorAndImporter.$$$reportNull$$$0(1);
        }
        if ((psiFile = PsiManager.getInstance((Project)project).findFile(file)) == null) {
            EslintConfigTranslatorAndImporter.reportError(project, "Can not find PsiFile for " + file.getName());
            return;
        }
        if (EslintConfigTranslatorAndImporter.configDoesNotRequireTranslation(psiFile)) {
            EslintConfigTranslatorAndImporter.doImportTranslatedFile(project, psiFile, file);
            return;
        }
        ESLintConfigTranslator translator = new ESLintConfigTranslator(project, file);
        if (!translator.configureNodeAndPackage(forceSilent)) {
            String error = translator.getError();
            if (error != null) {
                EslintConfigTranslatorAndImporter.reportError(project, error);
            }
            return;
        }
        FileDocumentManager manager = FileDocumentManager.getInstance();
        if (manager.isFileModified(file) && (document = manager.getDocument(file)) != null) {
            manager.saveDocument(document);
        }
        ProgressManager.getInstance().run((Task)new EslintConfigTranslatorAndImporter(project, translator, file));
    }

    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            EslintConfigTranslatorAndImporter.$$$reportNull$$$0(2);
        }
        try {
            this.myTranslatedFile = this.myTranslator.translate();
        }
        catch (ExecutionException e) {
            this.myErrorAnnotation = e.getMessage();
        }
    }

    public void onCancel() {
        if (this.myErrorAnnotation != null) {
            EslintConfigTranslatorAndImporter.reportError(this.myProject, this.myErrorAnnotation);
        }
    }

    public void onSuccess() {
        if (this.myErrorAnnotation != null) {
            EslintConfigTranslatorAndImporter.reportError(this.myProject, this.myErrorAnnotation);
        } else {
            EslintConfigTranslatorAndImporter.doImportTranslatedFile(this.myProject, this.myTranslatedFile, this.myFile);
        }
    }

    private static void reportError(@NotNull Project project, @NotNull String error) {
        if (project == null) {
            EslintConfigTranslatorAndImporter.$$$reportNull$$$0(3);
        }
        if (error == null) {
            EslintConfigTranslatorAndImporter.$$$reportNull$$$0(4);
        }
        JSLinterGuesser.NOTIFICATION_GROUP.createNotification(error, NotificationType.ERROR).notify(project);
    }

    private static boolean configDoesNotRequireTranslation(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            EslintConfigTranslatorAndImporter.$$$reportNull$$$0(5);
        }
        if (!JsonFileType.INSTANCE.equals(psiFile.getFileType())) {
            return false;
        }
        JsonObject rootObject = EslintUtil.getConfigRootObject(psiFile);
        if (rootObject == null) {
            return false;
        }
        if (rootObject.findProperty("extends") != null) {
            return false;
        }
        JsonProperty root = rootObject.findProperty("root");
        return root != null && root.getValue() != null && "true".equals(root.getValue().getText());
    }

    private static void doImportTranslatedFile(@NotNull Project project, @NotNull PsiFile translatedFile, @NotNull VirtualFile originalFile) {
        EslintRulesImporter importer;
        if (project == null) {
            EslintConfigTranslatorAndImporter.$$$reportNull$$$0(6);
        }
        if (translatedFile == null) {
            EslintConfigTranslatorAndImporter.$$$reportNull$$$0(7);
        }
        if (originalFile == null) {
            EslintConfigTranslatorAndImporter.$$$reportNull$$$0(8);
        }
        if ((importer = EslintRulesImporter.getRulesImporter(translatedFile)) != null) {
            if (!importer.hasDataToImport(project)) {
                JSLinterGuesser.NOTIFICATION_GROUP.createNotification(JSBundle.message((String)"javascript.linter.import.nothing.to.import", (Object[])new Object[0]), NotificationType.INFORMATION).notify(project);
                return;
            }
            Set<String> modifiedRules = importer.modifySettings(project);
            EditorNotifications.getInstance((Project)project).updateNotifications(originalFile);
            JSLinterUtil.reportCodeStyleSettingsImported(project, JSBundle.message((String)"settings.javascript.linters.eslint.configurable.name", (Object[])new Object[0]), originalFile, modifiedRules);
        } else {
            String message = JSBundle.message((String)"javascript.linter.import.translate.config.error.in.output.file", (Object[])new Object[0]);
            EslintConfigTranslatorAndImporter.reportError(project, message);
            LOG.info(message);
            LOG.info(translatedFile.getText());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "translatedFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EslintConfigTranslatorAndImporter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "reportError";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "configDoesNotRequireTranslation";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "doImportTranslatedFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

