/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNamespaceImpl;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeWithIncompleteSubstitution;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptNewExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyCallElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyInstanceContextElement;
import com.intellij.lang.javascript.psi.stubs.JSGenericsIndex;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSDecoratedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGlobalTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSSpecialNamedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTupleTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeComparingCacheService;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptIndexedAccessJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptMappedJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeOperatorJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.TypeScriptTypePredicateTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveArrayType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveFunctionType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSUintType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeUtils {
    @Nullable
    public static PsiElement getScopeInOriginalTree(@NotNull PsiElement scope) {
        if (scope == null) {
            JSTypeUtils.$$$reportNull$$$0(0);
        }
        if (scope instanceof ImplicitJSVariableImpl) {
            return scope;
        }
        PsiElement originalElement = CompletionUtilCoreImpl.getOriginalElement((PsiElement)scope);
        if (originalElement != null) {
            return originalElement;
        }
        PsiElement someElementAtOriginalTree = scope.getContainingFile().getOriginalFile().findElementAt(scope.getTextRange().getStartOffset());
        return someElementAtOriginalTree;
    }

    private JSTypeUtils() {
    }

    public static String transformActionScriptSpecificTypesIntoEcma(String type) {
        if ("int".equals(type) || "uint".equals(type)) {
            type = "Number";
        }
        return type;
    }

    public static boolean isNewPropertiesDefinitionAllowed(@Nullable JSType type) {
        if ((type = JSTypeUtils.getValuableType(type)) == null || type instanceof JSAnyType || type instanceof JSObjectType || type instanceof JSPrimitiveArrayType || type instanceof JSPrimitiveFunctionType || type instanceof JSFunctionTypeImpl || JSTypeUtils.isMapType(type)) {
            return true;
        }
        if (!type.getSource().isStrict()) {
            return true;
        }
        return type instanceof JSNamedType && ((JSNamedType)type).getTypeContext() == JSTypeContext.PROTOTYPE;
    }

    public static boolean isStrictType(@Nullable JSType type) {
        return JSTypeUtils.isRestrictiveType(type) && type.getSource().isStrict();
    }

    @Contract(value="null -> false")
    public static boolean isRestrictiveType(@Nullable JSType type) {
        return type != null && !(type instanceof JSAnyType) && !(type instanceof JSObjectType);
    }

    @Nullable
    public static JSType parseSerializedType(@Nullable String typeString, @NotNull JSTypeSource source) {
        if (source == null) {
            JSTypeUtils.$$$reportNull$$$0(1);
        }
        return JSTypeUtils.createType(typeString, source);
    }

    public static JSType createTypeFromJSDoc(@Nullable String typeString, @NotNull JSTypeSource source) {
        if (source == null) {
            JSTypeUtils.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmpty((String)typeString)) {
            return null;
        }
        JSTypeParser parser = new JSTypeParser(typeString, source, true);
        return parser.parse(false);
    }

    @Nullable
    public static JSType createType(@Nullable String typeString, @NotNull JSTypeSource source) {
        if (source == null) {
            JSTypeUtils.$$$reportNull$$$0(3);
        }
        return JSTypeUtils.createType(typeString, source, false);
    }

    @Nullable
    public static JSType createType(@Nullable String typeString, @NotNull JSTypeSource source, boolean allowCommentAfterType) {
        if (source == null) {
            JSTypeUtils.$$$reportNull$$$0(4);
        }
        if (StringUtil.isEmpty((String)typeString)) {
            return null;
        }
        JSTypeParser parser = new JSTypeParser(typeString, source);
        return parser.parse(allowCommentAfterType);
    }

    @Nullable
    public static JSParameterTypeDecorator createParameterType(@Nullable String typeString, @NotNull JSTypeSource source) {
        if (source == null) {
            JSTypeUtils.$$$reportNull$$$0(5);
        }
        return JSTypeUtils.createParameterType(typeString, source, false, false);
    }

    @Nullable
    public static JSParameterTypeDecorator createParameterType(@Nullable String typeString, @NotNull JSTypeSource source, boolean allowCommentAfterType, boolean isFromJSDoc) {
        if (source == null) {
            JSTypeUtils.$$$reportNull$$$0(6);
        }
        if (StringUtil.isEmpty((String)typeString)) {
            return null;
        }
        JSTypeParser parser = new JSTypeParser(typeString, source, isFromJSDoc);
        return parser.parseParameterType(allowCommentAfterType);
    }

    public static boolean isIterableCollectionType(@NotNull JSType type) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(7);
        }
        if (JSTypeUtils.isIndexableType(type)) {
            return true;
        }
        if (JSCommonTypeNames.TYPED_ARRAY_NAMES.contains(type.getTypeText())) {
            return true;
        }
        return "IArguments".equals(type.getTypeText());
    }

    public static boolean isIndexableType(@NotNull JSType type) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(8);
        }
        return JSTypeUtils.getIndexableComponentType(type) != null;
    }

    public static boolean isMapType(@NotNull JSType type) {
        JSType baseType;
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(9);
        }
        if (type instanceof JSGenericTypeImpl && ((JSGenericTypeImpl)type).getArguments().size() == 2 && (baseType = ((JSGenericTypeImpl)type).getType()) instanceof JSNamedType) {
            String typeText = baseType.getTypeText(JSType.TypeTextFormat.SIMPLE);
            return "Array".equals(typeText) || "Object".equals(typeText) || "Map".equals(typeText) || "WeakMap".equals(typeText);
        }
        return false;
    }

    public static boolean isPromiseType(@Nullable JSType type) {
        return (type = JSTypeUtils.getValuableType(type)) != null && "Promise".equals(JSTypeUtils.getQualifiedNameMatchingType(type, false));
    }

    @NotNull
    public static JSType wrapInPromiseType(@NotNull JSType jsType) {
        if (jsType == null) {
            JSTypeUtils.$$$reportNull$$$0(10);
        }
        JSType promiseType = JSNamedType.createExplicitlyDeclaredType("Promise", jsType.getSource().getSourceElement());
        JSGenericTypeImpl jSGenericTypeImpl = new JSGenericTypeImpl(promiseType.getSource(), promiseType, jsType);
        if (jSGenericTypeImpl == null) {
            JSTypeUtils.$$$reportNull$$$0(11);
        }
        return jSGenericTypeImpl;
    }

    @Nullable
    public static JSType getPromiseComponentTypeOrNull(@NotNull JSType type) {
        List<JSType> arguments;
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(12);
        }
        if (type instanceof JSGenericTypeImpl && (arguments = ((JSGenericTypeImpl)type).getArguments()).size() >= 1) {
            return (JSType)ContainerUtil.getFirstItem(arguments);
        }
        return null;
    }

    @Nullable
    public static JSType getIndexableComponentType(@NotNull JSType type) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(13);
        }
        if (type instanceof JSArrayTypeImpl) {
            return ((JSArrayTypeImpl)type).getType();
        }
        if (type instanceof JSTupleTypeImpl) {
            return JSTypeUtils.getIndexableComponentType(((JSTupleTypeImpl)type).toArrayType(true));
        }
        if (type instanceof JSPrimitiveArrayType) {
            return JSAnyType.get((PsiElement)type.getSource().getScope(), false);
        }
        if (type instanceof JSGenericTypeImpl) {
            return JSTypeUtils.getIndexableTypeFromGenericType((JSGenericTypeImpl)type, true);
        }
        if (type instanceof JSRecordType) {
            for (JSRecordType.TypeMember member : ((JSRecordType)type).getTypeMembers()) {
                if (!(member instanceof JSRecordType.IndexSignature)) continue;
                return ((JSRecordType.IndexSignature)member).getMemberType();
            }
        }
        return null;
    }

    @Nullable
    private static JSType getIndexableTypeFromGenericType(@NotNull JSGenericTypeImpl genericType, boolean traverseClassHierarchy) {
        JSType baseType;
        if (genericType == null) {
            JSTypeUtils.$$$reportNull$$$0(14);
        }
        if ((baseType = genericType.getType()) instanceof JSNamedType) {
            List<JSType> genericArguments = genericType.getArguments();
            if (genericArguments.isEmpty()) {
                return null;
            }
            if (JSTypeUtils.isSingleGenericComponentType((JSNamedType)baseType)) {
                return genericArguments.get(genericArguments.size() - 1);
            }
            if (!traverseClassHierarchy) {
                return null;
            }
            if (!(baseType instanceof JSResolvableType)) {
                return null;
            }
            JSResolvedTypeInfo resolvedTypeInfo = ((JSResolvableType)baseType).resolveType();
            if (resolvedTypeInfo == null) {
                return null;
            }
            JSClass sourceElement = resolvedTypeInfo.getDeclarationOfType(JSClass.class);
            if (sourceElement == null) {
                return null;
            }
            Ref indexerType = new Ref(null);
            JSClassUtils.processClassesInHierarchy(sourceElement, true, (klass, subst, fromImplements) -> {
                JSType idx;
                List<JSType> generics;
                if (!(klass instanceof TypeScriptTypeParameterListOwner)) {
                    return true;
                }
                TypeScriptTypeParameterList list = ((TypeScriptTypeParameterListOwner)klass).getTypeParameterList();
                if (list == null) {
                    return true;
                }
                List<JSType> list2 = generics = klass == sourceElement ? genericArguments : TypeScriptGenericTypesEvaluator.buildGenericParameters(list.getTypeParameters());
                if (generics.size() == 0) {
                    return true;
                }
                String qualifiedName = klass.getQualifiedName();
                if (qualifiedName == null) {
                    return true;
                }
                JSType type = JSNamedType.createType(qualifiedName, JSTypeSourceFactory.createTypeSource((PsiElement)klass, true), JSTypeContext.INSTANCE);
                type = new JSGenericTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)sourceElement, true), type, generics);
                if (!subst.isEmpty()) {
                    type = JSTypeUtils.applyGenericArguments(type, (Map<String, JSType>)subst);
                }
                if ((idx = JSTypeUtils.getIndexableTypeFromGenericType((JSGenericTypeImpl)type, false)) != null) {
                    idx = TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(sourceElement, genericArguments, sourceElement, idx);
                    indexerType.set((Object)idx);
                    return false;
                }
                return true;
            });
            if (!indexerType.isNull()) {
                return (JSType)indexerType.get();
            }
        }
        return null;
    }

    private static boolean isSingleGenericComponentType(@NotNull JSNamedType baseType) {
        String s;
        if (baseType == null) {
            JSTypeUtils.$$$reportNull$$$0(15);
        }
        return (s = baseType.getTypeText(JSType.TypeTextFormat.SIMPLE)).equals("Vector") || s.equals("Array") || s.equals("Object") || s.equals("Iterable") || s.equals("Iterator") || s.equals("IterableIterator") || s.equals("Set") || s.equals("WeakSet");
    }

    @Nullable
    public static JSType getIterableComponentType(@NotNull JSType type) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(16);
        }
        if (type instanceof JSAnyType || type instanceof JSNullType) {
            return type;
        }
        JSType realType = JSTypeUtils.getValuableType(type);
        JSType componentType = JSTypeUtils.getIndexableComponentType(realType);
        if (componentType == null) {
            JSRecordType recordType = realType.asRecordType();
            for (JSRecordType.TypeMember member : recordType.getTypeMembers()) {
                JSRecordType.PropertySignature propertySignature;
                JSType genericType;
                if (!(member instanceof JSRecordType.PropertySignature) || (genericType = JSTypeUtils.getIteratorComponentType((propertySignature = (JSRecordType.PropertySignature)member).getMemberName(), propertySignature.getType())) == null) continue;
                return genericType;
            }
        }
        return componentType;
    }

    @Nullable
    private static JSType getIteratorComponentType(String name, JSType iteratorType) {
        if ("[Symbol.iterator]".equals(name)) {
            JSGenericTypeImpl genericType;
            if (iteratorType instanceof JSFunctionTypeImpl) {
                iteratorType = ((JSFunctionTypeImpl)iteratorType).getReturnType();
            }
            if (iteratorType instanceof JSGenericTypeImpl && "Iterator".equals((genericType = (JSGenericTypeImpl)iteratorType).getType().getTypeText(JSType.TypeTextFormat.SIMPLE))) {
                return (JSType)ContainerUtil.getFirstItem(genericType.getArguments());
            }
        }
        return null;
    }

    public static boolean typeCanBeAssignedWithoutCoercion(@NotNull JSType lOpType, @Nullable JSType rOpType) {
        if (lOpType == null) {
            JSTypeUtils.$$$reportNull$$$0(17);
        }
        if (lOpType instanceof JSNumberType) {
            return rOpType instanceof JSIntType || rOpType instanceof JSNumberType || rOpType instanceof JSUintType;
        }
        if (lOpType instanceof JSIntType || lOpType instanceof JSUintType) {
            return rOpType instanceof JSIntType || rOpType instanceof JSUintType;
        }
        if (lOpType instanceof JSObjectType) {
            return true;
        }
        if (lOpType instanceof JSSpecialNamedTypeImpl || lOpType instanceof JSUndefinedType || lOpType instanceof JSNullType || lOpType instanceof JSVoidType) {
            return lOpType.isEquivalentTo(rOpType, null);
        }
        if (lOpType instanceof JSCompositeTypeImpl) {
            boolean anyTypeCanBeAssignedWithoutCoercion = false;
            for (JSType lOpTypePart : ((JSCompositeTypeImpl)lOpType).getTypes()) {
                anyTypeCanBeAssignedWithoutCoercion |= JSTypeUtils.typeCanBeAssignedWithoutCoercion(lOpTypePart, rOpType);
            }
            return anyTypeCanBeAssignedWithoutCoercion;
        }
        return rOpType != null && !(rOpType instanceof JSAnyType) && !(rOpType instanceof JSObjectType) && !(rOpType instanceof JSUndefinedType) && !(rOpType instanceof JSNullType) && !(rOpType instanceof JSVoidType);
    }

    @NotNull
    public static String getTypeMatchingNamespace(@NotNull String type) {
        JSType jsType;
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(18);
        }
        if ((jsType = JSTypeUtils.createType(type, JSTypeSource.EMPTY_TS)) == null) {
            String string = type;
            if (string == null) {
                JSTypeUtils.$$$reportNull$$$0(19);
            }
            return string;
        }
        String qName = JSTypeUtils.getQualifiedNameMatchingType(jsType, false);
        String string = qName != null ? qName : type;
        if (string == null) {
            JSTypeUtils.$$$reportNull$$$0(20);
        }
        return string;
    }

    @Nullable
    public static String getQualifiedNameMatchingType(@NotNull JSType type, boolean resolved) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(21);
        }
        if ((type = JSTypeUtils.unwrapDecorations(type)) instanceof JSGenericTypeImpl) {
            return JSTypeUtils.getQualifiedNameMatchingType(((JSGenericTypeImpl)type).getType(), resolved);
        }
        if (type instanceof JSArrayTypeImpl) {
            return "Array";
        }
        if (type instanceof JSNullType || type instanceof JSUndefinedType) {
            return null;
        }
        if (type instanceof JSStringType) {
            return "String";
        }
        if (type instanceof JSNumberType) {
            return "Number";
        }
        if (type instanceof JSBooleanType || type instanceof TypeScriptTypePredicateTypeImpl) {
            return "Boolean";
        }
        if (type instanceof JSGenericParameterImpl) {
            JSType constraintType = ((JSGenericParameterImpl)type).getConstraintType();
            if (constraintType == null) {
                return null;
            }
            return JSTypeUtils.getQualifiedNameMatchingType(constraintType, resolved);
        }
        if (type instanceof JSFunctionTypeImpl) {
            return "Function";
        }
        if (type instanceof JSTupleTypeImpl) {
            return "Array";
        }
        if (type instanceof JSNamedType) {
            String text = type.getTypeText(resolved ? JSType.TypeTextFormat.RESOLVED : JSType.TypeTextFormat.SIMPLE);
            return StringUtil.replace((String)text, (String)"prototype.", (String)"");
        }
        return null;
    }

    @Nullable
    public static JSNamespace getNamespaceMatchingType(@NotNull JSType type, boolean resolved, boolean forcedExplicitlyDeclared) {
        JSTypeSubstitutor typeSubstitutor;
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(22);
        }
        if ((type = JSTypeUtils.unwrapDecorations(type)) instanceof JSGlobalTypeImpl) {
            return new JSNamespaceImpl(null, JSContext.STATIC, type.getSource().isStrict());
        }
        String qualifiedName = JSTypeUtils.getQualifiedNameMatchingType(type, resolved);
        if (qualifiedName == null) {
            return null;
        }
        JSContext context = type instanceof JSNamedType ? ((JSNamedType)type).isStaticOrInstance() : JSContext.UNKNOWN;
        boolean explicitlyDeclared = forcedExplicitlyDeclared || type.getSource().isStrict();
        JSQualifiedNameImpl name = JSQualifiedNameImpl.fromNamepath(qualifiedName);
        PsiElement sourceElement = type.getSource().getSourceElement();
        JSNamespaceImpl namespace = new JSNamespaceImpl(name, context, explicitlyDeclared);
        if (type instanceof JSGenericTypeImpl && sourceElement != null && (typeSubstitutor = JSGenericTypesEvaluator.findTypeArgumentsForClassInHierarchy(type, name, sourceElement)) != JSTypeSubstitutor.EMPTY) {
            namespace.putUserData(JSNamespace.GENERIC_ARGUMENTS_KEY, typeSubstitutor);
        }
        return namespace;
    }

    @Nullable
    public static JSNamedType getNamedType(@NotNull JSType type) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(23);
        }
        if (type instanceof JSNamedType) {
            return (JSNamedType)type;
        }
        if ((type = JSTypeUtils.unwrapDecorations(type)) instanceof JSGenericTypeImpl) {
            return JSTypeUtils.getNamedType(((JSGenericTypeImpl)type).getType());
        }
        return null;
    }

    @NotNull
    public static JSType getNonValueType(@NotNull JSType type) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(24);
        }
        if (type instanceof JSStringLiteralTypeImpl) {
            JSStringType jSStringType = new JSStringType(true, type.getSource(), JSTypeContext.INSTANCE);
            if (jSStringType == null) {
                JSTypeUtils.$$$reportNull$$$0(25);
            }
            return jSStringType;
        }
        JSType jSType = type;
        if (jSType == null) {
            JSTypeUtils.$$$reportNull$$$0(26);
        }
        return jSType;
    }

    @Nullable
    public static String getPresentableType(@Nullable JSType type, boolean resolved) {
        if (type == null) {
            return null;
        }
        if (type instanceof JSStringLiteralTypeImpl) {
            return ((JSStringLiteralTypeImpl)type).isEcma() || resolved ? "String" : "string";
        }
        return resolved ? type.getResolvedTypeText() : type.getTypeText();
    }

    public static boolean hasFunctionType(@NotNull JSType type) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(27);
        }
        return JSTypeUtils.hasFunctionType(type, false);
    }

    public static boolean hasConstructorType(@NotNull JSType type) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(28);
        }
        return JSTypeUtils.hasFunctionType(type, true);
    }

    public static boolean hasFunctionType(@NotNull JSType _type, boolean includeConstructorSignatures) {
        if (_type == null) {
            JSTypeUtils.$$$reportNull$$$0(29);
        }
        return JSTypeUtils.getFunctionType(_type, false, includeConstructorSignatures, null).findAny().isPresent();
    }

    @NotNull
    public static Stream<JSType> getFunctionType(@Nullable JSType _type, boolean includeConstructorSignatures) {
        if (_type == null) {
            Stream<JSType> stream = Stream.empty();
            if (stream == null) {
                JSTypeUtils.$$$reportNull$$$0(30);
            }
            return stream;
        }
        Stream<JSType> stream = JSTypeUtils.getFunctionType(_type, false, includeConstructorSignatures, null);
        if (stream == null) {
            JSTypeUtils.$$$reportNull$$$0(31);
        }
        return stream;
    }

    @NotNull
    private static Stream<JSType> getFunctionType(@NotNull JSType _type, boolean typedefsExpanded, boolean includeConstructorSignatures, @Nullable Collection<Object> visited) {
        JSType substitute;
        if (_type == null) {
            JSTypeUtils.$$$reportNull$$$0(32);
        }
        JSType type = _type;
        if ((type = JSTypeUtils.getValuableType(type)) instanceof JSFunctionTypeImpl || type instanceof JSPrimitiveFunctionType || JSTypeCastUtil.isAlwaysAssignableType(type)) {
            Stream<JSType> stream = Stream.of(type);
            if (stream == null) {
                JSTypeUtils.$$$reportNull$$$0(33);
            }
            return stream;
        }
        if (visited != null && (type != _type && !visited.add((Object)JSTypeCastUtil.getTypeIdForComparison(_type)) || !visited.add((Object)JSTypeCastUtil.getTypeIdForComparison(type)))) {
            Stream<JSType> stream = Stream.empty();
            if (stream == null) {
                JSTypeUtils.$$$reportNull$$$0(34);
            }
            return stream;
        }
        if (type instanceof JSArrayType) {
            Stream<JSType> stream = Stream.empty();
            if (stream == null) {
                JSTypeUtils.$$$reportNull$$$0(35);
            }
            return stream;
        }
        if (type instanceof JSUnionOrIntersectionType) {
            if (visited == null) {
                visited = ContainerUtil.newHashSet();
            }
            HashSet _visited = visited;
            JSUnionOrIntersectionType compositeType = (JSUnionOrIntersectionType)type;
            Stream<JSType> resultStream = compositeType.getTypes().stream().filter(el -> el != null).flatMap(jsType -> JSTypeUtils.getFunctionType(jsType, typedefsExpanded, includeConstructorSignatures, _visited));
            if (compositeType instanceof JSIntersectionTypeImpl || !JSTypeCastUtil.isStrictTypeScriptUnionType(compositeType)) {
                Stream<JSType> stream = resultStream;
                if (stream == null) {
                    JSTypeUtils.$$$reportNull$$$0(36);
                }
                return stream;
            }
            List types = resultStream.collect(Collectors.toList());
            if (types.size() <= 1 || !compositeType.getSource().isStrict()) {
                Stream<JSType> stream = types.stream();
                if (stream == null) {
                    JSTypeUtils.$$$reportNull$$$0(37);
                }
                return stream;
            }
            JSType substitute2 = compositeType.substitute();
            Stream<JSType> stream = substitute2 != compositeType ? JSTypeUtils.getFunctionType(substitute2, typedefsExpanded, includeConstructorSignatures, visited) : Stream.empty();
            if (stream == null) {
                JSTypeUtils.$$$reportNull$$$0(38);
            }
            return stream;
        }
        if (type instanceof JSTypeImpl) {
            Collection<TypeScriptInterface> context;
            JSType typedefType;
            JSTypeImpl typeImpl = (JSTypeImpl)type;
            JSTypeSource source = type.getSource();
            if (!typedefsExpanded && source.isStrict() && (typedefType = JSTypeEvaluateManager.expandTypedefs((PsiElement)source.getScope(), type.getResolvedTypeText())) != null) {
                Stream<JSType> stream = JSTypeUtils.getFunctionType(typedefType, true, includeConstructorSignatures, visited);
                if (stream == null) {
                    JSTypeUtils.$$$reportNull$$$0(39);
                }
                return stream;
            }
            if (((JSTypeImpl)type).inheritsFunction()) {
                Stream<JSType> stream = Stream.of(type);
                if (stream == null) {
                    JSTypeUtils.$$$reportNull$$$0(40);
                }
                return stream;
            }
            if (source.isJavaScript() && typeImpl.getTypeContext() != JSTypeContext.STATIC && (context = JSTypeUtils.getTypeScriptInterfaceInJavaScriptContext(type)).size() > 0) {
                Stream<JSType> stream = context.stream().flatMap(anInterface -> TypeScriptPsiUtil.getCallSignatures(anInterface, includeConstructorSignatures).stream()).map(function -> TypeScriptTypeParser.buildFunctionTypeWithoutTypeArguments(function.myFunctionItem));
                if (stream == null) {
                    JSTypeUtils.$$$reportNull$$$0(41);
                }
                return stream;
            }
            JSType substitute3 = type.substitute();
            if (substitute3 != type) {
                Stream<JSType> typeStream;
                List types;
                if (visited == null) {
                    visited = ContainerUtil.newTroveSet();
                }
                if (!(types = (typeStream = JSTypeUtils.getFunctionType(substitute3, true, includeConstructorSignatures, visited)).collect(Collectors.toList())).isEmpty() || !includeConstructorSignatures) {
                    Stream<JSType> stream = types.stream();
                    if (stream == null) {
                        JSTypeUtils.$$$reportNull$$$0(42);
                    }
                    return stream;
                }
            }
            if (includeConstructorSignatures) {
                Stream<JSType> stream = Stream.of(new JSFunctionTypeImpl(type.getSource(), ContainerUtil.emptyList(), JSNamedType.createType(type.getTypeText(JSType.TypeTextFormat.PRESENTABLE), type.getSource(), JSContext.INSTANCE)));
                if (stream == null) {
                    JSTypeUtils.$$$reportNull$$$0(43);
                }
                return stream;
            }
        } else {
            JSGenericParameterImpl genericParameter;
            JSType constraintType;
            if (type instanceof JSRecordType) {
                Stream<JSType> stream = ((JSRecordType)type).getTypeMembers().stream().filter(typeMember -> typeMember instanceof JSRecordType.CallSignature && ((JSRecordType.CallSignature)typeMember).hasNew() == includeConstructorSignatures).map(typeMember -> ((JSRecordType.CallSignature)typeMember).getFunctionType());
                if (stream == null) {
                    JSTypeUtils.$$$reportNull$$$0(44);
                }
                return stream;
            }
            if (type instanceof JSGenericTypeImpl) {
                JSGenericTypeImpl genericType = (JSGenericTypeImpl)type;
                JSType substitute4 = genericType.substitute();
                if (substitute4 != genericType) {
                    Stream<JSType> typeStream;
                    List types;
                    if (visited == null) {
                        visited = ContainerUtil.newTroveSet();
                    }
                    if (!(types = (typeStream = JSTypeUtils.getFunctionType(substitute4, typedefsExpanded, includeConstructorSignatures, visited)).collect(Collectors.toList())).isEmpty()) {
                        Stream<JSType> stream = types.stream();
                        if (stream == null) {
                            JSTypeUtils.$$$reportNull$$$0(45);
                        }
                        return stream;
                    }
                }
                JSType innerType = genericType.getType();
                Stream<JSType> stream = JSTypeUtils.getFunctionType(innerType, typedefsExpanded, includeConstructorSignatures, visited).map(functionType -> {
                    JSType resultType;
                    if (genericType.getSource().isStrict() && !genericType.getSource().isTypeScript() && (resultType = JSTypeUtils.applyJSGenericsForType(genericType.getArguments(), innerType, genericType.getScope(), functionType)) != functionType) {
                        return resultType;
                    }
                    PsiElement sourceElement = functionType.getSource().getSourceElement();
                    if (functionType instanceof JSFunctionTypeImpl) {
                        TypeScriptTypeParameter[] tsSignatureTypeParameters;
                        if (sourceElement instanceof TypeScriptFunction && (tsSignatureTypeParameters = TypeScriptPsiUtil.getTypeParametersForOwner(sourceElement)).length > 0) {
                            JSTypeSubstitutor arguments = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(tsSignatureTypeParameters, genericType.getArguments());
                            return JSTypeUtils.applyGenericArguments(functionType, (Map<String, JSType>)arguments);
                        }
                        JSType newType = JSTypeUtils.getNewOrReturnType(functionType, true);
                        return new JSFunctionTypeImpl(functionType.getSource(), ((JSFunctionTypeImpl)((Object)functionType)).getParameters(), JSTypeUtils.wrapWithGenerics(newType, genericType));
                    }
                    return new JSGenericTypeImpl(genericType.getSource(), (JSType)functionType, genericType.getArguments(), genericType.getOuterArguments());
                });
                if (stream == null) {
                    JSTypeUtils.$$$reportNull$$$0(46);
                }
                return stream;
            }
            if (type instanceof JSGenericParameterImpl && (constraintType = (genericParameter = (JSGenericParameterImpl)type).getConstraintType()) != null) {
                Stream<JSType> stream = JSTypeUtils.getFunctionType(constraintType, typedefsExpanded, includeConstructorSignatures, visited);
                if (stream == null) {
                    JSTypeUtils.$$$reportNull$$$0(47);
                }
                return stream;
            }
        }
        if ((substitute = type.substitute()) != type) {
            if (visited == null && !(substitute instanceof JSRecordType)) {
                visited = ContainerUtil.newTroveSet();
            }
            Stream<JSType> stream = JSTypeUtils.getFunctionType(substitute, typedefsExpanded, includeConstructorSignatures, visited);
            if (stream == null) {
                JSTypeUtils.$$$reportNull$$$0(48);
            }
            return stream;
        }
        Stream<JSType> stream = Stream.empty();
        if (stream == null) {
            JSTypeUtils.$$$reportNull$$$0(49);
        }
        return stream;
    }

    @NotNull
    public static Collection<TypeScriptInterface> getTypeScriptInterfaceInJavaScriptContext(@NotNull JSType type) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(50);
        }
        PsiElement sourceElement = type.getSource().getSourceElement();
        String qName = JSTypeUtils.getQualifiedNameMatchingType(type, false);
        if (sourceElement == null || qName == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSTypeUtils.$$$reportNull$$$0(51);
            }
            return list;
        }
        JSTypeResolveResult result = JSDialectSpecificHandlersFactory.forElement(sourceElement).getImportHandler().resolveTypeName(qName, sourceElement);
        List list = ContainerUtil.mapNotNull(result.getElements(), TypeScriptUtil.TYPESCRIPT_INTERFACE_FILTER);
        if (list == null) {
            JSTypeUtils.$$$reportNull$$$0(52);
        }
        return list;
    }

    public static boolean hasAnyType(@NotNull JSType type) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(53);
        }
        if (type instanceof JSAnyType) {
            return true;
        }
        if (type instanceof JSCompositeTypeImpl) {
            return JSTypeUtils.hasAnyType(((JSCompositeTypeImpl)type).getTypes());
        }
        if (type instanceof JSTypeofTypeImpl) {
            return JSTypeUtils.hasAnyType(((JSTypeofTypeImpl)type).evaluateType());
        }
        return false;
    }

    public static boolean hasAnyType(@NotNull Collection<JSType> types) {
        if (types == null) {
            JSTypeUtils.$$$reportNull$$$0(54);
        }
        for (JSType type : types) {
            if (!JSTypeUtils.hasAnyType(type)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static JSType tryGetReturnType(@NotNull JSType functionType, @NotNull JSApplyCallElement applyCallElement) {
        if (functionType == null) {
            JSTypeUtils.$$$reportNull$$$0(55);
        }
        if (applyCallElement == null) {
            JSTypeUtils.$$$reportNull$$$0(56);
        }
        if (functionType instanceof JSFunctionTypeImpl) {
            return ((JSFunctionTypeImpl)functionType).getReturnType();
        }
        JSCallExpression callExpression = applyCallElement.getCallExpression();
        if (callExpression == null) {
            return null;
        }
        return JSTypeUtils.getReturnType(functionType, callExpression);
    }

    @Nullable
    public static JSType tryGetReturnType(@NotNull JSType functionType, @NotNull JSApplyInstanceContextElement applyInstanceContextElement) {
        JSNewExpression newExpression;
        if (functionType == null) {
            JSTypeUtils.$$$reportNull$$$0(57);
        }
        if (applyInstanceContextElement == null) {
            JSTypeUtils.$$$reportNull$$$0(58);
        }
        if ((newExpression = applyInstanceContextElement.getNewExpression()) == null) {
            return null;
        }
        return JSTypeUtils.getReturnType(functionType, (JSCallExpression)newExpression);
    }

    public static boolean hasTypeArguments(@NotNull JSCallExpression expression) {
        if (expression == null) {
            JSTypeUtils.$$$reportNull$$$0(59);
        }
        if (!(expression instanceof TypeScriptNewExpression)) {
            return false;
        }
        TypeScriptNewExpression newExpression = (TypeScriptNewExpression)expression;
        TypeScriptTypeArgumentList arguments = newExpression.getTypeArguments();
        return arguments != null && arguments.getTypeArguments().length > 0;
    }

    @Nullable
    private static JSType getReturnType(@NotNull JSType startFunction, @NotNull JSCallExpression callExpression) {
        boolean includeConstructors;
        List candidates;
        if (startFunction == null) {
            JSTypeUtils.$$$reportNull$$$0(60);
        }
        if (callExpression == null) {
            JSTypeUtils.$$$reportNull$$$0(61);
        }
        if ((candidates = JSTypeUtils.getFunctionType(startFunction, includeConstructors = callExpression instanceof JSNewExpression).collect(Collectors.toList())).size() == 0) {
            return null;
        }
        List<JSType> argumentTypes = TypeScriptGenericTypesEvaluator.getArgumentTypesForSignatureChecking(callExpression);
        List<JSParameterTypeDecorator> decorators = JSTypeUtils.getParameterTypeDecorators(argumentTypes);
        JSType notAssignableCandidate = null;
        JSType assignableWithDifferentGenericsCount = null;
        ProcessingContext processingContext = JSTypeComparingCacheService.getProcessingContextWithCache((PsiElement)callExpression);
        for (JSType rawType : candidates) {
            if (!(rawType instanceof JSFunctionTypeImpl)) continue;
            JSFunctionTypeImpl type = (JSFunctionTypeImpl)rawType;
            JSTypeSource source = type.getSource();
            boolean typeScript = source.isTypeScript();
            PsiElement sourceElement = source.getSourceElement();
            JSType returnType = JSTypeUtils.getNewOrReturnType(type, includeConstructors);
            TypeScriptTypeParameter[] tsTypeParameters = TypeScriptPsiUtil.getTypeParametersForOwner(sourceElement);
            JSTypeDeclaration[] callArguments = TypeScriptPsiUtil.getNestedTypeArguments((PsiElement)callExpression);
            if (tsTypeParameters.length > 0) {
                JSType withGenerics = TypeScriptGenericTypesEvaluator.applyTypeScriptGenericArguments(type, callExpression);
                returnType = JSTypeUtils.getNewOrReturnType(withGenerics, includeConstructors);
            }
            if (JSTypeUtils.areArgumentsAssignable(type.getParameters(), decorators, processingContext, false, false, typeScript) && tsTypeParameters.length >= callArguments.length) {
                if (callArguments.length == 0 || tsTypeParameters.length == callArguments.length) {
                    return returnType;
                }
                if (assignableWithDifferentGenericsCount != null) continue;
                assignableWithDifferentGenericsCount = returnType;
                continue;
            }
            if (notAssignableCandidate != null) continue;
            notAssignableCandidate = returnType;
        }
        return assignableWithDifferentGenericsCount != null ? assignableWithDifferentGenericsCount : notAssignableCandidate;
    }

    private static JSType applyJSGenericsForType(List<JSType> generics, JSType type, PsiFile scope, JSType resultType) {
        List<String> genericParameters = JSGenericsIndex.findGenericParameters(type.getResolvedTypeText(), scope);
        if (genericParameters != null && genericParameters.size() == generics.size()) {
            Map map = ContainerUtil.newHashMap(genericParameters, generics);
            resultType = JSTypeUtils.applyGenericArguments(resultType, map);
        }
        return resultType;
    }

    @Nullable
    private static JSType wrapWithGenerics(@Nullable JSType type, @Nullable JSGenericTypeImpl genericType) {
        if (genericType == null || type == null) {
            return type;
        }
        return new JSGenericTypeImpl(genericType.getSource(), type, genericType.getArguments(), genericType.getOuterArguments());
    }

    @Nullable
    public static JSType getNewOrReturnType(@Nullable JSType rawType, boolean includeConstructors) {
        JSFunctionTypeImpl functionType = null;
        JSGenericTypeImpl genericType = null;
        if (rawType instanceof JSGenericTypeImpl) {
            genericType = (JSGenericTypeImpl)rawType;
            rawType = ((JSGenericTypeImpl)rawType).getType();
        }
        if (rawType instanceof JSFunctionTypeImpl) {
            functionType = (JSFunctionTypeImpl)rawType;
        }
        if (functionType == null) {
            return null;
        }
        if (!includeConstructors) {
            return JSTypeUtils.wrapWithGenerics(functionType.getReturnType(), genericType);
        }
        JSType type = functionType.getNewType();
        return JSTypeUtils.wrapWithGenerics(type == null ? functionType.getReturnType() : type, genericType);
    }

    @Nullable
    @Contract(value="!null -> !null")
    public static JSType getValuableType(@Nullable JSType type) {
        return JSTypeUtils.getValuableType(type, false, true);
    }

    @Nullable
    @Contract(value="!null, _ -> !null")
    public static JSType getValuableType(@Nullable JSType type, boolean expandIndexers) {
        return JSTypeUtils.getValuableType(type, false, expandIndexers);
    }

    @Nullable
    @Contract(value="!null, _, _ -> !null")
    private static JSType getValuableType(@Nullable JSType type, boolean typedefExpanded, boolean expandIndexers) {
        if (type == null) {
            return null;
        }
        JSTypeSource source = type.getSource();
        if ((type = JSTypeUtils.unwrapDecorations(type)) instanceof JSTypeImpl && !typedefExpanded) {
            JSType typedefValue;
            if (source.isStrict() && source.getLanguage() == JSTypeSource.SourceLanguage.JS && (typedefValue = JSTypeEvaluateManager.expandTypedefs((PsiElement)source.getScope(), type.getTypeText())) != null) {
                return JSTypeUtils.getValuableType(typedefValue, true, expandIndexers);
            }
        } else if (type instanceof JSEvaluableType && (expandIndexers || !(type instanceof TypeScriptIndexedAccessJSTypeImpl))) {
            JSType substitute;
            JSType jSType = substitute = type instanceof JSTypeWithIncompleteSubstitution ? ((JSTypeWithIncompleteSubstitution)type).substituteCompletely() : type.substitute();
            if (substitute != type) {
                return JSTypeUtils.getValuableType(substitute, typedefExpanded, expandIndexers);
            }
        }
        return type;
    }

    @Nullable
    @Contract(value="!null -> !null")
    public static JSType unwrapDecorations(@Nullable JSType type) {
        if (type instanceof JSDecoratedTypeImpl) {
            return JSTypeUtils.unwrapDecorations(((JSDecoratedTypeImpl)type).getType());
        }
        return type;
    }

    public static boolean canBeCalledWithArguments(@Nullable JSType functionType, List<JSType> arguments, boolean inNewExpression) {
        return JSTypeUtils.canBeCalledWithArguments(functionType, arguments, inNewExpression, null);
    }

    public static boolean canBeCalledWithArguments(@Nullable JSType functionType, List<JSType> arguments, boolean inNewExpression, @Nullable ProcessingContext context) {
        return JSTypeUtils.canBeCalledWithArguments(functionType, arguments, inNewExpression, context, null);
    }

    private static boolean canBeCalledWithArguments(@Nullable JSType functionType, List<JSType> arguments, boolean inNewExpression, @Nullable ProcessingContext processingContext, @Nullable Set<String> visited) {
        JSType substitute;
        if (functionType == null || functionType instanceof JSAnyType || functionType instanceof JSPrimitiveFunctionType || functionType instanceof JSNullType && functionType.getSource().isTypeScript()) {
            return true;
        }
        if (visited != null && !JSTypeUtils.checkTypeForVisited(functionType, visited)) {
            return true;
        }
        if (functionType instanceof JSFunctionTypeImpl) {
            if (processingContext == null) {
                processingContext = new ProcessingContext();
                processingContext.put(JSGenericParameterImpl.CALL_ENV_KEY, (Object)true);
            }
            boolean typescript = ((JSFunctionTypeImpl)functionType).isTypeScript();
            return JSTypeUtils.areArgumentsAssignable(((JSFunctionTypeImpl)functionType).getParameters(), JSTypeUtils.getParameterTypeDecorators(arguments), processingContext, false, false, typescript);
        }
        if (functionType instanceof JSCompositeTypeImpl) {
            if (visited == null) {
                visited = ContainerUtil.newHashSet();
            }
            for (JSType type : ((JSCompositeTypeImpl)functionType).getTypes()) {
                if (!JSTypeUtils.canBeCalledWithArguments(type, arguments, inNewExpression, processingContext, visited)) continue;
                return true;
            }
        } else if (functionType instanceof JSRecordType) {
            for (JSRecordType.TypeMember typeMember : ((JSRecordType)functionType).getTypeMembers()) {
                if (!(typeMember instanceof JSRecordType.CallSignature) || ((JSRecordType.CallSignature)typeMember).hasNew() != inNewExpression || !JSTypeUtils.canBeCalledWithArguments(((JSRecordType.CallSignature)typeMember).getFunctionType(), arguments, inNewExpression, processingContext, visited)) continue;
                return true;
            }
        }
        if ((substitute = functionType.substitute()) != functionType) {
            if (visited == null && !(substitute instanceof JSRecordType)) {
                visited = ContainerUtil.newHashSet();
            }
            return JSTypeUtils.canBeCalledWithArguments(substitute, arguments, inNewExpression, processingContext, visited);
        }
        return false;
    }

    private static boolean checkTypeForVisited(@NotNull JSType type, @NotNull Collection<String> visited) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(62);
        }
        if (visited == null) {
            JSTypeUtils.$$$reportNull$$$0(63);
        }
        return visited.add(type.getResolvedTypeText());
    }

    @Deprecated
    @Contract(value="!null -> !null")
    public static JSType resolveType(@Nullable JSType type) {
        if ((type = JSTypeUtils.getValuableType(type)) != null && type.getSource().getLanguage() == JSTypeSource.SourceLanguage.TS) {
            return type.substitute();
        }
        return type;
    }

    public static boolean areArgumentsAssignable(@NotNull List<JSParameterTypeDecorator> parameters, @Nullable List<JSParameterTypeDecorator> arguments, ProcessingContext processingContext, boolean functionAssignment, boolean jsDocFunctionAssignment, boolean typescript) {
        if (parameters == null) {
            JSTypeUtils.$$$reportNull$$$0(64);
        }
        if (arguments == null) {
            return parameters.isEmpty();
        }
        if (typescript && !functionAssignment) {
            int min = TypeScriptSignatureChooser.getMinArgumentCount(parameters);
            int max = TypeScriptSignatureChooser.getMaxArgumentCount(parameters);
            int argumentSize = arguments.size();
            if (min > argumentSize || argumentSize > max) {
                return false;
            }
        }
        Iterator<JSParameterTypeDecorator> paramIterator = parameters.iterator();
        Iterator<JSParameterTypeDecorator> argIterator = arguments.iterator();
        Ref paramRestType = null;
        Ref argRestType = null;
        boolean remainingArgumentsAreOptional = false;
        boolean remainingParametersAreOptional = false;
        while (paramIterator.hasNext() || argIterator.hasNext()) {
            JSType argument;
            JSType parameter;
            JSParameterTypeDecorator parameterTypeDecorator = null;
            boolean hasParameter = true;
            if (paramIterator.hasNext()) {
                parameterTypeDecorator = paramIterator.next();
                parameter = parameterTypeDecorator.getType();
            } else if (paramRestType != null) {
                parameter = (JSType)paramRestType.get();
            } else {
                parameter = null;
                hasParameter = false;
            }
            if (parameterTypeDecorator != null && parameterTypeDecorator.isRest()) {
                paramRestType = Ref.create((Object)parameter);
                remainingParametersAreOptional = true;
            }
            if (parameterTypeDecorator != null && parameterTypeDecorator.isOptional()) {
                remainingParametersAreOptional = true;
            }
            JSParameterTypeDecorator argumentTypeDecorator = null;
            boolean hasArgument = true;
            if (argIterator.hasNext()) {
                argumentTypeDecorator = argIterator.next();
                argument = argumentTypeDecorator.getType();
            } else if (argRestType != null) {
                argument = (JSType)argRestType.get();
            } else {
                hasArgument = false;
                argument = null;
            }
            if (argumentTypeDecorator != null && argumentTypeDecorator.isRest()) {
                argRestType = Ref.create((Object)argument);
                remainingArgumentsAreOptional = true;
            }
            if (argumentTypeDecorator != null && argumentTypeDecorator.isOptional()) {
                remainingArgumentsAreOptional = true;
            }
            if (!hasParameter) {
                return functionAssignment && !typescript || remainingArgumentsAreOptional;
            }
            if (!hasArgument) {
                return remainingParametersAreOptional || functionAssignment && typescript;
            }
            if (JSTypeUtils.isAssignableType(parameter, argument, processingContext) || functionAssignment && !jsDocFunctionAssignment && JSTypeUtils.isAssignableType(argument, parameter, processingContext)) continue;
            return false;
        }
        return typescript || !functionAssignment || remainingParametersAreOptional || paramRestType != null || !remainingArgumentsAreOptional && (!jsDocFunctionAssignment || argRestType == null);
    }

    public static boolean haveAncestorChildRelation(@NotNull String qname1, @NotNull String qname2) {
        int i;
        if (qname1 == null) {
            JSTypeUtils.$$$reportNull$$$0(65);
        }
        if (qname2 == null) {
            JSTypeUtils.$$$reportNull$$$0(66);
        }
        for (i = 0; i < qname1.length() && i < qname2.length(); ++i) {
            if (qname1.charAt(i) == qname2.charAt(i)) continue;
            return false;
        }
        return qname1.length() == qname2.length() || i < qname1.length() && qname1.charAt(i) == '.' || i < qname2.length() && qname2.charAt(i) == '.';
    }

    public static JSType applyGenericArguments(@Nullable JSType _type, @Nullable Map<String, JSType> typeArguments, boolean call, @Nullable JSGenericTypesEvaluator.GenericErrorReporter report) {
        return JSTypeUtils.applyGenericArguments(_type, typeArguments, call, report, false);
    }

    public static JSType applyGenericArguments(@Nullable JSType _type, final @Nullable Map<String, JSType> typeArguments, final boolean call, final @Nullable JSGenericTypesEvaluator.GenericErrorReporter report, final boolean skipSelf) {
        if (_type == null || typeArguments == null || typeArguments.isEmpty()) {
            return _type;
        }
        return JSTypeUtils.applyCompositeMapping(_type, new Function<JSType, JSType>(){

            public JSType fun(JSType type) {
                JSType result;
                JSType constraintType;
                if (type instanceof JSTypeofTypeImpl) {
                    JSType evaluatedType = ((JSTypeofTypeImpl)type).evaluateType();
                    return JSTypeUtils.applyCompositeMapping(evaluatedType, this);
                }
                if (type instanceof JSGenericTypeImpl) {
                    List<JSType> initialArguments = ((JSGenericTypeImpl)type).getArguments();
                    ArrayList processedArguments = ContainerUtil.newArrayListWithCapacity((int)initialArguments.size());
                    boolean stop = false;
                    String ownId = JSTypeCastUtil.getTypeIdForComparison(type);
                    for (JSType subst : typeArguments.values()) {
                        String idForComparison = subst == null ? null : JSTypeCastUtil.getTypeIdForComparison(subst);
                        if (!Objects.equals(ownId, idForComparison)) continue;
                        stop = true;
                        break;
                    }
                    for (JSType arg : initialArguments) {
                        processedArguments.add(stop ? arg : JSTypeUtils.applyCompositeMappingNoRecurse(arg, (Function<JSType, JSType>)this));
                    }
                    type = new JSGenericTypeImpl(type.getSource(), ((JSGenericTypeImpl)type).getType(), processedArguments, ((JSGenericTypeImpl)type).getOuterArguments());
                }
                if (type instanceof JSGenericParameterImpl && (constraintType = ((JSGenericParameterImpl)type).getConstraintType()) != null) {
                    type = new JSGenericParameterImpl(((JSGenericParameterImpl)type).getName(), type.getSource(), JSTypeUtils.applyCompositeMappingNoRecurse(constraintType, (Function<JSType, JSType>)this), ((JSGenericParameterImpl)type).isCallEnvironment());
                }
                if (type instanceof TypeScriptTypeOperatorJSTypeImpl) {
                    JSType referencedType = ((TypeScriptTypeOperatorJSTypeImpl)type).getReferencedType();
                    JSType mappedReferencedType = JSTypeUtils.applyCompositeMappingNoRecurse(referencedType, (Function<JSType, JSType>)this);
                    type = new TypeScriptTypeOperatorJSTypeImpl(mappedReferencedType == null ? referencedType : mappedReferencedType, type.getSource());
                }
                if (type instanceof JSTypeImpl || type instanceof JSGenericParameterImpl) {
                    JSResolvedTypeInfo resolvedType;
                    JSType jsType;
                    if (call) {
                        type = TypeScriptUtil.setCallEnvironmentIfGenericParameterType(type);
                    }
                    if ((jsType = (JSType)typeArguments.get(type.getTypeText())) instanceof JSTypeofTypeImpl) {
                        jsType = ((JSTypeofTypeImpl)jsType).evaluateType();
                    }
                    if (jsType != null) {
                        if (skipSelf) {
                            return type;
                        }
                        if (type instanceof JSGenericParameterImpl) {
                            JSType constraintType2 = JSTypeUtils.applyCompositeMappingNoRecurse(((JSGenericParameterImpl)type).getConstraintType(), (Function<JSType, JSType>)this);
                            if (report != null && constraintType2 != null && !constraintType2.isDirectlyAssignableType(jsType, null)) {
                                report.error("typescript.validation.cannot.find.best.common.type");
                                return constraintType2;
                            }
                        }
                        return JSTypeUtils.applyCompositeMappingNoRecurse(jsType, (Function<JSType, JSType>)this);
                    }
                    if (type instanceof JSResolvableType && (resolvedType = ((JSResolvableType)type).resolveType()) != null && resolvedType.isLocal()) {
                        return new JSGenericTypeImpl(type.getSource(), type, typeArguments);
                    }
                } else if (type instanceof JSGenericTypeImpl && (result = JSTypeUtils.concatGenericsToJSGenericTypeIfNestedLocal((JSGenericTypeImpl)type, typeArguments)) != null) {
                    return result;
                }
                return type;
            }
        });
    }

    @Nullable
    @Contract(value="null, _ -> null")
    private static JSType applyCompositeMappingNoRecurse(@Nullable JSType constraintType, @NotNull Function<JSType, JSType> map) {
        if (map == null) {
            JSTypeUtils.$$$reportNull$$$0(67);
        }
        JSType result = constraintType == null ? null : (JSType)RecursionManager.doPreventingRecursion((Object)JSTypeCastUtil.getTypeIdForComparison(constraintType), (boolean)false, () -> {
            if (map == null) {
                JSTypeUtils.$$$reportNull$$$0(110);
            }
            return JSTypeUtils.applyCompositeMapping(constraintType, map);
        });
        return result == null ? constraintType : result;
    }

    private static JSType concatGenericsToJSGenericTypeIfNestedLocal(JSGenericTypeImpl genericType, @NotNull Map<String, JSType> typeArguments) {
        JSType jsType;
        JSResolvedTypeInfo resolvedType;
        JSType innerType;
        if (typeArguments == null) {
            JSTypeUtils.$$$reportNull$$$0(68);
        }
        if ((innerType = genericType.getType()) instanceof JSResolvableType && (resolvedType = ((JSResolvableType)innerType).resolveType()) != null && resolvedType.isLocal() && (jsType = typeArguments.get(innerType.getTypeText())) == null) {
            Map newOuterArguments = typeArguments;
            if (genericType.getOuterArguments() != null) {
                newOuterArguments = ContainerUtil.union(newOuterArguments, genericType.getOuterArguments());
            }
            return new JSGenericTypeImpl(genericType.getSource(), innerType, genericType.getArguments(), newOuterArguments);
        }
        return null;
    }

    public static JSType applyGenericArguments(@NotNull JSType _type, @Nullable Map<String, JSType> typeArguments, @Nullable JSGenericTypesEvaluator.GenericErrorReporter report) {
        if (_type == null) {
            JSTypeUtils.$$$reportNull$$$0(69);
        }
        return JSTypeUtils.applyGenericArguments(_type, typeArguments, false, report);
    }

    @Nullable
    @Contract(value="!null, _ -> !null")
    public static JSType applyGenericArguments(@Nullable JSType _type, @Nullable Map<String, JSType> typeArguments) {
        return JSTypeUtils.applyGenericArguments(_type, typeArguments, false, null);
    }

    @Nullable
    @Contract(value="!null, _ -> !null")
    public static JSType applyGenericArguments(@Nullable JSType _type, @Nullable Map<String, JSType> typeArguments, boolean skipSelf) {
        return JSTypeUtils.applyGenericArguments(_type, typeArguments, false, null, skipSelf);
    }

    @Nullable
    @Contract(value="!null, _ -> !null")
    public static JSType addGenericParameters(@Nullable JSType _type, @NotNull Set<String> genericParameters) {
        if (genericParameters == null) {
            JSTypeUtils.$$$reportNull$$$0(70);
        }
        if (_type == null || genericParameters.isEmpty()) {
            return _type;
        }
        return JSTypeUtils.applyCompositeMapping(_type, (Function<JSType, JSType>)((Function)type -> {
            if (genericParameters == null) {
                JSTypeUtils.$$$reportNull$$$0(109);
            }
            if (type instanceof JSTypeImpl && genericParameters.contains(type.getTypeText())) {
                return new JSGenericParameterImpl(type.getTypeText(), type.getSource());
            }
            return type;
        }));
    }

    @Nullable
    @Contract(value="!null, _ -> !null")
    public static JSType applyCompositeMapping(@Nullable JSType type, @NotNull Function<JSType, JSType> f) {
        if (f == null) {
            JSTypeUtils.$$$reportNull$$$0(71);
        }
        return JSTypeUtils.transformTypeHierarchySafe(type, f);
    }

    public static boolean hasGenericParameter(@Nullable JSType type) {
        return JSTypeUtils.hasTypes(type, JSGenericParameterImpl.class);
    }

    public static boolean hasTypes(@Nullable JSType type, final Class<?> ... typeClasses) {
        if (typeClasses == null) {
            JSTypeUtils.$$$reportNull$$$0(72);
        }
        if (type == null) {
            return false;
        }
        for (Class<?> typeClass : typeClasses) {
            if (!typeClass.isInstance(type)) continue;
            return true;
        }
        final Ref result = Ref.create((Object)Boolean.FALSE);
        type.accept(new JSRecursiveTypeVisitor(){

            public void visitJSType(JSType typeToVisit) {
                for (Class typeClass : typeClasses) {
                    if (!typeClass.isInstance(typeToVisit)) continue;
                    result.set((Object)Boolean.TRUE);
                    return;
                }
                super.visitJSType(typeToVisit);
            }
        });
        return (Boolean)result.get();
    }

    public static boolean hasThisGenericType(@Nullable JSType type) {
        return JSTypeUtils.hasTypes(type, TypeScriptGenericThisTypeImpl.class);
    }

    @Deprecated
    @Contract(value="!null, _ -> !null")
    public static JSType copyWithNewSourceRecursive(@Nullable JSType type, @NotNull JSTypeSource source) {
        if (source == null) {
            JSTypeUtils.$$$reportNull$$$0(73);
        }
        if (type == null) {
            return null;
        }
        if (source == type.getSource()) {
            return type;
        }
        return JSTypeBaseImpl.replaceSourceRecursive(type, source);
    }

    @Contract(value="!null, _ -> !null")
    public static JSType copyWithStrictRecursive(@Nullable JSType type, final boolean strict) {
        if (type == null) {
            return null;
        }
        return type.transformTypeHierarchy((Function)new Function<JSType, JSType>(){

            public JSType fun(@Nullable JSType type) {
                if (type == null || type.getSource().isStrict() == strict) {
                    return type;
                }
                JSType newType = JSTypeUtils.copyWithStrict(type, strict);
                return newType.transformTypeHierarchy((Function)this);
            }
        });
    }

    @Contract(value="!null, _ -> !null")
    public static JSType copyWithStrict(@Nullable JSType type, boolean strict) {
        if (type == null) {
            return null;
        }
        return type.copyWithStrict(strict);
    }

    @NotNull
    public static List<JSType> addPossibleOption(@NotNull Collection<JSType> types, @NotNull JSType newOption) {
        if (types == null) {
            JSTypeUtils.$$$reportNull$$$0(74);
        }
        if (newOption == null) {
            JSTypeUtils.$$$reportNull$$$0(75);
        }
        boolean hasAnyType = false;
        int typesCount = 0;
        for (JSType addedType : types) {
            ++typesCount;
            if (!(addedType instanceof JSAnyType)) continue;
            hasAnyType = true;
        }
        JSTypeSource optionSource = newOption.getSource();
        List<JSType> typesToAdd = newOption instanceof JSCompositeTypeImpl && !optionSource.isStrict() ? ((JSCompositeTypeImpl)newOption).getTypes() : Collections.singletonList(newOption);
        SmartList result = new SmartList();
        if (types.isEmpty()) {
            result.addAll(typesToAdd);
            SmartList smartList = result;
            if (smartList == null) {
                JSTypeUtils.$$$reportNull$$$0(76);
            }
            return smartList;
        }
        for (JSType typeToAdd : typesToAdd) {
            boolean alreadyPresent = false;
            String typeToAddText = typeToAdd.getTypeText(JSType.TypeTextFormat.SIMPLE);
            for (JSType addedType : types) {
                if (!StringUtil.equals((CharSequence)typeToAddText, (CharSequence)addedType.getTypeText(JSType.TypeTextFormat.SIMPLE))) continue;
                alreadyPresent = true;
                break;
            }
            if (alreadyPresent) continue;
            if (typesCount > 5) {
                if (hasAnyType) continue;
                result.add(JSAnyType.get((PsiElement)optionSource.getScope(), false));
                ++typesCount;
                continue;
            }
            result.add(typeToAdd);
            ++typesCount;
        }
        SmartList smartList = result;
        if (smartList == null) {
            JSTypeUtils.$$$reportNull$$$0(77);
        }
        return smartList;
    }

    public static boolean processExpandedType(JSTypeProcessor processor, JSType type, @NotNull JSEvaluateContext context, PsiElement source) {
        if (context == null) {
            JSTypeUtils.$$$reportNull$$$0(78);
        }
        return JSTypeUtils.processExpandedType((Processor<JSType>)((Processor)type1 -> {
            if (context == null) {
                JSTypeUtils.$$$reportNull$$$0(108);
            }
            processor.process((JSType)type1, context, source);
            return true;
        }), type, true, false, false);
    }

    public static boolean processExpandedType(@NotNull Processor<JSType> processor, @Nullable JSType type) {
        if (processor == null) {
            JSTypeUtils.$$$reportNull$$$0(79);
        }
        return JSTypeUtils.processExpandedType(processor, type, false, true, true);
    }

    public static boolean processExpandedType(@NotNull Processor<JSType> processor, @Nullable JSType type, boolean substituteUnionsAndIntersections, boolean recurse, boolean processOnlyFinalType) {
        if (processor == null) {
            JSTypeUtils.$$$reportNull$$$0(80);
        }
        return JSTypeUtils.processExpandedType(processor, type, substituteUnionsAndIntersections, recurse, processOnlyFinalType, null);
    }

    private static Set<String> getOrCreateProcessingSet(@NotNull JSType type, Set<String> processedTypeIds) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(81);
        }
        if (processedTypeIds != null) {
            return processedTypeIds;
        }
        HashSet set = ContainerUtil.newHashSet();
        set.add(JSTypeCastUtil.getTypeIdForComparison(type));
        return set;
    }

    public static boolean processExpandedType(@NotNull Processor<JSType> processor, @Nullable JSType type, boolean substituteUnionsAndIntersections, boolean recurse, boolean processOnlyFinalType, @Nullable Set<String> processedTypeIds) {
        JSType newType;
        if (processor == null) {
            JSTypeUtils.$$$reportNull$$$0(82);
        }
        if (type != null && processedTypeIds != null && !processedTypeIds.add(JSTypeCastUtil.getTypeIdForComparison(type))) {
            return false;
        }
        if (type instanceof JSUnionOrIntersectionType) {
            boolean isStrictTypeScript = JSTypeCastUtil.isStrictTypeScriptUnionType((JSUnionOrIntersectionType)type);
            if (isStrictTypeScript && substituteUnionsAndIntersections) {
                JSType resolveUnionType = type.substitute();
                processor.process((Object)resolveUnionType);
            } else {
                processedTypeIds = JSTypeUtils.getOrCreateProcessingSet(type, processedTypeIds);
                for (JSType jsType : ((JSUnionOrIntersectionType)type).getTypes()) {
                    if (!processOnlyFinalType) {
                        processor.process((Object)jsType);
                    }
                    if (!recurse || JSTypeUtils.processExpandedType(processor, jsType, substituteUnionsAndIntersections, true, processOnlyFinalType, processedTypeIds)) continue;
                    return false;
                }
            }
            return false;
        }
        if (type instanceof JSTypeImpl) {
            JSType typedefValue;
            JSTypeSource typeSource = type.getSource();
            if (typeSource.isStrict() && type.resolveClass() == null && (typedefValue = ((JSTypeImpl)type).getTypedef(null, new ProcessingContext())) != null) {
                if (!processOnlyFinalType) {
                    processor.process((Object)typedefValue);
                }
                if (!recurse) {
                    return true;
                }
                return JSTypeUtils.processExpandedType(processor, typedefValue, substituteUnionsAndIntersections, true, processOnlyFinalType, JSTypeUtils.getOrCreateProcessingSet(type, processedTypeIds));
            }
        } else if (type instanceof JSDecoratedTypeImpl) {
            JSType jsType = ((JSDecoratedTypeImpl)type).getType();
            if (!processOnlyFinalType) {
                processor.process((Object)jsType);
            }
            if (recurse) {
                JSTypeUtils.processExpandedType(processor, jsType, substituteUnionsAndIntersections, true, processOnlyFinalType, JSTypeUtils.getOrCreateProcessingSet(type, processedTypeIds));
            }
            return false;
        }
        if ((type instanceof TypeScriptGenericThisTypeImpl || type instanceof TypeScriptTypeOperatorJSTypeImpl || type instanceof TypeScriptMappedJSTypeImpl || type instanceof TypeScriptIndexedAccessJSTypeImpl) && type != (newType = type.substitute())) {
            if (!processOnlyFinalType) {
                processor.process((Object)newType);
            }
            if (recurse) {
                JSTypeUtils.processExpandedType(processor, newType, substituteUnionsAndIntersections, true, processOnlyFinalType, JSTypeUtils.getOrCreateProcessingSet(type, processedTypeIds));
            }
            return false;
        }
        if (processOnlyFinalType) {
            processor.process((Object)type);
        }
        return true;
    }

    public static boolean areTypesCompatible(@Nullable JSType type1, @Nullable JSType type2, @Nullable ProcessingContext processingContext, @Nullable PsiElement psiContext) {
        boolean eq;
        if (type1 == null || type2 == null) {
            return type1 == type2;
        }
        if (type1 instanceof JSTypeofTypeImpl) {
            return JSTypeUtils.areTypesCompatible(((JSTypeofTypeImpl)type1).evaluateType(), type2, processingContext, psiContext);
        }
        if (type2 instanceof JSTypeofTypeImpl) {
            return JSTypeUtils.areTypesCompatible(type1, ((JSTypeofTypeImpl)type2).evaluateType(), processingContext, psiContext);
        }
        if (type1 instanceof JSStringLiteralTypeImpl) {
            return type2 instanceof JSStringType;
        }
        if (type2 instanceof JSStringLiteralTypeImpl) {
            return type1 instanceof JSStringType;
        }
        if (type1 instanceof JSArrayTypeImpl) {
            if (type2 instanceof JSPrimitiveArrayType) {
                return true;
            }
            if (JSGenericTypeImpl.isGenericActionScriptVectorType(type2)) {
                return true;
            }
        }
        if (type2 instanceof JSArrayTypeImpl) {
            if (type1 instanceof JSPrimitiveArrayType) {
                return true;
            }
            if (JSGenericTypeImpl.isGenericActionScriptVectorType(type1)) {
                return true;
            }
        }
        if (eq = type1.isEquivalentTo(type2, processingContext)) {
            return true;
        }
        if (psiContext != null && DialectDetector.isTypeScript(psiContext)) {
            return type1.isDirectlyAssignableType(type2, processingContext) && type2.isDirectlyAssignableType(type1, processingContext);
        }
        return false;
    }

    @Nullable
    public static JSType getTypeOfElement(@Nullable PsiElement element) {
        if (element instanceof JSLocalImplicitElementImpl) {
            return ((JSLocalImplicitElementImpl)element).getJSType();
        }
        if (element instanceof JSImplicitElement) {
            return JSTypeUtils.parseSerializedType(((JSImplicitElement)element).getTypeString(), JSTypeSourceFactory.createTypeSource(element, true));
        }
        if (element instanceof JSFieldVariable) {
            return ((JSFieldVariable)element).getType();
        }
        if (element instanceof JSFunction && ((JSFunction)element).isGetProperty()) {
            return ((JSFunction)element).getReturnType();
        }
        if (element instanceof JSDefinitionExpression) {
            return ((JSDefinitionExpression)element).getType();
        }
        if (element instanceof JSProperty) {
            return ((JSProperty)element).getType();
        }
        if (element instanceof JSClass) {
            String name = ((JSClass)element).getQualifiedName();
            if (StringUtil.isNotEmpty((String)name)) {
                JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(element, false);
                return JSNamedType.createType(name, typeSource, JSContext.STATIC);
            }
            return TypeScriptTypeParser.buildTypeFromClass((JSClass)element, false);
        }
        return null;
    }

    public static boolean isActionScriptVectorType(@Nullable JSType type) {
        if (type != null && type.getSource().isTypeScript()) {
            return false;
        }
        if (type instanceof JSGenericTypeImpl) {
            type = ((JSGenericTypeImpl)type).getType();
        }
        return type instanceof JSTypeImpl && "Vector".equals(type.getTypeText());
    }

    public static String defaultValueOfType(@Nullable JSType retType) {
        if (retType instanceof JSNumberType) {
            return "0";
        }
        if (retType instanceof JSBooleanType) {
            return "false";
        }
        if (retType instanceof JSStringType) {
            return "\"\"";
        }
        return null;
    }

    @Deprecated
    @NonNls
    public static String defaultValueOfType(@NonNls String retType) {
        if ("int".equals(retType) || "uint".equals(retType) || "Number".equals(retType)) {
            return "0";
        }
        if ("Boolean".equals(retType)) {
            return "false";
        }
        if ("String".equals(retType)) {
            return "\"\"";
        }
        return "null";
    }

    @Nullable
    public static List<JSType> getGenericTypeArguments(@Nullable JSType type) {
        if (type instanceof JSGenericTypeImpl) {
            return ((JSGenericTypeImpl)type).getArguments();
        }
        if (type instanceof JSTupleTypeImpl) {
            return JSTypeUtils.getGenericTypeArguments(((JSTupleTypeImpl)type).toArrayType(true));
        }
        if (type instanceof JSArrayTypeImpl) {
            return Collections.singletonList(((JSArrayTypeImpl)type).getType());
        }
        if (type instanceof JSPrimitiveArrayType) {
            return Collections.singletonList(JSAnyType.get(type.getSource().getSourceElement(), ((JSPrimitiveArrayType)type).getSource().isStrict()));
        }
        return null;
    }

    @Contract(value="null -> false")
    public static boolean containsLiteralTypes(@Nullable JSType type) {
        Ref hasLiteral = Ref.create((Object)false);
        JSTypeUtils.processExpandedType((Processor<JSType>)((Processor)t -> {
            if (JSTypeUtils.isLiteralType(t)) {
                hasLiteral.set((Object)true);
            }
            return true;
        }), type);
        return (Boolean)hasLiteral.get();
    }

    private static boolean isLiteralType(@Nullable JSType t) {
        if (t instanceof JSLiteralType) {
            return true;
        }
        if (t instanceof TypeScriptTypeOperatorJSTypeImpl) {
            return true;
        }
        return JSTypeUtils.isEnumLiteral(t);
    }

    @Contract(value="null -> false")
    public static boolean isEnumLiteral(@Nullable JSType type) {
        if (!(type instanceof JSResolvableType)) {
            return false;
        }
        JSResolvedTypeInfo info = ((JSResolvableType)type).resolveType();
        return info != null && info.isEnumLiteral();
    }

    @Contract(value="null -> false")
    public static boolean isLiteralOrCompositeWithLiteralType(@Nullable JSType type) {
        if (type == null) {
            return false;
        }
        if (JSTypeUtils.isLiteralType(type)) {
            return true;
        }
        if (JSTypeUtils.isUnionTypeWithLiteralCandidate(type)) {
            return ((JSUnionType)type).getTypes().stream().anyMatch(el -> JSTypeUtils.isLiteralOrCompositeWithLiteralType(el));
        }
        return false;
    }

    @Contract(value="null -> false")
    public static boolean containsLiteralOrPrimitiveTypes(@Nullable JSType type) {
        Ref hasLiteralOrPrimitive = Ref.create((Object)false);
        JSTypeUtils.processExpandedType((Processor<JSType>)((Processor)t -> {
            if (t instanceof JSStringType || t instanceof JSNumberType || t instanceof JSBooleanType || JSTypeUtils.isLiteralType(t)) {
                hasLiteralOrPrimitive.set((Object)true);
            }
            return true;
        }), type);
        return (Boolean)hasLiteralOrPrimitive.get();
    }

    @Contract(value="null -> null")
    public static JSType expandEnumLiteralIfNeeded(@Nullable JSType exprType) {
        JSResolvedTypeInfo resolvedType;
        if (exprType instanceof JSResolvableType && ((JSResolvableType)exprType).isWidened() && (resolvedType = ((JSResolvableType)exprType).resolveType()) != null && resolvedType.isEnumLiteral()) {
            return TypeScriptUtil.getBaseTypeOfEnumLiteralType((JSResolvableType)exprType);
        }
        return exprType;
    }

    @Nullable
    @Contract(value="null -> null")
    public static JSType widenLiteralTypes(@Nullable JSType type) {
        if (type == null) {
            return null;
        }
        if (type instanceof JSPrimitiveLiteralType && !((JSPrimitiveLiteralType)type).isStrict()) {
            return ((JSPrimitiveLiteralType)type).asPrimitiveType();
        }
        if (type instanceof JSTypeImpl) {
            return ((JSTypeImpl)type).copyAsWidened();
        }
        if (JSTypeUtils.isUnionTypeWithLiteralCandidate(type)) {
            List<JSType> types = ((JSCompositeTypeImpl)type).getTypes();
            ArrayList newTypes = ContainerUtil.newArrayListWithCapacity((int)types.size());
            for (JSType part : types) {
                newTypes.add(JSTypeUtils.widenLiteralTypes(part));
            }
            return new JSCompositeTypeImpl(type.getSource(), newTypes);
        }
        return type;
    }

    private static boolean isUnionTypeWithLiteralCandidate(@NotNull JSType type) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(83);
        }
        return type instanceof JSUnionType && JSTypeUtils.hasTypes(type, JSStringLiteralTypeImpl.class, JSNumberLiteralTypeImpl.class, JSBooleanLiteralTypeImpl.class, JSTypeImpl.class);
    }

    public static JSType getApparentType(@Nullable JSType type) {
        if ((type = JSTypeUtils.widenLiteralTypes(type)) instanceof JSNullType || type instanceof JSUndefinedType) {
            return JSAnyType.getByTypeSource(type.getSource());
        }
        if (JSTypeUtils.hasTypes(type, JSUnionOrIntersectionType.class, JSTupleTypeImpl.class)) {
            Function<JSType, JSType> transformation = new Function<JSType, JSType>(){

                public JSType fun(JSType type) {
                    JSType optimizeTypeIfComposite;
                    if (type instanceof JSUnionOrIntersectionType && type != (optimizeTypeIfComposite = JSCompositeTypeImpl.optimizeTypeIfComposite(type, false))) {
                        return optimizeTypeIfComposite.transformTypeHierarchy((Function)this);
                    }
                    if (type instanceof JSTupleTypeImpl) {
                        return new JSTupleTypeImpl(type.getSource(), ((JSTupleTypeImpl)type).getTypes().stream().map(t -> t.transformTypeHierarchy((Function)this)).collect(Collectors.toList()), true);
                    }
                    return type;
                }
            };
            type = type.transformTypeHierarchy((Function)transformation);
        }
        return type;
    }

    public static JSType getCommonType(@NotNull JSType type1, @NotNull JSType type2, @Nullable DialectOptionHolder holder, boolean allowResolve) {
        boolean isTypeScript;
        if (type1 == null) {
            JSTypeUtils.$$$reportNull$$$0(84);
        }
        if (type2 == null) {
            JSTypeUtils.$$$reportNull$$$0(85);
        }
        JSTypeSource source = type1.getSource();
        boolean bl = isTypeScript = holder != null && holder.isTypeScript;
        if (!(!(type1 instanceof JSStringType) || !(type2 instanceof JSStringType) || isTypeScript && type1 instanceof JSStringLiteralTypeImpl && type2 instanceof JSStringLiteralTypeImpl)) {
            return JSNamedType.createType("string", source, ((JSStringType)type1).isStaticOrInstance());
        }
        if (isTypeScript) {
            return JSCompositeTypeImpl.getCommonType(type1, type2, null, allowResolve);
        }
        if (type1.isEquivalentTo(type2, null, allowResolve)) {
            return type1;
        }
        return JSAnyType.get((PsiElement)source.getScope(), false);
    }

    @NotNull
    public static JSType replaceImplicitTypesWithAny(@NotNull JSType type) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(86);
        }
        JSType jSType = type.transformTypeHierarchy(toProcess -> {
            if (!(toProcess = JSTypeUtils.getValuableType(toProcess)).getSource().isStrict() && toProcess.getSource().isTypeScript()) {
                return JSAnyType.get(toProcess.getSource().getSourceElement(), true);
            }
            return toProcess;
        });
        if (jSType == null) {
            JSTypeUtils.$$$reportNull$$$0(87);
        }
        return jSType;
    }

    public static JSType getCommonType(@NotNull Collection<TypeProvider> providers, @Nullable PsiElement context, boolean allowResolve) {
        DialectOptionHolder holder;
        if (providers == null) {
            JSTypeUtils.$$$reportNull$$$0(88);
        }
        DialectOptionHolder dialectOptionHolder = holder = context == null ? null : DialectDetector.dialectOfElement(context);
        if (holder != null && holder.isTypeScript) {
            return JSTypeUtils.getTypeScriptCommonType(providers, context, allowResolve);
        }
        JSAnyType commonType = null;
        for (TypeProvider provider : providers) {
            JSType exprType = provider.getType();
            if (!((commonType = commonType != null && exprType != null ? JSTypeUtils.getCommonType(commonType, exprType, holder, allowResolve) : exprType) instanceof JSAnyType)) continue;
            break;
        }
        if (commonType == null) {
            commonType = JSAnyType.get(context, false);
        }
        return commonType;
    }

    public static JSType getTypeScriptCommonType(@NotNull Collection<TypeProvider> providers, @Nullable PsiElement context, boolean allowResolve) {
        if (providers == null) {
            JSTypeUtils.$$$reportNull$$$0(89);
        }
        List<Object> types = ContainerUtil.newArrayListWithCapacity((int)providers.size());
        boolean hasStringType = false;
        for (TypeProvider provider : providers) {
            JSType type = provider.getType();
            if (type instanceof JSAnyType) {
                return type;
            }
            types.add(type);
            if (!(type instanceof JSStringType) || type instanceof JSStringLiteralTypeImpl) continue;
            hasStringType = true;
        }
        if (hasStringType) {
            types = types.stream().filter(el -> !(el instanceof JSStringLiteralTypeImpl)).collect(Collectors.toList());
        }
        JSTypeSource source = JSTypeSourceFactory.createTypeSource(context, true);
        return JSCompositeTypeImpl.getCommonType((Collection<JSType>)types, source, allowResolve);
    }

    private static boolean isAssignableType(@Nullable JSType thisType, @Nullable JSType elementType, ProcessingContext processingContext) {
        return thisType == null || thisType.isDirectlyAssignableType(elementType, processingContext);
    }

    public static List<JSParameterTypeDecorator> getParameterTypeDecorators(List<JSType> parameters) {
        ArrayList<JSParameterTypeDecorator> decorators = new ArrayList<JSParameterTypeDecorator>(parameters.size());
        for (JSType parameter : parameters) {
            decorators.add(new JSParameterTypeDecoratorImpl(parameter, false, false, true));
        }
        return decorators;
    }

    @NotNull
    public static JSContext combineJSContexts(@NotNull JSContext f, @NotNull JSContext g) {
        if (f == null) {
            JSTypeUtils.$$$reportNull$$$0(90);
        }
        if (g == null) {
            JSTypeUtils.$$$reportNull$$$0(91);
        }
        if (f == JSContext.STATIC && g == JSContext.STATIC) {
            JSContext jSContext = JSContext.STATIC;
            if (jSContext == null) {
                JSTypeUtils.$$$reportNull$$$0(92);
            }
            return jSContext;
        }
        if (f == JSContext.INSTANCE || g == JSContext.INSTANCE) {
            JSContext jSContext = JSContext.INSTANCE;
            if (jSContext == null) {
                JSTypeUtils.$$$reportNull$$$0(93);
            }
            return jSContext;
        }
        JSContext jSContext = JSContext.UNKNOWN;
        if (jSContext == null) {
            JSTypeUtils.$$$reportNull$$$0(94);
        }
        return jSContext;
    }

    public static Object getTypeInvalidationDependency() {
        return PsiModificationTracker.MODIFICATION_COUNT;
    }

    @Nullable
    public static JSRecordType buildRecordTypeFromProperties(@NotNull Map<JSQualifiedName, String> properties, @NotNull Set<JSQualifiedName> optional, @NotNull JSTypeSource typeSource) {
        if (properties == null) {
            JSTypeUtils.$$$reportNull$$$0(95);
        }
        if (optional == null) {
            JSTypeUtils.$$$reportNull$$$0(96);
        }
        if (typeSource == null) {
            JSTypeUtils.$$$reportNull$$$0(97);
        }
        ArrayList<Pair<JSQualifiedName, String>> list = new ArrayList<Pair<JSQualifiedName, String>>(properties.size());
        for (Map.Entry<JSQualifiedName, String> entry : properties.entrySet()) {
            list.add((Pair<JSQualifiedName, String>)Pair.create((Object)entry.getKey(), (Object)entry.getValue()));
        }
        return JSTypeUtils.buildRecordTypeFromQualifiedNames(list, optional, typeSource);
    }

    @Nullable
    public static JSRecordType buildRecordTypeFromQualifiedNames(@NotNull Collection<Pair<JSQualifiedName, String>> qualifiedNames, @NotNull Set<JSQualifiedName> optional, @NotNull JSTypeSource typeSource) {
        if (qualifiedNames == null) {
            JSTypeUtils.$$$reportNull$$$0(98);
        }
        if (optional == null) {
            JSTypeUtils.$$$reportNull$$$0(99);
        }
        if (typeSource == null) {
            JSTypeUtils.$$$reportNull$$$0(100);
        }
        RecordTypeNode root = new RecordTypeNode();
        for (Pair<JSQualifiedName, String> property : qualifiedNames) {
            List components = ((JSQualifiedName)property.getFirst()).toComponents();
            RecordTypeNode currentPath = root;
            for (int i = 0; i < components.size(); ++i) {
                String component = (String)components.get(i);
                RecordTypeNode child = currentPath.myChildren.get(component);
                if (child == null) {
                    child = new RecordTypeNode();
                    child.myOptional = optional.contains(property.getFirst());
                    currentPath.myChildren.put(component, child);
                }
                currentPath = child;
                if (i != components.size() - 1) continue;
                String typeString = (String)property.getSecond();
                currentPath.myType = JSTypeUtils.createTypeFromJSDoc(typeString, typeSource);
            }
        }
        return (JSRecordType)JSTypeUtils.buildTypeFromRecordTypeNode(root, typeSource);
    }

    @Nullable
    private static JSType buildTypeFromRecordTypeNode(@NotNull RecordTypeNode node, @NotNull JSTypeSource typeSource) {
        if (node == null) {
            JSTypeUtils.$$$reportNull$$$0(101);
        }
        if (typeSource == null) {
            JSTypeUtils.$$$reportNull$$$0(102);
        }
        if (node.myChildren.isEmpty()) {
            return node.myType;
        }
        ArrayList<JSRecordType.TypeMember> typeMembers = new ArrayList<JSRecordType.TypeMember>(node.myChildren.size());
        for (Map.Entry<String, RecordTypeNode> entry : node.myChildren.entrySet()) {
            JSType type = JSTypeUtils.buildTypeFromRecordTypeNode(entry.getValue(), typeSource);
            typeMembers.add((JSRecordType.TypeMember)new JSRecordTypeImpl.PropertySignatureImpl(entry.getKey(), type, entry.getValue().myOptional));
        }
        return new JSRecordTypeImpl(typeSource, typeMembers);
    }

    @NotNull
    public static Collection<JSImplicitElement> getImplicitMembersFromRecordType(@NotNull JSRecordType type, @Nullable JSQualifiedName namespace, @Nullable PsiElement parent) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(103);
        }
        SmartList elements = new SmartList();
        for (JSRecordType.TypeMember member : type.getTypeMembers()) {
            if (!(member instanceof JSRecordType.PropertySignature)) continue;
            String name = ((JSRecordType.PropertySignature)member).getMemberName();
            JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder(name, parent).setNamespace(namespace).setProperties(JSImplicitElement.Property.MinorImportance).setType(JSImplicitElement.Type.Property).setNamespaceExplicitlyDeclared(namespace != null);
            JSType jsType = ((JSRecordType.PropertySignature)member).getType();
            if (jsType instanceof JSRecordType) {
                Collection<JSImplicitElement> childElements = JSTypeUtils.getImplicitMembersFromRecordType((JSRecordType)jsType, JSQualifiedNameImpl.create(name, namespace), parent);
                elements.addAll(childElements);
            }
            if (jsType != null) {
                builder.setTypeString(jsType.getTypeText(JSType.TypeTextFormat.SERIALIZED));
            }
            JSImplicitElementImpl element = new JSImplicitElementImpl(builder);
            elements.add((Object)element);
        }
        SmartList smartList = elements;
        if (smartList == null) {
            JSTypeUtils.$$$reportNull$$$0(104);
        }
        return smartList;
    }

    @Contract(value="!null,_ -> !null")
    public static JSType transformTypeHierarchySafe(@Nullable JSType type, @NotNull Function<JSType, JSType> transformation) {
        if (transformation == null) {
            JSTypeUtils.$$$reportNull$$$0(105);
        }
        if (type == null) {
            return null;
        }
        return type.transformTypeHierarchy(transformation);
    }

    @NotNull
    public static List<JSType> getArgumentTypes(@Nullable JSArgumentList argumentList) {
        if (argumentList == null) {
            List<JSType> list = Collections.emptyList();
            if (list == null) {
                JSTypeUtils.$$$reportNull$$$0(106);
            }
            return list;
        }
        JSExpression[] arguments = argumentList.getArguments();
        ArrayList<JSType> argumentTypes = new ArrayList<JSType>(arguments.length);
        for (JSExpression argument : arguments) {
            argumentTypes.add(JSResolveUtil.getExpressionJSType(argument));
        }
        ArrayList<JSType> arrayList = argumentTypes;
        if (arrayList == null) {
            JSTypeUtils.$$$reportNull$$$0(107);
        }
        return arrayList;
    }

    public static boolean isNeedWrapTypeForSerialization(@Nullable JSType type) {
        return type instanceof JSUnionOrIntersectionType || type instanceof JSFunctionTypeImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 19: 
            case 20: 
            case 25: 
            case 26: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 76: 
            case 77: 
            case 87: 
            case 92: 
            case 93: 
            case 94: 
            case 104: 
            case 106: 
            case 107: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 19: 
            case 20: 
            case 25: 
            case 26: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 76: 
            case 77: 
            case 87: 
            case 92: 
            case 93: 
            case 94: 
            case 104: 
            case 106: 
            case 107: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 50: 
            case 53: 
            case 62: 
            case 81: 
            case 83: 
            case 86: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsType";
                break;
            }
            case 11: 
            case 19: 
            case 20: 
            case 25: 
            case 26: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 76: 
            case 77: 
            case 87: 
            case 92: 
            case 93: 
            case 94: 
            case 104: 
            case 106: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/JSTypeUtils";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericType";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseType";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lOpType";
                break;
            }
            case 29: 
            case 32: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_type";
                break;
            }
            case 54: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 55: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionType";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applyCallElement";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applyInstanceContextElement";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startFunction";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qname1";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qname2";
                break;
            }
            case 67: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArguments";
                break;
            }
            case 70: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericParameters";
                break;
            }
            case 71: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeClasses";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newOption";
                break;
            }
            case 78: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 79: 
            case 80: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type1";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type2";
                break;
            }
            case 88: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 96: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optional";
                break;
            }
            case 97: 
            case 100: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedNames";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/JSTypeUtils";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapInPromiseType";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeMatchingNamespace";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonValueType";
                break;
            }
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionType";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeScriptInterfaceInJavaScriptContext";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "addPossibleOption";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceImplicitTypesWithAny";
                break;
            }
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "combineJSContexts";
                break;
            }
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitMembersFromRecordType";
                break;
            }
            case 106: 
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getScopeInOriginalTree";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parseSerializedType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createTypeFromJSDoc";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createParameterType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isIterableCollectionType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isIndexableType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isMapType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "wrapInPromiseType";
                break;
            }
            case 11: 
            case 19: 
            case 20: 
            case 25: 
            case 26: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 76: 
            case 77: 
            case 87: 
            case 92: 
            case 93: 
            case 94: 
            case 104: 
            case 106: 
            case 107: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPromiseComponentTypeOrNull";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getIndexableComponentType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getIndexableTypeFromGenericType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isSingleGenericComponentType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getIterableComponentType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "typeCanBeAssignedWithoutCoercion";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTypeMatchingNamespace";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNameMatchingType";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceMatchingType";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getNamedType";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getNonValueType";
                break;
            }
            case 27: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "hasFunctionType";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "hasConstructorType";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionType";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getTypeScriptInterfaceInJavaScriptContext";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "hasAnyType";
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "tryGetReturnType";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "hasTypeArguments";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "checkTypeForVisited";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "areArgumentsAssignable";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "haveAncestorChildRelation";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "applyCompositeMappingNoRecurse";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "concatGenericsToJSGenericTypeIfNestedLocal";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "applyGenericArguments";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "addGenericParameters";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "applyCompositeMapping";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "hasTypes";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSourceRecursive";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "addPossibleOption";
                break;
            }
            case 78: 
            case 79: 
            case 80: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "processExpandedType";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateProcessingSet";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "isUnionTypeWithLiteralCandidate";
                break;
            }
            case 84: 
            case 85: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getCommonType";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "replaceImplicitTypesWithAny";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "getTypeScriptCommonType";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "combineJSContexts";
                break;
            }
            case 95: 
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "buildRecordTypeFromProperties";
                break;
            }
            case 98: 
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "buildRecordTypeFromQualifiedNames";
                break;
            }
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeFromRecordTypeNode";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitMembersFromRecordType";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "transformTypeHierarchySafe";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processExpandedType$10";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addGenericParameters$9";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "lambda$applyCompositeMappingNoRecurse$8";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 19: 
            case 20: 
            case 25: 
            case 26: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 76: 
            case 77: 
            case 87: 
            case 92: 
            case 93: 
            case 94: 
            case 104: 
            case 106: 
            case 107: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RecordTypeNode {
        Map<String, RecordTypeNode> myChildren = new LinkedHashMap<String, RecordTypeNode>();
        boolean myOptional;
        JSType myType;

        private RecordTypeNode() {
        }
    }

    public static interface TypeProvider {
        @Nullable
        public JSType getType();
    }
}

