/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSDestructuringElementImpl;
import com.intellij.lang.javascript.psi.impl.JSDestructuringPropertyBase;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSReferenceExpressionResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.WalkUpResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyContextElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyIndexedAccessElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyPropertyElement;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDestructuringPropertyReference
extends PsiPolyVariantReferenceBase<JSDestructuringProperty> {
    public JSDestructuringPropertyReference(@NotNull JSDestructuringProperty property) {
        if (property == null) {
            JSDestructuringPropertyReference.$$$reportNull$$$0(0);
        }
        super((PsiElement)property, true);
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = JSResolveUtil.resolve(((JSDestructuringProperty)this.getElement()).getContainingFile(), this, (reference, incompleteCode1) -> {
            JSType annotationType;
            JSDestructuringProperty destructuringProperty = (JSDestructuringProperty)this.getElement();
            JSInitializerOwner element = destructuringProperty.getDestructuringElement();
            if (!(element instanceof JSVariable)) {
                return ResolveResult.EMPTY_ARRAY;
            }
            JSEvaluateContext context = new JSEvaluateContext(element.getContainingFile());
            JSInitializerOwner parent = JSDestructuringUtil.findDestructuringParent((JSElement)destructuringProperty, context, (Condition<JSInitializerOwner>)((Condition)e -> e instanceof JSDestructuringElement && !(e.getParent() instanceof JSDestructuringContainer)));
            ArrayList results = ContainerUtil.newArrayList();
            JSExpression initializer = parent == null ? null : parent.getInitializer();
            JSTypeEvaluationResult expType = initializer == null ? null : JSTypeEvaluator.getExpressionType(initializer);
            JSType initializerType = expType == null ? null : expType.getType();
            JSType jSType = annotationType = JSDestructuringPropertyReference.hasTypeAnnotation(parent) ? ((JSDestructuringElement)parent).getType() : null;
            while (!(initializerType == null && annotationType == null || context.isJSElementsToApplyEmpty())) {
                JSApplyContextElement elt = context.popJSElementToApply();
                if (elt instanceof JSApplyIndexedAccessElement) {
                    initializerType = initializerType == null ? null : JSTypeUtils.getIndexableComponentType(initializerType);
                    annotationType = annotationType == null ? null : JSTypeUtils.getIndexableComponentType(annotationType);
                    continue;
                }
                if (!(elt instanceof JSApplyPropertyElement)) break;
                Ref shouldStop = Ref.create((Object)false);
                initializerType = JSDestructuringPropertyReference.addResultsFromDestructuringProperty(context, results, initializerType, (JSApplyPropertyElement)elt, (Ref<Boolean>)shouldStop);
                annotationType = JSDestructuringPropertyReference.addResultsFromDestructuringProperty(context, results, annotationType, (JSApplyPropertyElement)elt, (Ref<Boolean>)shouldStop);
                if (!((Boolean)shouldStop.get()).booleanValue()) continue;
                break;
            }
            if (!results.isEmpty()) {
                return (ResolveResult[])results.stream().map(r -> new JSResolveResult((PsiElement)r)).toArray(ResolveResult[]::new);
            }
            WalkUpResolveProcessor processor = new WalkUpResolveProcessor(this.getCanonicalText(), destructuringProperty.getContainingFile(), (PsiElement)destructuringProperty);
            processor.setAddOnlyCompleteMatches(true);
            JSReferenceExpressionResolver.processAllSymbols(processor);
            return processor.getResults();
        }, incompleteCode);
        if (resolveResultArray == null) {
            JSDestructuringPropertyReference.$$$reportNull$$$0(1);
        }
        return resolveResultArray;
    }

    private static boolean hasTypeAnnotation(JSInitializerOwner parent) {
        return parent instanceof JSTypeDeclarationOwner && ((JSTypeDeclarationOwner)parent).getTypeElement() != null || parent instanceof JSDestructuringElementImpl && ((JSDestructuringElementImpl)parent).getTypeElement() != null;
    }

    @Nullable
    private static JSType addResultsFromDestructuringProperty(@NotNull JSEvaluateContext context, @NotNull ArrayList<PsiElement> results, @Nullable JSType initializerType, @NotNull JSApplyPropertyElement elt, @NotNull Ref<Boolean> stop) {
        if (context == null) {
            JSDestructuringPropertyReference.$$$reportNull$$$0(2);
        }
        if (results == null) {
            JSDestructuringPropertyReference.$$$reportNull$$$0(3);
        }
        if (elt == null) {
            JSDestructuringPropertyReference.$$$reportNull$$$0(4);
        }
        if (stop == null) {
            JSDestructuringPropertyReference.$$$reportNull$$$0(5);
        }
        if (initializerType != null) {
            String name;
            JSRecordType recordType = initializerType.asRecordType();
            JSRecordType.PropertySignature prop = recordType.findPropertySignature(name = elt.getName());
            if (prop == null) {
                initializerType = null;
            } else {
                if (context.isJSElementsToApplyEmpty()) {
                    results.addAll(prop.getMemberSource().getAllSourceElements());
                    stop.set((Object)true);
                }
                initializerType = prop.getType();
            }
        }
        return initializerType;
    }

    protected TextRange calculateDefaultRangeInElement() {
        JSDestructuringProperty element = (JSDestructuringProperty)this.getElement();
        if (element instanceof JSDestructuringPropertyBase) {
            PsiElement identifier = ((JSDestructuringPropertyBase)element).getNameIdentifierForPropertyOrNestedElement();
            if (identifier == null) {
                return ((JSDestructuringProperty)this.getElement()).getTextRange();
            }
            int startOffsetInParent = identifier.getStartOffsetInParent();
            return new TextRange(startOffsetInParent, startOffsetInParent + identifier.getTextLength());
        }
        return new TextRange(0, element.getTextLength());
    }

    @NotNull
    public String getCanonicalText() {
        String string = StringUtil.notNullize((String)((JSDestructuringProperty)this.myElement).getName());
        if (string == null) {
            JSDestructuringPropertyReference.$$$reportNull$$$0(6);
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        JSDestructuringProperty element = (JSDestructuringProperty)this.getElement();
        element.setName(newElementName);
        return element;
    }

    public boolean isReferenceTo(PsiElement element) {
        return super.isReferenceTo(element);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSDestructuringPropertyReference.$$$reportNull$$$0(7);
        }
        return null;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            JSDestructuringPropertyReference.$$$reportNull$$$0(8);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 1: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSDestructuringPropertyReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elt";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stop";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSDestructuringPropertyReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: 
            case 8: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addResultsFromDestructuringProperty";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

