/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.documentation.JSDocumentationProcessor;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSNamespaceEvaluationResult;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionProperty;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSContextResolver {
    private JSElement qualifyingExpression;
    private JSNamedElement parentContainer;
    private JSNamespaceEvaluationResult forcedContextType;
    @Nullable
    private JSContext typeContext;
    private boolean isDeclaration = true;

    private JSContextResolver() {
    }

    @Nullable
    public static JSNamespaceEvaluationResult resolveContext(@NotNull PsiElement element) {
        if (element == null) {
            JSContextResolver.$$$reportNull$$$0(0);
        }
        JSContextResolver resolver = new JSContextResolver();
        resolver._resolveContext(element);
        return resolver.getQualifierAsNamespace(element);
    }

    private void _resolveContext(PsiElement context) {
        JSNamespaceEvaluationResult ns;
        PsiFile parentContainerParent;
        this.parentContainer = (JSNamedElement)PsiTreeUtil.getParentOfType((PsiElement)context, (Class[])new Class[]{JSFunction.class, JSClass.class});
        if (this.parentContainer instanceof JSFunctionExpression || this.parentContainer instanceof JSFunctionProperty) {
            boolean changedFunctionScope = false;
            while (this.parentContainer instanceof JSFunctionExpression || this.parentContainer instanceof JSFunctionProperty) {
                JSNamedElement parentContainerParent2 = this.parentContainer instanceof JSFunctionExpression ? this.parentContainer.getParent() : this.parentContainer;
                this.updateContextTypeFromComment((PsiElement)this.parentContainer);
                this.updateContextTypeFromComment((PsiElement)parentContainerParent2);
                if (JSPsiImplUtils.isArrowFunction((JSFunction)this.parentContainer)) {
                    this.parentContainer = (JSNamedElement)PsiTreeUtil.getParentOfType((PsiElement)this.parentContainer, JSFunction.class);
                    continue;
                }
                if (parentContainerParent2 instanceof JSAssignmentExpression) {
                    this.updateJSContext(JSContext.UNKNOWN);
                    JSExpression jsExpression = ((JSAssignmentExpression)parentContainerParent2).getLOperand();
                    JSExpression functionExpressionName = jsExpression instanceof JSDefinitionExpression ? ((JSDefinitionExpression)jsExpression).getExpression() : null;
                    this.qualifyingExpression = functionExpressionName;
                    if (functionExpressionName instanceof JSReferenceExpression) {
                        JSExpression functionExpressionNameQualifier = ((JSReferenceExpression)functionExpressionName).getQualifier();
                        if (functionExpressionNameQualifier instanceof JSThisExpression) {
                            this.parentContainer = (JSNamedElement)PsiTreeUtil.getParentOfType((PsiElement)functionExpressionName, JSFunction.class);
                            this.qualifyingExpression = null;
                            changedFunctionScope = true;
                            this.isDeclaration = false;
                            continue;
                        }
                        if (functionExpressionNameQualifier instanceof JSReferenceExpression) {
                            String referencedName;
                            String functionExpressionNameQualifierText = ((JSReferenceExpression)functionExpressionNameQualifier).getReferenceName();
                            if ("prototype".equals(functionExpressionNameQualifierText)) {
                                this.qualifyingExpression = ((JSReferenceExpression)functionExpressionNameQualifier).getQualifier();
                                this.updateJSContext(JSContext.INSTANCE);
                            } else if (!(changedFunctionScope || (referencedName = ((JSReferenceExpression)functionExpressionName).getReferencedName()) != null && referencedName.length() != 0 && Character.isUpperCase(referencedName.charAt(0)))) {
                                this.qualifyingExpression = functionExpressionNameQualifier;
                            }
                        }
                    }
                } else if (parentContainerParent2 instanceof JSProperty) {
                    this.parentContainer = (JSProperty)parentContainerParent2;
                    this.proceedFromProperty((JSProperty)parentContainerParent2);
                } else if (parentContainerParent2 instanceof JSNewExpression) {
                    JSExpression operand;
                    this.updateJSContext(JSContext.STATIC);
                    JSElement element = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)parentContainerParent2, (Class[])new Class[]{JSVariable.class, JSAssignmentExpression.class, JSArgumentList.class});
                    if (element instanceof JSVariable) {
                        this.qualifyingExpression = element;
                    } else if (element instanceof JSAssignmentExpression && (operand = ((JSAssignmentExpression)element).getLOperand()) instanceof JSDefinitionExpression) {
                        this.qualifyingExpression = ((JSDefinitionExpression)operand).getExpression();
                    }
                } else if (parentContainerParent2 instanceof JSReferenceExpression) {
                    if (!this.processRefExpr((JSReferenceExpression)parentContainerParent2)) {
                        this.parentContainer = (JSNamedElement)PsiTreeUtil.getParentOfType((PsiElement)parentContainerParent2, JSFunction.class);
                        continue;
                    }
                } else if (parentContainerParent2 instanceof JSParenthesizedExpression) {
                    PsiElement parentContainerGrandParent = JSPsiImplUtils.getNonParenthesizeParent((PsiElement)parentContainerParent2);
                    if (parentContainerGrandParent instanceof JSReferenceExpression) {
                        this.processRefExpr((JSReferenceExpression)parentContainerGrandParent);
                    }
                } else if (parentContainerParent2 instanceof JSVariable) {
                    JSNamespaceEvaluationResult ns2 = JSSymbolUtil.checkAnonymousCallForClassExtension(((JSVariable)parentContainerParent2).getName(), (JSElement)((JSVariable)parentContainerParent2));
                    if (ns2 != null) {
                        this.forcedContextType = ns2.withJSContext(JSContext.INSTANCE);
                    }
                } else if (parentContainerParent2 instanceof ES6ExportDefaultAssignment && this.parentContainer.getName() == null) {
                    JSQualifiedNameImpl qName = JSQualifiedNameImpl.create("\"default\"", null);
                    this.forcedContextType = new JSNamespaceEvaluationResult((JSQualifiedName)qName, JSContext.UNKNOWN, true, true, (JSElement)parentContainerParent2);
                }
                break;
            }
        } else if (this.parentContainer == null) {
            JSVariable[] vars;
            JSProperty property = (JSProperty)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{JSProperty.class});
            if (property != null) {
                this.proceedFromProperty(property);
            } else if (context instanceof JSVarStatement && (vars = ((JSVarStatement)context).getVariables()).length != 0) {
                this.proceedFromProperty((PsiElement)vars[0]);
            }
        }
        if (this.qualifyingExpression instanceof JSExpression) {
            if (this.qualifyingExpression instanceof JSReferenceExpression && "prototype".equals(((JSReferenceExpression)this.qualifyingExpression).getReferenceName())) {
                this.qualifyingExpression = ((JSReferenceExpression)this.qualifyingExpression).getQualifier();
                this.updateJSContext(JSContext.INSTANCE);
            } else {
                JSNamespaceEvaluationResult ns3;
                JSNamespaceEvaluationResult jSNamespaceEvaluationResult = ns3 = this.qualifyingExpression instanceof JSReferenceExpression ? JSSymbolUtil.evaluateNamespaceLocally((JSReferenceExpression)this.qualifyingExpression) : JSSymbolUtil.evaluateNamespaceLocally((JSExpression)this.qualifyingExpression);
                if (ns3 != null) {
                    if (this.typeContext != null) {
                        ns3 = ns3.withJSContext(JSTypeUtils.combineJSContexts(ns3.getJSContext(), this.typeContext));
                    }
                    this.forcedContextType = ns3.withExplicitlyDeclared(false);
                }
            }
        }
        Object object = parentContainerParent = this.parentContainer != null ? this.parentContainer.getParent() : context.getContainingFile();
        if (parentContainerParent instanceof JSFile) {
            PsiElement fileContext = parentContainerParent.getContext();
            if (this.parentContainer == null || fileContext == null || !JavaScriptSupportLoader.isBindowsFile(fileContext)) {
                parentContainerParent = JSResolveUtil.getClassReferenceForXmlFromContext((PsiElement)parentContainerParent);
            }
        }
        if (parentContainerParent instanceof JSClass) {
            if (this.parentContainer instanceof JSElementBase) {
                this.typeContext = ((JSElementBase)this.parentContainer).getJSContext();
            }
            this.parentContainer = (JSNamedElement)parentContainerParent;
        }
        if (this.parentContainer instanceof JSFunction && (ns = JSSymbolUtil.checkAnonymousCallForClassExtension(this.parentContainer.getName(), (JSElement)this.parentContainer)) != null) {
            this.forcedContextType = ns.withJSContext(JSContext.INSTANCE);
        }
        this.updateContextTypeFromComment(context);
        this.updateContextTypeFromComment((PsiElement)this.parentContainer);
        this.updateContextTypeFromComment((PsiElement)this.qualifyingExpression);
    }

    @NotNull
    private JSContext getJSContext() {
        JSContext jSContext = this.typeContext != null ? this.typeContext : JSContext.INSTANCE;
        if (jSContext == null) {
            JSContextResolver.$$$reportNull$$$0(1);
        }
        return jSContext;
    }

    private void updateJSContext(@NotNull JSContext jsContext) {
        if (jsContext == null) {
            JSContextResolver.$$$reportNull$$$0(2);
        }
        this.typeContext = this.typeContext != null ? JSTypeUtils.combineJSContexts(jsContext, this.typeContext) : jsContext;
    }

    private void updateContextTypeFromComment(@Nullable PsiElement container) {
        JSType contextType;
        if (this.forcedContextType == null && (contextType = JSDocumentationUtils.findContextType(container)) != null) {
            this.forcedContextType = JSNamespaceEvaluationResult.fromType(contextType);
        }
    }

    private boolean processRefExpr(JSReferenceExpression parentContainerGrandParent) {
        JSExpression[] args;
        JSArgumentList argumentList;
        PsiElement parentContainerGrandSecondParent = parentContainerGrandParent.getParent();
        String referencedName = null;
        if (parentContainerGrandSecondParent instanceof JSCallExpression && "apply".equals(referencedName = parentContainerGrandParent.getReferencedName())) {
            JSExpression[] args2;
            JSArgumentList argumentList2 = ((JSCallExpression)parentContainerGrandSecondParent).getArgumentList();
            if (argumentList2 != null && (args2 = argumentList2.getArguments()).length == 1 && args2[0] instanceof JSReferenceExpression) {
                this.qualifyingExpression = args2[0];
                this.updateJSContext(JSContext.STATIC);
                return true;
            }
        } else if ("bind".equals(referencedName) && (argumentList = ((JSCallExpression)parentContainerGrandSecondParent).getArgumentList()) != null && (args = argumentList.getArguments()).length == 1 && args[0] instanceof JSThisExpression) {
            this._resolveContext((PsiElement)args[0]);
            return true;
        }
        return false;
    }

    private void proceedFromProperty(@NotNull JSProperty property) {
        JSExpression methodExpression;
        PsiElement callExpression;
        PsiElement argumentList;
        PsiElement parent;
        if (property == null) {
            JSContextResolver.$$$reportNull$$$0(3);
        }
        if ((parent = property.getParent()) == null) {
            return;
        }
        String name = property.getName();
        if (("get".equals(name) || "set".equals(name)) && (argumentList = parent.getParent()) instanceof JSArgumentList && (callExpression = argumentList.getParent()) instanceof JSCallExpression && (methodExpression = ((JSCallExpression)callExpression).getMethodExpression()) instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)methodExpression, "Object", "defineProperty")) {
            this.qualifyingExpression = ((JSArgumentList)argumentList).getArguments()[0];
            return;
        }
        this.proceedFromProperty(parent);
    }

    private void proceedFromProperty(PsiElement parentContainerParent) {
        JSNamespaceEvaluationResult namespace;
        JSExpression loperand;
        JSElement element;
        if (parentContainerParent instanceof JSObjectLiteralExpression) {
            for (FrameworkIndexingHandler handler : (FrameworkIndexingHandler[])Extensions.getExtensions(FrameworkIndexingHandler.EP_NAME)) {
                String context = handler.resolveContextFromProperty((JSObjectLiteralExpression)parentContainerParent, false);
                if (context == null) continue;
                this.forcedContextType = new JSNamespaceEvaluationResult((JSQualifiedName)JSQualifiedNameImpl.fromQualifiedName(context), JSContext.UNKNOWN, true, true, (JSElement)parentContainerParent);
                return;
            }
        }
        if ((element = (JSElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)parentContainerParent, (Class[])new Class[]{JSVariable.class, JSAssignmentExpression.class, JSArgumentList.class})) instanceof JSVariable) {
            this.qualifyingExpression = element;
            this.updateJSContext(JSContext.STATIC);
        } else if (element instanceof JSAssignmentExpression && (loperand = ((JSAssignmentExpression)element).getLOperand()) != null) {
            this.qualifyingExpression = ((JSDefinitionExpression)loperand).getExpression();
            this.updateJSContext(JSContext.STATIC);
        }
        if (this.qualifyingExpression == null && parentContainerParent instanceof JSObjectLiteralExpression && (namespace = JSSymbolUtil.findNamespace((JSExpression)parentContainerParent)) != null) {
            this.qualifyingExpression = namespace.getSource();
            this.forcedContextType = namespace.withExplicitlyDeclared(false);
        }
    }

    @Nullable
    private JSNamespaceEvaluationResult getQualifierAsNamespace(PsiElement scope) {
        if (this.forcedContextType != null) {
            return this.forcedContextType;
        }
        String typeString = this.getQualifierAsString();
        if (typeString == null) {
            return null;
        }
        JSQualifiedNameImpl qName = JSQualifiedNameImpl.fromQualifiedName(typeString);
        JSDocumentationProcessor.MetaDocType[] classMarkers = new JSDocumentationProcessor.MetaDocType[]{JSDocumentationProcessor.MetaDocType.CONSTRUCTOR, JSDocumentationProcessor.MetaDocType.CLASS, JSDocumentationProcessor.MetaDocType.MEMBER_OF, JSDocumentationProcessor.MetaDocType.NAME, JSDocumentationProcessor.MetaDocType.THIS, JSDocumentationProcessor.MetaDocType.ALIAS};
        boolean explicitlyDeclared = JSDocumentationUtils.hasJSDocTag((PsiElement)this.parentContainer, classMarkers) || this.parentContainer instanceof JSClass && !(this.parentContainer instanceof XmlBackedJSClass) && ((JSClass)this.parentContainer).getExtendsList() == null;
        PsiElement sourceElement = this.qualifyingExpression != null ? this.qualifyingExpression : scope;
        JSContext jsContext = this.getJSContext();
        JSReferenceExpression source = sourceElement instanceof JSReferenceExpression ? (JSReferenceExpression)sourceElement : (this.qualifyingExpression instanceof JSReferenceExpression ? (JSReferenceExpression)this.qualifyingExpression : null);
        return new JSNamespaceEvaluationResult((JSQualifiedName)qName, jsContext, explicitlyDeclared, this.isDeclaration, (JSElement)source);
    }

    @Nullable
    private String getQualifierAsString() {
        String name;
        if (this.parentContainer instanceof JSFunction && DialectDetector.isActionScript((PsiElement)this.parentContainer)) {
            return "*";
        }
        if (this.qualifyingExpression instanceof JSLiteralExpression) {
            return JSStringUtil.unquoteAndUnescapeString(this.qualifyingExpression.getText());
        }
        if (this.qualifyingExpression instanceof JSReferenceExpression) {
            JSNamespaceEvaluationResult ns = JSSymbolUtil.replaceLocalVars((JSReferenceExpression)this.qualifyingExpression);
            if (ns != null && ns.getQualifiedName() != null) {
                return ns.getQualifiedName().getQualifiedName();
            }
            JSQualifiedName name2 = JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)this.qualifyingExpression);
            return name2 != null ? name2.getQualifiedName() : null;
        }
        if (this.qualifyingExpression instanceof JSNamedElement) {
            return this.qualifyingExpression.getName();
        }
        if (this.parentContainer instanceof JSQualifiedNamedElement && (name = ((JSQualifiedNamedElement)this.parentContainer).getQualifiedName()) != null) {
            return name;
        }
        return null;
    }

    @Nullable
    public static String getQualifierOfExprAsString(@NotNull JSElement expr) {
        JSExpression method;
        PsiElement jsExpressionParent;
        if (expr == null) {
            JSContextResolver.$$$reportNull$$$0(4);
        }
        if (expr instanceof JSNamedElement) {
            return expr.getName();
        }
        if (expr instanceof JSNewExpression && (jsExpressionParent = expr.getParent()) instanceof JSVariable && JSSymbolUtil.isAccurateReferenceExpressionName(method = ((JSNewExpression)expr).getMethodExpression(), "Class")) {
            return ((JSVariable)jsExpressionParent).getName();
        }
        if (expr instanceof JSReferenceExpression) {
            JSQualifiedName name;
            JSNamespaceEvaluationResult result = JSSymbolUtil.createNamespaceFromReferenceExpression((JSReferenceExpression)expr, JSContext.UNKNOWN, true);
            JSQualifiedName jSQualifiedName = name = result != null ? result.getQualifiedName() : null;
            if (name != null) {
                return name.getQualifiedName();
            }
        }
        if (expr instanceof JSLiteralExpression) {
            return JSStringUtil.unquoteAndUnescapeString(expr.getText());
        }
        return null;
    }

    @Nullable
    public static PsiElement findContextElement(@NotNull JSThisExpression thisExpression) {
        PsiElement parentContainerParent;
        if (thisExpression == null) {
            JSContextResolver.$$$reportNull$$$0(5);
        }
        JSThisExpression parentContainer = thisExpression;
        while ((parentContainer = PsiTreeUtil.getParentOfType((PsiElement)parentContainer, (Class[])new Class[]{JSFunction.class, JSClass.class})) instanceof JSFunction && JSPsiImplUtils.isArrowFunction((JSFunction)parentContainer)) {
        }
        if (parentContainer != null && (parentContainerParent = parentContainer.getParent()) instanceof JSClass) {
            parentContainer = parentContainerParent;
        }
        return parentContainer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSContextResolver";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSContextResolver";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveContext";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateJSContext";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "proceedFromProperty";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierOfExprAsString";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findContextElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

