/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.psi.ResolveResult;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;

public class JSTaggedResolveResult
implements Comparable<JSTaggedResolveResult> {
    @NotNull
    public final ResolveResult result;
    @NotNull
    public final EnumSet<ResolveResultTag> tags;

    JSTaggedResolveResult(@NotNull ResolveResult result, @NotNull EnumSet<ResolveResultTag> tags) {
        if (result == null) {
            JSTaggedResolveResult.$$$reportNull$$$0(0);
        }
        if (tags == null) {
            JSTaggedResolveResult.$$$reportNull$$$0(1);
        }
        this.result = result;
        this.tags = tags;
    }

    @Override
    public int compareTo(@NotNull JSTaggedResolveResult o) {
        int priorityTo;
        if (o == null) {
            JSTaggedResolveResult.$$$reportNull$$$0(2);
        }
        if ((priorityTo = this.comparePriorityTo(o)) != 0) {
            return priorityTo;
        }
        if (this.tags.contains((Object)ResolveResultTag.CURRENT_FILE) && !o.tags.contains((Object)ResolveResultTag.CURRENT_FILE)) {
            return -1;
        }
        if (!this.tags.contains((Object)ResolveResultTag.CURRENT_FILE) && o.tags.contains((Object)ResolveResultTag.CURRENT_FILE)) {
            return 1;
        }
        return 0;
    }

    int comparePriorityTo(@NotNull JSTaggedResolveResult o) {
        if (o == null) {
            JSTaggedResolveResult.$$$reportNull$$$0(3);
        }
        if (this.tags.contains((Object)ResolveResultTag.PARTIAL) && !o.tags.contains((Object)ResolveResultTag.PARTIAL)) {
            return 1;
        }
        if (!this.tags.contains((Object)ResolveResultTag.PARTIAL) && o.tags.contains((Object)ResolveResultTag.PARTIAL)) {
            return -1;
        }
        if (this.result.isValidResult() && !o.result.isValidResult()) {
            return -1;
        }
        if (!this.result.isValidResult() && o.result.isValidResult()) {
            return 1;
        }
        return JSTaggedResolveResult.comparePriorities(this.tags, o.tags);
    }

    public static int comparePriorities(@NotNull EnumSet<ResolveResultTag> tags1, @NotNull EnumSet<ResolveResultTag> tags2) {
        if (tags1 == null) {
            JSTaggedResolveResult.$$$reportNull$$$0(4);
        }
        if (tags2 == null) {
            JSTaggedResolveResult.$$$reportNull$$$0(5);
        }
        if (tags1.contains((Object)ResolveResultTag.NOT_EXPORTED) && !tags2.contains((Object)ResolveResultTag.NOT_EXPORTED)) {
            return 1;
        }
        if (!tags1.contains((Object)ResolveResultTag.NOT_EXPORTED) && tags2.contains((Object)ResolveResultTag.NOT_EXPORTED)) {
            return -1;
        }
        if (tags1.contains((Object)ResolveResultTag.NOT_IMPORTED) && !tags2.contains((Object)ResolveResultTag.NOT_IMPORTED)) {
            return 1;
        }
        if (!tags1.contains((Object)ResolveResultTag.NOT_IMPORTED) && tags2.contains((Object)ResolveResultTag.NOT_IMPORTED)) {
            return -1;
        }
        if (tags1.contains((Object)ResolveResultTag.IS_ASSIGNMENT) && !tags2.contains((Object)ResolveResultTag.IS_ASSIGNMENT)) {
            return 1;
        }
        if (!tags1.contains((Object)ResolveResultTag.IS_ASSIGNMENT) && tags2.contains((Object)ResolveResultTag.IS_ASSIGNMENT)) {
            return -1;
        }
        if (tags1.contains((Object)ResolveResultTag.HAS_JSDOC) && !tags2.contains((Object)ResolveResultTag.HAS_JSDOC)) {
            return -1;
        }
        if (!tags1.contains((Object)ResolveResultTag.HAS_JSDOC) && tags2.contains((Object)ResolveResultTag.HAS_JSDOC)) {
            return 1;
        }
        if (tags1.contains((Object)ResolveResultTag.MINOR_IMPORTANCE) && !tags2.contains((Object)ResolveResultTag.MINOR_IMPORTANCE)) {
            return 1;
        }
        if (!tags1.contains((Object)ResolveResultTag.MINOR_IMPORTANCE) && tags2.contains((Object)ResolveResultTag.MINOR_IMPORTANCE)) {
            return -1;
        }
        if (tags1.contains((Object)ResolveResultTag.RECORD_TYPE_PROPERTY) && !tags2.contains((Object)ResolveResultTag.RECORD_TYPE_PROPERTY)) {
            return 1;
        }
        if (!tags1.contains((Object)ResolveResultTag.RECORD_TYPE_PROPERTY) && tags2.contains((Object)ResolveResultTag.RECORD_TYPE_PROPERTY)) {
            return -1;
        }
        if (tags1.contains((Object)ResolveResultTag.CONTEXT_MATCHES) && !tags2.contains((Object)ResolveResultTag.CONTEXT_MATCHES)) {
            return -1;
        }
        if (!tags1.contains((Object)ResolveResultTag.CONTEXT_MATCHES) && tags2.contains((Object)ResolveResultTag.CONTEXT_MATCHES)) {
            return 1;
        }
        return 0;
    }

    public boolean hasTag(ResolveResultTag tag) {
        return this.tags.contains((Object)tag);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tags";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tags1";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tags2";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSTaggedResolveResult";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "compareTo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "comparePriorityTo";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "comparePriorities";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum ResolveResultTag {
        PARTIAL,
        NOT_EXPORTED,
        NOT_IMPORTED,
        IS_ASSIGNMENT,
        HAS_JSDOC,
        MINOR_IMPORTANCE,
        RECORD_TYPE_PROPERTY,
        CURRENT_FILE,
        CONTEXT_MATCHES;

    }
}

