/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTupleTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveArrayType;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSGenericTypeImpl
extends JSTypeBaseImpl
implements JSType.CompositeStructure {
    @NotNull
    private final JSType myType;
    @NotNull
    private final List<JSType> myArguments;
    @Nullable
    private final Map<String, JSType> myOuterArguments;

    public JSGenericTypeImpl(@NotNull JSTypeSource source, @NotNull JSType type, @Nullable Map<String, JSType> outer) {
        if (source == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(0);
        }
        if (type == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(1);
        }
        super(source);
        this.myType = type;
        this.myArguments = ContainerUtil.newArrayList();
        this.myOuterArguments = outer;
    }

    public JSGenericTypeImpl(@NotNull JSTypeSource source, @NotNull JSType type, @NotNull JSType argument) {
        if (source == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(2);
        }
        if (type == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(3);
        }
        if (argument == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(4);
        }
        super(source);
        this.myType = type;
        this.myArguments = ContainerUtil.newArrayList((Object[])new JSType[]{argument});
        this.myOuterArguments = null;
    }

    public JSGenericTypeImpl(@NotNull JSTypeSource source, @NotNull JSType type, @NotNull List<JSType> arguments, @Nullable Map<String, JSType> outer) {
        if (source == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(5);
        }
        if (type == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(6);
        }
        if (arguments == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(7);
        }
        super(source);
        this.myType = type;
        this.myArguments = ContainerUtil.newArrayList(arguments);
        this.myOuterArguments = outer;
    }

    public JSGenericTypeImpl(@NotNull JSTypeSource source, @NotNull JSType type, List<JSType> arguments) {
        if (source == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(8);
        }
        if (type == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(9);
        }
        this(source, type, arguments, null);
    }

    @Override
    public void accept(JSRecursiveTypeVisitor visitor) {
        visitor.visitJSGenericType((JSType)this);
    }

    @Override
    public void acceptChildren(JSRecursiveTypeVisitor visitor) {
        this.myType.accept(visitor);
        for (JSType argument : this.myArguments) {
            argument.accept(visitor);
        }
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        boolean isSerialization;
        StringBuilder builder = new StringBuilder();
        boolean bl = isSerialization = format == JSType.TypeTextFormat.SERIALIZED;
        if (!this.isTypeScript() || isSerialization) {
            boolean wrapInBraces = JSTypeUtils.isNeedWrapTypeForSerialization(this.myType);
            if (wrapInBraces) {
                builder.append("(");
            }
            builder.append(this.myType.getTypeText(format));
            if (wrapInBraces) {
                builder.append(")");
            }
            if (this.getSource().getLanguage() == JSTypeSource.SourceLanguage.AS) {
                builder.append('.');
            }
            this.appendArgumentTypeText(format, builder);
        } else {
            boolean isNestedFunctionType = this.myType instanceof JSFunctionTypeImpl;
            if (isNestedFunctionType) {
                this.appendArgumentTypeText(format, builder);
                builder.append(this.myType.getTypeText(format));
            } else {
                builder.append(this.myType.getTypeText(format));
                this.appendArgumentTypeText(format, builder);
            }
        }
        String string = builder.toString();
        if (string == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(10);
        }
        return string;
    }

    private void appendArgumentTypeText(@NotNull JSType.TypeTextFormat format, @NotNull StringBuilder builder) {
        if (format == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(11);
        }
        if (builder == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(12);
        }
        builder.append("<");
        String prefix = "";
        for (JSType argument : this.myArguments) {
            JSType constraint;
            builder.append(prefix);
            builder.append(argument.getTypeText(format));
            if (argument instanceof JSGenericParameterImpl && !((JSGenericParameterImpl)argument).isCallEnvironment() && format != JSType.TypeTextFormat.SERIALIZED && (constraint = ((JSGenericParameterImpl)argument).getConstraintType()) != null) {
                builder.append(" extends ");
                builder.append(constraint.getTypeText(format));
            }
            prefix = ", ";
        }
        builder.append(">");
    }

    @Override
    @Nullable
    public JSClass resolveClass() {
        return this.myType.resolveClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(13);
        }
        if (this.isTypeScript()) {
            JSTypeCastUtil.AssignableResult type;
            JSType typedef;
            if (processingContext == null) {
                processingContext = new ProcessingContext();
            }
            if (elementType instanceof JSTypeImpl && (typedef = ((JSTypeImpl)elementType).getTypedef(null, processingContext)) != null) {
                elementType = typedef;
            }
            if (elementType instanceof JSTupleTypeImpl) {
                return this.isDirectlyAssignableType(((JSTupleTypeImpl)elementType).toArrayType(true), processingContext);
            }
            if (elementType instanceof JSArrayType) {
                elementType = ((JSArrayType)elementType).asGenericType();
            } else {
                JSType resolved;
                if (elementType instanceof JSCompositeTypeImpl) {
                    String elementQName;
                    boolean isAssignable = true;
                    String thisText = this.getResolvedTypeText();
                    if (JSTypeCastUtil.startRecursiveTypesComparison(thisText, elementQName = elementType.getResolvedTypeText(), processingContext)) {
                        try {
                            for (JSType type2 : ((JSCompositeTypeImpl)elementType).getTypes()) {
                                if (this.isDirectlyAssignableType(type2, processingContext)) continue;
                                isAssignable = false;
                                break;
                            }
                        }
                        finally {
                            JSTypeCastUtil.endRecursiveTypesComparison(thisText, elementQName, processingContext);
                        }
                    }
                    return isAssignable;
                }
                if (elementType instanceof JSRecordType && this != (resolved = this.substitute())) {
                    JSType finalElementType = elementType;
                    ProcessingContext finalProcessingContext = processingContext;
                    Boolean result = (Boolean)RecursionManager.doPreventingRecursion((Object)("JSGenericTypeImpl.isDirectlyAssignableTypeImpl." + this.getResolvedTypeText()), (boolean)false, () -> resolved.isDirectlyAssignableType(finalElementType, finalProcessingContext));
                    return result == null ? true : result;
                }
            }
            if (elementType instanceof JSGenericTypeImpl && (type = this.isDirectlyAssignableGenericType((JSGenericTypeImpl)elementType, processingContext)).isStrict()) {
                return type.isAssignable();
            }
            String elementQName = JSTypeUtils.getQualifiedNameMatchingType(elementType, true);
            if (elementQName != null) {
                String thisQName = JSTypeUtils.getQualifiedNameMatchingType(this, true);
                if (thisQName != null && !JSTypeCastUtil.startRecursiveTypesComparison(thisQName, elementQName, processingContext)) {
                    return true;
                }
                JSType resolved = this.substitute();
                if (resolved != this) {
                    boolean result = resolved.isDirectlyAssignableType(elementType, processingContext);
                    if (thisQName != null) {
                        JSTypeCastUtil.endRecursiveTypesComparison(thisQName, elementQName, processingContext);
                    }
                    return result;
                }
            }
            return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
        }
        if (elementType instanceof JSGenericTypeImpl) {
            if (!this.myType.isDirectlyAssignableType(((JSGenericTypeImpl)elementType).myType, processingContext)) {
                return false;
            }
            List<JSType> elementTypeArgs = ((JSGenericTypeImpl)elementType).myArguments;
            ListIterator<JSType> iterator = elementTypeArgs.listIterator();
            boolean allArgumentsEquivalent = true;
            for (JSType argument : this.myArguments) {
                allArgumentsEquivalent &= iterator.hasNext() && JSTypeUtils.areTypesCompatible(argument, iterator.next(), processingContext, null);
            }
            return this.getSource().getLanguage() == JSTypeSource.SourceLanguage.JS || allArgumentsEquivalent && !iterator.hasNext();
        }
        if (JSGenericTypeImpl.isGenericActionScriptVectorType(this) && !(elementType instanceof JSNullType) && !(elementType instanceof JSAnyType)) {
            return false;
        }
        if (elementType instanceof JSArrayTypeImpl) {
            return this.isDirectlyAssignableType(((JSArrayTypeImpl)elementType).asGenericType(), processingContext);
        }
        if (elementType instanceof JSTypeofTypeImpl) {
            return this.isDirectlyAssignableType(elementType.substitute(), processingContext);
        }
        return this.myType.isDirectlyAssignableType(elementType, processingContext);
    }

    @Override
    @NotNull
    protected JSTypeCastUtil.AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        JSTypeCastUtil.AssignableResult result;
        if (elementType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(14);
        }
        if ((result = super.isDirectlyAssignableTypeCommon(elementType, processingContext)).isStrict()) {
            JSTypeCastUtil.AssignableResult assignableResult = result;
            if (assignableResult == null) {
                JSGenericTypeImpl.$$$reportNull$$$0(15);
            }
            return assignableResult;
        }
        JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(this.myType.isDirectlyAssignableType(elementType, processingContext));
        if (assignableResult == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(16);
        }
        return assignableResult;
    }

    @Override
    public boolean isEquivalentToImpl(@NotNull JSType type, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(17);
        }
        if (type instanceof JSGenericTypeImpl) {
            if (!this.myType.isEquivalentTo(((JSGenericTypeImpl)type).myType, processingContext, allowResolve)) {
                return false;
            }
            return JSGenericTypeImpl.areGenericArgumentsAssignable(this, (JSGenericTypeImpl)type, processingContext, true, allowResolve) == JSTypeCastUtil.AssignableResult.ASSIGNABLE;
        }
        return false;
    }

    public JSTypeCastUtil.AssignableResult isDirectlyAssignableGenericType(@NotNull JSGenericTypeImpl elementType, @NotNull ProcessingContext processingContext) {
        JSType rMainType;
        boolean isSameMainType;
        if (elementType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(18);
        }
        if (processingContext == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(19);
        }
        if (isSameMainType = this.myType.isEquivalentTo(rMainType = elementType.myType, processingContext)) {
            String elementText;
            String thisText = this.getResolvedTypeText();
            if (!JSTypeCastUtil.startRecursiveTypesComparison(thisText, elementText = elementType.getResolvedTypeText(), processingContext)) {
                return JSTypeCastUtil.AssignableResult.ASSIGNABLE;
            }
            JSTypeCastUtil.AssignableResult result = JSGenericTypeImpl.areGenericArgumentsAssignable(this, elementType, processingContext, false, true);
            if (result.isAssignable() || !result.isStrict()) {
                return JSTypeCastUtil.AssignableResult.ASSIGNABLE;
            }
            JSTypeCastUtil.endRecursiveTypesComparison(thisText, elementText, processingContext);
            if (this.myType instanceof JSPrimitiveArrayType && rMainType instanceof JSPrimitiveArrayType) {
                return JSTypeCastUtil.AssignableResult.NOT_ASSIGNABLE;
            }
        } else if (rMainType instanceof JSNamedType && this.myType instanceof JSNamedType) {
            Collection<? extends PsiElement> lOpElements = TypeScriptTypeParser.resolveElementsByType(this.myType);
            Collection<? extends PsiElement> rOpElements = TypeScriptTypeParser.resolveElementsByType(rMainType);
            for (PsiElement psiElement : lOpElements) {
                for (PsiElement psiElement2 : rOpElements) {
                    String elementText;
                    JSClass parentClass;
                    JSClass childClass;
                    if (!(psiElement instanceof JSClass) || !(psiElement2 instanceof JSClass) || !JSInheritanceUtil.isParentClass(childClass = (JSClass)psiElement, parentClass = (JSClass)psiElement2, false)) continue;
                    String thisText = this.getResolvedTypeText();
                    if (!JSTypeCastUtil.startRecursiveTypesComparison(thisText, elementText = elementType.getResolvedTypeText(), processingContext)) {
                        return JSTypeCastUtil.AssignableResult.ASSIGNABLE;
                    }
                    TypeScriptTypeParameterList list = ((TypeScriptTypeParameterListOwner)parentClass).getTypeParameterList();
                    JSTypeCastUtil.AssignableResult result = JSTypeCastUtil.AssignableResult.NOT_SURE;
                    if (list != null) {
                        JSTypeSource source = rMainType.getSource();
                        ArrayList rawGenerics = ContainerUtil.newArrayList();
                        for (TypeScriptTypeParameter parameter : list.getTypeParameters()) {
                            String name = parameter.getName();
                            if (name == null) continue;
                            rawGenerics.add(JSNamedType.createType(name, source, JSContext.INSTANCE));
                        }
                        JSGenericTypeImpl guessedType = new JSGenericTypeImpl(rMainType.getSource(), rMainType, rawGenerics);
                        JSType type = TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(childClass, elementType.getArguments(), parentClass, guessedType);
                        if (type instanceof JSGenericTypeImpl) {
                            result = JSGenericTypeImpl.areGenericArgumentsAssignable(this, (JSGenericTypeImpl)type, processingContext, false, true);
                        }
                    }
                    JSTypeCastUtil.endRecursiveTypesComparison(thisText, elementText, processingContext);
                    return result;
                }
            }
        }
        return JSTypeCastUtil.AssignableResult.NOT_SURE;
    }

    public static JSTypeCastUtil.AssignableResult areGenericArgumentsAssignable(@NotNull JSGenericTypeImpl lType, @NotNull JSGenericTypeImpl rType, @Nullable ProcessingContext processingContext, boolean checkEquivalent, boolean allowResolve) {
        if (lType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(20);
        }
        if (rType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(21);
        }
        Iterator<JSType> iterator = rType.myArguments.iterator();
        for (JSType argument : lType.myArguments) {
            boolean result;
            if (!iterator.hasNext()) {
                return JSTypeCastUtil.AssignableResult.NOT_SURE;
            }
            JSType next = iterator.next();
            if (!(checkEquivalent ? !argument.isEquivalentTo(next, processingContext, allowResolve) : !(result = argument.isDirectlyAssignableType(next, processingContext)))) continue;
            return JSTypeCastUtil.AssignableResult.NOT_ASSIGNABLE;
        }
        return iterator.hasNext() ? JSTypeCastUtil.AssignableResult.NOT_SURE : JSTypeCastUtil.AssignableResult.ASSIGNABLE;
    }

    public static boolean isGenericActionScriptVectorType(@Nullable JSType type) {
        if (type == null) {
            return false;
        }
        if (type instanceof JSGenericTypeImpl && type.getSource().isEcma()) {
            JSGenericTypeImpl genericType = (JSGenericTypeImpl)type;
            String typeText = genericType.myType.getResolvedTypeText();
            return "Vector".equals(typeText) && genericType.myArguments.size() == 1;
        }
        return false;
    }

    @NotNull
    public JSType getType() {
        JSType jSType = this.myType;
        if (jSType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(22);
        }
        return jSType;
    }

    @Deprecated
    void addGenericArgument(JSType type) {
        this.myArguments.add(type);
    }

    @NotNull
    public List<JSType> getArguments() {
        List<JSType> list = Collections.unmodifiableList(this.myArguments);
        if (list == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(23);
        }
        return list;
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform) {
        if (childTransform == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(24);
        }
        JSType oldType = this.getType();
        JSType newType = JSTypeUtils.transformTypeHierarchySafe(oldType, childTransform);
        List<JSType> oldArgs = this.getArguments();
        List newArgs = ContainerUtil.map(oldArgs, type -> {
            if (childTransform == null) {
                JSGenericTypeImpl.$$$reportNull$$$0(32);
            }
            return JSTypeUtils.transformTypeHierarchySafe(type, childTransform);
        });
        Map<String, JSType> oldOuterArgs = this.getOuterArguments();
        LinkedHashMap newOuterArgs = null;
        boolean hasNewOuters = false;
        if (oldOuterArgs != null) {
            newOuterArgs = ContainerUtil.newLinkedHashMap();
            for (Map.Entry<String, JSType> entry : oldOuterArgs.entrySet()) {
                JSType oldOuterArgType = entry.getValue();
                JSType newOuterArgType = JSTypeUtils.transformTypeHierarchySafe(oldOuterArgType, childTransform);
                if (newOuterArgType != oldOuterArgType) {
                    hasNewOuters = true;
                }
                newOuterArgs.put(entry.getKey(), newOuterArgType);
            }
        }
        if (!hasNewOuters && ContainerUtil.equalsIdentity(oldArgs, (List)newArgs) && oldType == newType) {
            JSGenericTypeImpl jSGenericTypeImpl = this;
            if (jSGenericTypeImpl == null) {
                JSGenericTypeImpl.$$$reportNull$$$0(25);
            }
            return jSGenericTypeImpl;
        }
        if (newType instanceof JSGenericTypeImpl) {
            JSGenericTypeImpl jSGenericTypeImpl = new JSGenericTypeImpl(this.getSource(), ((JSGenericTypeImpl)newType).getType(), ((JSGenericTypeImpl)newType).getArguments().stream().map(a -> {
                if (childTransform == null) {
                    JSGenericTypeImpl.$$$reportNull$$$0(31);
                }
                return a.transformTypeHierarchy(childTransform);
            }).collect(Collectors.toList()), newOuterArgs);
            if (jSGenericTypeImpl == null) {
                JSGenericTypeImpl.$$$reportNull$$$0(26);
            }
            return jSGenericTypeImpl;
        }
        JSGenericTypeImpl jSGenericTypeImpl = new JSGenericTypeImpl(this.getSource(), newType, newArgs, newOuterArgs);
        if (jSGenericTypeImpl == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(27);
        }
        return jSGenericTypeImpl;
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(28);
        }
        JSGenericTypeImpl jSGenericTypeImpl = new JSGenericTypeImpl(source, this.getType(), this.getArguments(), this.getOuterArguments());
        if (jSGenericTypeImpl == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(29);
        }
        return jSGenericTypeImpl;
    }

    @Override
    @NotNull
    public JSType substitute() {
        JSType jSType = JSTypeImpl.resolveQualifiedType(this);
        if (jSType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(30);
        }
        return jSType;
    }

    @Nullable
    public Map<String, JSType> getOuterArguments() {
        return this.myOuterArguments;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 15: 
            case 16: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 15: 
            case 16: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 10: 
            case 15: 
            case 16: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSGenericTypeImpl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 13: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lType";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rType";
                break;
            }
            case 24: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSGenericTypeImpl";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewSource";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "substitute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 15: 
            case 16: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "appendArgumentTypeText";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToImpl";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableGenericType";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "areGenericArgumentsAssignable";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$copyTypeHierarchy$2";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$copyTypeHierarchy$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 15: 
            case 16: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

