/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSimpleTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSSpecialNamedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public abstract class JSNamedType
extends JSSimpleTypeBaseImpl {
    private static final String PROTOTYPE_SUFFIX = ".prototype";
    protected static final String STATIC_SUFFIX = "^s";
    private static final String PROTOTYPE_CONSTRUCTOR_SUFFIX = ".prototype.constructor";
    public static final char QUOTE_ESCAPE_MARK = 'q';
    public static final String QUOTE_ESCAPE = '^' + Character.toString('q');
    static final String FUNCTION_TYPE_SUFFIX = "^f";
    static final String WIDENED_SUFFIX = "^w";
    private final JSTypeContext myContext;

    protected JSNamedType(JSTypeSource source, JSTypeContext jsTypeContext) {
        super(source);
        this.myContext = jsTypeContext;
    }

    public static JSType createExplicitlyDeclaredType(@NotNull String typeString, PsiElement element) {
        if (typeString == null) {
            JSNamedType.$$$reportNull$$$0(0);
        }
        return JSNamedType.createType(typeString, JSTypeSourceFactory.createTypeSource(element, true), JSContext.INSTANCE);
    }

    @NotNull
    public static JSType createType(@NotNull String typeString, @NotNull JSTypeSource source, @NotNull JSContext staticOrInstance) {
        if (typeString == null) {
            JSNamedType.$$$reportNull$$$0(1);
        }
        if (source == null) {
            JSNamedType.$$$reportNull$$$0(2);
        }
        if (staticOrInstance == null) {
            JSNamedType.$$$reportNull$$$0(3);
        }
        JSType jSType = JSNamedType.createType(typeString, source, JSTypeContext.fromJSContext(staticOrInstance));
        if (jSType == null) {
            JSNamedType.$$$reportNull$$$0(4);
        }
        return jSType;
    }

    @NotNull
    public static JSType createType(@NotNull String typeString, @NotNull JSTypeSource source, @NotNull JSTypeContext jsContext) {
        if (typeString == null) {
            JSNamedType.$$$reportNull$$$0(5);
        }
        if (source == null) {
            JSNamedType.$$$reportNull$$$0(6);
        }
        if (jsContext == null) {
            JSNamedType.$$$reportNull$$$0(7);
        }
        JSType jSType = JSNamedType.createType(typeString, source, jsContext, false);
        if (jSType == null) {
            JSNamedType.$$$reportNull$$$0(8);
        }
        return jSType;
    }

    @NotNull
    public static JSType createType(@NotNull String typeString, @NotNull JSTypeSource source, @NotNull JSTypeContext jsContext, boolean inheritsFunction) {
        if (typeString == null) {
            JSNamedType.$$$reportNull$$$0(9);
        }
        if (source == null) {
            JSNamedType.$$$reportNull$$$0(10);
        }
        if (jsContext == null) {
            JSNamedType.$$$reportNull$$$0(11);
        }
        JSType jSType = JSNamedType.createType(typeString, source, jsContext, inheritsFunction, true);
        if (jSType == null) {
            JSNamedType.$$$reportNull$$$0(12);
        }
        return jSType;
    }

    @NotNull
    public static JSType createType(@NotNull String typeString, @NotNull JSTypeSource source, @NotNull JSTypeContext jsContext, boolean inheritsFunction, boolean isFromJSDoc) {
        JSType primitiveType;
        if (typeString == null) {
            JSNamedType.$$$reportNull$$$0(13);
        }
        if (source == null) {
            JSNamedType.$$$reportNull$$$0(14);
        }
        if (jsContext == null) {
            JSNamedType.$$$reportNull$$$0(15);
        }
        if ("*".equals(typeString) || source.getLanguage() == JSTypeSource.SourceLanguage.TS && "any".equals(typeString)) {
            JSAnyType jSAnyType = JSAnyType.get((PsiElement)source.getScope(), true);
            if (jSAnyType == null) {
                JSNamedType.$$$reportNull$$$0(16);
            }
            return jSAnyType;
        }
        PsiFile scope = source.getScope();
        if (scope != null && scope != scope.getOriginalFile()) {
            source = new JSTypeSource(scope.getOriginalFile(), source.getSourceElement(), source.getLanguage(), source.isStrict(), source.isExplicitlyDeclared());
        }
        if (source.getLanguage() == JSTypeSource.SourceLanguage.AS) {
            JSType genericArgument = null;
            if ("Vector$object".equals(typeString)) {
                genericArgument = JSNamedType.createType("Object", source, JSContext.INSTANCE);
            }
            if ("Vector$int".equals(typeString)) {
                genericArgument = JSNamedType.createType("int", source, JSContext.INSTANCE);
            }
            if ("Vector$uint".equals(typeString)) {
                genericArgument = JSNamedType.createType("uint", source, JSContext.INSTANCE);
            }
            if ("Vector$double".equals(typeString)) {
                genericArgument = JSNamedType.createType("Number", source, JSContext.INSTANCE);
            }
            if (genericArgument != null) {
                JSGenericTypeImpl jSGenericTypeImpl = new JSGenericTypeImpl(source, JSNamedType.createType("Vector", source, jsContext), genericArgument);
                if (jSGenericTypeImpl == null) {
                    JSNamedType.$$$reportNull$$$0(17);
                }
                return jSGenericTypeImpl;
            }
        }
        boolean isWidened = false;
        if ((typeString = typeString.replace(QUOTE_ESCAPE, "\"")).endsWith(WIDENED_SUFFIX)) {
            typeString = typeString.substring(0, typeString.length() - WIDENED_SUFFIX.length());
            isWidened = true;
        }
        if (typeString.endsWith(FUNCTION_TYPE_SUFFIX)) {
            typeString = typeString.substring(0, typeString.length() - FUNCTION_TYPE_SUFFIX.length());
            inheritsFunction = true;
        }
        if (typeString.endsWith(STATIC_SUFFIX)) {
            typeString = typeString.substring(0, typeString.length() - STATIC_SUFFIX.length());
            jsContext = JSTypeContext.STATIC;
        } else if (typeString.endsWith(PROTOTYPE_SUFFIX)) {
            typeString = typeString.substring(0, typeString.length() - PROTOTYPE_SUFFIX.length());
            jsContext = JSTypeContext.PROTOTYPE;
        } else if (typeString.endsWith(PROTOTYPE_CONSTRUCTOR_SUFFIX)) {
            typeString = typeString.substring(0, typeString.length() - PROTOTYPE_CONSTRUCTOR_SUFFIX.length());
            jsContext = JSTypeContext.STATIC;
        }
        if (source.getLanguage() == JSTypeSource.SourceLanguage.JS && source.getSourceElement() instanceof JSFunctionItem && jsContext != JSTypeContext.INSTANCE) {
            inheritsFunction = true;
        }
        if ((primitiveType = JSSpecialNamedTypeImpl.getSpecialType(typeString, source, jsContext, isFromJSDoc)) != null) {
            JSType jSType = primitiveType;
            if (jSType == null) {
                JSNamedType.$$$reportNull$$$0(18);
            }
            return jSType;
        }
        JSTypeImpl jSTypeImpl = new JSTypeImpl(typeString, source, jsContext, inheritsFunction, isWidened);
        if (jSTypeImpl == null) {
            JSNamedType.$$$reportNull$$$0(19);
        }
        return jSTypeImpl;
    }

    @NotNull
    public JSContext isStaticOrInstance() {
        JSContext jSContext = this.myContext.toJSContext();
        if (jSContext == null) {
            JSNamedType.$$$reportNull$$$0(20);
        }
        return jSContext;
    }

    @NotNull
    public JSTypeContext getTypeContext() {
        JSTypeContext jSTypeContext = this.myContext;
        if (jSTypeContext == null) {
            JSNamedType.$$$reportNull$$$0(21);
        }
        return jSTypeContext;
    }

    @NotNull
    public static String appendStaticSuffix(@NotNull String type) {
        if (type == null) {
            JSNamedType.$$$reportNull$$$0(22);
        }
        String string = type + STATIC_SUFFIX;
        if (string == null) {
            JSNamedType.$$$reportNull$$$0(23);
        }
        return string;
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSNamedType.$$$reportNull$$$0(24);
        }
        JSType jSType = JSNamedType.createType(this.getTypeText(), source, this.isStaticOrInstance());
        if (jSType == null) {
            JSNamedType.$$$reportNull$$$0(25);
        }
        return jSType;
    }

    @NotNull
    public JSType copyWithJSContext(@NotNull JSContext jsContext) {
        if (jsContext == null) {
            JSNamedType.$$$reportNull$$$0(26);
        }
        if (this.isStaticOrInstance() == jsContext) {
            JSNamedType jSNamedType = this;
            if (jSNamedType == null) {
                JSNamedType.$$$reportNull$$$0(27);
            }
            return jSNamedType;
        }
        JSType jSType = JSNamedType.createType(this.getTypeText(JSType.TypeTextFormat.SIMPLE), this.getSource(), jsContext);
        if (jSType == null) {
            JSNamedType.$$$reportNull$$$0(28);
        }
        return jSType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeString";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 14: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staticOrInstance";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSNamedType";
                break;
            }
            case 7: 
            case 11: 
            case 15: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsContext";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSNamedType";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createType";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "isStaticOrInstance";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeContext";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "appendStaticSuffix";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewSource";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithJSContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createExplicitlyDeclaredType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: {
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "appendStaticSuffix";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "copyWithJSContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

