/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSResolvedTypeInfoImpl
implements JSResolvedTypeInfo {
    private final Collection<? extends PsiElement> myElements;
    private boolean myIsEnum;
    private boolean myIsEnumLiteral;
    private boolean myIsEnumWithLiteralValues;
    private boolean myIsLocal;
    private boolean myIsAbstract;
    private boolean myIsInterface;
    private JSType myTypedef;
    private String myResolvedType;

    public JSResolvedTypeInfoImpl(String resolvedType, Collection<? extends PsiElement> elements) {
        this.myResolvedType = resolvedType;
        this.myElements = elements;
        this.setTypeScriptAdditionalParams();
    }

    private void setTypeScriptAdditionalParams() {
        for (PsiElement psiElement : this.myElements) {
            if (psiElement instanceof TypeScriptTypeAlias) {
                this.myTypedef = ((TypeScriptTypeAlias)psiElement).getParsedTypeDeclaration();
                break;
            }
            if (psiElement instanceof JSClass) {
                if (!((JSClass)psiElement).isNamespaceExplicitlyDeclared()) {
                    this.myIsLocal = true;
                }
                if (psiElement instanceof TypeScriptClass) {
                    this.myIsAbstract = TypeScriptPsiUtil.isAbstractElement((JSAttributeListOwner)((TypeScriptClass)psiElement));
                } else if (psiElement instanceof TypeScriptInterface) {
                    this.myIsInterface = ((TypeScriptInterface)psiElement).isInterface();
                }
            }
            if (psiElement instanceof TypeScriptEnum) {
                this.myIsEnum = true;
                boolean hasConstValues = true;
                for (JSElement member : ((TypeScriptEnum)psiElement).getMembers()) {
                    if (((TypeScriptEnumField)member).getConstantValue().isValid()) continue;
                    hasConstValues = false;
                    break;
                }
                this.myIsEnumWithLiteralValues = hasConstValues;
            }
            if (!(psiElement instanceof TypeScriptEnumField)) continue;
            this.myIsEnumLiteral = true;
        }
    }

    @Override
    @NotNull
    public String getResolvedTypeText() {
        String string = this.myResolvedType;
        if (string == null) {
            JSResolvedTypeInfoImpl.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    public <T extends PsiElement> T getDeclarationOfType(Class<T> klass) {
        for (PsiElement psiElement : this.myElements) {
            if (!klass.isInstance(psiElement)) continue;
            PsiElement declaration = psiElement;
            return (T)declaration;
        }
        return null;
    }

    @Override
    public boolean isEnum() {
        return this.myIsEnum;
    }

    @Override
    public boolean isEnumWithLiteralValues() {
        return this.myIsEnumWithLiteralValues;
    }

    @Override
    public boolean isEnumLiteral() {
        return this.myIsEnumLiteral;
    }

    @Override
    public boolean isInterface() {
        return this.myIsInterface;
    }

    @Override
    public boolean isLocal() {
        return this.myIsLocal;
    }

    @Override
    public boolean isAbstract() {
        return this.myIsAbstract;
    }

    @Override
    @Nullable
    public JSType getTypedef() {
        return this.myTypedef;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSResolvedTypeInfoImpl", "getResolvedTypeText"));
    }
}

