/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSDecoratedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSFreshObjectLiteralType;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIterableComponentTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRequireCallExpressionType;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptIndexedAccessJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptMappedJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeOperatorJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.TypeScriptTypePredicateTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverJSTypeImpl;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeCastUtil {
    private static final Key<Map<Object, Set<Object>>> OUR_ALREADY_COMPARED_TYPES_KEY = Key.create((String)"already.compared.types");
    public static final JSRecordType NO_RECORD_TYPE = new JSRecordTypeImpl(JSTypeSource.EMPTY, ContainerUtil.emptyList());

    public static boolean startRecursiveTypesComparison(@NotNull JSType type1, @NotNull JSType type2, @NotNull ProcessingContext processingContext) {
        if (type1 == null) {
            JSTypeCastUtil.$$$reportNull$$$0(0);
        }
        if (type2 == null) {
            JSTypeCastUtil.$$$reportNull$$$0(1);
        }
        if (processingContext == null) {
            JSTypeCastUtil.$$$reportNull$$$0(2);
        }
        String lId = JSTypeCastUtil.getTypeIdForComparison(type1);
        String rId = JSTypeCastUtil.getTypeIdForComparison(type2);
        return JSTypeCastUtil.startRecursiveTypesComparison(lId, rId, processingContext);
    }

    @NotNull
    public static String getTypeIdForComparison(@NotNull JSType type) {
        if (type == null) {
            JSTypeCastUtil.$$$reportNull$$$0(3);
        }
        if (type instanceof JSNamedType) {
            String typeStringForComparison = JSTypeCastUtil.getTypeStringForComparison((JSNamedType)type);
            if (type instanceof JSPrimitiveLiteralType) {
                String string = typeStringForComparison + "Literal#" + ((JSPrimitiveLiteralType)type).getLiteral();
                if (string == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(4);
                }
                return string;
            }
            String string = typeStringForComparison;
            if (string == null) {
                JSTypeCastUtil.$$$reportNull$$$0(5);
            }
            return string;
        }
        if (type instanceof JSRecordType) {
            String string = "#record#" + type.hashCode();
            if (string == null) {
                JSTypeCastUtil.$$$reportNull$$$0(6);
            }
            return string;
        }
        if (type instanceof JSCompositeTypeImpl) {
            List<JSType> types = ((JSCompositeTypeImpl)type).getTypes();
            String separator = ((JSCompositeTypeImpl)type).getTypeSeparator();
            String string = "#composite#" + StringUtil.join(types, el -> JSTypeCastUtil.getTypeIdForComparison(el), (String)separator);
            if (string == null) {
                JSTypeCastUtil.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (type instanceof TypeScriptIndexedAccessJSTypeImpl) {
            String string = "#indexer#" + JSTypeCastUtil.getTypeIdForComparison(((TypeScriptIndexedAccessJSTypeImpl)type).getOwner()) + "[" + JSTypeCastUtil.getTypeIdForComparison(((TypeScriptIndexedAccessJSTypeImpl)type).getParameterType()) + "]";
            if (string == null) {
                JSTypeCastUtil.$$$reportNull$$$0(8);
            }
            return string;
        }
        if (type instanceof TypeScriptMappedJSTypeImpl) {
            String string = "#mapped#" + JSTypeCastUtil.getTypeIdForComparison(((TypeScriptMappedJSTypeImpl)type).getParameterType()) + ":" + JSTypeCastUtil.getTypeIdForComparison(((TypeScriptMappedJSTypeImpl)type).getResultType());
            if (string == null) {
                JSTypeCastUtil.$$$reportNull$$$0(9);
            }
            return string;
        }
        if (type instanceof TypeScriptTypeOperatorJSTypeImpl) {
            String string = "#keyof#" + JSTypeCastUtil.getTypeIdForComparison(((TypeScriptTypeOperatorJSTypeImpl)type).getReferencedType());
            if (string == null) {
                JSTypeCastUtil.$$$reportNull$$$0(10);
            }
            return string;
        }
        if (type instanceof JSGenericTypeImpl) {
            String desc = "#generic#" + JSTypeCastUtil.getTypeIdForComparison(((JSGenericTypeImpl)type).getType()) + "#inner#" + StringUtil.join(((JSGenericTypeImpl)type).getArguments(), el -> JSTypeCastUtil.getTypeIdForComparison(el), (String)",");
            Map<String, JSType> outer = ((JSGenericTypeImpl)type).getOuterArguments();
            if (outer == null) {
                String string = desc;
                if (string == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(11);
                }
                return string;
            }
            String string = desc + "#outer#" + StringUtil.join(outer.entrySet(), e -> (String)e.getKey() + ":" + e.getValue(), (String)",");
            if (string == null) {
                JSTypeCastUtil.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = "#type#" + type.getClass() + "#" + type.hashCode();
        if (string == null) {
            JSTypeCastUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    public static void endRecursiveTypesComparison(@NotNull JSType type1, @NotNull JSType type2, @NotNull ProcessingContext processingContext) {
        if (type1 == null) {
            JSTypeCastUtil.$$$reportNull$$$0(14);
        }
        if (type2 == null) {
            JSTypeCastUtil.$$$reportNull$$$0(15);
        }
        if (processingContext == null) {
            JSTypeCastUtil.$$$reportNull$$$0(16);
        }
        String type1Id = JSTypeCastUtil.getTypeIdForComparison(type1);
        String type2Id = JSTypeCastUtil.getTypeIdForComparison(type2);
        JSTypeCastUtil.endRecursiveTypesComparison(type1Id, type2Id, processingContext);
    }

    @NotNull
    private static String getTypeStringForComparison(JSNamedType type1) {
        String string = (JSTypeContext.STATIC == type1.getTypeContext() ? "static#" : "") + type1.getResolvedTypeText();
        if (string == null) {
            JSTypeCastUtil.$$$reportNull$$$0(17);
        }
        return string;
    }

    public static boolean startRecursiveTypesComparison(@Nullable Object thisTypeId, @Nullable Object elementTypeId, @NotNull ProcessingContext processingContext) {
        Set typesComparedToThis;
        if (processingContext == null) {
            JSTypeCastUtil.$$$reportNull$$$0(18);
        }
        ProgressIndicatorProvider.checkCanceled();
        Map alreadyComparedTypes = (Map)processingContext.get(OUR_ALREADY_COMPARED_TYPES_KEY);
        if (alreadyComparedTypes == null) {
            alreadyComparedTypes = new THashMap();
            processingContext.put(OUR_ALREADY_COMPARED_TYPES_KEY, (Object)alreadyComparedTypes);
        }
        if ((typesComparedToThis = (Set)alreadyComparedTypes.get(thisTypeId)) == null) {
            THashSet set = new THashSet();
            set.add(elementTypeId);
            alreadyComparedTypes.put(thisTypeId, set);
            return true;
        }
        return typesComparedToThis.add(elementTypeId);
    }

    public static void endRecursiveTypesComparison(Object thisTypeId, Object elementTypeId, @NotNull ProcessingContext processingContext) {
        Set elementQNames;
        Map alreadyComparedTypes;
        if (processingContext == null) {
            JSTypeCastUtil.$$$reportNull$$$0(19);
        }
        if ((alreadyComparedTypes = (Map)processingContext.get(OUR_ALREADY_COMPARED_TYPES_KEY)) != null && (elementQNames = (Set)alreadyComparedTypes.get(thisTypeId)) != null) {
            elementQNames.remove(elementTypeId);
            if (elementQNames.isEmpty()) {
                alreadyComparedTypes.remove(thisTypeId);
            }
        }
    }

    @NotNull
    public static AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType thisOperand, @NotNull JSType rOperand, @Nullable ProcessingContext processingContext) {
        JSType substitutedType;
        JSType type;
        if (thisOperand == null) {
            JSTypeCastUtil.$$$reportNull$$$0(20);
        }
        if (rOperand == null) {
            JSTypeCastUtil.$$$reportNull$$$0(21);
        }
        if (rOperand instanceof JSUndefinedType) {
            AssignableResult assignableResult = AssignableResult.ASSIGNABLE;
            if (assignableResult == null) {
                JSTypeCastUtil.$$$reportNull$$$0(22);
            }
            return assignableResult;
        }
        if (rOperand instanceof JSGenericParameterImpl) {
            JSType type2 = ((JSGenericParameterImpl)rOperand).getConstraintType();
            if (type2 != null) {
                AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand.isDirectlyAssignableType(type2, processingContext));
                if (assignableResult == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(23);
                }
                return assignableResult;
            }
            AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(rOperand.isDirectlyAssignableType(thisOperand, processingContext));
            if (assignableResult == null) {
                JSTypeCastUtil.$$$reportNull$$$0(24);
            }
            return assignableResult;
        }
        if (rOperand instanceof JSDecoratedTypeImpl && !((JSDecoratedTypeImpl)rOperand).getDecorations().isEmpty()) {
            AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand.isDirectlyAssignableType(((JSDecoratedTypeImpl)rOperand).getType(), processingContext));
            if (assignableResult == null) {
                JSTypeCastUtil.$$$reportNull$$$0(25);
            }
            return assignableResult;
        }
        if (rOperand instanceof JSUnionOrIntersectionType) {
            JSUnionOrIntersectionType compositeType = (JSUnionOrIntersectionType)rOperand;
            boolean isIntersection = compositeType instanceof JSIntersectionTypeImpl;
            boolean isStrictContext = JSTypeCastUtil.isStrictTypeScriptUnionType(compositeType);
            boolean result = JSTypeCastUtil.checkAssignableComposite(thisOperand, compositeType, processingContext, !isIntersection && isStrictContext);
            if (result || !isStrictContext) {
                AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(result);
                if (assignableResult == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(26);
                }
                return assignableResult;
            }
        } else if (rOperand instanceof JSTypeImpl) {
            JSType typedefValue;
            JSTypeImpl jsType = (JSTypeImpl)rOperand;
            if (processingContext == null) {
                processingContext = new ProcessingContext();
            }
            if ((typedefValue = jsType.getTypedef(null, processingContext)) != null) {
                if (!JSTypeCastUtil.startRecursiveTypesComparison(thisOperand, jsType, processingContext)) {
                    AssignableResult assignableResult = AssignableResult.ASSIGNABLE;
                    if (assignableResult == null) {
                        JSTypeCastUtil.$$$reportNull$$$0(27);
                    }
                    return assignableResult;
                }
                AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand.isDirectlyAssignableType(typedefValue, processingContext));
                if (assignableResult == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(28);
                }
                return assignableResult;
            }
        } else if (rOperand instanceof JSGenericTypeImpl && (type = ((JSGenericTypeImpl)rOperand).getType()) instanceof JSTypeImpl && ((JSTypeImpl)type).getTypedef(null, processingContext) != null && (substitutedType = rOperand.substitute()) != rOperand) {
            AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand.isDirectlyAssignableType(substitutedType, processingContext));
            if (assignableResult == null) {
                JSTypeCastUtil.$$$reportNull$$$0(29);
            }
            return assignableResult;
        }
        if (rOperand instanceof JSIterableComponentTypeImpl || rOperand instanceof TypeScriptGenericThisTypeImpl || rOperand instanceof TypeScriptTypePredicateTypeImpl || rOperand instanceof JSEvaluableType || rOperand instanceof TypeScriptTypeOperatorJSTypeImpl || rOperand instanceof TypeScriptMappedJSTypeImpl || rOperand instanceof JSCompositeTypeBaseImpl) {
            String parameterName;
            JSType paramType;
            type = rOperand.substitute();
            if (type != rOperand) {
                if (processingContext == null) {
                    processingContext = new ProcessingContext();
                }
                if (!JSTypeCastUtil.startRecursiveTypesComparison(thisOperand, rOperand, processingContext)) {
                    AssignableResult assignableResult = AssignableResult.ASSIGNABLE;
                    if (assignableResult == null) {
                        JSTypeCastUtil.$$$reportNull$$$0(30);
                    }
                    return assignableResult;
                }
                AssignableResult result = JSTypeCastUtil.toStrictAssignable(thisOperand.isDirectlyAssignableType(type, processingContext));
                JSTypeCastUtil.endRecursiveTypesComparison(thisOperand, rOperand, processingContext);
                AssignableResult assignableResult = result;
                if (assignableResult == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(31);
                }
                return assignableResult;
            }
            if (rOperand instanceof TypeScriptMappedJSTypeImpl && JSTypeCastUtil.isTypeOperatorLikeType(paramType = ((TypeScriptMappedJSTypeImpl)rOperand).getParameterType()) && (parameterName = ((TypeScriptMappedJSTypeImpl)rOperand).getParameterName()) != null && new TypeScriptIndexedAccessJSTypeImpl(thisOperand, JSNamedType.createType(parameterName, rOperand.getSource(), JSTypeContext.INSTANCE), rOperand.getSource()).isDirectlyAssignableType(((TypeScriptMappedJSTypeImpl)rOperand).getResultType(), processingContext)) {
                if (JSGenericTypesEvaluator.isGenericProcessingInProgress(processingContext) && paramType instanceof JSGenericParameterImpl) {
                    new TypeScriptTypeOperatorJSTypeImpl(thisOperand, thisOperand.getSource()).isDirectlyAssignableType(paramType, processingContext);
                }
                AssignableResult assignableResult = AssignableResult.ASSIGNABLE;
                if (assignableResult == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(32);
                }
                return assignableResult;
            }
            if (rOperand instanceof JSEvaluableType) {
                AssignableResult assignableResult = AssignableResult.ASSIGNABLE;
                if (assignableResult == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(33);
                }
                return assignableResult;
            }
        }
        AssignableResult assignableResult = thisOperand.isEquivalentTo(rOperand, processingContext) ? AssignableResult.ASSIGNABLE : AssignableResult.NOT_SURE;
        if (assignableResult == null) {
            JSTypeCastUtil.$$$reportNull$$$0(34);
        }
        return assignableResult;
    }

    @Contract(value="null -> false")
    public static boolean isTypeOperatorLikeType(@Nullable JSType paramType) {
        return paramType instanceof TypeScriptTypeOperatorJSTypeImpl || paramType instanceof JSGenericParameterImpl && ((JSGenericParameterImpl)paramType).getConstraintType() instanceof TypeScriptTypeOperatorJSTypeImpl;
    }

    public static boolean isAlwaysAssignableType(@NotNull JSType type, boolean isJavaScriptContext) {
        if (type == null) {
            JSTypeCastUtil.$$$reportNull$$$0(35);
        }
        if (type instanceof JSAnyType || type instanceof TypeScriptNeverJSTypeImpl || type instanceof JSRequireCallExpressionType) {
            return true;
        }
        return (type instanceof JSNullType || type instanceof JSUndefinedType) && !isJavaScriptContext;
    }

    public static boolean isAlwaysAssignableType(@NotNull JSType type) {
        if (type == null) {
            JSTypeCastUtil.$$$reportNull$$$0(36);
        }
        return JSTypeCastUtil.isAlwaysAssignableType(type, type.getSource().isJavaScript());
    }

    public static boolean isStrictTypeScriptUnionType(@NotNull JSUnionOrIntersectionType rOperand) {
        if (rOperand == null) {
            JSTypeCastUtil.$$$reportNull$$$0(37);
        }
        assert (rOperand instanceof JSTypeBaseImpl);
        JSTypeBaseImpl baseType = (JSTypeBaseImpl)((Object)rOperand);
        if (!baseType.isTypeScript() || !baseType.getSource().isStrict()) {
            return false;
        }
        for (JSType type : rOperand.getTypes()) {
            if (!(type instanceof JSAnyType)) continue;
            return false;
        }
        return true;
    }

    public static AssignableResult toStrictAssignable(boolean value) {
        return value ? AssignableResult.ASSIGNABLE : AssignableResult.NOT_ASSIGNABLE;
    }

    @Nullable
    public static JSRecordType buildWithAppliedGenericArguments(@NotNull JSClass jsClass, @NotNull JSGenericTypeImpl type) {
        TypeScriptTypeParameterListOwner owner;
        if (jsClass == null) {
            JSTypeCastUtil.$$$reportNull$$$0(38);
        }
        if (type == null) {
            JSTypeCastUtil.$$$reportNull$$$0(39);
        }
        if (jsClass instanceof TypeScriptTypeParameterListOwner && ((owner = (TypeScriptTypeParameterListOwner)jsClass).getTypeParameterList() != null || type.getOuterArguments() != null)) {
            JSTypeSubstitutor genericArgumentsMap = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(owner, type);
            JSType baseType = type.getType();
            boolean isStatic = baseType instanceof JSNamedType && ((JSNamedType)baseType).isStaticOrInstance() == JSContext.STATIC;
            JSRecordType recordType = TypeScriptTypeParser.buildTypeFromClass(jsClass, isStatic);
            return (JSRecordType)JSTypeUtils.applyGenericArguments((JSType)recordType, (Map<String, JSType>)genericArgumentsMap);
        }
        return null;
    }

    public static boolean checkAssignableComposite(@NotNull JSType thisOperand, @NotNull JSUnionOrIntersectionType rOperand, @Nullable ProcessingContext processingContext, boolean needCheckAllTypes) {
        if (thisOperand == null) {
            JSTypeCastUtil.$$$reportNull$$$0(40);
        }
        if (rOperand == null) {
            JSTypeCastUtil.$$$reportNull$$$0(41);
        }
        for (JSType jsType : rOperand.getTypes()) {
            boolean result = thisOperand.isDirectlyAssignableType(jsType, processingContext);
            if (needCheckAllTypes) {
                if (result) continue;
                return false;
            }
            if (!result) continue;
            return true;
        }
        return needCheckAllTypes;
    }

    public static boolean compareByExcessProperties(@NotNull JSTypeBaseImpl ownType, @NotNull JSFreshObjectLiteralType otherType) {
        if (ownType == null) {
            JSTypeCastUtil.$$$reportNull$$$0(42);
        }
        if (otherType == null) {
            JSTypeCastUtil.$$$reportNull$$$0(43);
        }
        if (ownType instanceof JSObjectType || JSTypeCastUtil.excessPropertyChecksDisabled(ownType)) {
            return true;
        }
        JSRecordType ownTypeAsRecord = ownType.asRecordType();
        if (JSTypeCastUtil.shouldCheckForExcessProperties(ownTypeAsRecord) && (!(ownType instanceof JSUnionOrIntersectionType) || JSTypeCastUtil.shouldCheckCompositeTypeForExcessProperties((JSUnionOrIntersectionType)((Object)ownType)))) {
            JSType objectType = JSNamedType.createType("Object", otherType.getSource(), JSContext.INSTANCE);
            HashSet otherProps = ContainerUtil.newHashSet((Iterable)otherType.getPropertyNames());
            otherProps.removeAll(ownTypeAsRecord.getPropertyNames());
            otherProps.removeAll(objectType.asRecordType().getPropertyNames());
            return otherProps.size() == 0;
        }
        return true;
    }

    private static boolean shouldCheckCompositeTypeForExcessProperties(@Nullable JSUnionOrIntersectionType type) {
        Ref shouldCheck = Ref.create((Object)true);
        JSTypeUtils.processExpandedType((Processor<JSType>)((Processor)t -> {
            if (t instanceof JSObjectType) {
                shouldCheck.set((Object)false);
                return false;
            }
            JSRecordType recordType = t.asRecordType();
            if (!JSTypeCastUtil.shouldCheckForExcessProperties(recordType)) {
                shouldCheck.set((Object)false);
                return false;
            }
            return true;
        }), type);
        return (Boolean)shouldCheck.get();
    }

    private static boolean shouldCheckForExcessProperties(@NotNull JSRecordType recordType) {
        if (recordType == null) {
            JSTypeCastUtil.$$$reportNull$$$0(44);
        }
        return !recordType.hasIndexers() && recordType.getPropertyNames().size() > 0;
    }

    private static boolean excessPropertyChecksDisabled(@NotNull JSTypeBaseImpl type) {
        TypeScriptConfig config2;
        PsiFile scope;
        if (type == null) {
            JSTypeCastUtil.$$$reportNull$$$0(45);
        }
        return (scope = type.getSource().getScope()) != null && scope.isValid() && (config2 = TypeScriptConfigUtil.getConfigForPsiFile(scope)) != null && config2.suppressExcessPropertyChecks();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type1";
                break;
            }
            case 1: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type2";
                break;
            }
            case 2: 
            case 16: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 3: 
            case 35: 
            case 36: 
            case 39: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeCastUtil";
                break;
            }
            case 20: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisOperand";
                break;
            }
            case 21: 
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rOperand";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownType";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherType";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeCastUtil";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeIdForComparison";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeStringForComparison";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "isDirectlyAssignableTypeCommon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "startRecursiveTypesComparison";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTypeIdForComparison";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "endRecursiveTypesComparison";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isAlwaysAssignableType";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isStrictTypeScriptUnionType";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "buildWithAppliedGenericArguments";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "checkAssignableComposite";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "compareByExcessProperties";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "shouldCheckForExcessProperties";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "excessPropertyChecksDisabled";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum AssignableResult {
        ASSIGNABLE(true, true),
        NOT_ASSIGNABLE(true, false),
        NOT_SURE(false, false),
        NO_CACHE(false, false);

        private final boolean myStrict;
        private final boolean myAssignable;

        private AssignableResult(boolean strict, boolean assignable) {
            this.myStrict = strict;
            this.myAssignable = assignable;
        }

        public boolean isAssignable() {
            return this.myAssignable;
        }

        public boolean isStrict() {
            return this.myStrict;
        }
    }
}

