/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSDestructuringShorthandedProperty;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.refactoring.JSDefaultRenameProcessor;
import com.intellij.lang.javascript.refactoring.JSGetterSetterRenameUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenameHandler;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSInplaceRenameHandler
extends VariableInplaceRenameHandler {
    protected boolean isAvailable(PsiElement element, Editor editor, PsiFile file) {
        return element instanceof JSNamedElement && element.getUseScope() instanceof LocalSearchScope && !JavaScriptSupportLoader.isMxmlOrFxgFile(InjectedLanguageUtil.getTopLevelFile((PsiElement)file)) && !JSGetterSetterRenameUtil.isFieldWithAccessors(element) && (!(element instanceof JSVariable) || !(element.getParent() instanceof JSDestructuringShorthandedProperty));
    }

    @Nullable
    protected VariableInplaceRenamer createRenamer(@NotNull PsiElement elementToRename, Editor editor) {
        if (elementToRename == null) {
            JSInplaceRenameHandler.$$$reportNull$$$0(0);
        }
        return new VariableInplaceRenamer((PsiNamedElement)((PsiNameIdentifierOwner)elementToRename), editor){
            private final Collection<Pair<PsiElement, TextRange>> myStringUsages;
            private boolean myDone;
            {
                this.myStringUsages = Collections.synchronizedList(new ArrayList());
                this.myDone = false;
            }

            protected Collection<PsiReference> collectRefs(SearchScope referencesSearchScope) {
                LOG.assertTrue(!this.myDone);
                List<PsiReference> result = Collections.synchronizedList(new ArrayList());
                ReferencesSearch.search((PsiElement)this.myElementToRename, (SearchScope)referencesSearchScope).forEach(psiReference -> {
                    if (JSDefaultRenameProcessor.isStrictlyRenameableReference(psiReference)) {
                        result.add((PsiReference)psiReference);
                    } else {
                        this.myStringUsages.add((Pair<PsiElement, TextRange>)Pair.create((Object)psiReference.getElement(), (Object)psiReference.getRangeInElement()));
                    }
                    return true;
                });
                return result;
            }

            protected void collectAdditionalElementsToRename(@NotNull List<Pair<PsiElement, TextRange>> stringUsages) {
                if (stringUsages == null) {
                    1.$$$reportNull$$$0(0);
                }
                LOG.assertTrue(!this.myDone);
                stringUsages.addAll(this.myStringUsages);
                super.collectAdditionalElementsToRename(stringUsages);
            }

            public boolean performInplaceRename() {
                boolean result = super.performInplaceRename();
                this.myDone = true;
                return result;
            }

            protected boolean buildTemplateAndStart(Collection<PsiReference> refs, Collection<Pair<PsiElement, TextRange>> stringUsages, PsiElement scope, PsiFile containingFile) {
                if (!JSDefaultRenameProcessor.collectShorthandPropertyUsages(refs).isEmpty()) {
                    return false;
                }
                boolean result = super.buildTemplateAndStart(refs, stringUsages, scope, containingFile);
                PsiElement container = PsiTreeUtil.getNonStrictParentOfType((PsiElement)scope, (Class[])new Class[]{PsiFile.class, JSEmbeddedContent.class});
                if (container != null) {
                    this.myLanguage = container.getLanguage();
                }
                return result;
            }

            @NotNull
            protected TextRange getRangeToRename(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (element.getNode().getElementType() != JSTokenTypes.STRING_LITERAL) {
                    TextRange textRange = super.getRangeToRename(element);
                    if (textRange == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return textRange;
                }
                if (!(element.getParent() instanceof JSRecordType.PropertySignature)) {
                    TextRange textRange = super.getRangeToRename(element);
                    if (textRange == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return textRange;
                }
                TextRange textRange = new TextRange(1, element.getTextLength() - 1);
                if (textRange == null) {
                    1.$$$reportNull$$$0(4);
                }
                return textRange;
            }

            protected boolean isIdentifier(String newName, Language language) {
                PsiNamedElement element = this.myElementToRename;
                if (!(element instanceof JSRecordType.PropertySignature)) {
                    return super.isIdentifier(newName, language);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "stringUsages";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/refactoring/JSInplaceRenameHandler$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/refactoring/JSInplaceRenameHandler$1";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRangeToRename";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "collectAdditionalElementsToRename";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getRangeToRename";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Nullable
    public InplaceRefactoring doRename(@NotNull PsiElement elementToRename, final Editor editor, DataContext dataContext) {
        if (elementToRename == null) {
            JSInplaceRenameHandler.$$$reportNull$$$0(1);
        }
        RenamePsiElementProcessor processor = RenamePsiElementProcessor.forElement((PsiElement)elementToRename);
        processor.substituteElementToRename(elementToRename, editor, (Pass)new Pass<PsiElement>(){

            public void pass(PsiElement element) {
                boolean startedRename;
                VariableInplaceRenamer renamer = JSInplaceRenameHandler.this.createRenamer(element, editor);
                boolean bl = startedRename = renamer != null && renamer.performInplaceRename();
                if (!startedRename) {
                    PsiElementRenameHandler.invoke((PsiElement)element, (Project)element.getProject(), (PsiElement)element, (Editor)editor);
                }
            }
        });
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "elementToRename";
        objectArray2[1] = "com/intellij/lang/javascript/refactoring/JSInplaceRenameHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createRenamer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "doRename";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

