/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.extractSuper;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.JSChangeVisibilityUtil;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.refactoring.extractSuper.ES6ExtractSuperParameters;
import com.intellij.lang.javascript.refactoring.extractSuper.JSConvertReferencesToSuperUtil;
import com.intellij.lang.javascript.refactoring.extractSuper.JSExtractSuperMode;
import com.intellij.lang.javascript.refactoring.memberPullUp.JSPullUpConflictsUtil;
import com.intellij.lang.javascript.refactoring.memberPullUp.JSPullUpHelper;
import com.intellij.lang.javascript.refactoring.util.JSInterfaceContainmentVerifier;
import com.intellij.lang.javascript.refactoring.util.JSMemberInfo;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ExtractSuperProcessor
extends BaseRefactoringProcessor {
    private final ES6ExtractSuperParameters myParameters;
    private Collection<JSElement> myMembersAfterMove;
    private JSClass myTargetClass;

    public ES6ExtractSuperProcessor(ES6ExtractSuperParameters parameters) {
        super(parameters.sourceClass.getProject());
        this.myParameters = parameters;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            ES6ExtractSuperProcessor.$$$reportNull$$$0(0);
        }
        UsageViewDescriptorAdapter usageViewDescriptorAdapter = new UsageViewDescriptorAdapter(){

            @NotNull
            public PsiElement[] getElements() {
                PsiElement[] psiElementArray = new PsiElement[]{((ES6ExtractSuperProcessor)ES6ExtractSuperProcessor.this).myParameters.sourceClass};
                if (psiElementArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiElementArray;
            }

            public String getProcessedElementsHeader() {
                return RefactoringBundle.message((String)(((ES6ExtractSuperProcessor)ES6ExtractSuperProcessor.this).myParameters.classNotInterface ? "members.to.form.superclass" : "members.to.form.interface"));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/extractSuper/ES6ExtractSuperProcessor$1", "getElements"));
            }
        };
        if (usageViewDescriptorAdapter == null) {
            ES6ExtractSuperProcessor.$$$reportNull$$$0(1);
        }
        return usageViewDescriptorAdapter;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        if (this.myParameters.mode == JSExtractSuperMode.ExtractSuper) {
            if (UsageInfo.EMPTY_ARRAY == null) {
                ES6ExtractSuperProcessor.$$$reportNull$$$0(2);
            }
            return UsageInfo.EMPTY_ARRAY;
        }
        Collection<JSReferenceExpression> candidates = Collections.synchronizedCollection(new ArrayList());
        ReferencesSearch.search((PsiElement)this.myParameters.sourceClass, (SearchScope)this.myParameters.sourceClass.getUseScope()).forEach(psiReference -> {
            PsiElement element = psiReference.getElement();
            if (!(element instanceof JSReferenceExpression)) {
                return true;
            }
            if (element == this.myParameters.sourceClass.getNameIdentifier()) {
                return true;
            }
            candidates.add((JSReferenceExpression)element);
            return true;
        });
        HashMap<PsiElement, JSConvertReferencesToSuperUtil.Status> variablesResults = new HashMap<PsiElement, JSConvertReferencesToSuperUtil.Status>();
        Collection<UsageInfo> result = Collections.synchronizedCollection(new ArrayList());
        JSConvertReferencesToSuperUtil util = new JSConvertReferencesToSuperUtil(this.myParameters.membersToMove, this.myMembersAfterMove, this.myParameters.mode, this.myParameters.sourceClass, this.myTargetClass);
        for (JSReferenceExpression candidate : candidates) {
            if (!util.canTurnReferenceToSuper(candidate, variablesResults)) continue;
            result.add(new UsageInfo((PsiElement)candidate));
        }
        UsageInfo[] usageInfoArray = result.toArray(new UsageInfo[result.size()]);
        if (usageInfoArray == null) {
            ES6ExtractSuperProcessor.$$$reportNull$$$0(3);
        }
        return usageInfoArray;
    }

    @NotNull
    protected String getCommandName() {
        String string = RefactoringBundle.message((String)(this.myParameters.classNotInterface ? "extract.superclass.command.name" : "extract.interface.command.name"), (Object[])new Object[]{this.myParameters.targetName, JSFormatUtil.formatClass(this.myParameters.sourceClass, 1)});
        if (string == null) {
            ES6ExtractSuperProcessor.$$$reportNull$$$0(4);
        }
        return string;
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            ES6ExtractSuperProcessor.$$$reportNull$$$0(5);
        }
        return this.showConflicts(this.detectConflicts(), (UsageInfo[])refUsages.get());
    }

    private MultiMap<PsiElement, String> detectConflicts() {
        JSInterfaceContainmentVerifier v = JSInterfaceContainmentVerifier.create(this.myParameters.membersToMove);
        Collection<TypeScriptTypeParameter> referencedGenerics = ES6ExtractSuperProcessor.getReferencedGenericParameters(this.myParameters.membersToMove, this.myParameters.sourceClass);
        JSClass fakeClass = ES6ExtractSuperProcessor.createEmptyES6Class(this.myParameters, "Foo", referencedGenerics);
        if (fakeClass == null) {
            return new MultiMap();
        }
        if (this.myParameters.sourceClass.getContainingFile() == ES6ExtractSuperProcessor.getDestinationPsiFile(this.myParameters)) {
            fakeClass.getContainingFile().putUserData(JSResolveUtil.contextKey, (Object)this.myParameters.sourceClass.getContainingFile());
        }
        return JSPullUpConflictsUtil.checkConflicts(this.myParameters.membersToMove, this.myParameters.sourceClass, fakeClass, v, JSVisibilityUtil.DEFAULT_OPTIONS);
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        List propertiesToCreateInConstructor;
        if (usages == null) {
            ES6ExtractSuperProcessor.$$$reportNull$$$0(6);
        }
        this.myTargetClass = ES6ExtractSuperProcessor.createSuperClass(this.myParameters, this.myParameters.targetName);
        if (this.myTargetClass == null) {
            return;
        }
        List list = propertiesToCreateInConstructor = this.myParameters.classNotInterface ? ContainerUtil.mapNotNull((Object[])this.myParameters.membersToMove, t -> {
            JSAttributeListOwner member = (JSAttributeListOwner)t.getMember();
            if (member instanceof JSParameter && TypeScriptPsiUtil.isFieldParameter((JSParameter)member)) {
                return (JSParameter)member;
            }
            return null;
        }) : ContainerUtil.emptyList();
        if (this.myParameters.classNotInterface) {
            JSFunction constructor;
            JSFunction jSFunction = constructor = this.myParameters.sourceClass instanceof TypeScriptClass ? (JSFunction)ContainerUtil.find((Object[])((TypeScriptClass)this.myParameters.sourceClass).getConstructors(), c -> !c.isOverloadDeclaration() && (!c.hasOverloadDeclarations() || c.isOverloadImplementation())) : this.myParameters.sourceClass.getConstructor();
            if (!propertiesToCreateInConstructor.isEmpty()) {
                ES6ExtractSuperProcessor.createSuperConstructor(this.myTargetClass, propertiesToCreateInConstructor);
                if (constructor != null) {
                    for (JSParameter originalParameter : constructor.getParameterVariables()) {
                        ES6ExtractSuperProcessor.convertFieldParameterToParameter(originalParameter);
                    }
                }
            }
            if (constructor != null) {
                ES6ExtractSuperProcessor.ensureSuperCall(constructor, propertiesToCreateInConstructor);
            }
        }
        ArrayList formatters = ContainerUtil.newArrayList();
        JSMemberInfo[] remainingMembers = (JSMemberInfo[])Arrays.stream(this.myParameters.membersToMove).filter(t -> !(t.getMember() instanceof JSParameter) || !propertiesToCreateInConstructor.contains(t.getMember())).toArray(JSMemberInfo[]::new);
        this.myMembersAfterMove = new JSPullUpHelper(this.myParameters.sourceClass, this.myTargetClass, remainingMembers, this.myParameters.docCommentPolicy).moveMembersToBase(formatters);
        if (this.myParameters.mode != JSExtractSuperMode.ExtractSuper) {
            this.convertReferences(usages);
        }
        ES6CreateImportUtil.optimizeImports((PsiElement)this.myParameters.sourceClass);
        ES6CreateImportUtil.optimizeImports((PsiElement)this.myTargetClass);
        JSRefactoringUtil.format(formatters);
    }

    private static void convertFieldParameterToParameter(@NotNull JSParameter originalParameter) {
        if (originalParameter == null) {
            ES6ExtractSuperProcessor.$$$reportNull$$$0(7);
        }
        if (!TypeScriptPsiUtil.isFieldParameter(originalParameter)) {
            return;
        }
        JSAttributeListWrapper wrapper = new JSAttributeListWrapper(originalParameter.getAttributeList());
        wrapper.removeAccessModifier();
        wrapper.overrideModifier(JSAttributeList.ModifierType.READONLY, false);
        wrapper.applyTo((JSAttributeListOwner)originalParameter);
    }

    private static void createSuperConstructor(@NotNull JSClass targetClass, @NotNull List<JSParameter> properties) {
        if (targetClass == null) {
            ES6ExtractSuperProcessor.$$$reportNull$$$0(8);
        }
        if (properties == null) {
            ES6ExtractSuperProcessor.$$$reportNull$$$0(9);
        }
        List copied = ContainerUtil.map(properties, t -> (JSParameter)t.copy());
        for (JSParameter parameter : copied) {
            JSAttributeList.AccessType accessType;
            JSAttributeList attributeList = parameter.getAttributeList();
            if (attributeList == null || (accessType = attributeList.getExplicitAccessType()) != JSAttributeList.AccessType.PRIVATE) continue;
            JSChangeVisibilityUtil.setVisibility((JSAttributeListOwner)parameter, JSAttributeList.AccessType.PROTECTED);
        }
        String text = String.format("constructor(%s){\n}", StringUtil.join((Collection)copied, t -> t.getText(), (String)", "));
        JSFunction created = JSChangeUtil.createClassMemberPsiFromTextWithContext(text, (PsiElement)targetClass, JSFunction.class);
        if (created != null) {
            JSRefactoringUtil.addMemberToTargetClass(targetClass, (PsiElement)created);
        }
    }

    private static void ensureSuperCall(@NotNull JSFunction constructor, @NotNull List<JSParameter> parameters) {
        Object[] bodies;
        JSBlockStatement blockStatement;
        if (constructor == null) {
            ES6ExtractSuperProcessor.$$$reportNull$$$0(10);
        }
        if (parameters == null) {
            ES6ExtractSuperProcessor.$$$reportNull$$$0(11);
        }
        if ((blockStatement = (JSBlockStatement)ObjectUtils.tryCast((Object)ArrayUtil.getFirstElement((Object[])(bodies = constructor.getBody())), JSBlockStatement.class)) == null) {
            return;
        }
        JSStatement firstStatement = (JSStatement)ArrayUtil.getFirstElement((Object[])blockStatement.getStatements());
        JSStatement superCall = JSChangeUtil.createStatementPsiFromTextWithContext(String.format("super(%s)%s", StringUtil.join(parameters, t -> t.getName(), (String)","), JSCodeStyleSettings.getSemicolon((PsiElement)constructor.getContainingFile())), (PsiElement)constructor, JSStatement.class);
        if (superCall == null) {
            return;
        }
        if (firstStatement != null) {
            blockStatement.addBefore((PsiElement)superCall, (PsiElement)firstStatement);
        } else {
            ASTNode lbrace = blockStatement.getNode().findChildByType(JSTokenTypes.LBRACE);
            if (lbrace == null) {
                return;
            }
            blockStatement.addAfter((PsiElement)superCall, lbrace.getPsi());
        }
    }

    private void convertReferences(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            ES6ExtractSuperProcessor.$$$reportNull$$$0(12);
        }
        this.bindRefsToTarget(usages);
        JSConvertReferencesToSuperUtil util = new JSConvertReferencesToSuperUtil(this.myParameters.membersToMove, this.myMembersAfterMove, this.myParameters.mode, this.myParameters.sourceClass, this.myTargetClass);
        HashMap<PsiElement, JSConvertReferencesToSuperUtil.Status> variablesResults = new HashMap<PsiElement, JSConvertReferencesToSuperUtil.Status>();
        for (JSElement memberAfterMove : this.myMembersAfterMove) {
            List<JSReferenceExpression> referenceExpressions = ES6ExtractSuperProcessor.collectReferenceExpressions(memberAfterMove);
            for (JSReferenceExpression expression : referenceExpressions) {
                if (!util.getSubjectClass((JSElement)expression).isEquivalentTo(expression.resolve()) || !util.canTurnReferenceToSuper(expression, variablesResults)) continue;
                ES6ExtractSuperProcessor.rebindReferenceExpression(expression, this.myTargetClass);
            }
        }
    }

    private static List<JSReferenceExpression> collectReferenceExpressions(@NotNull JSElement scope) {
        if (scope == null) {
            ES6ExtractSuperProcessor.$$$reportNull$$$0(13);
        }
        final ArrayList result = ContainerUtil.newArrayList();
        if (scope instanceof JSClass) {
            return ContainerUtil.emptyList();
        }
        scope.accept((PsiElementVisitor)new JSRecursiveElementVisitor(){

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                result.add(node);
                super.visitJSReferenceExpression(node);
            }
        });
        return result;
    }

    private void bindRefsToTarget(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            ES6ExtractSuperProcessor.$$$reportNull$$$0(14);
        }
        com.intellij.util.containers.HashSet filesToOptimizeImports = new com.intellij.util.containers.HashSet();
        for (UsageInfo usage : usages) {
            JSReferenceExpression refExpr = (JSReferenceExpression)usage.getElement();
            if (refExpr == null) continue;
            refExpr = ES6ExtractSuperProcessor.rebindReferenceExpression(refExpr, this.myTargetClass);
            filesToOptimizeImports.add(refExpr.getContainingFile());
        }
        for (PsiFile affectedFile : filesToOptimizeImports) {
            ES6CreateImportUtil.insertImport((PsiElement)affectedFile, (JSQualifiedNamedElement)this.myTargetClass, this.myTargetClass.getName());
            ES6CreateImportUtil.optimizeImports((PsiElement)affectedFile);
        }
    }

    @NotNull
    private static JSReferenceExpression rebindReferenceExpression(@NotNull JSReferenceExpression refExpr, @NotNull JSClass targetClass) {
        if (refExpr == null) {
            ES6ExtractSuperProcessor.$$$reportNull$$$0(15);
        }
        if (targetClass == null) {
            ES6ExtractSuperProcessor.$$$reportNull$$$0(16);
        }
        if (refExpr.getQualifier() instanceof JSReferenceExpression) {
            refExpr.deleteChildRange((PsiElement)refExpr.getQualifier(), refExpr.getQualifier().getNextSibling());
        }
        String targetName = targetClass.getName();
        JSReferenceExpression jSReferenceExpression = refExpr = JSReferenceExpressionImpl.bindToElement(refExpr, targetName, (PsiNamedElement)targetClass, false);
        if (jSReferenceExpression == null) {
            ES6ExtractSuperProcessor.$$$reportNull$$$0(17);
        }
        return jSReferenceExpression;
    }

    @Nullable
    private static JSClass createSuperClass(@NotNull ES6ExtractSuperParameters parameters, @NotNull String name) {
        PsiFile destinationPsiFile;
        if (parameters == null) {
            ES6ExtractSuperProcessor.$$$reportNull$$$0(18);
        }
        if (name == null) {
            ES6ExtractSuperProcessor.$$$reportNull$$$0(19);
        }
        if ((destinationPsiFile = ES6ExtractSuperProcessor.getDestinationPsiFile(parameters)) == null) {
            return null;
        }
        Collection<TypeScriptTypeParameter> referencedGenerics = ES6ExtractSuperProcessor.getReferencedGenericParameters(parameters.membersToMove, parameters.sourceClass);
        JSClass created = ES6ExtractSuperProcessor.createEmptyES6Class(parameters, name, referencedGenerics);
        if (created == null) {
            return null;
        }
        PsiElement insertionAnchor = destinationPsiFile == parameters.sourceClass.getContainingFile() ? (PsiElement)ObjectUtils.coalesce((Object)JSUtils.findSourceAnchor((PsiElement)parameters.sourceClass, false), (Object)parameters.sourceClass) : null;
        insertionAnchor = JSPsiImplUtils.findLeadingCommentOrSelf(insertionAnchor);
        created = insertionAnchor != null ? (JSClass)insertionAnchor.getParent().addBefore((PsiElement)created, insertionAnchor) : (JSClass)destinationPsiFile.add((PsiElement)created);
        String superText = created.getName() + (!referencedGenerics.isEmpty() ? "<" + StringUtil.join(referencedGenerics, t -> t.getName(), (String)", ") + ">" : "");
        JSRefactoringUtil.addToSupersList(parameters.sourceClass, superText, !parameters.classNotInterface);
        if (destinationPsiFile != parameters.sourceClass.getContainingFile()) {
            ES6CreateImportUtil.insertImport((PsiElement)parameters.sourceClass.getContainingFile(), (JSQualifiedNamedElement)created, created.getName());
        }
        return created;
    }

    @NotNull
    private static Collection<TypeScriptTypeParameter> getReferencedGenericParameters(@NotNull JSMemberInfo[] toMove, @NotNull JSClass sourceClass) {
        TypeScriptTypeParameterListOwner parameterListOwner;
        if (toMove == null) {
            ES6ExtractSuperProcessor.$$$reportNull$$$0(20);
        }
        if (sourceClass == null) {
            ES6ExtractSuperProcessor.$$$reportNull$$$0(21);
        }
        if ((parameterListOwner = (TypeScriptTypeParameterListOwner)ObjectUtils.tryCast((Object)sourceClass, TypeScriptTypeParameterListOwner.class)) == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                ES6ExtractSuperProcessor.$$$reportNull$$$0(22);
            }
            return list;
        }
        TypeScriptTypeParameterList typeParameterList = parameterListOwner.getTypeParameterList();
        if (typeParameterList == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                ES6ExtractSuperProcessor.$$$reportNull$$$0(23);
            }
            return list;
        }
        HashSet typeParameters = ContainerUtil.newHashSet((Object[])typeParameterList.getTypeParameters());
        HashSet result = ContainerUtil.newHashSet();
        for (JSMemberInfo info : toMove) {
            PsiTreeUtil.processElements((PsiElement)info.getMember(), e -> {
                if (!(e instanceof JSReferenceExpression)) {
                    return true;
                }
                PsiElement resolveResult = ((JSReferenceExpression)e).resolve();
                if (resolveResult instanceof TypeScriptTypeParameter && typeParameters.contains(resolveResult)) {
                    result.add((TypeScriptTypeParameter)resolveResult);
                    return false;
                }
                return true;
            });
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            ES6ExtractSuperProcessor.$$$reportNull$$$0(24);
        }
        return hashSet;
    }

    @Nullable
    private static JSClass createEmptyES6Class(@NotNull ES6ExtractSuperParameters parameters, @NotNull String name, @NotNull Collection<TypeScriptTypeParameter> genericParameters) {
        PsiFile destinationPsiFile;
        if (parameters == null) {
            ES6ExtractSuperProcessor.$$$reportNull$$$0(25);
        }
        if (name == null) {
            ES6ExtractSuperProcessor.$$$reportNull$$$0(26);
        }
        if (genericParameters == null) {
            ES6ExtractSuperProcessor.$$$reportNull$$$0(27);
        }
        if ((destinationPsiFile = ES6ExtractSuperProcessor.getDestinationPsiFile(parameters)) == null) {
            return null;
        }
        boolean isExported = destinationPsiFile != parameters.sourceClass.getContainingFile() || ES6PsiUtil.findExternalModule((PsiElement)parameters.sourceClass) != null && ES6ImportHandler.isExportedWithNameOrDefault((PsiElement)parameters.sourceClass) && parameters.mode != JSExtractSuperMode.ExtractSuper;
        StringBuilder result = new StringBuilder();
        if (isExported) {
            result.append("export ");
        }
        if (parameters.classNotInterface && ContainerUtil.or((Object[])parameters.membersToMove, m -> m.isToAbstract())) {
            result.append("abstract ");
        }
        result.append(parameters.classNotInterface ? "class " : "interface ");
        result.append(name);
        if (!ContainerUtil.isEmpty(genericParameters)) {
            result.append("<");
            result.append(StringUtil.join(genericParameters, t -> t.getText(), (String)", "));
            result.append(">");
        }
        result.append("{}");
        String text = result.toString();
        return (JSClass)ObjectUtils.assertNotNull((Object)JSChangeUtil.createStatementPsiFromTextWithContext(text, (PsiElement)parameters.sourceClass, JSClass.class));
    }

    @Nullable
    private static PsiFile getDestinationPsiFile(@NotNull ES6ExtractSuperParameters parameters) {
        VirtualFile destinationVirtualFile;
        if (parameters == null) {
            ES6ExtractSuperProcessor.$$$reportNull$$$0(28);
        }
        if ((destinationVirtualFile = LocalFileSystem.getInstance().findFileByPath(Objects.requireNonNull(parameters.destinationFileName))) == null) {
            return null;
        }
        PsiFile destinationPsiFile = parameters.sourceClass.getManager().findFile(destinationVirtualFile);
        if (destinationPsiFile == null) {
            return null;
        }
        return destinationPsiFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 17: 
            case 22: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 17: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 17: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/extractSuper/ES6ExtractSuperProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalParameter";
                break;
            }
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 11: 
            case 18: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpr";
                break;
            }
            case 19: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toMove";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceClass";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/extractSuper/ES6ExtractSuperProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "rebindReferenceExpression";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencedGenericParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 17: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "convertFieldParameterToParameter";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createSuperConstructor";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "ensureSuperCall";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "convertReferences";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collectReferenceExpressions";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "bindRefsToTarget";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "rebindReferenceExpression";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createSuperClass";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getReferencedGenericParameters";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyES6Class";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getDestinationPsiFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 17: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

