/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.moveMembers;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.JSChangeVisibilityUtil;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.refactoring.moveMembers.JSMoveMembersOptions;
import com.intellij.lang.javascript.refactoring.util.ActionScriptRefactoringUtil;
import com.intellij.lang.javascript.refactoring.util.JSMemberUsageInfo;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringConflictsUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandler;
import com.intellij.refactoring.move.MoveMemberViewDescriptor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSMoveMembersProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)JSMoveMembersProcessor.class.getName());
    private JSClass myTargetClass;
    private final Set<JSAttributeListOwner> myMembersToMove = new LinkedHashSet<JSAttributeListOwner>();
    private final MoveCallback myMoveCallback;
    private final JSClass mySourceClass;
    @Nullable
    private String myNewVisibility;
    private String myCommandName = JSBundle.message((String)"move.members.refactoring.name", (Object[])new Object[0]);

    public JSMoveMembersProcessor(Project project, MoveCallback moveCallback, JSClass sourceClass, GlobalSearchScope scope, JSMoveMembersOptions options) {
        super(project);
        this.myMoveCallback = moveCallback;
        this.mySourceClass = sourceClass;
        Object[] members = options.getSelectedMembers();
        this.myMembersToMove.clear();
        ContainerUtil.addAll(this.myMembersToMove, (Object[])members);
        this.myTargetClass = (JSClass)JSDialectSpecificHandlersFactory.forLanguage(JavaScriptSupportLoader.ECMA_SCRIPT_L4).getClassResolver().findClassByQName(options.getTargetClassName(), scope);
        this.setCommandName(sourceClass, (PsiElement[])members);
        this.myNewVisibility = options.getMemberVisibility();
    }

    protected String getCommandName() {
        return this.myCommandName;
    }

    private void setCommandName(JSClass sourceClass, PsiElement[] members) {
        StringBuilder commandName = new StringBuilder();
        commandName.append(MoveHandler.REFACTORING_NAME);
        commandName.append(" ");
        boolean first = true;
        for (PsiElement member : members) {
            if (member instanceof JSFunction && ((JSFunction)member).isSetProperty() && sourceClass.findFunctionByNameAndKind(((JSFunction)member).getName(), JSFunction.FunctionKind.GETTER) != null) continue;
            if (!first) {
                commandName.append(", ");
            }
            commandName.append(member instanceof JSVariable ? JSFormatUtil.formatField((JSTypeDeclarationOwner)((JSVariable)member), 1) : JSFormatUtil.formatMethod((JSFunction)member, 257, 0, 0, null));
            first = false;
        }
        this.myCommandName = commandName.toString();
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            JSMoveMembersProcessor.$$$reportNull$$$0(0);
        }
        MoveMemberViewDescriptor moveMemberViewDescriptor = new MoveMemberViewDescriptor(PsiUtilCore.toPsiElementArray(this.myMembersToMove));
        if (moveMemberViewDescriptor == null) {
            JSMoveMembersProcessor.$$$reportNull$$$0(1);
        }
        return moveMemberViewDescriptor;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        UsageInfo[] usageInfoArray = JSRefactoringUtil.getUsages(this.myMembersToMove, this.myTargetClass);
        if (usageInfoArray == null) {
            JSMoveMembersProcessor.$$$reportNull$$$0(2);
        }
        return usageInfoArray;
    }

    protected void refreshElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            JSMoveMembersProcessor.$$$reportNull$$$0(3);
        }
        LOG.assertTrue(this.myMembersToMove.size() == elements.length);
        this.myMembersToMove.clear();
        for (PsiElement element : elements) {
            this.myMembersToMove.add((JSAttributeListOwner)element);
        }
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            JSMoveMembersProcessor.$$$reportNull$$$0(4);
        }
        try {
            Collection<PsiFile> filesWithUsages = ActionScriptRefactoringUtil.qualifyIncomingReferences(usages);
            HashSet<String> importsInTargetFile = new HashSet<String>();
            HashSet<String> namespacesInTargetFile = new HashSet<String>();
            ArrayList<FormatFixer> postponedFormatters = new ArrayList<FormatFixer>();
            JSRefactoringUtil.addRemovalFormatters(this.mySourceClass, this.myMembersToMove, (Condition<JSFunction>)Conditions.alwaysTrue(), (Condition<JSVariable>)Conditions.alwaysTrue(), postponedFormatters);
            for (JSAttributeListOwner member : this.myMembersToMove) {
                RefactoringElementListener elementListener = this.getTransaction().getElementListener((PsiElement)member);
                ActionScriptRefactoringUtil.fixOutgoingReferences((PsiElement)member, importsInTargetFile, namespacesInTargetFile, this.myMembersToMove, this.myTargetClass, false, this.myNewVisibility != null && !"escalate".equals(this.myNewVisibility));
                if (member instanceof JSVariable) {
                    ActionScriptRefactoringUtil.fixOutgoingReferences((PsiElement)member.getAttributeList(), importsInTargetFile, namespacesInTargetFile, this.myMembersToMove, this.myTargetClass, false, this.myNewVisibility != null && !"escalate".equals(this.myNewVisibility));
                }
                JSAttributeListOwner newMember = JSMoveMembersProcessor.doMove(member, this.myTargetClass, postponedFormatters);
                elementListener.elementMoved((PsiElement)newMember);
                this.fixVisibility(newMember, usages);
                postponedFormatters.add(FormatFixer.create(JSRefactoringUtil.getElementToFormat((PsiElement)newMember), FormatFixer.Mode.Reformat));
            }
            JSRefactoringUtil.postProcess((PsiElement)this.mySourceClass, (JSQualifiedNamedElement)this.myTargetClass, filesWithUsages, importsInTargetFile, namespacesInTargetFile, postponedFormatters, true, false);
            this.myMembersToMove.clear();
            if (this.myMoveCallback != null) {
                this.myMoveCallback.refactoringCompleted();
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private void fixVisibility(JSAttributeListOwner member, UsageInfo[] usages) throws IncorrectOperationException {
        JSAttributeList modifierList = member.getAttributeList();
        if (this.myNewVisibility == null) {
            return;
        }
        if ("escalate".equals(this.myNewVisibility)) {
            PsiElement place;
            UsageInfo usage;
            JSAttributeList.AccessType visibility = modifierList.getAccessType();
            UsageInfo[] usageInfoArray = usages;
            int n = usageInfoArray.length;
            for (int i = 0; !(i >= n || (usage = usageInfoArray[i]) instanceof JSMemberUsageInfo && (place = usage.getElement()) != null && (visibility = JSVisibilityUtil.getEscalatedVisibility(member, place, visibility, JSVisibilityUtil.DEFAULT_OPTIONS)) == JSAttributeList.AccessType.PUBLIC); ++i) {
            }
            JSChangeVisibilityUtil.setVisibility(member, visibility);
        } else {
            JSChangeVisibilityUtil.setVisibility(member, this.myNewVisibility);
        }
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            JSMoveMembersProcessor.$$$reportNull$$$0(5);
        }
        if (this.myTargetClass == null) {
            return true;
        }
        MultiMap conflicts = new MultiMap();
        JSRefactoringConflictsUtil.checkMembersAlreadyExist(this.myMembersToMove, this.myTargetClass, (MultiMap<PsiElement, String>)conflicts);
        for (JSAttributeListOwner member : this.myMembersToMove) {
            JSRefactoringConflictsUtil.checkOutgoingReferencesAccessibility((PsiElement)member, this.myMembersToMove, (PsiElement)this.myTargetClass, true, (MultiMap<PsiElement, String>)conflicts, (Condition<PsiElement>)Conditions.alwaysTrue(), JSVisibilityUtil.DEFAULT_OPTIONS);
        }
        UsageInfo[] usages = (UsageInfo[])refUsages.get();
        JSRefactoringConflictsUtil.checkIncomingReferencesAccessibility(usages, this.myTargetClass, this.myNewVisibility, (MultiMap<PsiElement, String>)conflicts, JSVisibilityUtil.DEFAULT_OPTIONS);
        JSRefactoringConflictsUtil.analyzeModuleConflicts(this.myProject, this.myMembersToMove, usages, (PsiElement)this.myTargetClass, (MultiMap<PsiElement, String>)conflicts);
        return this.showConflicts(conflicts, usages);
    }

    public void doRun() {
        if (this.myMembersToMove.isEmpty()) {
            String message = RefactoringBundle.message((String)"no.members.selected");
            CommonRefactoringUtil.showErrorMessage((String)JSBundle.message((String)"move.members.refactoring.name", (Object[])new Object[0]), (String)message, null, (Project)this.myProject);
            return;
        }
        super.doRun();
    }

    public static JSAttributeListOwner doMove(@NotNull JSAttributeListOwner member, @NotNull JSClass targetClass, List<FormatFixer> formatters) {
        if (member == null) {
            JSMoveMembersProcessor.$$$reportNull$$$0(6);
        }
        if (targetClass == null) {
            JSMoveMembersProcessor.$$$reportNull$$$0(7);
        }
        Object insert = member instanceof JSFunction ? member.copy() : JSRefactoringUtil.getVarStatementCopy((JSVariable)member);
        PsiElement inserted = JSRefactoringUtil.addMemberToTargetClass(targetClass, insert);
        formatters.add(FormatFixer.create(inserted, FormatFixer.Mode.Reformat));
        JSRefactoringUtil.handleDocCommentAndFormat(inserted, formatters);
        JSRefactoringUtil.deleteWithNoPostponedFormatting((PsiElement)member);
        return inserted instanceof JSFunction ? (JSAttributeListOwner)inserted : (JSAttributeListOwner)PsiTreeUtil.getChildOfType((PsiElement)inserted, JSVariable.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/moveMembers/JSMoveMembersProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/moveMembers/JSMoveMembersProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "refreshElements";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doMove";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

