/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.integration.JSAnnotationRangeError;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLanguageServiceAnnotationResult
implements JSAnnotationRangeError {
    protected final int myColumn;
    protected final int myLine;
    protected final int myEndLine;
    protected final int myEndColumn;
    @NotNull
    protected final String myErrorText;
    @Nullable
    protected final String myTooltipText;
    @Nullable
    protected final String myCategory;
    @Nullable
    protected final String myFileAbsoluteSystemDependPath;

    @Override
    public int getColumn() {
        return this.myColumn;
    }

    @Override
    public int getLine() {
        return this.myLine;
    }

    @Override
    @NotNull
    public String getDescription() {
        String string = this.myErrorText;
        if (string == null) {
            JSLanguageServiceAnnotationResult.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    public String getTooltipText() {
        return this.myTooltipText;
    }

    @Override
    @Nullable
    public String getCategory() {
        return this.myCategory;
    }

    @Override
    @Nullable
    public String getAbsoluteFilePath() {
        return this.myFileAbsoluteSystemDependPath;
    }

    @Override
    public int getEndLine() {
        return this.myEndLine;
    }

    @Override
    public int getEndColumn() {
        return this.myEndColumn;
    }

    public static ImmutableList<JSAnnotationError> buildError(String errorText) {
        return ContainerUtil.immutableList((Object[])new JSAnnotationError[]{new JSLanguageServiceAnnotationResult(errorText, null, null, null, 0, 0, 0, 0)});
    }

    public JSLanguageServiceAnnotationResult(@NotNull String errorText, @Nullable String tooltipText, @Nullable String fileAbsolutePath, @Nullable String category, int line, int column, int lineEnd, int columnEnd) {
        if (errorText == null) {
            JSLanguageServiceAnnotationResult.$$$reportNull$$$0(1);
        }
        this.myCategory = category;
        this.myColumn = column - 1;
        this.myLine = line - 1;
        this.myEndLine = lineEnd - 1;
        this.myEndColumn = columnEnd - 1;
        this.myErrorText = errorText;
        this.myTooltipText = tooltipText;
        this.myFileAbsoluteSystemDependPath = fileAbsolutePath;
    }

    @Override
    @Nullable
    public ProblemHighlightType getHighlightType() {
        return null;
    }

    public String toString() {
        return "JSLanguageCompilerResult{myColumn=" + this.myColumn + ", myLine=" + this.myLine + ", myEndLine=" + this.myEndLine + ", myEndColumn=" + this.myEndColumn + ", myErrorText='" + this.myErrorText + '\'' + ", myCategory='" + this.myCategory + '\'' + ", myFileAbsoluteSystemDependPath='" + this.myFileAbsoluteSystemDependPath + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSLanguageServiceAnnotationResult result = (JSLanguageServiceAnnotationResult)o;
        if (this.myColumn != result.myColumn) {
            return false;
        }
        if (this.myLine != result.myLine) {
            return false;
        }
        if (this.myEndLine != result.myEndLine) {
            return false;
        }
        if (this.myEndColumn != result.myEndColumn) {
            return false;
        }
        if (!this.myErrorText.equals(result.myErrorText)) {
            return false;
        }
        if (this.myCategory != null ? !this.myCategory.equals(result.myCategory) : result.myCategory != null) {
            return false;
        }
        return !(this.myFileAbsoluteSystemDependPath != null ? !this.myFileAbsoluteSystemDependPath.equals(result.myFileAbsoluteSystemDependPath) : result.myFileAbsoluteSystemDependPath != null);
    }

    public int hashCode() {
        int result = this.myColumn;
        result = 31 * result + this.myLine;
        result = 31 * result + this.myEndLine;
        result = 31 * result + this.myEndColumn;
        result = 31 * result + this.myErrorText.hashCode();
        result = 31 * result + (this.myCategory != null ? this.myCategory.hashCode() : 0);
        result = 31 * result + (this.myFileAbsoluteSystemDependPath != null ? this.myFileAbsoluteSystemDependPath.hashCode() : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/service/JSLanguageServiceAnnotationResult";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/service/JSLanguageServiceAnnotationResult";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

