/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.impl.ErrorUtil;
import com.intellij.lang.javascript.validation.fixes.ES6ConvertSpecifierToDefaultFix;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ThrowableRunnable;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0002\u001a\u00020\bH\u0002J\b\u0010\f\u001a\u00020\u0006H\u0017J\b\u0010\r\u001a\u00020\u0006H\u0016J3\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0096\u0002J(\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/lang/javascript/validation/fixes/ES6ConvertSpecifierToDefaultFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "element", "Lcom/intellij/lang/ecmascript6/psi/ES6ImportSpecifier;", "(Lcom/intellij/lang/ecmascript6/psi/ES6ImportSpecifier;)V", "specifierName", "", "findDefaultExportElement", "Lcom/intellij/lang/javascript/psi/JSElement;", "declaration", "Lcom/intellij/lang/ecmascript6/psi/ES6ImportDeclaration;", "getDefaultElementName", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "isAvailable", "", "JavaScriptLanguage"})
public final class ES6ConvertSpecifierToDefaultFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final String specifierName;

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Object[] objectArray;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)startElement, (String)"startElement");
        Intrinsics.checkParameterIsNotNull((Object)endElement, (String)"endElement");
        if (!(startElement instanceof ES6ImportSpecifier)) {
            return;
        }
        ES6ImportDeclaration eS6ImportDeclaration = ((ES6ImportSpecifier)startElement).getDeclaration();
        if (eS6ImportDeclaration == null) {
            return;
        }
        ES6ImportDeclaration declaration = eS6ImportDeclaration;
        Object[] objectArray2 = objectArray = (Object[])declaration.getImportedBindings();
        if (!(objectArray2.length == 0)) {
            return;
        }
        ES6ImportDeclaration eS6ImportDeclaration2 = declaration;
        Intrinsics.checkExpressionValueIsNotNull((Object)eS6ImportDeclaration2, (String)"declaration");
        JSElement jSElement = this.findDefaultExportElement(eS6ImportDeclaration2);
        if (jSElement == null) {
            return;
        }
        JSElement element = jSElement;
        String string = this.getDefaultElementName(element);
        if (string == null) {
            return;
        }
        String defaultElementName = string;
        if (StringUtil.isEmpty((String)defaultElementName)) {
            return;
        }
        WriteAction.run((ThrowableRunnable)new ThrowableRunnable<E>(declaration, defaultElementName){
            final /* synthetic */ ES6ImportDeclaration $declaration;
            final /* synthetic */ String $defaultElementName;

            public final void run() {
                block4: {
                    ES6ImportSpecifier specifier;
                    Object object;
                    block3: {
                        Object[] objectArray;
                        ES6ImportedBinding eS6ImportedBinding = ES6ImportPsiUtil.insertBinding(this.$declaration, this.$defaultElementName);
                        if (eS6ImportedBinding == null) {
                            return;
                        }
                        ES6ImportedBinding binding = eS6ImportedBinding;
                        ES6ImportDeclaration eS6ImportDeclaration = binding.getDeclaration();
                        if (eS6ImportDeclaration == null) {
                            return;
                        }
                        ES6ImportDeclaration newDeclaration = eS6ImportDeclaration;
                        Object[] objectArray2 = objectArray = (Object[])newDeclaration.getImportSpecifiers();
                        for (int i = 0; i < objectArray2.length; ++i) {
                            Object object2 = objectArray2[i];
                            ES6ImportSpecifier it = (ES6ImportSpecifier)object2;
                            if (!Intrinsics.areEqual((Object)it.getReferenceName(), (Object)this.$defaultElementName)) continue;
                            object = object2;
                            break block3;
                        }
                        object = null;
                    }
                    ES6ImportSpecifier eS6ImportSpecifier = specifier = (ES6ImportSpecifier)object;
                    if (eS6ImportSpecifier == null) break block4;
                    eS6ImportSpecifier.delete();
                }
            }
            {
                this.$declaration = eS6ImportDeclaration;
                this.$defaultElementName = string;
            }
        });
    }

    @NotNull
    public String getText() {
        String string = JSBundle.message((String)"es6.change.to.default.fix", (Object[])new Object[]{this.specifierName});
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JSBundle.message(\"es6.ch\u2026ault.fix\", specifierName)");
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Object[] objectArray;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)startElement, (String)"startElement");
        Intrinsics.checkParameterIsNotNull((Object)endElement, (String)"endElement");
        if (!(startElement instanceof ES6ImportSpecifier)) {
            return false;
        }
        ES6ImportDeclaration eS6ImportDeclaration = ((ES6ImportSpecifier)startElement).getDeclaration();
        if (eS6ImportDeclaration == null) {
            return false;
        }
        ES6ImportDeclaration declaration = eS6ImportDeclaration;
        Object[] objectArray2 = objectArray = (Object[])declaration.getImportedBindings();
        if (!(objectArray2.length == 0) || ErrorUtil.containsError((PsiElement)declaration)) {
            return false;
        }
        ES6ImportDeclaration eS6ImportDeclaration2 = declaration;
        Intrinsics.checkExpressionValueIsNotNull((Object)eS6ImportDeclaration2, (String)"declaration");
        JSElement jSElement = this.findDefaultExportElement(eS6ImportDeclaration2);
        if (jSElement == null) {
            return false;
        }
        JSElement element = jSElement;
        String string = this.getDefaultElementName(element);
        if (string == null) {
            return false;
        }
        String defaultElementName = string;
        String name = ((ES6ImportSpecifier)startElement).getReferenceName();
        return StringUtil.equals((CharSequence)name, (CharSequence)defaultElementName);
    }

    private final String getDefaultElementName(JSElement element) {
        if (element instanceof JSExportAssignment) {
            JSElement jSElement = ((JSExportAssignment)element).getStubSafeElement();
            return jSElement != null ? jSElement.getName() : null;
        }
        return element.getName();
    }

    /*
     * WARNING - void declaration
     */
    private final JSElement findDefaultExportElement(ES6ImportDeclaration declaration) {
        Object v1;
        block3: {
            void $receiver$iv;
            ES6FromClause eS6FromClause = declaration.getFromClause();
            if (eS6FromClause == null) {
                return null;
            }
            ES6FromClause clause = eS6FromClause;
            Collection elements = clause.resolveReferencedElements();
            if (elements.isEmpty()) {
                return null;
            }
            Sequence sequence = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)elements), (Function1)findDefaultExportElement.1.INSTANCE);
            for (Object element$iv : $receiver$iv) {
                JSElement it = (JSElement)element$iv;
                if (!(it != null)) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        return v1;
    }

    public ES6ConvertSpecifierToDefaultFix(@NotNull ES6ImportSpecifier element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super((PsiElement)element);
        String string = StringUtil.notNullize((String)element.getName());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.notNullize(element.name)");
        this.specifierName = string;
    }
}

