/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.refactoring.JSChangeVisibilityUtil;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.lang.javascript.validation.fixes.JSInsertModifierFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSetElementVisibilityFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final JSAttributeList.AccessType myVisibility;
    private final String myNamespace;

    public JSSetElementVisibilityFix(@NotNull JSAttributeListOwner method, @Nullable JSAttributeList.AccessType visibility, @Nullable String namespace) {
        if (method == null) {
            JSSetElementVisibilityFix.$$$reportNull$$$0(0);
        }
        super((PsiElement)method);
        this.myVisibility = visibility;
        this.myNamespace = namespace;
    }

    @NotNull
    public String getText() {
        JSAttributeListOwner myClassOrMethod = (JSAttributeListOwner)this.getStartElement();
        if (myClassOrMethod == null) {
            if ("" == null) {
                JSSetElementVisibilityFix.$$$reportNull$$$0(1);
            }
            return "";
        }
        String string = JSInsertModifierFix.getSetModifierText(myClassOrMethod, this.myVisibility != null ? JSFormatUtil.formatVisibility(this.myVisibility, (PsiElement)myClassOrMethod) : this.myNamespace);
        if (string == null) {
            JSSetElementVisibilityFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            JSSetElementVisibilityFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            JSSetElementVisibilityFix.$$$reportNull$$$0(4);
        }
        if (file == null) {
            JSSetElementVisibilityFix.$$$reportNull$$$0(5);
        }
        if (startElement == null) {
            JSSetElementVisibilityFix.$$$reportNull$$$0(6);
        }
        if (endElement == null) {
            JSSetElementVisibilityFix.$$$reportNull$$$0(7);
        }
        JSChangeVisibilityUtil.setVisibility((JSAttributeListOwner)startElement, this.myVisibility, this.myNamespace);
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/JSSetElementVisibilityFix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/JSSetElementVisibilityFix";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

