/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.javascript.ecmascript6.TypeScriptAnnotatorCheckerProvider;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.service.JSLanguageServiceBase;
import com.intellij.lang.javascript.validation.JSEmptyTypeChecker;
import com.intellij.lang.javascript.validation.JSProblemReporter;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptLanguageServiceAnnotatorCheckerProvider
extends TypeScriptAnnotatorCheckerProvider {
    private final Project myProject;
    @Nullable
    private final TypeScriptCompilerSettings mySettings;

    public TypeScriptLanguageServiceAnnotatorCheckerProvider(@NotNull Project project, @Nullable TypeScriptCompilerSettings settings) {
        if (project == null) {
            TypeScriptLanguageServiceAnnotatorCheckerProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.mySettings = settings;
    }

    @Override
    protected boolean isAvailable(@NotNull PsiElement context) {
        if (context == null) {
            TypeScriptLanguageServiceAnnotatorCheckerProvider.$$$reportNull$$$0(1);
        }
        if (this.mySettings == null) {
            return false;
        }
        PsiFile file = context.getContainingFile();
        if (!(file instanceof JSFile)) {
            return false;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null || !virtualFile.isValid()) {
            return false;
        }
        JSLanguageServiceBase service = this.getService(virtualFile);
        return TypeScriptLanguageServiceAnnotatorCheckerProvider.checkServiceIsAvailable(this.myProject, service, this.mySettings);
    }

    public static boolean checkServiceIsAvailable(@NotNull Project project, @Nullable JSLanguageServiceBase service, @NotNull TypeScriptCompilerSettings settings) {
        if (project == null) {
            TypeScriptLanguageServiceAnnotatorCheckerProvider.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            TypeScriptLanguageServiceAnnotatorCheckerProvider.$$$reportNull$$$0(3);
        }
        if (!TypeScriptLanguageServiceUtil.isServiceEnabled(project)) {
            return false;
        }
        if (service == null || !service.checkCanUseService()) {
            return false;
        }
        service.initialize();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return TypeScriptLanguageServiceUtil.USE_SERVICE;
        }
        return settings.useServiceForProjectsWithoutConfig() || TypeScriptConfigService.Provider.hasConfigs(project);
    }

    private JSLanguageServiceBase getService(VirtualFile virtualFile) {
        return TypeScriptCompilerService.getServiceForFile(this.myProject, virtualFile);
    }

    @Override
    @NotNull
    public JSTypeChecker<Annotation> getTypeChecker(@NotNull JSProblemReporter<Annotation> reporter) {
        if (reporter == null) {
            TypeScriptLanguageServiceAnnotatorCheckerProvider.$$$reportNull$$$0(4);
        }
        JSEmptyTypeChecker jSEmptyTypeChecker = JSEmptyTypeChecker.getInstance();
        if (jSEmptyTypeChecker == null) {
            TypeScriptLanguageServiceAnnotatorCheckerProvider.$$$reportNull$$$0(5);
        }
        return jSEmptyTypeChecker;
    }

    @Override
    protected boolean skipErrors() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceAnnotatorCheckerProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceAnnotatorCheckerProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkServiceIsAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTypeChecker";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

