/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.psi;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.typescript.psi.TypeScriptAutoImportUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptAddImportExecutor {
    @NotNull
    private final String myImportedName;
    @Nullable
    private final Editor myEditor;
    @NotNull
    private final PsiElement myPlace;
    @NotNull
    private final Project myProject;

    public TypeScriptAddImportExecutor(@NotNull String name, @Nullable Editor editor, @NotNull PsiElement place) {
        if (name == null) {
            TypeScriptAddImportExecutor.$$$reportNull$$$0(0);
        }
        if (place == null) {
            TypeScriptAddImportExecutor.$$$reportNull$$$0(1);
        }
        this.myImportedName = name;
        this.myEditor = editor;
        this.myPlace = place;
        this.myProject = place.getProject();
    }

    public final void execute(@NotNull JSElement elementToImport) {
        if (elementToImport == null) {
            TypeScriptAddImportExecutor.$$$reportNull$$$0(2);
        }
        PsiFile file = this.myPlace.getContainingFile();
        if (!this.executeImpl(elementToImport)) {
            TypeScriptAutoImportUtil.showError(this.myProject, this.myEditor);
        }
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart(file);
    }

    private boolean executeForNamespaceAndModuleImport(@NotNull JSElement elementToImport) {
        if (elementToImport == null) {
            TypeScriptAddImportExecutor.$$$reportNull$$$0(3);
        }
        PsiElement current = elementToImport.getParent();
        PsiElement lastElement = null;
        while (current != null) {
            PsiElement parent = current.getParent();
            if (parent != null && ES6PsiUtil.isExternalModule(parent)) {
                lastElement = current;
                break;
            }
            current = parent;
        }
        if (!(lastElement instanceof JSQualifiedNamedElement)) {
            return false;
        }
        JSQualifiedNamedElement element = (JSQualifiedNamedElement)lastElement;
        String moduleName = element.getName();
        if (moduleName == null) {
            return false;
        }
        if (!this.hasImportForNamespace(element, moduleName) && !new TypeScriptAddImportExecutor(moduleName, this.myEditor, this.myPlace).executeImpl((JSElement)element)) {
            return false;
        }
        return this.executeForImportType(elementToImport, ES6ImportPsiUtil.ImportExportType.TS_NAMESPACE);
    }

    private boolean hasImportForNamespace(@NotNull JSQualifiedNamedElement element, @NotNull String name) {
        PsiElement scope;
        if (element == null) {
            TypeScriptAddImportExecutor.$$$reportNull$$$0(4);
        }
        if (name == null) {
            TypeScriptAddImportExecutor.$$$reportNull$$$0(5);
        }
        if ((scope = ES6CreateImportUtil.getScopeToAdd(this.myPlace, false)) == null) {
            return false;
        }
        JSTypeResolveResult result = TypeScriptImportHandler.getInstance().resolveName(name, this.myPlace);
        return result.getElements().contains(element);
    }

    private boolean executeImpl(@NotNull JSElement elementToImport) {
        if (elementToImport == null) {
            TypeScriptAddImportExecutor.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        JSElement elementContainer = ES6PsiUtil.getExportScope((PsiElement)elementToImport);
        JSElement placeContainer = ES6PsiUtil.getExportScope(this.myPlace);
        if (elementContainer == null || elementContainer.isEquivalentTo((PsiElement)placeContainer)) {
            return true;
        }
        JSQualifiedName namespace = TypeScriptAddImportExecutor.getElementNamespace(elementToImport);
        ES6ImportPsiUtil.ImportExportType importType = this.getImportType(elementToImport, (PsiElement)elementContainer, namespace);
        if (importType == null) {
            return false;
        }
        return this.executeForImportType(elementToImport, importType);
    }

    @Nullable
    private static JSQualifiedName getElementNamespace(@NotNull JSElement elementToImport) {
        if (elementToImport == null) {
            TypeScriptAddImportExecutor.$$$reportNull$$$0(7);
        }
        if (elementToImport instanceof JSQualifiedNamedElement) {
            return ((JSQualifiedNamedElement)elementToImport).getNamespace();
        }
        return null;
    }

    public boolean executeForImportType(@NotNull JSElement elementToImport, @NotNull ES6ImportPsiUtil.ImportExportType importType) {
        String moduleOrNamespaceName;
        if (elementToImport == null) {
            TypeScriptAddImportExecutor.$$$reportNull$$$0(8);
        }
        if (importType == null) {
            TypeScriptAddImportExecutor.$$$reportNull$$$0(9);
        }
        if (importType == ES6ImportPsiUtil.ImportExportType.TS_NS_AND_MODULE) {
            return this.executeForNamespaceAndModuleImport(elementToImport);
        }
        JSQualifiedName namespace = TypeScriptAddImportExecutor.getElementNamespace(elementToImport);
        JSElement elementContainer = ES6PsiUtil.getExportScope((PsiElement)elementToImport);
        if (elementContainer == null) {
            return false;
        }
        PsiElement externalModule = null;
        if (importType == ES6ImportPsiUtil.ImportExportType.TS_NAMESPACE) {
            moduleOrNamespaceName = namespace == null ? this.myImportedName : namespace + "." + this.myImportedName;
        } else {
            String externalModuleName = null;
            PsiElement rawExternalModule = this.getRawExternalModule(elementToImport, (PsiElement)elementContainer, namespace);
            if (rawExternalModule == null) {
                return false;
            }
            if (rawExternalModule instanceof PsiFile) {
                PsiFile moduleFile = (PsiFile)rawExternalModule;
                JSModuleNameInfo moduleNameWithResolve = ES6CreateImportUtil.getExternalFileModuleName((PsiElement)elementToImport, moduleFile.getVirtualFile(), this.myPlace);
                if (moduleNameWithResolve != null) {
                    externalModuleName = moduleNameWithResolve.getPath();
                    VirtualFile module = moduleNameWithResolve.getResolvedFile();
                    externalModule = PsiManager.getInstance((Project)this.myProject).findFile(module);
                }
            } else if (rawExternalModule instanceof TypeScriptModule) {
                externalModule = rawExternalModule;
                String rawName = ((TypeScriptModule)rawExternalModule).getName();
                if (rawName == null) {
                    return false;
                }
                externalModuleName = ES6ImportPsiUtil.wrapWithQuotesFromSettings(StringUtil.unquoteString((String)rawName), (PsiElement)elementToImport);
            }
            if (externalModuleName == null) {
                return false;
            }
            moduleOrNamespaceName = externalModuleName;
        }
        return this.createImportOrUseExisting(elementToImport.getName(), externalModule, moduleOrNamespaceName, importType);
    }

    @Nullable
    public PsiElement getRawExternalModule(@NotNull JSElement elementToImport, @NotNull PsiElement elementContainer, @Nullable JSQualifiedName namespace) {
        PsiElement externalModuleForContainer;
        boolean isDefaultExport;
        if (elementToImport == null) {
            TypeScriptAddImportExecutor.$$$reportNull$$$0(10);
        }
        if (elementContainer == null) {
            TypeScriptAddImportExecutor.$$$reportNull$$$0(11);
        }
        if (ES6PsiUtil.isExternalModule((PsiElement)elementToImport)) {
            return elementToImport;
        }
        if (elementContainer instanceof TypeScriptModule && ((TypeScriptModule)elementContainer).isAugmentation()) {
            return elementContainer.getParent();
        }
        boolean bl = isDefaultExport = elementToImport instanceof JSPsiElementBase && ((JSPsiElementBase)elementToImport).isExportedWithDefault();
        if (namespace == null && !isDefaultExport) {
            return elementContainer.getContainingFile();
        }
        PsiElement psiElement = externalModuleForContainer = ES6PsiUtil.isExternalModule(elementContainer) ? elementContainer : elementContainer.getParent();
        if (!ES6PsiUtil.isExternalModule(externalModuleForContainer)) {
            return null;
        }
        if (externalModuleForContainer instanceof TypeScriptModule) {
            String currentModuleName = ((TypeScriptModule)externalModuleForContainer).getName();
            if (currentModuleName == null) {
                return null;
            }
            return externalModuleForContainer;
        }
        return elementContainer.getContainingFile();
    }

    public boolean createImportOrUseExisting(@Nullable String exportedName, @Nullable PsiElement externalModule, @NotNull String quotedModuleOrNamespaceName, @NotNull ES6ImportPsiUtil.ImportExportType importType) {
        PsiElement scope;
        if (quotedModuleOrNamespaceName == null) {
            TypeScriptAddImportExecutor.$$$reportNull$$$0(12);
        }
        if (importType == null) {
            TypeScriptAddImportExecutor.$$$reportNull$$$0(13);
        }
        if ((scope = ES6CreateImportUtil.getScopeToAdd(this.myPlace, importType != ES6ImportPsiUtil.ImportExportType.TS_NAMESPACE)) == null) {
            return false;
        }
        if (this.tryToUseExistingImport(quotedModuleOrNamespaceName, externalModule, importType, scope)) {
            return true;
        }
        PsiElement importPsi = this.createTypeScriptOrES6Import(exportedName, quotedModuleOrNamespaceName, importType);
        if (importPsi == null) {
            return false;
        }
        if (importPsi instanceof ES6ImportDeclaration && importType != ES6ImportPsiUtil.ImportExportType.BARE) {
            ES6CreateImportUtil.findPlaceAndInsertES6Import(scope, importPsi, StringUtil.unquoteString((String)quotedModuleOrNamespaceName), this.myEditor);
        } else {
            ES6CreateImportUtil.findPlaceAndInsertAnyImport(scope, importPsi, this.myEditor);
        }
        return true;
    }

    @Nullable
    private PsiElement createTypeScriptOrES6Import(@Nullable String exportedName, @NotNull String externalModuleName, @NotNull ES6ImportPsiUtil.ImportExportType importType) {
        if (externalModuleName == null) {
            TypeScriptAddImportExecutor.$$$reportNull$$$0(14);
        }
        if (importType == null) {
            TypeScriptAddImportExecutor.$$$reportNull$$$0(15);
        }
        if (importType.isES6()) {
            ES6ImportPsiUtil.CreateImportExportInfo info = new ES6ImportPsiUtil.CreateImportExportInfo(exportedName, this.myImportedName, importType);
            return ES6ImportPsiUtil.createImportExport(this.myPlace, info, externalModuleName);
        }
        ES6ImportPsiUtil.CreateImportExportInfo info = new ES6ImportPsiUtil.CreateImportExportInfo(this.myImportedName, importType);
        return TypeScriptAutoImportUtil.createTypeScriptImport(this.myPlace, info, externalModuleName);
    }

    @Nullable
    public ES6ImportPsiUtil.ImportExportType getImportType(@NotNull JSElement elementToImport, @NotNull PsiElement elementContainer, @Nullable JSQualifiedName namespace) {
        TypeScriptModule container;
        if (elementToImport == null) {
            TypeScriptAddImportExecutor.$$$reportNull$$$0(16);
        }
        if (elementContainer == null) {
            TypeScriptAddImportExecutor.$$$reportNull$$$0(17);
        }
        if (ES6PsiUtil.isExternalModule((PsiElement)elementToImport)) {
            return ES6ImportPsiUtil.ImportExportType.IMPORT_BINDING_ALL;
        }
        if (elementContainer instanceof TypeScriptModule && (container = (TypeScriptModule)elementContainer).isAugmentation()) {
            if (TypeScriptAutoImportUtil.isSelfExportedAugmentationModule(container)) {
                return ES6ImportPsiUtil.ImportExportType.SPECIFIER;
            }
            return null;
        }
        JSExportAssignment exportAssignment = TypeScriptAutoImportUtil.getExportAssignment(elementContainer);
        if (exportAssignment instanceof TypeScriptExportAssignment) {
            if (elementToImport instanceof TypeScriptModule) {
                return ES6ImportPsiUtil.ImportExportType.IMPORT_BINDING_ALL;
            }
            return ES6ImportPsiUtil.ImportExportType.TS_REQUIRE_IMPORT;
        }
        if (namespace != null && elementContainer instanceof TypeScriptModule && !ES6PsiUtil.isExternalModule(elementContainer)) {
            PsiElement module = ES6PsiUtil.findExternalModule(elementContainer);
            if (module == null) {
                return ES6ImportPsiUtil.ImportExportType.TS_NAMESPACE;
            }
            JSExportAssignment externalModuleExportAssignment = TypeScriptAutoImportUtil.getExportAssignment(module);
            if (externalModuleExportAssignment == null || elementContainer.getParent() != module) {
                return ES6ImportPsiUtil.ImportExportType.TS_NS_AND_MODULE;
            }
        }
        if (elementToImport instanceof JSElementBase && ((JSElementBase)elementToImport).isExportedWithDefault()) {
            return ES6ImportPsiUtil.ImportExportType.DEFAULT;
        }
        ES6ImportPsiUtil.ImportExportType isExportDefault = ES6ImportPsiUtil.ImportExportType.DEFAULT;
        if (elementToImport instanceof JSAttributeListOwner) {
            JSAttributeList attributeList = ((JSAttributeListOwner)elementToImport).getAttributeList();
            if (!(elementToImport.getParent() instanceof JSExportAssignment) && attributeList != null && elementToImport instanceof JSElementBase && ((JSElementBase)elementToImport).isExported()) {
                isExportDefault = ES6ImportPsiUtil.ImportExportType.SPECIFIER;
            }
        }
        return isExportDefault;
    }

    public boolean tryToUseExistingImport(@NotNull String externalModuleName, @Nullable PsiElement externalModule, @NotNull ES6ImportPsiUtil.ImportExportType importType, @NotNull PsiElement scope) {
        PsiElement grandParent;
        PsiElement parent;
        if (externalModuleName == null) {
            TypeScriptAddImportExecutor.$$$reportNull$$$0(18);
        }
        if (importType == null) {
            TypeScriptAddImportExecutor.$$$reportNull$$$0(19);
        }
        if (scope == null) {
            TypeScriptAddImportExecutor.$$$reportNull$$$0(20);
        }
        if ((parent = this.myPlace.getParent()) instanceof ES6ImportSpecifier && (grandParent = parent.getParent()) instanceof ES6ImportDeclaration && ((ES6ImportDeclaration)grandParent).getFromClause() == null) {
            return ES6CreateImportUtil.insertFromClause((ES6ImportDeclaration)grandParent, externalModuleName);
        }
        if (JSCodeStyleSettings.isMergeImports(this.myPlace) && importType.isES6()) {
            ES6ImportDeclaration possibleImport = ES6ImportPsiUtil.findExistingES6Import(scope, externalModule, externalModuleName, true);
            return possibleImport != null && ES6ImportPsiUtil.tryToAddImportToExistingDeclaration(possibleImport, this.myImportedName, importType);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToImport";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 13: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importType";
                break;
            }
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementContainer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quotedModuleOrNamespaceName";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalModuleName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/psi/TypeScriptAddImportExecutor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "executeForNamespaceAndModuleImport";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "hasImportForNamespace";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "executeImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementNamespace";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "executeForImportType";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getRawExternalModule";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "createImportOrUseExisting";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "createTypeScriptOrES6Import";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "getImportType";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "tryToUseExistingImport";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

