/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.psi;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGenericOrMappedTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGlobalModuleExportDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterfaceClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptNewExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptStringLiteralType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeofType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptModuleImpl;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptParameterListImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSElementImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSCoreLibraryElementsCollector;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.stubs.impl.JSQualifiedObjectStubBase;
import com.intellij.lang.javascript.psi.types.JSCompositeFunctionPropertySignatureImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeOfJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptPsiUtil {
    public static final Condition<PsiElement> IS_TS_MODULE = Conditions.instanceOf(TypeScriptModule.class);
    private static final String THIS_NAME = "this";

    @Nullable
    public static JSType getTypeFromDeclaration(StubBasedPsiElementBase element) {
        TypeScriptType resultType = TypeScriptPsiUtil.getStubOrPsiTypeElement(element);
        return resultType == null ? null : TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)resultType);
    }

    @Nullable
    public static JSClass getParentClass(@Nullable PsiElement element) {
        PsiElement secondParent;
        if (element == null) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof JSClass) {
            return (JSClass)parent;
        }
        if (parent instanceof TypeScriptObjectType && (secondParent = parent.getParent()) instanceof JSClass) {
            return (JSClass)secondParent;
        }
        return null;
    }

    public static boolean isAmbientDeclaration(@Nullable PsiElement element) {
        if (element instanceof JSAttributeListOwner) {
            while (element != null && !(element instanceof JSFile)) {
                if (TypeScriptPsiUtil.hasAmbientAttribute((JSAttributeListOwner)element)) {
                    return true;
                }
                element = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JSClass.class, TypeScriptModule.class, JSFile.class});
            }
            if (element != null && DialectDetector.isTypeScriptDefinitionFile((PsiFile)((JSFile)element))) {
                return true;
            }
        }
        return false;
    }

    public static boolean hasAmbientAttribute(@NotNull JSAttributeListOwner element) {
        if (element == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(0);
        }
        if (element instanceof TypeScriptModule && ((TypeScriptModule)element).isGlobalScopeAugmentation()) {
            return true;
        }
        JSAttributeList list = element.getAttributeList();
        return list != null && list.hasModifier(JSAttributeList.ModifierType.DECLARE);
    }

    public static boolean isNamedTypeDefinition(PsiElement element) {
        return element instanceof JSClass || element instanceof TypeScriptGenericOrMappedTypeParameter || element instanceof ES6ImportExportSpecifier || element instanceof ES6ImportedBinding || element instanceof ES6ImportExportSpecifierAlias || element instanceof TypeScriptImportStatement || element instanceof TypeScriptEnumField;
    }

    public static boolean isNamedTypeContainerDefinition(PsiElement element) {
        return element instanceof JSClass || element instanceof TypeScriptGenericOrMappedTypeParameter || TypeScriptPsiUtil.isNamespaceDefinition(element);
    }

    public static boolean isNamespaceDefinition(@Nullable PsiElement element) {
        return element instanceof TypeScriptModule || element instanceof ES6ImportedBinding || element instanceof TypeScriptImportStatement || element instanceof ES6ImportExportSpecifierAlias || element instanceof ES6ExportDefaultAssignment || element instanceof JSFile || element instanceof ES6ImportExportSpecifier || element instanceof TypeScriptGlobalModuleExportDeclaration;
    }

    @Nullable
    public static TypeScriptExportAssignment findExportAssignment(@NotNull PsiElement module) {
        if (module == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(1);
        }
        if (!DialectDetector.isTypeScript(module)) {
            return null;
        }
        TypeScriptExportAssignment exportAssignment = null;
        if (module instanceof PsiFileImpl) {
            StubElement stub = ((PsiFileImpl)module).getStub();
            if (stub != null) {
                StubElement exportAssignmentStub = stub.findChildStubByType(TypeScriptElementTypes.EXPORT_ASSIGNMENT);
                if (exportAssignmentStub != null) {
                    exportAssignment = (TypeScriptExportAssignment)exportAssignmentStub.getPsi();
                }
            } else {
                exportAssignment = (TypeScriptExportAssignment)((PsiFileImpl)module).findChildByClass(TypeScriptExportAssignment.class);
            }
        } else if (module instanceof TypeScriptModuleImpl) {
            exportAssignment = (TypeScriptExportAssignment)((TypeScriptModuleImpl)module).getStubOrPsiChild((IStubElementType)TypeScriptElementTypes.EXPORT_ASSIGNMENT);
        }
        return exportAssignment;
    }

    public static boolean isClassMember(JSParameter parameter) {
        return TypeScriptPsiUtil.isFieldParameter(parameter);
    }

    @Nullable
    public static String getNameFromIdentifierOwner(@NotNull JSNamedElement identifierOwner) {
        String nameFromComputed;
        if (identifierOwner == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(2);
        }
        if (identifierOwner instanceof JSComputedPropertyNameOwner && (nameFromComputed = JSPsiImplUtils.getValidNameFromComputedName(((JSComputedPropertyNameOwner)identifierOwner).getComputedPropertyName())) != null) {
            return nameFromComputed;
        }
        return TypeScriptPsiUtil.getNameFromIdentifier(identifierOwner.findNameIdentifier());
    }

    @Nullable
    public static String getNameFromIdentifier(@Nullable ASTNode identifier) {
        if (identifier == null) {
            return null;
        }
        if (identifier.getElementType() == JSElementTypes.REFERENCE_EXPRESSION) {
            identifier = identifier.getFirstChildNode();
        }
        if (identifier == null) {
            return null;
        }
        if (JSTokenTypes.STRING_LITERALS.contains(identifier.getElementType())) {
            return JSStringUtil.unquoteAndUnescapeString(identifier.getText());
        }
        return identifier.getText();
    }

    @Nullable
    public static TypeScriptType getStubOrPsiTypeElement(@NotNull StubBasedPsiElementBase element) {
        if (element == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(3);
        }
        return (TypeScriptType)ArrayUtil.getFirstElement((Object[])TypeScriptPsiUtil.getStubOrPsiTypeElements(element));
    }

    @NotNull
    public static TypeScriptType[] getStubOrPsiTypeElements(@NotNull StubBasedPsiElementBase element) {
        if (element == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(4);
        }
        TypeScriptType[] typeScriptTypeArray = (TypeScriptType[])element.getStubOrPsiChildren(TypeScriptElementTypes.TYPESCRIPT_TYPES, TypeScriptType.ARRAY_FACTORY);
        if (typeScriptTypeArray == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(5);
        }
        return typeScriptTypeArray;
    }

    @Nullable
    public static TypeScriptType getPsiTypeElement(@NotNull JSElementImpl element) {
        if (element == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(6);
        }
        return (TypeScriptType)ArrayUtil.getFirstElement((Object[])element.getChildrenAsPsiElements(TypeScriptElementTypes.TYPESCRIPT_TYPES, TypeScriptType.ARRAY_FACTORY));
    }

    public static boolean isTopLevelContainer(@Nullable PsiElement element) {
        return element instanceof JSFile || element instanceof TypeScriptModule || element instanceof JSEmbeddedContent && !(element.getContainingFile() instanceof JSFile);
    }

    public static boolean isTopLevelContainerMember(@NotNull PsiElement element) {
        if (element == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(7);
        }
        if (!(element instanceof JSQualifiedNamedElement)) {
            return false;
        }
        PsiElement parent = TypeScriptPsiUtil.getParentOverDefaultAssignable(element);
        if (parent instanceof JSVarStatement) {
            parent = parent.getParent();
        }
        if (parent instanceof ES6ExportDefaultAssignment) {
            parent = parent.getParent();
        }
        return TypeScriptPsiUtil.isTopLevelContainer(parent);
    }

    public static boolean isTopLevelContainerMember(@NotNull JSQualifiedObjectStubBase<?> stubElement) {
        StubElement parentStub;
        if (stubElement == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(8);
        }
        if ((parentStub = stubElement.getParentStub()) != null && parentStub.getStubType() == ES6ElementTypes.EXPORT_DEFAULT_ASSIGNMENT) {
            parentStub = parentStub.getParentStub();
        }
        if (parentStub != null && JSElementTypes.VAR_STATEMENTS.contains((IElementType)parentStub.getStubType())) {
            parentStub = parentStub.getParentStub();
        }
        IStubElementType type = parentStub != null ? parentStub.getStubType() : null;
        return type == JSStubElementTypes.TYPESCRIPT_MODULE || type == null;
    }

    public static PsiElement getParentOverDefaultAssignable(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(9);
        }
        if ((parent = element.getParent()) instanceof ES6ExportDefaultAssignment) {
            parent = parent.getParent();
        }
        return parent;
    }

    public static boolean isAmbientModule(@NotNull TypeScriptModule module) {
        if (module == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(10);
        }
        return module.isGlobalScopeAugmentation() || !module.isInternal();
    }

    public static boolean isModule(PsiElement element, boolean includeInternal) {
        return element instanceof JSFile && ((JSFile)element).isCommonJSModule() || element instanceof TypeScriptModule && (includeInternal || !((TypeScriptModule)element).isInternal());
    }

    public static boolean isAugmentationModule(@Nullable PsiElement element) {
        return element instanceof TypeScriptModule && ((TypeScriptModule)element).isAugmentation();
    }

    public static boolean isFromAugmentationModule(@NotNull PsiElement element) {
        if (element == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(11);
        }
        return TypeScriptPsiUtil.isAugmentationModule(ES6PsiUtil.findExternalModule(element));
    }

    public static boolean isAbstractElement(@NotNull JSAttributeListOwner element) {
        JSAttributeList list;
        if (element == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(12);
        }
        if ((list = element.getAttributeList()) == null) {
            return false;
        }
        return list.hasModifier(JSAttributeList.ModifierType.ABSTRACT);
    }

    public static boolean referencesNamedTypeContainer(@NotNull ES6ImportExportSpecifier specifier) {
        ResolveResult[] results;
        if (specifier == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(13);
        }
        if ((results = specifier.resolveOverAliases()).length == 0) {
            return true;
        }
        for (ResolveResult result : results) {
            PsiElement element = result.getElement();
            if (!TypeScriptPsiUtil.isNamedTypeContainerDefinition(element)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static Collection<JSFunctionWithSubstitutor> calculatePossibleFunctionForVariable(@NotNull JSFieldVariable element, @Nullable PsiElement methodExpression, @Nullable Set<PsiElement> visited) {
        if (element == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(14);
        }
        Collection<JSFunctionWithSubstitutor> collection = TypeScriptPsiUtil.calculatePossibleFunctionForTypeElement(element.getTypeElement(), methodExpression, visited);
        if (collection == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(15);
        }
        return collection;
    }

    @NotNull
    private static Collection<JSFunctionWithSubstitutor> calculatePossibleFunctionForTypeElement(@Nullable PsiElement typeElement, @Nullable PsiElement methodExpression, @Nullable Set<PsiElement> visited) {
        if (visited != null && visited.contains(typeElement)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptPsiUtil.$$$reportNull$$$0(16);
            }
            return list;
        }
        PsiElement callExpressionCandidate = methodExpression instanceof JSCallExpression ? methodExpression : (methodExpression == null ? null : methodExpression.getParent());
        boolean hasNew = callExpressionCandidate instanceof JSNewExpression;
        if (typeElement instanceof TypeScriptSingleType) {
            Collection<JSFunctionWithSubstitutor> collection = TypeScriptPsiUtil.getSignaturesForSingleType((TypeScriptSingleType)typeElement, hasNew, methodExpression, visited);
            if (collection == null) {
                TypeScriptPsiUtil.$$$reportNull$$$0(17);
            }
            return collection;
        }
        if (typeElement instanceof JSFunction) {
            ArrayList arrayList = ContainerUtil.newArrayList((Object[])new JSFunctionWithSubstitutor[]{new JSFunctionWithSubstitutor((JSFunctionItem)typeElement, null)});
            if (arrayList == null) {
                TypeScriptPsiUtil.$$$reportNull$$$0(18);
            }
            return arrayList;
        }
        if (typeElement instanceof TypeScriptObjectType) {
            List<JSFunctionWithSubstitutor> list = TypeScriptPsiUtil.getCallSignatures((TypeScriptObjectType)typeElement, hasNew);
            if (list == null) {
                TypeScriptPsiUtil.$$$reportNull$$$0(19);
            }
            return list;
        }
        if (typeElement instanceof TypeScriptTypeofType) {
            String refExpression = ((TypeScriptTypeofType)typeElement).getReferenceText();
            if (StringUtil.isEmpty((String)refExpression)) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    TypeScriptPsiUtil.$$$reportNull$$$0(20);
                }
                return list;
            }
            Collection<? extends PsiElement> elements = TypeScriptTypeOfJSTypeImpl.getTypeOfResultElements(typeElement, refExpression);
            if (visited == null) {
                visited = ContainerUtil.newTroveSet();
                visited.add(typeElement);
            }
            THashSet finalVisited = visited;
            Collection collection = elements.stream().flatMap(arg_0 -> TypeScriptPsiUtil.lambda$calculatePossibleFunctionForTypeElement$0(methodExpression, (Set)finalVisited, arg_0)).collect(Collectors.toList());
            if (collection == null) {
                TypeScriptPsiUtil.$$$reportNull$$$0(21);
            }
            return collection;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(22);
        }
        return list;
    }

    @NotNull
    private static Collection<JSFunctionWithSubstitutor> getSignaturesForSingleType(@NotNull TypeScriptSingleType singleType, boolean isNewExpression, @Nullable PsiElement methodExpression, @Nullable Set<PsiElement> visited) {
        TypeScriptTypeArgumentList typeArgumentsList;
        if (singleType == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(23);
        }
        JSTypeDeclaration[] typeArguments = (typeArgumentsList = singleType.getTypeArguments()) == null ? JSTypeDeclaration.EMPTY_ARRAY : typeArgumentsList.getTypeArguments();
        List<JSType> genericArguments = TypeScriptGenericTypesEvaluator.getTypeArgumentsForDeclarations(typeArguments, null);
        String qualifiedTypeName = singleType.getQualifiedTypeName();
        if (qualifiedTypeName == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptPsiUtil.$$$reportNull$$$0(24);
            }
            return list;
        }
        JSTypeResolveResult result = TypeScriptImportHandler.getInstance().resolveTypeName(qualifiedTypeName, (PsiElement)singleType);
        if (!result.hasElements()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptPsiUtil.$$$reportNull$$$0(25);
            }
            return list;
        }
        ArrayList allSignatures = ContainerUtil.newArrayList();
        for (PsiElement psiElement : result.getElements()) {
            Collection<Object> signatures = ContainerUtil.emptyList();
            if (psiElement instanceof TypeScriptTypeAlias) {
                JSTypeDeclaration aliasedType = ((TypeScriptTypeAlias)psiElement).getTypeDeclaration();
                if (aliasedType != null) {
                    if (visited == null) {
                        visited = ContainerUtil.newTroveSet();
                    }
                    visited.add(singleType);
                    signatures = TypeScriptPsiUtil.calculatePossibleFunctionForTypeElement((PsiElement)aliasedType, methodExpression, (Set<PsiElement>)visited);
                } else {
                    signatures = ContainerUtil.emptyList();
                }
            } else if (psiElement instanceof TypeScriptInterface) {
                signatures = TypeScriptPsiUtil.getCallSignatures((TypeScriptInterface)psiElement, isNewExpression);
            }
            if (!genericArguments.isEmpty() && psiElement instanceof TypeScriptTypeParameterListOwner) {
                JSTypeSubstitutor argumentsSubstitutor = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments((TypeScriptTypeParameterListOwner)psiElement, genericArguments);
                for (JSFunctionWithSubstitutor jSFunctionWithSubstitutor : signatures) {
                    JSTypeSubstitutor substitutor = TypeScriptPsiUtil.combineSubstitutors(jSFunctionWithSubstitutor.myTypeSubstitutor, argumentsSubstitutor);
                    allSignatures.add(new JSFunctionWithSubstitutor(jSFunctionWithSubstitutor.myFunctionItem, substitutor));
                }
                continue;
            }
            allSignatures.addAll(signatures);
        }
        ArrayList arrayList = allSignatures;
        if (arrayList == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(26);
        }
        return arrayList;
    }

    @Nullable
    private static JSTypeSubstitutor combineSubstitutors(@Nullable JSTypeSubstitutor first, @Nullable JSTypeSubstitutor second) {
        if (second == null) {
            return first;
        }
        if (first == null) {
            return second;
        }
        JSTypeSubstitutor result = new JSTypeSubstitutor();
        result.putAll((Map)first);
        result.putAll((Map)second);
        return result;
    }

    @NotNull
    public static Collection<JSFunctionWithSubstitutor> getCallSignatures(@NotNull TypeScriptInterface interfaceToProcess, final boolean isNew) {
        if (interfaceToProcess == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(27);
        }
        final ArrayList result = ContainerUtil.newArrayList();
        JSClassUtils.processClassesInHierarchy(interfaceToProcess, true, new TypeScriptUtil.JSClassHierarchyProcessor(){

            @Override
            public boolean process(@NotNull JSClass<?> aClass, @NotNull JSTypeSubstitutor typeSubstitutor, boolean fromImplements) {
                if (aClass == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (typeSubstitutor == null) {
                    1.$$$reportNull$$$0(1);
                }
                List interfaceSignatures = TypeScriptPsiUtil.getCallSignatures(aClass.getMembers(), isNew);
                result.addAll(ContainerUtil.map((Collection)interfaceSignatures, fun -> {
                    if (typeSubstitutor == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return new JSFunctionWithSubstitutor((JSFunctionItem)fun, typeSubstitutor.isEmpty() ? null : typeSubstitutor);
                }));
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aClass";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "typeSubstitutor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/typescript/psi/TypeScriptPsiUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "process";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$process$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ArrayList arrayList = result;
        if (arrayList == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(28);
        }
        return arrayList;
    }

    @NotNull
    private static List<JSFunctionWithSubstitutor> getCallSignatures(@NotNull TypeScriptObjectType type, boolean isNew) {
        if (type == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(29);
        }
        List<JSFunctionWithSubstitutor> list = TypeScriptPsiUtil.getCallSignatures(Arrays.asList(type.getTypeMembers()), isNew).stream().map(JSPsiImplUtils.TO_FUNCTION_WITH_SUBSTITUTOR).collect(Collectors.toList());
        if (list == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(30);
        }
        return list;
    }

    @NotNull
    private static List<JSFunctionItem> getCallSignatures(@NotNull Iterable<? extends JSElement> members, boolean isNew) {
        if (members == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(31);
        }
        List result = ContainerUtil.newSmartList();
        for (JSElement jSElement : members) {
            TypeScriptCallSignature callSignature;
            if (!(jSElement instanceof TypeScriptCallSignature) || (callSignature = (TypeScriptCallSignature)jSElement).isConstructor() != isNew) continue;
            result.add(callSignature);
        }
        List list = result;
        if (list == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(32);
        }
        return list;
    }

    public static boolean isFieldParameter(@NotNull JSParameter parameter) {
        JSAttributeList list;
        if (parameter == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(33);
        }
        return (list = parameter.getAttributeList()) != null && (list.getExplicitAccessType() != null || list.hasModifier(JSAttributeList.ModifierType.READONLY));
    }

    public static boolean isThisParameter(@NotNull JSParameterItem parameter) {
        if (parameter == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(34);
        }
        return THIS_NAME.equals(parameter.getName());
    }

    @Nullable
    public static JSType getThisParameterType(@NotNull JSFunction function) {
        JSParameter parameter;
        JSParameter[] parameters;
        JSParameterList list;
        if (function == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(35);
        }
        if ((list = function.getParameterList()) instanceof TypeScriptParameterListImpl && (parameters = ((TypeScriptParameterListImpl)list).getRawParameters()).length > 0 && TypeScriptPsiUtil.isThisParameter((JSParameterItem)(parameter = parameters[0]))) {
            return parameter.getType();
        }
        return null;
    }

    @NotNull
    public static TypeScriptFunction getLastOverload(@NotNull TypeScriptFunction function) {
        if (function == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(36);
        }
        TypeScriptFunction prev = null;
        if (!function.isOverloadDeclaration()) {
            TypeScriptFunction typeScriptFunction = function;
            if (typeScriptFunction == null) {
                TypeScriptPsiUtil.$$$reportNull$$$0(37);
            }
            return typeScriptFunction;
        }
        for (TypeScriptFunction currentFunction = function; currentFunction != null; currentFunction = currentFunction.getNextOverloadOrImplementation()) {
            prev = currentFunction;
        }
        TypeScriptFunction typeScriptFunction = prev;
        if (typeScriptFunction == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(38);
        }
        return typeScriptFunction;
    }

    @NotNull
    public static Collection<? extends JSFunctionItem> getAllOverloadSignatures(@NotNull TypeScriptFunction functionItem) {
        TypeScriptFunction implementation;
        if (functionItem == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(39);
        }
        LinkedHashSet result = ContainerUtil.newLinkedHashSet();
        boolean isOverloadImpl = functionItem.isOverloadImplementation();
        if (!isOverloadImpl) {
            result.add(functionItem);
        }
        result.addAll(TypeScriptPsiUtil.getAllOverloadsWithImplementation(functionItem));
        TypeScriptFunction typeScriptFunction = implementation = isOverloadImpl ? functionItem : TypeScriptPsiUtil.getOverloadImplementation(functionItem);
        if (implementation != null) {
            result.remove(implementation);
        }
        LinkedHashSet linkedHashSet = result;
        if (linkedHashSet == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(40);
        }
        return linkedHashSet;
    }

    @Nullable
    public static TypeScriptFunction getOverloadImplementation(@NotNull TypeScriptFunction function) {
        TypeScriptFunction overload;
        if (function == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(41);
        }
        return (overload = TypeScriptPsiUtil.getLastOverload(function)) != function && overload.isOverloadImplementation() ? overload : null;
    }

    public static Collection<TypeScriptFunction> getAllOverloadsWithImplementation(@NotNull TypeScriptFunction function) {
        if (function == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(42);
        }
        JSClass containingClass = JSUtils.getMemberContainingClass((PsiElement)function);
        String name = function.getName();
        if (name != null && containingClass instanceof TypeScriptInterfaceClass) {
            JSFunction.FunctionKind kind = "constructor".equals(name) ? JSFunction.FunctionKind.CONSTRUCTOR : JSFunction.FunctionKind.SIMPLE;
            Object[] functions = ((TypeScriptInterfaceClass)containingClass).findFunctionsByNameAndKind(name, kind);
            LinkedHashSet result = ContainerUtil.newLinkedHashSet((Object[])functions);
            result.remove(function);
            return result;
        }
        TypeScriptFunction overload = TypeScriptPsiUtil.getLastOverload(function);
        LinkedHashSet result = overload == function ? ContainerUtil.newLinkedHashSet() : ContainerUtil.newLinkedHashSet((Object[])new TypeScriptFunction[]{overload});
        result.addAll(overload.getOverloadDeclarations());
        result.remove(function);
        return result;
    }

    public static ResolveResult[] chooseOverload(@NotNull ResolveResult[] resolveResults) {
        if (resolveResults == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(43);
        }
        Arrays.sort(resolveResults, TypeScriptSignatureChooser.FUNCTIONS_FIRST_RESOLVE_RESULT);
        ResolveResult resultWithLiteralArguments = null;
        block0: for (ResolveResult result : resolveResults) {
            PsiElement element;
            if (!result.isValidResult() || !((element = result.getElement()) instanceof TypeScriptFunction)) continue;
            for (JSParameterListElement listElement : ((TypeScriptFunction)element).getParameters()) {
                if (!(listElement.getTypeElement() instanceof TypeScriptStringLiteralType)) continue;
                resultWithLiteralArguments = result;
                break block0;
            }
        }
        ResolveResult result = resultWithLiteralArguments != null ? resultWithLiteralArguments : (ResolveResult)ArrayUtil.getFirstElement((Object[])resolveResults);
        return new ResolveResult[]{result};
    }

    public static ResolveResult[] removeDuplicates(@NotNull ResolveResult[] resolveResults, @Nullable PsiElement place) {
        if (resolveResults == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(44);
        }
        if (resolveResults.length > 20) {
            return resolveResults;
        }
        if (place == null || DialectDetector.isTypeScript(place) || resolveResults.length <= 1) {
            return resolveResults;
        }
        if (!TypeScriptPsiUtil.elementsCanBeMerged(resolveResults)) {
            return resolveResults;
        }
        JSCoreLibraryElementsCollector<ResolveResult> collector = new JSCoreLibraryElementsCollector<ResolveResult>();
        ArrayList newResult = ContainerUtil.newArrayList();
        for (ResolveResult result : resolveResults) {
            PsiElement element = result.getElement();
            if (collector.isLibraryElement(element)) {
                collector.addElement(element, result);
                continue;
            }
            newResult.add(result);
        }
        Collection values = collector.getValues();
        for (ResolveResult currentResult : resolveResults) {
            if (!values.contains(currentResult)) continue;
            newResult.add(currentResult);
        }
        return newResult.toArray(ResolveResult.EMPTY_ARRAY);
    }

    public static boolean elementsCanBeMerged(@NotNull ResolveResult[] resolveResults) {
        if (resolveResults == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(45);
        }
        for (ResolveResult result : resolveResults) {
            if (!result.isValidResult()) {
                return false;
            }
            PsiElement element = result.getElement();
            if (element instanceof TypeScriptFunction || element instanceof TypeScriptVariable || element instanceof TypeScriptField) continue;
            return false;
        }
        return true;
    }

    public static boolean isImplementationAndOverloadFunction(PsiElement _element, PsiElement resolvedElement) {
        if (_element instanceof TypeScriptFunction && resolvedElement instanceof TypeScriptFunction) {
            TypeScriptFunction function = (TypeScriptFunction)_element;
            TypeScriptFunction resolvedFunction = (TypeScriptFunction)resolvedElement;
            if (resolvedFunction.isOverloadDeclaration() && function.isOverloadImplementation() && function.getOverloadDeclarations().contains(resolvedFunction)) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static String getMemberName(@NotNull JSComputedPropertyNameOwner function) {
        String name;
        if (function == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(46);
        }
        if ((name = function.getName()) == null) {
            name = JSPsiImplUtils.getComputedPropertyNameWithoutBrackets(function);
        }
        String string = name == null ? "" : JSStringUtil.unquoteAndUnescapeString(name);
        if (string == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(47);
        }
        return string;
    }

    public static boolean isLiteralModuleAugmentationName(@Nullable PsiElement element) {
        PsiElement parent;
        return element instanceof JSLiteralExpression && (parent = element.getParent()) instanceof TypeScriptModule && element.isEquivalentTo(((TypeScriptModule)parent).getNameIdentifier());
    }

    @NotNull
    public static TypeScriptTypeParameter[] getTypeParametersForOwner(@Nullable PsiElement sourceElement) {
        if (!(sourceElement instanceof TypeScriptTypeParameterListOwner)) {
            if (TypeScriptTypeParameter.EMPTY_ARRAY == null) {
                TypeScriptPsiUtil.$$$reportNull$$$0(48);
            }
            return TypeScriptTypeParameter.EMPTY_ARRAY;
        }
        TypeScriptTypeParameterList list = ((TypeScriptTypeParameterListOwner)sourceElement).getTypeParameterList();
        TypeScriptTypeParameter[] typeScriptTypeParameterArray = list == null ? TypeScriptTypeParameter.EMPTY_ARRAY : list.getTypeParameters();
        if (typeScriptTypeParameterArray == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(49);
        }
        return typeScriptTypeParameterArray;
    }

    @NotNull
    public static JSTypeDeclaration[] getNewExpressionTypeArguments(@NotNull PsiElement expression) {
        if (expression == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(50);
        }
        if (expression instanceof TypeScriptNewExpression) {
            TypeScriptNewExpression newExpression = (TypeScriptNewExpression)expression;
            TypeScriptTypeArgumentList arguments = newExpression.getTypeArguments();
            JSTypeDeclaration[] jSTypeDeclarationArray = arguments == null ? JSTypeDeclaration.EMPTY_ARRAY : arguments.getTypeArguments();
            if (jSTypeDeclarationArray == null) {
                TypeScriptPsiUtil.$$$reportNull$$$0(51);
            }
            return jSTypeDeclarationArray;
        }
        if (JSTypeDeclaration.EMPTY_ARRAY == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(52);
        }
        return JSTypeDeclaration.EMPTY_ARRAY;
    }

    @NotNull
    public static JSTypeDeclaration[] getNestedTypeArguments(@Nullable PsiElement parentExpression) {
        if (parentExpression instanceof TypeScriptNewExpression) {
            JSTypeDeclaration[] jSTypeDeclarationArray = TypeScriptPsiUtil.getNewExpressionTypeArguments(parentExpression);
            if (jSTypeDeclarationArray == null) {
                TypeScriptPsiUtil.$$$reportNull$$$0(53);
            }
            return jSTypeDeclarationArray;
        }
        TypeScriptTypeArgumentList list = (TypeScriptTypeArgumentList)PsiTreeUtil.getChildOfType((PsiElement)parentExpression, TypeScriptTypeArgumentList.class);
        if (list != null) {
            JSTypeDeclaration[] jSTypeDeclarationArray = list.getTypeArguments();
            if (jSTypeDeclarationArray == null) {
                TypeScriptPsiUtil.$$$reportNull$$$0(54);
            }
            return jSTypeDeclarationArray;
        }
        if (JSTypeDeclaration.EMPTY_ARRAY == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(55);
        }
        return JSTypeDeclaration.EMPTY_ARRAY;
    }

    public static boolean isTsIndexerType(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof TypeScriptType)) {
            return false;
        }
        PsiElement pp = parent.getParent();
        return pp instanceof TypeScriptIndexSignature && ((TypeScriptIndexSignature)pp).getParameterType() == parent;
    }

    public static boolean isObjectBuiltInTypeProperty(JSRecordType.TypeMember member) {
        JSRecordType.MemberSource source = member.getMemberSource();
        if (source.isEmpty()) {
            if (member instanceof JSCompositeFunctionPropertySignatureImpl) {
                for (JSRecordType.TypeMember typeMember : ((JSCompositeFunctionPropertySignatureImpl)member).getMembers()) {
                    if (TypeScriptPsiUtil.isObjectBuiltInTypeProperty(typeMember)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        JSClass parent = JSUtils.getMemberContainingClass(source.getSingleElement());
        return parent instanceof TypeScriptInterface && "Object".equals(((TypeScriptInterface)parent).getQualifiedName());
    }

    public static boolean returnTypeAnnotationForbidden(@NotNull JSElement node) {
        if (node == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(56);
        }
        JSFunction function = node instanceof JSFunction ? (JSFunction)node : null;
        return function != null && function.getKind() == JSFunction.FunctionKind.SETTER;
    }

    @Nullable
    public static PsiElement getPsiElementByRange(@NotNull PsiFile psiFile, TextRange range) {
        int rangeStartOffset;
        PsiElement startElement;
        if (psiFile == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(57);
        }
        if ((startElement = psiFile.findElementAt(rangeStartOffset = range.getStartOffset())) == null) {
            return null;
        }
        PsiElement lastCandidate = startElement;
        int rangeEndOffset = range.getEndOffset();
        for (PsiElement currentElement = startElement; currentElement != null && !(currentElement instanceof PsiFile) && currentElement.getTextRange().getStartOffset() == rangeStartOffset && currentElement.getTextRange().getEndOffset() <= rangeEndOffset; currentElement = currentElement.getParent()) {
            if (currentElement.getTextRange().getEndOffset() == rangeEndOffset) {
                return currentElement;
            }
            lastCandidate = currentElement;
        }
        return lastCandidate;
    }

    private static /* synthetic */ Stream lambda$calculatePossibleFunctionForTypeElement$0(@Nullable PsiElement methodExpression, Set finalVisited, PsiElement el) {
        return JSPsiImplUtils.calculatePossibleFunctions(el, methodExpression, finalVisited).stream();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 37: 
            case 38: 
            case 40: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 37: 
            case 38: 
            case 40: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifierOwner";
                break;
            }
            case 5: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 37: 
            case 38: 
            case 40: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/psi/TypeScriptPsiUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubElement";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specifier";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "singleType";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceToProcess";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 35: 
            case 36: 
            case 41: 
            case 42: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionItem";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResults";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/psi/TypeScriptPsiUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubOrPsiTypeElements";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "calculatePossibleFunctionForVariable";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "calculatePossibleFunctionForTypeElement";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignaturesForSingleType";
                break;
            }
            case 28: 
            case 30: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallSignatures";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastOverload";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllOverloadSignatures";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberName";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParametersForOwner";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewExpressionTypeArguments";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getNestedTypeArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasAmbientAttribute";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findExportAssignment";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNameFromIdentifierOwner";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getStubOrPsiTypeElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getStubOrPsiTypeElements";
                break;
            }
            case 5: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 37: 
            case 38: 
            case 40: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPsiTypeElement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isTopLevelContainerMember";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getParentOverDefaultAssignable";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isAmbientModule";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isFromAugmentationModule";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAbstractElement";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "referencesNamedTypeContainer";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "calculatePossibleFunctionForVariable";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getSignaturesForSingleType";
                break;
            }
            case 27: 
            case 29: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getCallSignatures";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isFieldParameter";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isThisParameter";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getThisParameterType";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getLastOverload";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getAllOverloadSignatures";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getOverloadImplementation";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getAllOverloadsWithImplementation";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "chooseOverload";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicates";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "elementsCanBeMerged";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getMemberName";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getNewExpressionTypeArguments";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "returnTypeAnnotationForbidden";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElementByRange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 37: 
            case 38: 
            case 40: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

