/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.settings;

import com.intellij.application.options.editor.AutoImportOptionsProvider;
import com.intellij.ide.DataManager;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class JSImportOptionsProvider
implements AutoImportOptionsProvider {
    private final Project myProject;
    private final JBCheckBox myAddTSImportsOnCompletion;
    private final JBCheckBox myShowTypeScriptPopup;
    private JBCheckBox myAddTypeScriptImports;
    private JBCheckBox myAddTypeScriptOnTheFly;
    private JBCheckBox myAddES6Imports;
    private JPanel myPanel;
    private final JPanel myTSAdditionalSettings;

    public JSImportOptionsProvider(Project project) {
        this.myProject = project;
        this.myPanel = new JPanel((LayoutManager)new GridLayoutManager(5, 1, (Insets)JBUI.insets((int)0), 0, 2));
        this.myPanel.setBorder(IdeBorderFactory.createTitledBorder((String)JSBundle.message((String)"es6.auto.import.options.title", (Object[])new Object[0])));
        this.myAddES6Imports = new JBCheckBox(JSBundle.message((String)"es6.auto.import.options.completion.add.imports", (Object[])new Object[0]));
        this.myAddTypeScriptImports = new JBCheckBox(JSBundle.message((String)"typescript.auto.import.options.add.imports", (Object[])new Object[0]));
        this.myAddTypeScriptImports.addChangeListener(el -> this.refreshAdditionalPanel());
        this.myAddTSImportsOnCompletion = new JBCheckBox(JSBundle.message((String)"typescript.auto.import.options.add.on.code.completion", (Object[])new Object[0]));
        this.myAddTSImportsOnCompletion.setBorder((Border)JBUI.Borders.empty());
        this.myAddTypeScriptOnTheFly = new JBCheckBox(JSBundle.message((String)"typescript.auto.import.options.add.imports.on.the.fly", (Object[])new Object[0]));
        this.myAddTypeScriptOnTheFly.setBorder((Border)JBUI.Borders.empty());
        this.myShowTypeScriptPopup = new JBCheckBox(JSBundle.message((String)"typescript.auto.import.options.show.popup", (Object[])new Object[0]));
        this.myShowTypeScriptPopup.setBorder((Border)JBUI.Borders.empty());
        this.myPanel.add((Component)this.myAddES6Imports, this.createConstraints(0));
        this.myPanel.add((Component)JSImportOptionsProvider.createLinkComponent("JavaScript"), this.createConstraints(1));
        this.myPanel.add((Component)this.myAddTypeScriptImports, this.createConstraints(2));
        this.myPanel.add((Component)JSImportOptionsProvider.createLinkComponent("TypeScript"), this.createConstraints(3));
        FormBuilder additionalSettings = FormBuilder.createFormBuilder();
        additionalSettings.addComponent((JComponent)this.myAddTSImportsOnCompletion);
        additionalSettings.addComponent((JComponent)this.myShowTypeScriptPopup);
        additionalSettings.addComponent((JComponent)this.myAddTypeScriptOnTheFly);
        this.myTSAdditionalSettings = additionalSettings.getPanel();
        this.myTSAdditionalSettings.setBorder((Border)JBUI.Borders.emptyLeft((int)25));
        this.myPanel.add((Component)this.myTSAdditionalSettings, this.createConstraints(4));
    }

    @NotNull
    private static HyperlinkLabel createLinkComponent(@NotNull String name) {
        if (name == null) {
            JSImportOptionsProvider.$$$reportNull$$$0(0);
        }
        HyperlinkLabel label = new HyperlinkLabel();
        label.setHyperlinkText("Find more configuration options in ", "Code Style", "");
        label.addHyperlinkListener(e -> {
            Settings settings;
            DataContext context;
            if (name == null) {
                JSImportOptionsProvider.$$$reportNull$$$0(3);
            }
            if ((context = (DataContext)DataManager.getInstance().getDataContextFromFocus().getResult()) != null && (settings = (Settings)Settings.KEY.getData(context)) != null) {
                Configurable configurable = settings.find("preferences.sourceCode." + name);
                settings.select(configurable);
            }
        });
        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)label);
        HyperlinkLabel hyperlinkLabel = label;
        if (hyperlinkLabel == null) {
            JSImportOptionsProvider.$$$reportNull$$$0(1);
        }
        return hyperlinkLabel;
    }

    @NotNull
    public GridConstraints createConstraints(int row) {
        GridConstraints constraints = new GridConstraints();
        constraints.setRow(row);
        constraints.setAnchor(9);
        GridConstraints gridConstraints = constraints;
        if (gridConstraints == null) {
            JSImportOptionsProvider.$$$reportNull$$$0(2);
        }
        return gridConstraints;
    }

    public JComponent createComponent() {
        return this.myPanel;
    }

    public boolean isModified() {
        JSApplicationSettings settings = JSApplicationSettings.getInstance();
        return settings.isUseTypeScriptAutoImport() != this.myAddTypeScriptImports.isSelected() || settings.isUseJavaScriptAutoImport() != this.myAddES6Imports.isSelected() || settings.hasTSUnambiguousImportsOnTheFly(this.myProject) != this.myAddTypeScriptOnTheFly.isSelected() || settings.showTSImportPopup(this.myProject) != this.myShowTypeScriptPopup.isSelected() || settings.hasTSImportCompletion(this.myProject) != this.myAddTSImportsOnCompletion.isSelected();
    }

    public void apply() throws ConfigurationException {
        JSApplicationSettings settings = JSApplicationSettings.getInstance();
        settings.setUseTypeScriptAutoImport(this.myAddTypeScriptImports.isSelected());
        settings.setUseJavaScriptAutoImport(this.myAddES6Imports.isSelected());
        settings.setTSAddUnambiguousImportsOnTheFly(this.myProject, this.myAddTypeScriptOnTheFly.isSelected());
        settings.setTSImportCompletion(this.myProject, this.myAddTSImportsOnCompletion.isSelected());
        settings.setShowTSImportPopup(this.myProject, this.myShowTypeScriptPopup.isSelected());
    }

    public void reset() {
        JSApplicationSettings settings = JSApplicationSettings.getInstance();
        this.myAddTypeScriptImports.setSelected(settings.isUseTypeScriptAutoImport());
        this.myAddES6Imports.setSelected(settings.isUseJavaScriptAutoImport());
        this.myAddTypeScriptOnTheFly.setSelected(settings.hasTSUnambiguousImportsOnTheFly(this.myProject));
        this.myAddTSImportsOnCompletion.setSelected(settings.hasTSImportCompletion(this.myProject));
        this.myShowTypeScriptPopup.setSelected(settings.showTSImportPopup(this.myProject));
        this.refreshAdditionalPanel();
    }

    private void refreshAdditionalPanel() {
        UIUtil.setEnabled((Component)this.myTSAdditionalSettings, (boolean)this.myAddTypeScriptImports.isSelected(), (boolean)true);
    }

    public void disposeUIResources() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/settings/JSImportOptionsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/settings/JSImportOptionsProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createLinkComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstraints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createLinkComponent";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createLinkComponent$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

