/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.json.JsonLanguage;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptConfigUtil {
    public static final String TWO_ASTERISK = "**";
    private static final Key<ParameterizedCachedValue<TypeScriptConfig, PsiFile>> CACHE_KEY = Key.create((String)"TypeScript.PsiFile.To.Config");
    private static final ParameterizedCachedValueProvider<TypeScriptConfig, PsiFile> CACHED_CONFIG_PROVIDER = new ParameterizedCachedValueProvider<TypeScriptConfig, PsiFile>(){

        @Nullable
        public CachedValueProvider.Result<TypeScriptConfig> compute(PsiFile param) {
            VirtualFile file = param.getOriginalFile().getVirtualFile();
            Project project = param.getProject();
            TypeScriptConfig config2 = file == null ? null : TypeScriptConfigUtil.getConfigForFile(project, file);
            return CachedValueProvider.Result.create((Object)config2, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        }
    };

    @Nullable
    private static JsonProperty getFilesProperty(Project project, TypeScriptConfig config2) {
        PsiFile file = PsiManager.getInstance((Project)project).findFile(config2.getConfigFile());
        return TypeScriptConfigUtil.getProperty(file, "files");
    }

    @Nullable
    private static JsonProperty getIncludeProperty(Project project, TypeScriptConfig config2) {
        PsiFile file = PsiManager.getInstance((Project)project).findFile(config2.getConfigFile());
        return TypeScriptConfigUtil.getProperty(file, "include");
    }

    @Nullable
    private static JsonProperty getProperty(@Nullable PsiFile file, @NotNull String propertyName) {
        if (propertyName == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(0);
        }
        if (file == null) {
            return null;
        }
        JsonObject jsonObject = (JsonObject)PsiTreeUtil.getChildOfType((PsiElement)file, JsonObject.class);
        if (jsonObject == null) {
            return null;
        }
        return jsonObject.findProperty(propertyName);
    }

    public static boolean addVirtualFileToConfigFiles(Project project, VirtualFile file, TypeScriptConfig config2) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        assert (!config2.isDirectoryBased());
        JsonProperty property = TypeScriptConfigUtil.getFilesProperty(project, config2);
        if (property == null && (property = TypeScriptConfigUtil.getIncludeProperty(project, config2)) == null) {
            return false;
        }
        JsonArray value = (JsonArray)property.getValue();
        if (value == null) {
            return false;
        }
        List list = value.getValueList();
        if (list.isEmpty()) {
            return false;
        }
        String text = value.getText();
        StringBuilder builder = new StringBuilder(text);
        String path = VfsUtil.getPath((VirtualFile)config2.getConfigFile(), (VirtualFile)file, (char)(text.indexOf("/") > 0 ? (char)'/' : (char)File.separatorChar));
        int i = text.lastIndexOf("]");
        builder.insert(i, ",\"" + path + "\"");
        value.replace((PsiElement)TypeScriptConfigUtil.createJSONAndGetPropertyValue(project, builder.toString()));
        return true;
    }

    private static JsonValue createJSONAndGetPropertyValue(Project project, String propertyValue) {
        String tempName = "tempName";
        String json = String.format("{ \"" + tempName + "\":%s }", propertyValue);
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText((Language)JsonLanguage.INSTANCE, (CharSequence)json);
        JsonProperty property = TypeScriptConfigUtil.getProperty(psiFile, tempName);
        assert (property != null);
        return property.getValue();
    }

    public static String getOutDirectory(VirtualFile baseFile, String relativeOrAbsolutePath) {
        if (StringUtil.isEmpty((String)relativeOrAbsolutePath)) {
            return null;
        }
        if (FileUtil.isAbsolute((String)relativeOrAbsolutePath)) {
            return relativeOrAbsolutePath;
        }
        VirtualFile file = VfsUtil.findRelativeFile((VirtualFile)baseFile, (String[])ArrayUtil.toStringArray((Collection)FileUtil.splitPath((String)FileUtil.toCanonicalPath((String)relativeOrAbsolutePath))));
        return file == null ? null : file.getCanonicalPath();
    }

    @Nullable
    public static TypeScriptConfig getConfigForPsiFile(@NotNull PsiFile file) {
        if (file == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(1);
        }
        if (DumbService.isDumb((Project)file.getProject())) {
            return null;
        }
        return (TypeScriptConfig)CachedValuesManager.getManager((Project)file.getProject()).getParameterizedCachedValue((UserDataHolder)file, CACHE_KEY, CACHED_CONFIG_PROVIDER, false, (Object)file);
    }

    @Nullable
    public static TypeScriptConfig getConfigForFile(@Nullable Project project, @NotNull VirtualFile file) {
        if (file == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Collection<TypeScriptConfig> filteredConfigs = TypeScriptConfigService.Provider.getConfigInclude(project, file);
        if (filteredConfigs.isEmpty()) {
            return null;
        }
        assert (project != null);
        if (1 == filteredConfigs.size()) {
            return (TypeScriptConfig)ContainerUtil.getFirstItem(filteredConfigs);
        }
        TypeScriptConfig entry = TypeScriptConfigUtil.getNearestParentConfig(file, filteredConfigs);
        if (entry != null) {
            return entry;
        }
        return (TypeScriptConfig)ContainerUtil.getFirstItem(filteredConfigs);
    }

    public static VirtualFile getNearestParentConfig(@Nullable VirtualFile file) {
        VirtualFile toSearch;
        if (file == null) {
            return null;
        }
        VirtualFile virtualFile = toSearch = file.isDirectory() ? file : file.getParent();
        while (toSearch != null && toSearch.isValid()) {
            VirtualFile child = toSearch.findChild("tsconfig.json");
            if (child != null) {
                return child;
            }
            toSearch = toSearch.getParent();
        }
        return null;
    }

    @Nullable
    public static TypeScriptConfig getNearestParentConfig(@Nullable VirtualFile file, @NotNull Collection<TypeScriptConfig> configs) {
        if (configs == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(3);
        }
        if (file == null) {
            return null;
        }
        for (VirtualFile toSearch = file.getParent(); toSearch != null; toSearch = toSearch.getParent()) {
            for (TypeScriptConfig config2 : configs) {
                if (!config2.getConfigDirectory().equals(toSearch)) continue;
                return config2;
            }
        }
        return null;
    }

    public static String getRegularExpressionForGlobPattern(@NotNull Collection<String> specs, @NotNull VirtualFile baseDirectory, @NotNull WildCardType usage) {
        if (specs == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(4);
        }
        if (baseDirectory == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(5);
        }
        if (usage == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(6);
        }
        if (ContainerUtil.isEmpty(specs)) {
            return null;
        }
        StringBuilder pattern = new StringBuilder();
        boolean hasWrittenSubPattern = false;
        block0: for (String spec : specs) {
            if (StringUtil.isEmpty((String)spec)) continue;
            StringBuilder subPattern = new StringBuilder();
            boolean hasRecursiveDirectoryWildcard = false;
            boolean hasWrittenComponent = false;
            ArrayList components = TypeScriptConfigUtil.getNormalizedPathComponents(FileUtil.toSystemIndependentName((String)spec), baseDirectory);
            String lastUsage = components.get(components.size() - 1);
            if (usage != WildCardType.EXCLUDE && !StringUtil.isEmpty((String)lastUsage)) {
                if (TWO_ASTERISK.equals(lastUsage)) continue;
                if (!lastUsage.contains(".") && !lastUsage.contains("*")) {
                    components = ContainerUtil.newArrayList(components);
                    components.add(TWO_ASTERISK);
                    components.add("*");
                }
            }
            int optionalCount = 0;
            for (String component : components) {
                if (TWO_ASTERISK.equals(component)) {
                    if (hasRecursiveDirectoryWildcard) continue block0;
                    subPattern.append("(\\/.+?)?");
                    hasRecursiveDirectoryWildcard = true;
                    hasWrittenComponent = true;
                    continue;
                }
                if (usage == WildCardType.DIRECTORIES) {
                    subPattern.append('(');
                    ++optionalCount;
                }
                if (hasWrittenComponent) {
                    subPattern.append("\\/");
                }
                subPattern.append(TypeScriptConfigUtil.escapeSymbols(component));
                hasWrittenComponent = true;
            }
            while (optionalCount > 0) {
                subPattern.append(")?");
                --optionalCount;
            }
            if (hasWrittenSubPattern) {
                pattern.append("|");
            }
            pattern.append("(").append((CharSequence)subPattern).append(")");
            hasWrittenSubPattern = true;
        }
        if (StringUtil.isEmpty((CharSequence)pattern)) {
            return null;
        }
        return "^(" + pattern + (usage == WildCardType.EXCLUDE ? ")($|\\/)" : ")$");
    }

    private static String escapeSymbols(String component) {
        String escapedString = StringUtil.escapeToRegexp((String)component);
        escapedString = escapedString.replace("\\*", "[^\\/]*");
        escapedString = escapedString.replace("\\?", "[^\\/]");
        return escapedString;
    }

    private static List<String> getNormalizedPathComponents(String spec, VirtualFile baseDirectory) {
        String stringPath = JSPathMappingsUtil.getStringPathRelativeBaseUrlOrSelfIfAbsolute(baseDirectory, spec);
        int rootLength = TypeScriptConfigUtil.getRootLength(stringPath);
        String root = stringPath.substring(0, rootLength);
        ArrayList result = ContainerUtil.newArrayList((Object[])new String[]{StringUtil.trimEnd((String)root, (char)'/')});
        result.addAll(StringUtil.split((String)stringPath.substring(rootLength), (String)"/"));
        return result;
    }

    public static boolean isRootDiskPath(@NotNull String stringPath) {
        if (stringPath == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(7);
        }
        return FileUtil.isAbsolute((String)stringPath);
    }

    private static int getRootLength(@NotNull String absoluteNormalizedPath) {
        if (absoluteNormalizedPath == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(8);
        }
        if (StringUtil.isEmpty((String)absoluteNormalizedPath)) {
            return 0;
        }
        if (absoluteNormalizedPath.charAt(0) == '/') {
            int p2;
            int p1;
            if (absoluteNormalizedPath.length() > 1 && absoluteNormalizedPath.charAt(1) != '/') {
                return 1;
            }
            int n = p1 = absoluteNormalizedPath.length() > 2 ? absoluteNormalizedPath.indexOf("/", 2) : -1;
            if (p1 < 0) {
                return 2;
            }
            int n2 = p2 = absoluteNormalizedPath.length() > p1 + 1 ? absoluteNormalizedPath.indexOf("/", p1 + 1) : -1;
            if (p2 < 0) {
                return p1 + 1;
            }
            return p2 + 1;
        }
        if (absoluteNormalizedPath.length() > 1 && absoluteNormalizedPath.charAt(1) == ':') {
            if (absoluteNormalizedPath.charAt(2) == '/') {
                return 3;
            }
            return 2;
        }
        if (absoluteNormalizedPath.lastIndexOf("file:///", 0) == 0) {
            return "file:///".length();
        }
        int idx = absoluteNormalizedPath.indexOf("://");
        if (idx != -1) {
            return idx + "://".length();
        }
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configs";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specs";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDirectory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringPath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absoluteNormalizedPath";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getProperty";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getConfigForPsiFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getConfigForFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getNearestParentConfig";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getRegularExpressionForGlobPattern";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isRootDiskPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getRootLength";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum WildCardType {
        EXCLUDE,
        DIRECTORIES,
        FILES;

    }
}

