/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.lang.javascript.index.ES6ImportIndex;
import com.intellij.lang.typescript.modules.TypeScriptNodeReference;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImports;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsResolver;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsResolverImpl;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileInclude;
import com.intellij.lang.typescript.tsconfig.TypeScriptImportResolveContext;
import com.intellij.lang.typescript.tsconfig.TypeScriptImportSimpleResolveContextImpl;
import com.intellij.lang.typescript.tsconfig.TypeScriptOrJSFileImportsResolverImpl;
import com.intellij.lang.typescript.tsconfig.checkers.TypeScriptSimpleFileInclude;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptFileImportsImpl
implements TypeScriptFileImports {
    @NotNull
    private final Project myProject;
    @NotNull
    private final TypeScriptFileInclude myChecker;
    @NotNull
    private final TypeScriptFileImportsResolver myResolver;
    @NotNull
    private final TypeScriptImportResolveContext myContext;

    private static TypeScriptFileImportsResolver createResolverForConfig(Project project, @NotNull TypeScriptConfig config2) {
        if (config2 == null) {
            TypeScriptFileImportsImpl.$$$reportNull$$$0(0);
        }
        TypeScriptNodeReference.TypeScriptNodeModuleDirectorySearchProcessor processor = new TypeScriptNodeReference.TypeScriptNodeModuleDirectorySearchProcessor(project);
        TypeScriptImportResolveContext context = config2.getResolveContext();
        return config2.allowJs() ? new TypeScriptOrJSFileImportsResolverImpl(project, context, processor) : new TypeScriptFileImportsResolverImpl(project, context, processor);
    }

    public TypeScriptFileImportsImpl(@NotNull Project project, @NotNull TypeScriptConfig config2) {
        if (project == null) {
            TypeScriptFileImportsImpl.$$$reportNull$$$0(1);
        }
        if (config2 == null) {
            TypeScriptFileImportsImpl.$$$reportNull$$$0(2);
        }
        this(project, config2.getInclude(), config2.getResolveContext(), TypeScriptFileImportsImpl.createResolverForConfig(project, config2));
    }

    public TypeScriptFileImportsImpl(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            TypeScriptFileImportsImpl.$$$reportNull$$$0(3);
        }
        if (file == null) {
            TypeScriptFileImportsImpl.$$$reportNull$$$0(4);
        }
        this(project, new TypeScriptSimpleFileInclude(file), new TypeScriptImportSimpleResolveContextImpl(file));
    }

    public TypeScriptFileImportsImpl(@NotNull Project project, @NotNull TypeScriptFileInclude checker, @NotNull TypeScriptImportResolveContext context) {
        if (project == null) {
            TypeScriptFileImportsImpl.$$$reportNull$$$0(5);
        }
        if (checker == null) {
            TypeScriptFileImportsImpl.$$$reportNull$$$0(6);
        }
        if (context == null) {
            TypeScriptFileImportsImpl.$$$reportNull$$$0(7);
        }
        this(project, checker, context, new TypeScriptFileImportsResolverImpl(project, context, new TypeScriptNodeReference.TypeScriptNodeModuleDirectorySearchProcessor(project)));
    }

    public TypeScriptFileImportsImpl(@NotNull Project project, @NotNull TypeScriptFileInclude checker, @NotNull TypeScriptImportResolveContext context, @NotNull TypeScriptFileImportsResolver resolver) {
        if (project == null) {
            TypeScriptFileImportsImpl.$$$reportNull$$$0(8);
        }
        if (checker == null) {
            TypeScriptFileImportsImpl.$$$reportNull$$$0(9);
        }
        if (context == null) {
            TypeScriptFileImportsImpl.$$$reportNull$$$0(10);
        }
        if (resolver == null) {
            TypeScriptFileImportsImpl.$$$reportNull$$$0(11);
        }
        this.myProject = project;
        this.myChecker = checker;
        this.myContext = context;
        this.myResolver = resolver;
    }

    @Override
    @NotNull
    public Set<VirtualFile> getRootFiles() {
        Set<VirtualFile> set = this.myChecker.getRootFiles(this.myProject);
        if (set == null) {
            TypeScriptFileImportsImpl.$$$reportNull$$$0(12);
        }
        return set;
    }

    @NotNull
    public TypeScriptFileImportsResolver getResolver() {
        TypeScriptFileImportsResolver typeScriptFileImportsResolver = this.myResolver;
        if (typeScriptFileImportsResolver == null) {
            TypeScriptFileImportsImpl.$$$reportNull$$$0(13);
        }
        return typeScriptFileImportsResolver;
    }

    @Override
    @Nullable
    public VirtualFile resolveFile(@NotNull String moduleName, @NotNull VirtualFile containingFile) {
        if (moduleName == null) {
            TypeScriptFileImportsImpl.$$$reportNull$$$0(14);
        }
        if (containingFile == null) {
            TypeScriptFileImportsImpl.$$$reportNull$$$0(15);
        }
        return this.myResolver.resolveFileModule(moduleName, containingFile);
    }

    @Override
    @NotNull
    public Set<VirtualFile> getOutFiles(@NotNull VirtualFile file) {
        if (file == null) {
            TypeScriptFileImportsImpl.$$$reportNull$$$0(16);
        }
        Set<VirtualFile> set = ES6ImportIndex.getIncludes(file, GlobalSearchScope.allScope((Project)this.myProject)).stream().map(el -> {
            if (file == null) {
                TypeScriptFileImportsImpl.$$$reportNull$$$0(18);
            }
            return this.resolveFile(el.getPath(), file);
        }).filter(el -> el != null).collect(Collectors.toSet());
        if (set == null) {
            TypeScriptFileImportsImpl.$$$reportNull$$$0(17);
        }
        return set;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeScriptFileImportsImpl imports = (TypeScriptFileImportsImpl)o;
        if (!this.myChecker.equals(imports.myChecker)) {
            return false;
        }
        return this.myContext.equals(imports.myContext);
    }

    public int hashCode() {
        int result = this.myChecker.hashCode();
        result = 31 * result + this.myContext.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checker";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 12: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/tsconfig/TypeScriptFileImportsImpl";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/tsconfig/TypeScriptFileImportsImpl";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootFiles";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolver";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createResolverForConfig";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: 
            case 13: 
            case 17: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resolveFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getOutFiles";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getOutFiles$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

