/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig.graph;

import com.intellij.lang.typescript.tsconfig.TypeScriptFileImports;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.Graph;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;

public final class TypeScriptImportGraph
implements Graph<VirtualFile> {
    @NotNull
    private final Set<VirtualFile> myRootNodes;
    @NotNull
    private final THashSet<VirtualFile> myNodes;
    @NotNull
    private final THashMap<VirtualFile, List<VirtualFile>> myOutEdges;
    @NotNull
    private final THashMap<VirtualFile, List<VirtualFile>> myInEdges;
    @NotNull
    private final TypeScriptFileImports mySearcher;
    private final ReadWriteLock myLock;

    public TypeScriptImportGraph(@NotNull TypeScriptFileImports searcher) {
        if (searcher == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(0);
        }
        this.myLock = new ReentrantReadWriteLock();
        this.myNodes = new THashSet();
        this.myOutEdges = new THashMap();
        this.myInEdges = new THashMap();
        this.mySearcher = searcher;
        this.myRootNodes = searcher.getRootFiles();
        this.add(this.myRootNodes);
    }

    private void add(@NotNull Collection<VirtualFile> toProcess) {
        if (toProcess == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(1);
        }
        ArrayDeque<VirtualFile> toCheck = new ArrayDeque<VirtualFile>(toProcess);
        while (!toCheck.isEmpty()) {
            ProgressManager.checkCanceled();
            VirtualFile file = (VirtualFile)toCheck.pop();
            if (!this.myNodes.add((Object)file)) continue;
            Set<VirtualFile> outFiles = this.mySearcher.getOutFiles(file);
            TypeScriptImportGraph.addEdge(this.myOutEdges, file, outFiles);
            outFiles.forEach(el -> {
                toCheck.add((VirtualFile)el);
                TypeScriptImportGraph.addEdge(this.myInEdges, el, file);
            });
        }
    }

    public Collection<VirtualFile> getRoots() {
        return this.myRootNodes;
    }

    public Collection<VirtualFile> getNodes() {
        return this.myNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsFile(@NotNull VirtualFile file) {
        if (file == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(2);
        }
        Lock lock = this.myLock.readLock();
        lock.lock();
        try {
            boolean bl = this.myNodes.contains((Object)file);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public final Iterator<VirtualFile> getIn(@NotNull VirtualFile file) {
        if (file == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(3);
        }
        return ((List)this.myInEdges.getOrDefault((Object)file, Collections.emptyList())).iterator();
    }

    public final Iterator<VirtualFile> getOut(@NotNull VirtualFile file) {
        if (file == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(4);
        }
        return ((List)this.myOutEdges.getOrDefault((Object)file, Collections.emptyList())).iterator();
    }

    public void recalculateEdges(@NotNull VirtualFile file) {
        if (file == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(5);
        }
        this.validateNode(file);
        Set<VirtualFile> newFiles = this.mySearcher.getOutFiles(file);
        this.recalculateEdges(file, newFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalculateEdges(@NotNull VirtualFile file, @NotNull Set<VirtualFile> newFiles) {
        List oldFiles;
        if (file == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(6);
        }
        if (newFiles == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(7);
        }
        if ((oldFiles = (List)this.myOutEdges.getOrDefault((Object)file, Collections.emptyList())).size() == newFiles.size() && newFiles.containsAll(oldFiles)) {
            return;
        }
        Lock lock = this.myLock.writeLock();
        lock.lock();
        try {
            this.removeOutNodesRecursive(file);
            this.add(file, newFiles);
            this.removeNotAvailableFromRoots();
        }
        finally {
            lock.unlock();
        }
    }

    public void add(@NotNull VirtualFile file, @NotNull Collection<VirtualFile> newOutFiles) {
        if (file == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(8);
        }
        if (newOutFiles == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(9);
        }
        this.myNodes.add((Object)file);
        TypeScriptImportGraph.addEdge(this.myOutEdges, file, newOutFiles);
        ArrayList toCheck = ContainerUtil.newArrayList();
        newOutFiles.forEach(el -> {
            if (file == null) {
                TypeScriptImportGraph.$$$reportNull$$$0(20);
            }
            toCheck.add(el);
            TypeScriptImportGraph.addEdge(this.myInEdges, el, file);
        });
        this.add(toCheck);
    }

    private void removeOutNodesRecursive(@NotNull VirtualFile file) {
        if (file == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(10);
        }
        this.myNodes.remove((Object)file);
        List oldOut = (List)this.myOutEdges.getOrDefault((Object)file, Collections.emptyList());
        for (VirtualFile oldDestination : oldOut) {
            List inForOldValue = (List)this.myInEdges.get((Object)oldDestination);
            if (inForOldValue.remove(file)) continue;
            throw new IllegalStateException("Inconsistent graph in: " + file.getPath() + " out: " + oldDestination.getPath());
        }
        if (oldOut.size() > 0) {
            oldOut.clear();
        }
    }

    private void removeNotAvailableFromRoots() {
        Set<VirtualFile> elements = this.getAvailableFromRoots();
        if (elements.size() == this.myNodes.size()) {
            return;
        }
        THashSet toRemove = ContainerUtil.newTroveSet(this.myNodes);
        toRemove.removeAll(elements);
        this.myNodes.removeAll((Collection)toRemove);
        toRemove.forEach(el -> {
            this.myOutEdges.remove(el);
            this.myInEdges.remove(el);
        });
    }

    private void validateNode(@NotNull VirtualFile file) throws IllegalArgumentException {
        if (file == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(11);
        }
        if (!this.myNodes.contains((Object)file)) {
            throw new IllegalArgumentException("No such node present in the graph");
        }
    }

    @NotNull
    public Set<VirtualFile> getAvailableFromRoots() {
        ArrayDeque<VirtualFile> toCheck = new ArrayDeque<VirtualFile>(this.myRootNodes);
        THashSet result = ContainerUtil.newTroveSet();
        while (!toCheck.isEmpty()) {
            VirtualFile pop = (VirtualFile)toCheck.pop();
            if (!result.add(pop)) continue;
            ContainerUtil.addAll(toCheck, this.getOut(pop));
        }
        THashSet tHashSet = result;
        if (tHashSet == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(12);
        }
        return tHashSet;
    }

    private static void addEdge(@NotNull Map<VirtualFile, List<VirtualFile>> map, @NotNull VirtualFile key, @NotNull VirtualFile value) {
        if (map == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(13);
        }
        if (key == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(14);
        }
        if (value == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(15);
        }
        map.putIfAbsent(key, (List<VirtualFile>)ContainerUtil.createConcurrentList());
        map.get(key).add(value);
    }

    private static void addEdge(@NotNull Map<VirtualFile, List<VirtualFile>> map, @NotNull VirtualFile key, @NotNull Collection<VirtualFile> values) {
        if (map == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(16);
        }
        if (key == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(17);
        }
        if (values == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(18);
        }
        map.putIfAbsent(key, (List<VirtualFile>)ContainerUtil.createConcurrentList());
        map.get(key).addAll(values);
    }

    @NotNull
    public final TypeScriptFileImports getFileImports() {
        TypeScriptFileImports typeScriptFileImports = this.mySearcher;
        if (typeScriptFileImports == null) {
            TypeScriptImportGraph.$$$reportNull$$$0(19);
        }
        return typeScriptFileImports;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searcher";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toProcess";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFiles";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newOutFiles";
                break;
            }
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/tsconfig/graph/TypeScriptImportGraph";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/tsconfig/graph/TypeScriptImportGraph";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableFromRoots";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileImports";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "containsFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIn";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOut";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "recalculateEdges";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeOutNodesRecursive";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "validateNode";
                break;
            }
            case 12: 
            case 19: {
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addEdge";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$add$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

