/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.validation;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.types.JSTypeComparingCacheService;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.validation.JSFunctionSignatureChecker;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.psi.PsiElement;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class TypeScriptFunctionSignatureChecker
extends JSFunctionSignatureChecker {
    public TypeScriptFunctionSignatureChecker(JSTypeChecker<Annotation> typeChecker) {
        super(typeChecker);
    }

    @Override
    protected void registerProblem(JSCallExpression callExpression, String message, LocalQuickFix ... fixes) {
        PsiElement place = ValidateTypesUtil.getPlaceForSignatureProblem(callExpression, callExpression.getArgumentList());
        ProblemHighlightType highlightType = ProblemHighlightType.GENERIC_ERROR;
        JSExpression methodExpression = callExpression.getMethodExpression();
        if (methodExpression instanceof JSReferenceExpression && !TypeScriptUtil.resolveIsStrict((JSReferenceExpression)methodExpression)) {
            highlightType = ProblemHighlightType.WEAK_WARNING;
        }
        this.myTypeChecker.registerProblem(place, message, highlightType, fixes);
    }

    @Override
    protected void checkCallArgumentType(JSParameterItem p, JSExpression exp, JSCallExpression node, PsiElement resolveResult) {
        JSType type = this.addGenericArgumentsAndReportConstraintProblems(p.getType(), exp, node, resolveResult);
        this.myTypeChecker.checkExpressionIsAssignableToType(exp, type, "javascript.argument.type.mismatch", (PsiElement)(p instanceof JSParameter ? (JSParameter)p : null), JSTypeComparingCacheService.getProcessingContextWithCache((PsiElement)exp), false);
    }

    @Override
    @Nullable
    @Contract(value="!null, _, _, _ -> !null")
    protected JSType addGenericTypesFromCall(@Nullable JSType type, JSCallExpression callExpression, PsiElement resolveResult, JSGenericTypesEvaluator.GenericErrorReporter reporter) {
        if (JSTypeUtils.hasGenericParameter(type)) {
            type = TypeScriptGenericTypesEvaluator.getInstance().evaluateGenerics(type, callExpression.getMethodExpression(), resolveResult, reporter);
            JSTypeSubstitutor genericArguments = TypeScriptGenericTypesEvaluator.addExplicitGenericArgumentsFromCall(resolveResult, (PsiElement)callExpression, null);
            if (genericArguments != null && !genericArguments.isEmpty()) {
                return JSTypeUtils.applyGenericArguments(type, (Map<String, JSType>)genericArguments, true, reporter);
            }
        }
        return type;
    }

    @Override
    protected boolean obtainNextMatchedParams(int[] matchedParams, JSParameterItem[] parameters) {
        return false;
    }
}

