/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config.hints;

import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.spring.boot.application.config.hints.HintReferenceBase;
import com.intellij.util.ProcessingContext;
import java.util.Arrays;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StaticValuesReferenceProvider
extends PsiReferenceProvider {
    private final boolean myAllowOtherValues;
    private final boolean myCaseInsensitive;
    private final TextAttributesKey myTextAttributesKey;
    private final String[] values;

    StaticValuesReferenceProvider(boolean allowOtherValues, boolean caseInsensitive, TextAttributesKey textAttributesKey, String ... values) {
        this.myAllowOtherValues = allowOtherValues;
        this.myCaseInsensitive = caseInsensitive;
        this.myTextAttributesKey = textAttributesKey;
        Arrays.sort(values);
        this.values = values;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            StaticValuesReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            StaticValuesReferenceProvider.$$$reportNull$$$0(1);
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{this.createValueReference(element)};
        if (psiReferenceArray == null) {
            StaticValuesReferenceProvider.$$$reportNull$$$0(2);
        }
        return psiReferenceArray;
    }

    @NotNull
    protected final HintReferenceBase createValueReference(@NotNull PsiElement element) {
        if (element == null) {
            StaticValuesReferenceProvider.$$$reportNull$$$0(3);
        }
        HintReferenceBase hintReferenceBase = new HintReferenceBase(element){

            public TextAttributesKey getTextAttributesKey() {
                return StaticValuesReferenceProvider.this.myTextAttributesKey;
            }

            @Nullable
            protected PsiElement doResolve() {
                if (StaticValuesReferenceProvider.this.myAllowOtherValues) {
                    return this.myElement;
                }
                String value = StaticValuesReferenceProvider.this.myCaseInsensitive ? this.getValue().toUpperCase(Locale.US) : this.getValue();
                return Arrays.binarySearch(StaticValuesReferenceProvider.this.values, value.trim()) > -1 ? this.myElement : null;
            }

            @NotNull
            public Object[] getVariants() {
                Object[] objectArray = StaticValuesReferenceProvider.this.values;
                if (objectArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return objectArray;
            }

            @NotNull
            public String getUnresolvedMessagePattern() {
                if (StaticValuesReferenceProvider.this.values.length > 5) {
                    String string = super.getUnresolvedMessagePattern();
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }
                String string = "Invalid value ''{0}'', must be one of " + StringUtil.join((String[])StaticValuesReferenceProvider.this.values, (String)"|");
                if (string == null) {
                    1.$$$reportNull$$$0(2);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/spring/boot/application/config/hints/StaticValuesReferenceProvider$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getVariants";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getUnresolvedMessagePattern";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        if (hintReferenceBase == null) {
            StaticValuesReferenceProvider.$$$reportNull$$$0(4);
        }
        return hintReferenceBase;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/application/config/hints/StaticValuesReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/application/config/hints/StaticValuesReferenceProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createValueReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createValueReference";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

