/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonReader;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.boot.application.metadata.ConfigKeyDeclarationPsiElement;
import com.intellij.spring.boot.application.metadata.ConfigKeyDocumentationProviderBase;
import com.intellij.spring.boot.application.metadata.RelaxedNames;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyImpl;
import com.intellij.spring.boot.application.metadata.additional.SpringBootAdditionalConfigUtils;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.text.CharSequenceReader;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpringBootConfigurationMetadataParser {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.spring.boot.application.metadata.SpringBootConfigurationMetadataParser");
    @Nullable
    private final Module myLocalModule;
    @Nullable
    private final JsonFile myJsonPsiFile;
    @Nullable
    private final File myLocalJsonFile;
    private final String myLibraryName;
    private final Caching myCaching;
    private final NotNullLazyValue<Map<String, PsiElement>> myAdditionalConfigTargets;
    private static final Pair<PsiType, SpringBootApplicationMetaConfigKey.AccessType> DUMMY_TYPE = Pair.create((Object)PsiType.NULL, (Object)SpringBootApplicationMetaConfigKey.AccessType.NORMAL);

    SpringBootConfigurationMetadataParser(@NotNull JsonFile jsonPsiFile) {
        if (jsonPsiFile == null) {
            SpringBootConfigurationMetadataParser.$$$reportNull$$$0(0);
        }
        this.myAdditionalConfigTargets = new NotNullLazyValue<Map<String, PsiElement>>(){

            @NotNull
            protected Map<String, PsiElement> compute() {
                if (SpringBootConfigurationMetadataParser.this.myLocalModule == null) {
                    Map<String, PsiElement> map = Collections.emptyMap();
                    if (map == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return map;
                }
                HashMap<String, PsiElement> additionalConfigTargets = new HashMap<String, PsiElement>();
                SpringBootAdditionalConfigUtils utils = new SpringBootAdditionalConfigUtils(SpringBootConfigurationMetadataParser.this.myLocalModule);
                utils.processAdditionalMetadataFiles(file -> {
                    com.intellij.json.psi.JsonObject rootObject = (com.intellij.json.psi.JsonObject)ObjectUtils.tryCast((Object)file.getTopLevelValue(), com.intellij.json.psi.JsonObject.class);
                    if (rootObject == null) {
                        return true;
                    }
                    JsonProperty propertiesRoot = rootObject.findProperty("properties");
                    if (propertiesRoot == null) {
                        return true;
                    }
                    JsonArray propertiesArray = (JsonArray)ObjectUtils.tryCast((Object)propertiesRoot.getValue(), JsonArray.class);
                    if (propertiesArray == null) {
                        return true;
                    }
                    for (JsonValue value : propertiesArray.getValueList()) {
                        String key;
                        JsonStringLiteral nameValue;
                        JsonProperty nameProperty;
                        com.intellij.json.psi.JsonObject object = (com.intellij.json.psi.JsonObject)ObjectUtils.tryCast((Object)value, com.intellij.json.psi.JsonObject.class);
                        if (object == null || (nameProperty = object.findProperty("name")) == null || (nameValue = (JsonStringLiteral)ObjectUtils.tryCast((Object)nameProperty.getValue(), JsonStringLiteral.class)) == null || !StringUtil.isNotEmpty((String)(key = JsonPsiUtil.stripQuotes((String)nameValue.getValue())))) continue;
                        additionalConfigTargets.put(key, (PsiElement)nameProperty);
                    }
                    return true;
                });
                HashMap<String, PsiElement> hashMap = additionalConfigTargets;
                if (hashMap == null) {
                    1.$$$reportNull$$$0(1);
                }
                return hashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootConfigurationMetadataParser$1", "compute"));
            }
        };
        this.myJsonPsiFile = jsonPsiFile;
        this.myLocalJsonFile = null;
        this.myLocalModule = null;
        this.myLibraryName = SpringBootConfigurationMetadataParser.getLibraryOrContainingJarName(jsonPsiFile);
        this.myCaching = new Caching(jsonPsiFile.getResolveScope());
    }

    SpringBootConfigurationMetadataParser(@NotNull Module module, @NotNull File localJsonFile) {
        if (module == null) {
            SpringBootConfigurationMetadataParser.$$$reportNull$$$0(1);
        }
        if (localJsonFile == null) {
            SpringBootConfigurationMetadataParser.$$$reportNull$$$0(2);
        }
        this.myAdditionalConfigTargets = new /* invalid duplicate definition of identical inner class */;
        this.myLocalModule = module;
        this.myJsonPsiFile = null;
        this.myLocalJsonFile = localJsonFile;
        this.myLibraryName = this.myLocalModule.getName();
        this.myCaching = new Caching(module.getModuleRuntimeScope(false));
    }

    @NotNull
    private static String getLibraryOrContainingJarName(@NotNull JsonFile jsonFile) {
        OrderEntry libraryEntry;
        if (jsonFile == null) {
            SpringBootConfigurationMetadataParser.$$$reportNull$$$0(3);
        }
        if ((libraryEntry = LibraryUtil.findLibraryEntry((VirtualFile)jsonFile.getVirtualFile(), (Project)jsonFile.getProject())) instanceof LibraryOrderEntry) {
            String libraryName = ((LibraryOrderEntry)libraryEntry).getLibraryName();
            if (libraryName != null) {
                String string = libraryName;
                if (string == null) {
                    SpringBootConfigurationMetadataParser.$$$reportNull$$$0(4);
                }
                return string;
            }
            VirtualFile jarRoot = JarFileSystem.getInstance().getLocalByEntry(jsonFile.getVirtualFile());
            if (jarRoot != null) {
                String string = jarRoot.getName();
                if (string == null) {
                    SpringBootConfigurationMetadataParser.$$$reportNull$$$0(5);
                }
                return string;
            }
        }
        if ("<unknown>" == null) {
            SpringBootConfigurationMetadataParser.$$$reportNull$$$0(6);
        }
        return "<unknown>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processKeys(@NotNull Module module, @NotNull Processor<SpringBootApplicationMetaConfigKey> processor) {
        JsonObject rootObject;
        JsonElement parse;
        String path;
        JsonReader reader;
        block15: {
            if (module == null) {
                SpringBootConfigurationMetadataParser.$$$reportNull$$$0(7);
            }
            if (processor == null) {
                SpringBootConfigurationMetadataParser.$$$reportNull$$$0(8);
            }
            reader = null;
            path = null;
            if (this.myJsonPsiFile != null) {
                path = this.myJsonPsiFile.getVirtualFile().getPath();
                String content = VfsUtilCore.loadText((VirtualFile)this.myJsonPsiFile.getVirtualFile());
                reader = new JsonReader((Reader)new CharSequenceReader((CharSequence)content));
            } else {
                assert (this.myLocalJsonFile != null);
                path = this.myLocalJsonFile.getPath();
                reader = new JsonReader((Reader)new BufferedReader(new FileReader(this.myLocalJsonFile)));
            }
            reader.setLenient(true);
            parse = new JsonParser().parse(reader);
            if (parse.isJsonObject()) break block15;
            boolean bl = true;
            StreamUtil.closeStream((Closeable)reader);
            return bl;
        }
        try {
            rootObject = parse.getAsJsonObject();
        }
        catch (Throwable e) {
            try {
                LOG.error("Error parsing Spring Boot metadata JSON from " + path, e);
                boolean bl = true;
                return bl;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                StreamUtil.closeStream(reader);
            }
        }
        StreamUtil.closeStream((Closeable)reader);
        JsonElement propertiesElement = rootObject.get("properties");
        if (propertiesElement == null) {
            return true;
        }
        com.google.gson.JsonArray properties = propertiesElement.getAsJsonArray();
        Map<String, SpringBootApplicationMetaConfigKey.ItemHint> hints = SpringBootConfigurationMetadataParser.getItemHints(rootObject);
        for (JsonElement element : properties) {
            Pair<SpringBootApplicationMetaConfigKey.DeclarationResolveResult, PsiElement> declarationPair;
            SpringBootApplicationMetaConfigKey.ItemHint keyHint;
            SpringBootApplicationMetaConfigKey.ItemHint valueHint;
            JsonObject property = element.getAsJsonObject();
            String configKeyName = SpringBootConfigurationMetadataParser.getStringLiteral(property, "name");
            if (StringUtil.isEmptyOrSpaces((String)configKeyName)) continue;
            String typeLiteral = SpringBootConfigurationMetadataParser.getStringLiteral(property, "type");
            String finalType = Comparing.strEqual((String)typeLiteral, (String)"java.util.Properties") ? "java.util.Map<java.lang.String,java.lang.String>" : typeLiteral;
            Pair<PsiType, SpringBootApplicationMetaConfigKey.AccessType> typeWithAccess = SpringBootConfigurationMetadataParser.getPsiTypeToAccessType(module.getProject(), finalType);
            PsiType type = (PsiType)typeWithAccess.getFirst();
            SpringBootApplicationMetaConfigKey.AccessType accessType = (SpringBootApplicationMetaConfigKey.AccessType)typeWithAccess.getSecond();
            if (accessType == SpringBootApplicationMetaConfigKey.AccessType.MAP) {
                valueHint = hints.get(configKeyName + ".values");
                keyHint = hints.get(configKeyName + ".keys");
            } else {
                valueHint = hints.get(configKeyName);
                keyHint = SpringBootApplicationMetaConfigKey.ItemHint.NONE;
            }
            if ((declarationPair = this.getDeclaration(property, configKeyName, type)) == null || declarationPair.second == null) continue;
            ((PsiElement)declarationPair.second).putUserData(ConfigKeyDocumentationProviderBase.CONFIG_KEY_DECLARATION_MODULE, (Object)module);
            SpringBootApplicationMetaConfigKeyImpl key = new SpringBootApplicationMetaConfigKeyImpl((PsiElement)declarationPair.second, (SpringBootApplicationMetaConfigKey.DeclarationResolveResult)declarationPair.first, configKeyName, SpringBootConfigurationMetadataParser.getDescription(property), SpringBootConfigurationMetadataParser.getValueAsString(property, "defaultValue"), SpringBootConfigurationMetadataParser.getDeprecation(property), type, accessType, (SpringBootApplicationMetaConfigKey.ItemHint)ObjectUtils.notNull((Object)valueHint, (Object)SpringBootApplicationMetaConfigKey.ItemHint.NONE), (SpringBootApplicationMetaConfigKey.ItemHint)ObjectUtils.notNull((Object)keyHint, (Object)SpringBootApplicationMetaConfigKey.ItemHint.NONE));
            if (processor.process((Object)key)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static String getValueAsString(JsonObject object, String propertyName) {
        JsonElement propertyElement = object.get(propertyName);
        if (propertyElement == null) {
            return null;
        }
        if (propertyElement.isJsonPrimitive()) {
            return propertyElement.getAsJsonPrimitive().getAsString();
        }
        if (!propertyElement.isJsonArray()) {
            return null;
        }
        com.google.gson.JsonArray array = propertyElement.getAsJsonArray();
        SmartList valueList = new SmartList();
        for (JsonElement jsonValue : array) {
            if (!jsonValue.isJsonPrimitive()) continue;
            valueList.add(StringUtil.wrapWithDoubleQuote((String)jsonValue.getAsJsonPrimitive().getAsString()));
        }
        return "[" + StringUtil.join((Collection)valueList, (String)", ") + "]";
    }

    @Nullable
    private Pair<SpringBootApplicationMetaConfigKey.DeclarationResolveResult, PsiElement> getDeclaration(JsonObject entry, String configKeyName, PsiType type) {
        String sourceTypeText = SpringBootConfigurationMetadataParser.getStringLiteral(entry, "sourceType");
        if (StringUtil.isEmpty((String)sourceTypeText)) {
            return this.getFallbackDeclaration(configKeyName, type, false);
        }
        PsiClass sourceTypeClass = (PsiClass)this.myCaching.myCachedClass.get(sourceTypeText);
        if (sourceTypeClass == null) {
            return this.getFallbackDeclaration(configKeyName, type, true);
        }
        return Pair.pair((Object)SpringBootApplicationMetaConfigKey.DeclarationResolveResult.PROPERTY, (Object)new ConfigKeyDeclarationPsiElement(this.myLibraryName, (PsiElement)sourceTypeClass, SpringBootConfigurationMetadataParser.findPropertyNavigationTarget(sourceTypeClass, configKeyName), configKeyName, sourceTypeText, type));
    }

    @Nullable
    private Pair<SpringBootApplicationMetaConfigKey.DeclarationResolveResult, PsiElement> getFallbackDeclaration(String configKeyName, PsiType type, boolean unresolvedSourceTypeClass) {
        PsiElement additionalTarget = this.getAdditionalJsonDeclaration(configKeyName);
        if (this.myJsonPsiFile != null) {
            return Pair.pair((Object)(unresolvedSourceTypeClass ? SpringBootApplicationMetaConfigKey.DeclarationResolveResult.JSON_UNRESOLVED_SOURCE_TYPE : SpringBootApplicationMetaConfigKey.DeclarationResolveResult.JSON), (Object)new ConfigKeyDeclarationPsiElement(this.myLibraryName, (PsiElement)this.myJsonPsiFile, additionalTarget, configKeyName, configKeyName, type));
        }
        if (additionalTarget == null) {
            return null;
        }
        return Pair.pair((Object)SpringBootApplicationMetaConfigKey.DeclarationResolveResult.ADDITIONAL_JSON, (Object)new ConfigKeyDeclarationPsiElement(this.myLibraryName, additionalTarget, additionalTarget, configKeyName, configKeyName, type));
    }

    @Nullable
    private PsiElement getAdditionalJsonDeclaration(String configKeyName) {
        PsiElement additionalTarget = (PsiElement)((Map)this.myAdditionalConfigTargets.getValue()).get(configKeyName);
        return additionalTarget != null ? additionalTarget : this.myJsonPsiFile;
    }

    @NotNull
    private static PsiElement findPropertyNavigationTarget(@NotNull PsiClass sourceTypeClass, String configKeyName) {
        String propertyName;
        PsiMethod setter;
        if (sourceTypeClass == null) {
            SpringBootConfigurationMetadataParser.$$$reportNull$$$0(9);
        }
        if ((setter = PropertyUtilBase.findPropertySetter((PsiClass)sourceTypeClass, (String)(propertyName = RelaxedNames.dashedPropertyNameToCamelCase((String)configKeyName)), (boolean)false, (boolean)false)) != null) {
            PsiMethod psiMethod = setter;
            if (psiMethod == null) {
                SpringBootConfigurationMetadataParser.$$$reportNull$$$0(10);
            }
            return psiMethod;
        }
        PsiMethod getter = PropertyUtilBase.findPropertyGetter((PsiClass)sourceTypeClass, (String)propertyName, (boolean)false, (boolean)false);
        Object object = getter != null ? getter : sourceTypeClass;
        if (object == null) {
            SpringBootConfigurationMetadataParser.$$$reportNull$$$0(11);
        }
        return object;
    }

    private static SpringBootApplicationMetaConfigKey.DescriptionText getDescription(JsonObject property) {
        String descriptionText = SpringBootConfigurationMetadataParser.getStringLiteral(property, "description");
        if (descriptionText == null) {
            return SpringBootApplicationMetaConfigKey.DescriptionText.NONE;
        }
        return new SpringBootApplicationMetaConfigKey.DescriptionText(descriptionText);
    }

    private static SpringBootApplicationMetaConfigKey.Deprecation getDeprecation(JsonObject property) {
        JsonObject deprecationObject = property.getAsJsonObject("deprecation");
        if (deprecationObject != null) {
            String reasonText = SpringBootConfigurationMetadataParser.getStringLiteral(deprecationObject, "reason");
            SpringBootApplicationMetaConfigKey.DescriptionText reason = reasonText == null ? SpringBootApplicationMetaConfigKey.DescriptionText.NONE : new SpringBootApplicationMetaConfigKey.DescriptionText(reasonText);
            SpringBootApplicationMetaConfigKey.Deprecation.DeprecationLevel level = SpringBootApplicationMetaConfigKey.Deprecation.DeprecationLevel.WARNING;
            String levelLiteral = SpringBootConfigurationMetadataParser.getStringLiteral(deprecationObject, "level");
            SpringBootApplicationMetaConfigKey.Deprecation.DeprecationLevel parsedLevel = SpringBootApplicationMetaConfigKey.Deprecation.DeprecationLevel.parse((String)levelLiteral);
            if (parsedLevel != null) {
                level = parsedLevel;
            }
            String replacement = SpringBootConfigurationMetadataParser.getStringLiteral(deprecationObject, "replacement");
            return new SpringBootApplicationMetaConfigKey.Deprecation(reason, level, replacement);
        }
        JsonPrimitive deprecatedProperty = property.getAsJsonPrimitive("deprecated");
        if (deprecatedProperty != null && deprecatedProperty.getAsBoolean()) {
            return SpringBootApplicationMetaConfigKey.Deprecation.DEPRECATED_WITHOUT_REASON;
        }
        return SpringBootApplicationMetaConfigKey.Deprecation.NOT_DEPRECATED;
    }

    private static Map<String, SpringBootApplicationMetaConfigKey.ItemHint> getItemHints(JsonObject rootObject) {
        JsonElement hintsElement = rootObject.get("hints");
        if (hintsElement == null) {
            return Collections.emptyMap();
        }
        HashMap<String, SpringBootApplicationMetaConfigKey.ItemHint> itemHintsMap = new HashMap<String, SpringBootApplicationMetaConfigKey.ItemHint>();
        for (JsonElement value : hintsElement.getAsJsonArray()) {
            JsonObject entry = value.getAsJsonObject();
            String nameValue = SpringBootConfigurationMetadataParser.getStringLiteral(entry, "name");
            if (nameValue == null) continue;
            itemHintsMap.put(nameValue, SpringBootConfigurationMetadataParser.createItemHint(entry));
        }
        return itemHintsMap;
    }

    private static SpringBootApplicationMetaConfigKey.ItemHint createItemHint(JsonObject entry) {
        List<SpringBootApplicationMetaConfigKey.ValueProvider> providers = SpringBootConfigurationMetadataParser.getItemHintProviders(entry);
        List<SpringBootApplicationMetaConfigKey.ValueHint> values = SpringBootConfigurationMetadataParser.getItemHintValues(entry);
        return new SpringBootApplicationMetaConfigKey.ItemHint(providers, values);
    }

    private static List<SpringBootApplicationMetaConfigKey.ValueProvider> getItemHintProviders(JsonObject entry) {
        JsonElement providersObject = entry.get("providers");
        if (providersObject == null) {
            return Collections.emptyList();
        }
        List providers = ContainerUtil.newSmartList();
        for (JsonElement arrayValue : providersObject.getAsJsonArray()) {
            JsonObject providerObject;
            String name;
            if (!arrayValue.isJsonObject() || (name = SpringBootConfigurationMetadataParser.getStringLiteral(providerObject = arrayValue.getAsJsonObject(), "name")) == null) continue;
            Map<String, String> parameters = SpringBootConfigurationMetadataParser.getItemHintProviderParameters(providerObject);
            providers.add(new SpringBootApplicationMetaConfigKey.ValueProvider(name, parameters));
        }
        return providers;
    }

    private static Map<String, String> getItemHintProviderParameters(JsonObject entry) {
        JsonElement parametersProperty = entry.get("parameters");
        if (parametersProperty == null || !parametersProperty.isJsonObject()) {
            return Collections.emptyMap();
        }
        JsonObject parametersObject = parametersProperty.getAsJsonObject();
        LinkedHashMap parameters = ContainerUtil.newLinkedHashMap();
        for (Map.Entry parameterProperty : parametersObject.entrySet()) {
            JsonElement value = (JsonElement)parameterProperty.getValue();
            if (value == null || !value.isJsonPrimitive()) continue;
            JsonPrimitive primitive = value.getAsJsonPrimitive();
            parameters.put(parameterProperty.getKey(), primitive.getAsString());
        }
        return parameters;
    }

    private static List<SpringBootApplicationMetaConfigKey.ValueHint> getItemHintValues(JsonObject entry) {
        JsonElement valuesObject = entry.get("values");
        if (valuesObject == null || !valuesObject.isJsonArray()) {
            return Collections.emptyList();
        }
        List values = ContainerUtil.newSmartList();
        for (JsonElement arrayValue : valuesObject.getAsJsonArray()) {
            JsonObject valueObject;
            String value;
            if (!arrayValue.isJsonObject() || (value = SpringBootConfigurationMetadataParser.getStringLiteral(valueObject = arrayValue.getAsJsonObject(), "value")) == null) continue;
            values.add(new SpringBootApplicationMetaConfigKey.ValueHint(value, SpringBootConfigurationMetadataParser.getDescription(valueObject)));
        }
        return values;
    }

    @Nullable
    private static String getStringLiteral(JsonObject object, String propertyName) {
        JsonElement property = object.get(propertyName);
        return property != null ? property.getAsString() : null;
    }

    private static Pair<PsiType, SpringBootApplicationMetaConfigKey.AccessType> getPsiTypeToAccessType(Project project, String type) {
        Map myCachedTypes = (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            PsiElementFactory myElementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            ConcurrentMap myFactoryMap = ConcurrentFactoryMap.createMap(arg_0 -> SpringBootConfigurationMetadataParser.lambda$null$0((PsiJavaParserFacade)myElementFactory, arg_0));
            return CachedValueProvider.Result.create((Object)myFactoryMap, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
        return (Pair)myCachedTypes.get(type);
    }

    private static SpringBootApplicationMetaConfigKey.AccessType getAccessType(PsiType type) {
        if (type instanceof PsiArrayType) {
            return SpringBootApplicationMetaConfigKey.AccessType.INDEXED;
        }
        PsiClass resolve = PsiTypesUtil.getPsiClass((PsiType)type);
        if (resolve == null) {
            return SpringBootApplicationMetaConfigKey.AccessType.NORMAL;
        }
        if (resolve.isEnum()) {
            return SpringBootApplicationMetaConfigKey.AccessType.NORMAL;
        }
        String fqn = resolve.getQualifiedName();
        if ("java.util.Map".equals(fqn)) {
            return SpringBootApplicationMetaConfigKey.AccessType.MAP;
        }
        if ("java.util.List".equals(fqn)) {
            return SpringBootApplicationMetaConfigKey.AccessType.INDEXED;
        }
        return SpringBootApplicationMetaConfigKey.AccessType.NORMAL;
    }

    private static /* synthetic */ Pair lambda$null$0(PsiJavaParserFacade myElementFactory, String key) {
        if (key == null) {
            return DUMMY_TYPE;
        }
        try {
            PsiType psiType = myElementFactory.createTypeFromText(key.replace('$', '.'), null);
            return Pair.create((Object)psiType, (Object)SpringBootConfigurationMetadataParser.getAccessType(psiType));
        }
        catch (IncorrectOperationException e) {
            return DUMMY_TYPE;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonPsiFile";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localJsonFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonFile";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/application/metadata/SpringBootConfigurationMetadataParser";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceTypeClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/application/metadata/SpringBootConfigurationMetadataParser";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryOrContainingJarName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findPropertyNavigationTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryOrContainingJarName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processKeys";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findPropertyNavigationTarget";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Caching {
        private final JavaPsiFacade myJavaPsiFacade;
        private final GlobalSearchScope mySearchScope;
        private final Map<String, PsiClass> myCachedClass;

        private Caching(GlobalSearchScope scope) {
            this.myJavaPsiFacade = JavaPsiFacade.getInstance((Project)scope.getProject());
            this.mySearchScope = scope;
            this.myCachedClass = FactoryMap.create(key -> this.myJavaPsiFacade.findClass(key.replace('$', '.'), this.mySearchScope));
        }
    }
}

