/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.banner;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.spring.boot.banner.SpringBootBannerPropertyReference;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.SpringBootConfigValueSearcher;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.spring.constants.SpringReferencePatternConditions;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class SpringBootBannerReferenceContributor
extends PsiReferenceContributor {
    private static boolean TEST_MODE = ApplicationManager.getApplication().isUnitTestMode();
    private static final PatternCondition<PsiPlainTextFile> IS_BANNER_FILE_CONDITION = new PatternCondition<PsiPlainTextFile>("isBannerFile"){

        public boolean accepts(@NotNull PsiPlainTextFile file, ProcessingContext context) {
            Ref foundConfigKey;
            Processor findBannerFileProcessor;
            Module module;
            if (file == null) {
                1.$$$reportNull$$$0(0);
            }
            if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file)) == null) {
                return false;
            }
            ModuleFileIndex index = ModuleRootManager.getInstance((Module)module).getFileIndex();
            if (!TEST_MODE && !index.isUnderSourceRootOfType(file.getOriginalFile().getVirtualFile(), JavaModuleSourceRootTypes.RESOURCES)) {
                return false;
            }
            SpringBootConfigValueSearcher searcher = SpringBootConfigValueSearcher.productionForProfiles((Module)module, (String)"banner.location", null);
            if (!searcher.process(findBannerFileProcessor = arg_0 -> 1.lambda$accepts$0(foundConfigKey = Ref.create((Object)false), file, arg_0))) {
                return true;
            }
            if (((Boolean)foundConfigKey.get()).booleanValue()) {
                return false;
            }
            return file.getName().equals("banner.txt");
        }

        private static /* synthetic */ boolean lambda$accepts$0(Ref foundConfigKey, @NotNull PsiPlainTextFile file, SpringBootModelConfigFileContributor.ConfigurationValueResult result) {
            if (file == null) {
                1.$$$reportNull$$$0(1);
            }
            foundConfigKey.set((Object)true);
            if (result.valueElement == null) {
                return true;
            }
            for (PsiReference reference : result.valueElement.getReferences()) {
                if (!file.isEquivalentTo(reference.resolve())) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "file";
            objectArray2[1] = "com/intellij/spring/boot/banner/SpringBootBannerReferenceContributor$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "accepts";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$accepts$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final PsiElementPattern.Capture<PsiPlainTextFile> PATTERN = (PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PsiPlainTextFile.class).with(SpringReferencePatternConditions.PROJECT_HAS_SPRING_FACETS_CONDITION)).with((PatternCondition)new PatternCondition<PsiPlainTextFile>("springBootLibrary"){

        public boolean accepts(@NotNull PsiPlainTextFile file, ProcessingContext context) {
            if (file == null) {
                2.$$$reportNull$$$0(0);
            }
            return SpringBootLibraryUtil.hasSpringBootLibrary((Project)file.getProject());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/boot/banner/SpringBootBannerReferenceContributor$2", "accepts"));
        }
    })).with(IS_BANNER_FILE_CONDITION);
    static final String PREFIX = "${";
    static final String SUFFIX = "}";

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            SpringBootBannerReferenceContributor.$$$reportNull$$$0(0);
        }
        registrar.registerReferenceProvider(PATTERN, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                Module module;
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    3.$$$reportNull$$$0(1);
                }
                if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) == null) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        3.$$$reportNull$$$0(2);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                boolean is13 = SpringBootLibraryUtil.isAtLeastVersion((Module)module, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_1_3_0);
                SmartList references = new SmartList();
                String text = element.getText();
                int startOffset = 0;
                while ((startOffset = text.indexOf(SpringBootBannerReferenceContributor.PREFIX, startOffset)) != -1) {
                    int endOffset = text.indexOf(SpringBootBannerReferenceContributor.SUFFIX, startOffset + SpringBootBannerReferenceContributor.PREFIX.length());
                    if (endOffset == -1) {
                        startOffset += SpringBootBannerReferenceContributor.PREFIX.length();
                        continue;
                    }
                    TextRange range = TextRange.create((int)(startOffset + SpringBootBannerReferenceContributor.PREFIX.length()), (int)endOffset);
                    SpringBootBannerPropertyReference reference = new SpringBootBannerPropertyReference(element, range, is13);
                    references.add(reference);
                    startOffset = endOffset + SpringBootBannerReferenceContributor.SUFFIX.length();
                }
                PsiReference[] psiReferenceArray = references.toArray(new PsiReference[references.size()]);
                if (psiReferenceArray == null) {
                    3.$$$reportNull$$$0(3);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/spring/boot/banner/SpringBootBannerReferenceContributor$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/spring/boot/banner/SpringBootBannerReferenceContributor$3";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/spring/boot/banner/SpringBootBannerReferenceContributor", "registerReferenceProviders"));
    }
}

