/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure;

import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.semantic.SemService;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.spring.boot.model.autoconfigure.jam.ConditionalOnEvaluationContext;
import com.intellij.spring.boot.model.autoconfigure.jam.ConditionalOnJamElement;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AutoConfigClassConditionEvaluator {
    private static final boolean FILTER_AUTO_CONFIGS = SystemProperties.getBooleanProperty((String)"idea.spring.boot.filter.autoconfig", (boolean)true);
    private final Module myModule;
    private final boolean myNonStrictEvaluation;
    private final PsiClass myAutoConfigClass;
    private final Set<String> myActiveProfiles;
    private final Function<SpringBootModelConfigFileContributor, List<List<VirtualFile>>> myConfigFiles;

    AutoConfigClassConditionEvaluator(Module module, boolean nonStrictEvaluation, PsiClass autoConfigClass, Set<String> profiles, Function<SpringBootModelConfigFileContributor, List<List<VirtualFile>>> configFiles) {
        this.myModule = module;
        this.myNonStrictEvaluation = nonStrictEvaluation;
        this.myAutoConfigClass = autoConfigClass;
        this.myActiveProfiles = profiles;
        this.myConfigFiles = configFiles;
    }

    boolean isActive() {
        if (!FILTER_AUTO_CONFIGS) {
            return true;
        }
        PsiModifierList modifierList = this.myAutoConfigClass.getModifierList();
        if (modifierList == null) {
            return false;
        }
        List<ConditionalOnJamElement> allConditions = AutoConfigClassConditionEvaluator.getConditionalJamElements(this.myAutoConfigClass, modifierList);
        if (allConditions.isEmpty()) {
            return true;
        }
        ConditionalOnEvaluationContext evaluationContext = this.createConditionalOnEvaluationContext();
        for (ConditionalOnJamElement condition : allConditions) {
            if (this.myNonStrictEvaluation && condition instanceof ConditionalOnJamElement.NonStrict || condition.value((Object)evaluationContext)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private ConditionalOnEvaluationContext createConditionalOnEvaluationContext() {
        ConditionalOnEvaluationContext conditionalOnEvaluationContext = new ConditionalOnEvaluationContext(){

            @NotNull
            public PsiClass getAutoConfigClass() {
                PsiClass psiClass = AutoConfigClassConditionEvaluator.this.myAutoConfigClass;
                if (psiClass == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiClass;
            }

            @NotNull
            public Module getModule() {
                Module module = AutoConfigClassConditionEvaluator.this.myModule;
                if (module == null) {
                    1.$$$reportNull$$$0(1);
                }
                return module;
            }

            @Nullable
            public Set<String> getActiveProfiles() {
                return AutoConfigClassConditionEvaluator.this.myActiveProfiles;
            }

            @NotNull
            public List<List<VirtualFile>> getUserConfigurationFiles(SpringBootModelConfigFileContributor contributor) {
                List list = (List)AutoConfigClassConditionEvaluator.this.myConfigFiles.fun((Object)contributor);
                if (list == null) {
                    1.$$$reportNull$$$0(2);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/spring/boot/model/autoconfigure/AutoConfigClassConditionEvaluator$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAutoConfigClass";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getModule";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getUserConfigurationFiles";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        if (conditionalOnEvaluationContext == null) {
            AutoConfigClassConditionEvaluator.$$$reportNull$$$0(0);
        }
        return conditionalOnEvaluationContext;
    }

    @NotNull
    private static List<ConditionalOnJamElement> getConditionalJamElements(PsiClass autoConfigClass, PsiModifierList modifierList) {
        List allConditionalMeta = SemService.getSemService((Project)autoConfigClass.getProject()).getSemElements(ConditionalOnJamElement.MEMBER_META_KEY, (PsiElement)autoConfigClass);
        if (allConditionalMeta.isEmpty()) {
            List<ConditionalOnJamElement> list = Collections.emptyList();
            if (list == null) {
                AutoConfigClassConditionEvaluator.$$$reportNull$$$0(1);
            }
            return list;
        }
        SmartList allConditionalJamElements = new SmartList();
        block0: for (PsiAnnotation annotation : modifierList.getAnnotations()) {
            for (JamMemberMeta memberMeta : allConditionalMeta) {
                JamAnnotationMeta jamAnnotationMeta = memberMeta.findAnnotationMeta(annotation);
                if (jamAnnotationMeta == null) continue;
                ConditionalOnJamElement jamElement = (ConditionalOnJamElement)memberMeta.getJamElement((PsiModifierListOwner)autoConfigClass);
                allConditionalJamElements.add(jamElement);
                continue block0;
            }
        }
        SmartList smartList = allConditionalJamElements;
        if (smartList == null) {
            AutoConfigClassConditionEvaluator.$$$reportNull$$$0(2);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/spring/boot/model/autoconfigure/AutoConfigClassConditionEvaluator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createConditionalOnEvaluationContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConditionalJamElements";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

