/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.number;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.util.ParenthesesUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.utils.BinaryOperatorUtils;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.intellij.idea.lang.javascript.intention.number.ShiftUtils;
import org.intellij.idea.lang.javascript.psiutil.JSElementFactory;
import org.jetbrains.annotations.NotNull;

public class JSReplaceMultiplyWithShiftIntention
extends JSMutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        IElementType tokenType = ((JSBinaryExpression)element).getOperationSign();
        String operatorString = element instanceof JSAssignmentExpression ? (tokenType.equals(JSTokenTypes.MULTEQ) ? "<<=" : ">>=") : (tokenType.equals(JSTokenTypes.MULT) ? "<<" : ">>");
        return this.getText(BinaryOperatorUtils.getOperatorText((IElementType)tokenType), operatorString);
    }

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        MultiplyByPowerOfTwoPredicate multiplyByPowerOfTwoPredicate = new MultiplyByPowerOfTwoPredicate();
        if (multiplyByPowerOfTwoPredicate == null) {
            JSReplaceMultiplyWithShiftIntention.$$$reportNull$$$0(0);
        }
        return multiplyByPowerOfTwoPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSReplaceMultiplyWithShiftIntention.$$$reportNull$$$0(1);
        }
        if (element instanceof JSAssignmentExpression) {
            this.replaceMultiplyOrDivideAssignWithShiftAssign((JSAssignmentExpression)element);
        } else {
            this.replaceMultiplyOrDivideWithShift((JSBinaryExpression)element);
        }
    }

    private void replaceMultiplyOrDivideAssignWithShiftAssign(JSAssignmentExpression exp) throws IncorrectOperationException {
        JSExpression lhs = exp.getLOperand();
        JSExpression rhs = exp.getROperand();
        IElementType tokenType = exp.getOperationSign();
        String assignString = tokenType.equals(JSTokenTypes.MULTEQ) ? "<<=" : ">>=";
        String expString = lhs.getText() + assignString + ShiftUtils.getLogBase2(rhs);
        JSElementFactory.replaceExpression((JSExpression)exp, expString);
    }

    private void replaceMultiplyOrDivideWithShift(JSBinaryExpression exp) throws IncorrectOperationException {
        String operatorString;
        JSExpression lhs = exp.getLOperand();
        JSExpression rhs = exp.getROperand();
        IElementType tokenType = exp.getOperationSign();
        String string = operatorString = tokenType.equals(JSTokenTypes.MULT) ? "<<" : ">>";
        if (ShiftUtils.isPowerOfTwo(lhs) && tokenType.equals(JSTokenTypes.MULT)) {
            JSExpression swap = lhs;
            lhs = rhs;
            rhs = swap;
        }
        String lhsText = ParenthesesUtils.getParenthesized((JSExpression)lhs, (int)7);
        String expString = lhsText + operatorString + ShiftUtils.getLogBase2(rhs);
        JSElement parent = (JSElement)exp.getParent();
        if (parent != null && parent instanceof JSExpression && !(parent instanceof JSParenthesizedExpression) && ParenthesesUtils.getPrecedence((JSExpression)((JSExpression)parent)) < 7) {
            expString = '(' + expString + ')';
        }
        JSElementFactory.replaceExpression((JSExpression)exp, expString);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/number/JSReplaceMultiplyWithShiftIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/number/JSReplaceMultiplyWithShiftIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MultiplyByPowerOfTwoPredicate
    implements JSElementPredicate {
        private MultiplyByPowerOfTwoPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                MultiplyByPowerOfTwoPredicate.$$$reportNull$$$0(0);
            }
            if (element instanceof JSAssignmentExpression) {
                return MultiplyByPowerOfTwoPredicate.isMultiplyByPowerOfTwo((JSAssignmentExpression)element);
            }
            if (element instanceof JSBinaryExpression) {
                return MultiplyByPowerOfTwoPredicate.isMultiplyByPowerOfTwo((JSBinaryExpression)element);
            }
            return false;
        }

        private static boolean isMultiplyByPowerOfTwo(JSAssignmentExpression expression) {
            IElementType operator = expression.getOperationSign();
            if (operator == null || !operator.equals(JSTokenTypes.MULTEQ) && !operator.equals(JSTokenTypes.DIVEQ)) {
                return false;
            }
            JSExpression rightExpression = expression.getROperand();
            if (rightExpression == null) {
                return false;
            }
            return ShiftUtils.isPowerOfTwo(rightExpression);
        }

        private static boolean isMultiplyByPowerOfTwo(JSBinaryExpression expression) {
            IElementType operator = expression.getOperationSign();
            if (operator == null || !operator.equals(JSTokenTypes.MULT) && !operator.equals(JSTokenTypes.DIV)) {
                return false;
            }
            JSExpression leftOperand = expression.getLOperand();
            JSExpression rightOperand = expression.getROperand();
            if (leftOperand == null || rightOperand == null) {
                return false;
            }
            return ShiftUtils.isPowerOfTwo(leftOperand) || ShiftUtils.isPowerOfTwo(rightOperand);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/number/JSReplaceMultiplyWithShiftIntention$MultiplyByPowerOfTwoPredicate", "satisfiedBy"));
        }
    }
}

