/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.jsp.JspxFileViewProvider;
import com.intellij.lang.jsp.NewJspLanguage;
import com.intellij.lang.jspx.JSPXLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.html.ScriptSupportUtil;
import com.intellij.psi.jsp.BaseJspFile;
import com.intellij.psi.jsp.BaseJspUtil;
import com.intellij.psi.jsp.JspDirectiveKind;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.reference.SoftReference;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class BaseJspFileImpl
extends PsiFileImpl
implements BaseJspFile {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.jsp.JspxFileImpl");
    private SoftReference<Map<JspDirectiveKind, XmlTag[]>> myDirectives;

    public BaseJspFileImpl(@NotNull JspxFileViewProvider viewProvider) {
        if (viewProvider == null) {
            BaseJspFileImpl.$$$reportNull$$$0(0);
        }
        super((IElementType)((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(viewProvider.getBaseLanguage())).getFileNodeType(), (IElementType)((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(viewProvider.getBaseLanguage())).getFileNodeType(), (FileViewProvider)viewProvider);
        this.myDirectives = null;
    }

    public PsiFile getBaseLanguageRoot() {
        return this.getViewProvider().getPsi(this.getViewProvider().getTemplateDataLanguage());
    }

    public PsiElement[] getContentsElements() {
        XmlTag rootTag = this.getDocument().getRootTag();
        if (rootTag == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        if ("root".equals(rootTag.getLocalName()) && "http://java.sun.com/JSP/Page".equals(rootTag.getNamespace())) {
            return rootTag.getValue().getChildren();
        }
        return new PsiElement[]{rootTag};
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            BaseJspFileImpl.$$$reportNull$$$0(1);
        }
        visitor.visitFile((PsiFile)this);
    }

    @NotNull
    public FileType getFileType() {
        Language language = this.getLanguage();
        if (language == Language.findInstance(NewJspLanguage.class)) {
            LanguageFileType languageFileType = StdFileTypes.JSP;
            if (languageFileType == null) {
                BaseJspFileImpl.$$$reportNull$$$0(2);
            }
            return languageFileType;
        }
        LanguageFileType languageFileType = StdFileTypes.JSPX;
        if (languageFileType == null) {
            BaseJspFileImpl.$$$reportNull$$$0(3);
        }
        return languageFileType;
    }

    public String toString() {
        return "JspxFile:" + this.getName();
    }

    public XmlDocument getDocument() {
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof XmlDocument)) continue;
            return (XmlDocument)child;
        }
        return null;
    }

    @NotNull
    public XmlTag getRootTag() {
        XmlDocument document = this.getDocument();
        assert (document != null);
        XmlTag rootTag = document.getRootTag();
        assert (rootTag != null);
        XmlTag xmlTag = rootTag;
        if (xmlTag == null) {
            BaseJspFileImpl.$$$reportNull$$$0(4);
        }
        return xmlTag;
    }

    public boolean processElements(PsiElementProcessor processor, PsiElement place) {
        XmlDocument document = this.getDocument();
        return document == null || document.processElements(processor, place);
    }

    public void clearCaches() {
        super.clearCaches();
        this.myDirectives = null;
        if (this.getLanguage() == JSPXLanguage.INSTANCE) {
            ScriptSupportUtil.clearCaches((XmlFile)this);
        }
    }

    public boolean isErrorPage() {
        XmlTag[] directiveTags;
        for (XmlTag directiveTag : directiveTags = this.getDirectiveTags(JspDirectiveKind.PAGE, true)) {
            String isErrorPage = directiveTag.getAttributeValue("isErrorPage");
            if (isErrorPage == null) continue;
            return Boolean.parseBoolean(isErrorPage);
        }
        return false;
    }

    public PsiFile getErrorPage() {
        XmlTag[] directiveTags;
        for (XmlTag directiveTag : directiveTags = this.getDirectiveTags(JspDirectiveKind.PAGE, true)) {
            PsiReference[] references;
            XmlAttributeValue valueElement;
            XmlAttribute errorPage = directiveTag.getAttribute("errorPage", null);
            if (errorPage == null || (valueElement = errorPage.getValueElement()) == null) continue;
            for (PsiReference reference : references = valueElement.getReferences()) {
                PsiElement element = reference.resolve();
                if (!(element instanceof PsiFile)) continue;
                return (PsiFile)element;
            }
        }
        return null;
    }

    public boolean isSessionPage() {
        XmlTag[] directiveTags;
        for (XmlTag directiveTag : directiveTags = this.getDirectiveTags(JspDirectiveKind.PAGE, true)) {
            String session = directiveTag.getAttributeValue("session");
            if (session == null) continue;
            return Boolean.parseBoolean(session);
        }
        return true;
    }

    @NotNull
    public Language getLanguage() {
        Language language = this.getViewProvider().getBaseLanguage();
        if (language == null) {
            BaseJspFileImpl.$$$reportNull$$$0(5);
        }
        return language;
    }

    public XmlTag[] getDirectiveTags(JspDirectiveKind directiveKind, boolean searchInIncludes) {
        if (searchInIncludes) {
            ArrayList<XmlTag> directives = new ArrayList<XmlTag>(Arrays.asList(this.getDirectiveTags(directiveKind, false)));
            this.visitAllIncludedFilesRecursively(this, jspFile -> {
                ContainerUtil.addAll((Collection)directives, (Object[])jspFile.getDirectiveTags(directiveKind, false));
                return true;
            });
            return (XmlTag[])ContainerUtil.toArray(directives, (Object[])new XmlTag[directives.size()]);
        }
        Map deref = (Map)SoftReference.dereference(this.myDirectives);
        if (deref != null) {
            XmlTag[] xmlTags = (XmlTag[])deref.get(directiveKind);
            return xmlTags == null ? XmlTag.EMPTY : xmlTags;
        }
        final EnumMap directivesMap = new EnumMap(JspDirectiveKind.class);
        XmlUtil.processXmlElements((XmlElement)this.getDocument(), (PsiElementProcessor)new PsiElementProcessor(){

            public boolean execute(@NotNull PsiElement element) {
                XmlTag xmlTag;
                JspDirectiveKind directiveKindByTag;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element instanceof XmlTag && (directiveKindByTag = BaseJspUtil.getDirectiveKindByTag(xmlTag = (XmlTag)element)) != null) {
                    ArrayList<XmlTag> xmlTags = (ArrayList<XmlTag>)directivesMap.get(directiveKindByTag);
                    if (xmlTags == null) {
                        xmlTags = new ArrayList<XmlTag>(10);
                        directivesMap.put(directiveKindByTag, xmlTags);
                    }
                    xmlTags.add(xmlTag);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/jsp/BaseJspFileImpl$1", "execute"));
            }
        }, (boolean)true);
        EnumMap<JspDirectiveKind, Object[]> directives = new EnumMap<JspDirectiveKind, Object[]>(JspDirectiveKind.class);
        for (Map.Entry entry : directivesMap.entrySet()) {
            List tags = (List)entry.getValue();
            directives.put((JspDirectiveKind)entry.getKey(), ContainerUtil.toArray((List)tags, (Object[])new XmlTag[tags.size()]));
        }
        this.myDirectives = new SoftReference(directives);
        return this.getDirectiveTags(directiveKind, false);
    }

    protected <T extends BaseJspFile> void visitAllIncludedFilesRecursively(T baseJspFile, Processor<T> processor) {
        BaseJspUtil.visitAllIncludedFilesRecursively(baseJspFile, processor);
    }

    public XmlTag createDirective(XmlTag context, JspDirectiveKind directiveKind) {
        String localName = BaseJspUtil.getDirectiveAttributeName(directiveKind, this);
        XmlTag parent = context == null || this.getLanguage() == StdLanguages.JSP ? this.getRootTag() : context;
        LOG.assertTrue(parent != null);
        return parent.createChildTag(localName, "http://java.sun.com/JSP/Page", null, true);
    }

    public XmlTag createDirective(JspDirectiveKind directiveKind) {
        return this.createDirective(null, directiveKind);
    }

    public boolean isTagPage() {
        String name = this.getName();
        return BaseJspFileImpl.getExtension(name).startsWith("tag");
    }

    private static String getExtension(String name) {
        int extensionStart = name.lastIndexOf(46);
        String extension = "";
        if (extensionStart >= 0) {
            extension = name.substring(extensionStart + 1);
        }
        return extension;
    }

    @NotNull
    public JspxFileViewProvider getViewProvider() {
        JspxFileViewProvider jspxFileViewProvider = (JspxFileViewProvider)super.getViewProvider();
        if (jspxFileViewProvider == null) {
            BaseJspFileImpl.$$$reportNull$$$0(6);
        }
        return jspxFileViewProvider;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        boolean b;
        if (processor == null) {
            BaseJspFileImpl.$$$reportNull$$$0(7);
        }
        if (state == null) {
            BaseJspFileImpl.$$$reportNull$$$0(8);
        }
        if (place == null) {
            BaseJspFileImpl.$$$reportNull$$$0(9);
        }
        if ((b = super.processDeclarations(processor, state, lastParent, place)) && this.getLanguage() == JSPXLanguage.INSTANCE) {
            b = ScriptSupportUtil.processDeclarations((XmlFile)this, (PsiScopeProcessor)processor, (ResolveState)state, (PsiElement)lastParent, (PsiElement)place);
        }
        return b;
    }

    public boolean isTemplateDataFile() {
        return true;
    }

    @NotNull
    public GlobalSearchScope getFileResolveScope() {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this);
        GlobalSearchScope globalSearchScope = module != null ? module.getModuleWithDependenciesAndLibrariesScope(true) : GlobalSearchScope.allScope((Project)this.getProject());
        if (globalSearchScope == null) {
            BaseJspFileImpl.$$$reportNull$$$0(10);
        }
        return globalSearchScope;
    }

    public boolean ignoreReferencedElementAccessibility() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/jsp/BaseJspFileImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/jsp/BaseJspFileImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootTag";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewProvider";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileResolveScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

