/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceSet;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JspImportListReferenceProvider
extends JavaClassReferenceProvider {
    @NonNls
    private static final String STATIC_PREFIX = "static ";

    public JspImportListReferenceProvider() {
        THashMap options = new THashMap();
        options.put(RESOLVE_QUALIFIED_CLASS_NAME, Boolean.TRUE);
        options.put(ADVANCED_RESOLVE, Boolean.TRUE);
        this.setOptions((Map)options);
    }

    @NotNull
    public PsiReference[] getReferencesByString(String str, @NotNull PsiElement position, int offsetInPosition) {
        if (position == null) {
            JspImportListReferenceProvider.$$$reportNull$$$0(0);
        }
        ArrayList<JavaClassReference> results = new ArrayList<JavaClassReference>();
        int lastReferencePosition = 0;
        do {
            JavaClassReference[] allReferences;
            int i;
            int nextReferenceStart;
            String identifier;
            if ((identifier = str.substring(lastReferencePosition, nextReferenceStart = (i = str.indexOf(44, lastReferencePosition)) >= 0 ? i : str.length())).isEmpty()) {
                lastReferencePosition = nextReferenceStart + 1;
                continue;
            }
            int whitespaceShift = 0;
            while (whitespaceShift < identifier.length() && Character.isWhitespace(identifier.charAt(whitespaceShift++))) {
            }
            lastReferencePosition += whitespaceShift - 1;
            identifier = identifier.substring(whitespaceShift - 1);
            boolean isStatic = false;
            if (identifier.startsWith(STATIC_PREFIX)) {
                identifier = identifier.substring(STATIC_PREFIX.length());
                lastReferencePosition += STATIC_PREFIX.length();
                isStatic = true;
            }
            JavaClassReferenceSet referenceSet = new JavaClassReferenceSet(identifier.trim(), position, offsetInPosition + lastReferencePosition, isStatic, this){

                protected boolean isStaticSeparator(char c, boolean strict) {
                    return !strict && (c == '.' || c == '$');
                }

                public boolean isAllowDollarInNames() {
                    return false;
                }
            };
            for (JavaClassReference allReference : allReferences = referenceSet.getAllReferences()) {
                if ("*".equals(allReference.getCanonicalText())) continue;
                results.add(allReference);
            }
            lastReferencePosition = nextReferenceStart + 1;
        } while (lastReferencePosition < str.length());
        PsiReference[] psiReferenceArray = results.toArray(new PsiReference[results.size()]);
        if (psiReferenceArray == null) {
            JspImportListReferenceProvider.$$$reportNull$$$0(1);
        }
        return psiReferenceArray;
    }

    public boolean isSoft() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/JspImportListReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/JspImportListReferenceProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByString";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

