/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.SourcePathsBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaModuleBuilder
extends ModuleBuilder
implements SourcePathsBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.projectWizard.JavaModuleBuilder");
    private String myCompilerOutputPath;
    private List<Pair<String, String>> mySourcePaths;
    private final List<Pair<String, String>> myModuleLibraries = new ArrayList<Pair<String, String>>();
    public static final int JAVA_WEIGHT = 100;
    public static final int BUILD_SYSTEM_WEIGHT = 80;
    public static final int JAVA_MOBILE_WEIGHT = 60;

    public final void setCompilerOutputPath(String compilerOutputPath) {
        this.myCompilerOutputPath = JavaModuleBuilder.acceptParameter(compilerOutputPath);
    }

    @Override
    public List<Pair<String, String>> getSourcePaths() {
        if (this.mySourcePaths == null) {
            ArrayList<Pair<String, String>> paths = new ArrayList<Pair<String, String>>();
            String path2 = this.getContentEntryPath() + File.separator + "src";
            new File(path2).mkdirs();
            paths.add(Pair.create((Object)path2, (Object)""));
            return paths;
        }
        return this.mySourcePaths;
    }

    @Override
    public void setSourcePaths(List<Pair<String, String>> sourcePaths) {
        this.mySourcePaths = sourcePaths != null ? new ArrayList<Pair<String, String>>(sourcePaths) : null;
    }

    @Override
    public void addSourcePath(Pair<String, String> sourcePathInfo) {
        if (this.mySourcePaths == null) {
            this.mySourcePaths = new ArrayList<Pair<String, String>>();
        }
        this.mySourcePaths.add(sourcePathInfo);
    }

    @Override
    public ModuleType getModuleType() {
        return StdModuleTypes.JAVA;
    }

    @Override
    public boolean isSuitableSdkType(SdkTypeId sdkType) {
        return sdkType instanceof JavaSdkType && !((JavaSdkType)((Object)sdkType)).isDependent();
    }

    @Override
    @Nullable
    public ModuleWizardStep modifySettingsStep(@NotNull SettingsStep settingsStep) {
        if (settingsStep == null) {
            JavaModuleBuilder.$$$reportNull$$$0(0);
        }
        return StdModuleTypes.JAVA.modifySettingsStep(settingsStep, this);
    }

    @Override
    public void setupRootModel(ModifiableRootModel rootModel) throws ConfigurationException {
        List<Pair<String, String>> sourcePaths;
        CompilerModuleExtension compilerModuleExtension = rootModel.getModuleExtension(CompilerModuleExtension.class);
        compilerModuleExtension.setExcludeOutput(true);
        if (this.myJdk != null) {
            rootModel.setSdk(this.myJdk);
        } else {
            rootModel.inheritSdk();
        }
        ContentEntry contentEntry = this.doAddContentEntry(rootModel);
        if (contentEntry != null && (sourcePaths = this.getSourcePaths()) != null) {
            for (Pair<String, String> sourcePath : sourcePaths) {
                String first = (String)sourcePath.first;
                new File(first).mkdirs();
                VirtualFile sourceRoot = LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)first));
                if (sourceRoot == null) continue;
                contentEntry.addSourceFolder(sourceRoot, false, (String)sourcePath.second);
            }
        }
        if (this.myCompilerOutputPath != null) {
            String canonicalPath;
            try {
                canonicalPath = FileUtil.resolveShortWindowsName((String)this.myCompilerOutputPath);
            }
            catch (IOException e) {
                canonicalPath = this.myCompilerOutputPath;
            }
            compilerModuleExtension.setCompilerOutputPath(VfsUtilCore.pathToUrl(FileUtil.toSystemIndependentName((String)canonicalPath)));
        } else {
            compilerModuleExtension.inheritCompilerOutputPath(true);
        }
        LibraryTable libraryTable = rootModel.getModuleLibraryTable();
        for (Pair<String, String> libInfo : this.myModuleLibraries) {
            String moduleLibraryPath = (String)libInfo.first;
            String sourceLibraryPath = (String)libInfo.second;
            Library library = libraryTable.createLibrary();
            Library.ModifiableModel modifiableModel = library.getModifiableModel();
            modifiableModel.addRoot(JavaModuleBuilder.getUrlByPath(moduleLibraryPath), OrderRootType.CLASSES);
            if (sourceLibraryPath != null) {
                modifiableModel.addRoot(JavaModuleBuilder.getUrlByPath(sourceLibraryPath), OrderRootType.SOURCES);
            }
            modifiableModel.commit();
        }
    }

    @Override
    @Nullable
    public List<Module> commit(@NotNull Project project, ModifiableModuleModel model, ModulesProvider modulesProvider) {
        if (project == null) {
            JavaModuleBuilder.$$$reportNull$$$0(1);
        }
        LanguageLevelProjectExtension extension = LanguageLevelProjectExtension.getInstance(ProjectManager.getInstance().getDefaultProject());
        Boolean aDefault = extension.getDefault();
        LOG.debug("commit: aDefault=" + aDefault);
        LanguageLevelProjectExtension instance = LanguageLevelProjectExtension.getInstance(project);
        if (aDefault != null && !aDefault.booleanValue()) {
            instance.setLanguageLevel(extension.getLanguageLevel());
            instance.setDefault(false);
        } else {
            Sdk sdk = ProjectRootManager.getInstance(project).getProjectSdk();
            LOG.debug("commit: projectSdk=" + sdk);
            if (sdk != null) {
                JavaSdkVersion version = JavaSdk.getInstance().getVersion(sdk);
                LOG.debug("commit: sdk.version=" + (Object)((Object)version));
                if (version != null) {
                    instance.setLanguageLevel(version.getMaxLanguageLevel());
                    instance.setDefault(true);
                }
            }
        }
        return super.commit(project, model, modulesProvider);
    }

    private static String getUrlByPath(String path2) {
        return VfsUtil.getUrlForLibraryRoot(new File(path2));
    }

    public void addModuleLibrary(String moduleLibraryPath, String sourcePath) {
        this.myModuleLibraries.add((Pair<String, String>)Pair.create((Object)moduleLibraryPath, (Object)sourcePath));
    }

    @Nullable
    protected static String getPathForOutputPathStep() {
        return null;
    }

    @Override
    public int getWeight() {
        return 100;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsStep";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/util/projectWizard/JavaModuleBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "modifySettingsStep";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "commit";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

